<?php
defined( 'ABSPATH' ) or die( 'Cheatin&#8217; uh?' );

/**
 * Allow to force the protocol rewrite on script, link, img and form tags.
 *
 * @since 2.7
 *
 * @param bool true will force the protocol rewrite
 */
$do_rocket_protocol_rewrite = apply_filters( 'do_rocket_protocol_rewrite', false );

if ( ( get_rocket_option( 'do_cloudflare', 0 ) && get_rocket_option( 'cloudflare_protocol_rewrite', 0 ) || $do_rocket_protocol_rewrite ) ) {
	add_filter( 'rocket_buffer', 'rocket_protocol_rewrite', PHP_INT_MAX );
	add_filter( 'wp_calculate_image_srcset', 'rocket_protocol_rewrite_srcset', PHP_INT_MAX );
}

/**
 * Remove HTTP protocol on script, link, img and form tags.
 *
 * @since 2.7
 *
 * @param string $buffer HTML content.
 * @return string Updated HTML content
 */
function rocket_protocol_rewrite( $buffer ) {
	$re     = "/(<(script|link|img|form)([^>]*)(href|src|action)=[\"'])https?:\\/\\//i";
	$subst  = '$1//';
	$return = preg_replace( $re, $subst, $buffer );

	if ( $return ) {
		$buffer = $return;
	}

	return $buffer;
}

/**
 * Remove HTTP protocol on srcset attribute generated by WordPress
 *
 * @since 2.7
 *
 * @param array $sources an Array of images sources for srcset.
 * @return array Updated array of images sources
 */
function rocket_protocol_rewrite_srcset( $sources ) {
	if ( (bool) $sources ) {
		foreach ( $sources as $i => $source ) {
			$sources[ $i ]['url'] = str_replace( array( 'http:', 'https:' ), '', $source['url'] );
		}
	}

	return $sources;
}
