<?php
if ( ! defined( 'pluginbuddy_importbuddy' ) ) {
	pb_backupbuddy::$ui->title( __( 'Malware Scan', 'it-l10n-backupbuddy' ) );
	pb_backupbuddy::disalert( 'it-security_ad','<b>Is your site locked down & secure?</b><br> Check out <a href="http://ithemes.com/security/?utm_source=BackupBuddy%20Malware%20Scan%20Page&utm_medium=bub%20link&utm_campaign=itsec%20%2B%20bub" target="_blank">iThemes Security Pro</a>, for the do-it-yourself WP security toolbox, or have the website security professionals at <a href="http://ithemes.com/sucuri?utm_medium=bub%20link&utm_campaign=sucuri%20%2B%20bub">Sucuri</a> do it for you.' );
	$url = home_url();
} else {
	$url = str_replace( $_SERVER['QUERY_STRING'], '', $_SERVER['REQUEST_URI'] );
	$url = str_replace( basename( $url ) , '', $url );
	$url = 'http://' . $_SERVER['HTTP_HOST'] . $url;
}
?>
<style type="text/css">
	.inside label {
		display: block;
		vertical-align: top;
		width: 140px;
		font-weight: bold;
	}
</style>


<?php
pb_backupbuddy::$ui->start_metabox( __( 'Malware Scan URL', 'it-l10n-backupbuddy' ), true, 'width: 100%;' );
	
	
	
	?>
	
	<?php echo $url; ?>
	
	<?php
	
	$continue_1 = true;
	if ( $url == 'http://localhost' ) {
		_e('ERROR: You are currently running your site locally. Your site must be internet accessible to scan.', 'it-l10n-backupbuddy' );
		$continue_1 = false;
	}
	
	if ( $continue_1 === true ) {
	
		if ( !empty( $_GET['refresh'] ) ) {
			delete_transient( 'pb_backupbuddy_malwarescan' );
		}
		
		//echo '<br />Scanning `' . $url . '`.<br /><br />';
		if ( !defined( 'pluginbuddy_importbuddy' ) ) {
			$scan = get_transient( 'pb_backupbuddy_malwarescan' );
		} else {
			$scan = false;
		}
		
		if ( false === $scan ) {
			?>
			<div id="pb_backupbuddy_malwarescanloading">
			<table><tr><td><img src="<?php echo pb_backupbuddy::plugin_url(); ?>/images/loading_large.gif" /></td><td><h1>&nbsp;<?php _e('Scanning for Malware... Please wait...', 'it-l10n-backupbuddy' );?></h1></td></tr></table>
			</div>
			<?php
			flush();
			
			$scan = wp_remote_get(
				'http://sitecheck.sucuri.net/scanner/?scan=' . urlencode( $url ) . '&serialized&clear=true',
				array(
					'method' => 'GET',
					'timeout' => 45,
					'redirection' => 5,
					'httpversion' => '1.0',
					'blocking' => true,
					'headers' => array(),
					'body' => null,
					'cookies' => array()
				)
			);
			
			if ( is_wp_error( $scan ) ) {
				pb_backupbuddy::alert( __('ERROR #24452. Unable to load Malware Scan results. Details:', 'it-l10n-backupbuddy' ). ' ' . $scan->get_error_message(), true );
				$scan = 'N;';
			} else {
				$scan = $scan['body'];
				set_transient( 'pb_backupbuddy_malwarescan', $scan, 60*60*1 ); // 1 hour cache.
			}
			?>
			<script type="text/javascript">
				jQuery(document).ready(function() {
					jQuery('#pb_backupbuddy_malwarescanloading').slideToggle();
				});
			</script>
		<?php
		}
		
		$continue_2 = true;
		if ( substr( $scan, 0, 2 ) == 'N;' ) {
			echo __('An error was encountered attempting to scan this site.','it-l10n-backupbuddy' ), '<br />';
			echo __('An internet connection is required and this site must be accessible on the public internet.', 'it-l10n-backupbuddy' );
			echo '<br>';
			$scan = array();
			$continue_2 = false;
		} else {
			$scan = maybe_unserialize( $scan );
			//echo '<pre>';
			//print_r( $scan );
			//echo '</pre>';
		}
	
	}

pb_backupbuddy::$ui->end_metabox();
?>



<?php

	
if ( $continue_2 === true ) {
	function lined_array( $array ) {
		if ( is_array( $array ) ) {
			foreach( $array as $array_key => $array_item ) {
				if ( is_array( $array_item ) ) {
					$array[$array_key] = lined_array( $array_item );
				}
			}
			//return implode( '<br />', $array );
			$return = '';
			foreach( $array as $array_item ) {
				$return .= $array_item . '<br />';
			}
			return $return;
		} else {
			if ( empty( $array ) ) {
				return '<i>'.__('none', 'it-l10n-backupbuddy' ).'</i><br />';
			} else {
				return $array . '<br />';
			}
		}
	}
	
	
	if ( !empty( $scan['MALWARE'] ) && ( $scan['MALWARE'] != 'E' ) ) {
		echo '<table><tr><td><img src="' . pb_backupbuddy::plugin_url() . '/images/warning.png" style="width: 92px; height: 92px;" /></td><td><h1>', __('Warning: Possible Malware Detected!', 'it-l10n-backupbuddy' ), '</h1>',__('See details below.', 'it-l10n-backupbuddy' ), '</td></tr></table>';
	}
	?>
	
	
	<div class="postbox-container" style="width: 100%; min-width: 750px;">
		<div class="metabox-holder">
			<div class="meta-box-sortables">
				
				<div id="breadcrumbslike" class="postbox">
					<div class="handlediv" title="<?php _e('Click to toggle', 'it-l10n-backupbuddy' );?>"><br /></div>
					<h3 class="hndle"><span><?php _e('Malware Detection', 'it-l10n-backupbuddy' );?></span></h3>
					<div class="inside">
						<label><?php _e('Malware', 'it-l10n-backupbuddy' );?></label>
						<?php
						if ( !empty( $scan['MALWARE']['WARN'] ) ) { // Malware found.
							echo lined_array( $scan['MALWARE']['WARN'] );
							backupbuddy_core::addNotification( 'malware_found', 'Malware detected on `' . $url . '`.', 'A malware scan was run on the site and detected malware.', array(), true ); // Urgent
						} else { // No malware found.
							echo '<i>', __('none', 'it-l10n-backupbuddy' ), '</i><br />';
							backupbuddy_core::addNotification( 'malware_not_found', 'No malware detected on `' . $url . '`.', 'A malware scan was run on the site and did not detect malware.' );
						} ?><br />
					</div>
				</div>
				
				<div id="breadcrumbslike" class="postbox">
					<div class="handlediv" title="<?php _e('Click to toggle', 'it-l10n-backupbuddy' );?>"><br /></div>
					<h3 class="hndle"><span><?php _e('Web server details', 'it-l10n-backupbuddy' );?></span></h3>
					<div class="inside">
						<label><?php _e('Site', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['SCAN']['SITE'] ) ) { echo lined_array( $scan['SCAN']['SITE'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ),'</i><br />'; } ?><br />
						<label><?php _e('Hostname', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['SCAN']['DOMAIN'] ) ) { echo lined_array( $scan['SCAN']['DOMAIN'] ); } else { echo '<i>',__('none', 'it-l10n-backupbuddy' ),'</i><br />'; } ?><br />
						<label><?php _e('IP Address', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['SCAN']['IP'] ) ) { echo lined_array( $scan['SCAN']['IP'] ); } else { echo '<i>',__('none', 'it-l10n-backupbuddy' ),'</i><br />'; } ?><br />
						<label><?php _e('System details', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['SYSTEM']['NOTICE'] ) ) { echo lined_array( $scan['SYSTEM']['NOTICE'] ); } else { echo '<i>', __('none','it-l10n-backupbuddy' ), '</i><br />'; } ?><br />
						<label><?php _e('Information', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['SYSTEM']['INFO'] ) ) { echo lined_array( $scan['SYSTEM']['INFO'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ), '</i><br />'; } ?><br />
					</div>
				</div>
				
				<div id="breadcrumbslike" class="postbox">
					<div class="handlediv" title="Click to toggle"><br /></div>
					<h3 class="hndle"><span><?php _e('Web application', 'it-l10n-backupbuddy' );?></span></h3>
					<div class="inside">
						<label><?php _e('Details', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['WEBAPP']['INFO'] ) ) { echo lined_array( $scan['WEBAPP']['INFO'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ),'</i><br />'; } ?><br />
						<label><?php _e('Versions', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['WEBAPP']['VERSION'] ) ) { echo lined_array( $scan['WEBAPP']['VERSION'] ); } else { echo '<i>',__('none', 'it-l10n-backupbuddy' ),'</i><br />'; } ?><br />
						<label><?php _e('Notices', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['WEBAPP']['NOTICE'] ) ) { echo lined_array( $scan['WEBAPP']['NOTICE'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ), '</i><br />'; } ?><br />
						<label><?php _e('Errors', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['WEBAPP']['ERROR'] ) ) { echo lined_array( $scan['WEBAPP']['ERROR'] ); } else { echo '<i>',__('none', 'it-l10n-backupbuddy' ),'</i><br />'; } ?><br />
						<label><?php _e('Warnings', 'it-l10n-backupbuddy' );?></label> <?php if ( !empty( $scan['WEBAPP']['WARN'] ) ) { echo lined_array( $scan['WEBAPP']['WARN'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ), '</i><br />'; } ?><br />
					</div>
				</div>
				
				<div id="breadcrumbslike" class="postbox">
					<div class="handlediv" title="<?php _e('Click to toggle', 'it-l10n-backupbuddy' );?>"><br /></div>
					<h3 class="hndle"><span><?php _e('Links', 'it-l10n-backupbuddy' );?></span></h3>
					<div class="inside">
						<?php if ( !empty( $scan['LINKS']['URL'] ) ) { echo lined_array( $scan['LINKS']['URL'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ), '</i><br />'; } ?>
					</div>
				</div>
				
				<div id="breadcrumbslike" class="postbox">
					<div class="handlediv" title="<?php _e('Click to toggle', 'it-l10n-backupbuddy' );?>"><br /></div>
					<h3 class="hndle"><span><?php _e('Local Javascript', 'it-l10n-backupbuddy' );?></span></h3>
					<div class="inside">
						<?php if ( !empty( $scan['LINKS']['JSLOCAL'] ) ) { echo lined_array( $scan['LINKS']['JSLOCAL'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ),'</i><br />'; } ?>
					</div>
				</div>
				
				<div id="breadcrumbslike" class="postbox">
					<div class="handlediv" title="<?php _e('Click to toggle', 'it-l10n-backupbuddy' );?>"><br /></div>
					<h3 class="hndle"><span><?php _e('External Javascript', 'it-l10n-backupbuddy' );?></span></h3>
					<div class="inside">
						<?php if ( !empty( $scan['LINKS']['JSEXTERNAL'] ) ) { echo lined_array( $scan['LINKS']['JSEXTERNAL'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ), '</i><br />'; } ?>
					</div>
				</div>
				
				<div id="breadcrumbslike" class="postbox">
					<div class="handlediv" title="<?php _e('Click to toggle', 'it-l10n-backupbuddy' );?>"><br /></div>
					<h3 class="hndle"><span><?php _e('Iframes Included', 'it-l10n-backupbuddy' );?></span></h3>
					<div class="inside">
						<?php if ( !empty( $scan['LINKS']['IFRAME'] ) ) { echo lined_array( $scan['LINKS']['IFRAME'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ), '</i><br />'; } ?>
					</div>
				</div>
				
				<div id="breadcrumbslike" class="postbox">
					<div class="handlediv" title="<?php _e('Click to toggle', 'it-l10n-backupbuddy' );?>"><br /></div>
					<h3 class="hndle"><span><?php _e('Blacklisting Status', 'it-l10n-backupbuddy' );?></span></h3>
					<div class="inside">
						<?php if ( !empty( $scan['BLACKLIST']['INFO'] ) ) { echo lined_array( $scan['BLACKLIST']['INFO'] ); } else { echo '<i>', __('none', 'it-l10n-backupbuddy' ), '</i><br />'; } ?>
					</div>
				</div>
				
			</div>
		</div>
	</div>
	
	<br /><br /><br /><br />
	
	<div style="color: #AFAFAF; width: 793px;">
		<a href="<?php
		if ( defined( 'pluginbuddy_importbuddy' ) ) {
			echo page_link( 'malware_scan', 'view_malware' );
		} else {
			if ( is_network_admin() ) {
				echo network_admin_url( 'admin.php' );
			} else {
				echo admin_url( 'admin.php' );
			}
			echo '?page=pb_backupbuddy_malware_scan';
		}
		?>&refresh=true" class="button-secondary"><?php _e('Perform New Scan Now', 'it-l10n-backupbuddy' );?></a>
		<span class="description" style="vertical-align: -4px;">&nbsp;&nbsp;&nbsp;<?php _e('Malware scan results are cached for one hour.', 'it-l10n-backupbuddy' );?></span>
	</div>
	
	<br /><br />
	<?php
}
?>
