<?php
/*
Plugin Name: Qianya Floating CS (芊雅在线客服)
Description: 一款高转化、自适应的在线客服插件。PC端带雷达波纹与灵动提示，手机端带流光呼吸特效。
Version: 1.0.0
Author: qianya
Author URI: https://www.kejianet.cn
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Prevent direct access
}

// 在页脚加载代码
add_action('wp_footer', 'qy_render_floating_cs_widget');

function qy_render_floating_cs_widget() {
    ?>
    <style>
        /* =================================================================
           Qianya CS Core Styles
           Prefix: qy- (Prevent Conflicts)
           ================================================================= */
        :root {
            --qy-z: 99999999; /* 顶级层级，压过所有主题元素 */
            --qy-wx: #07C160;
            --qy-tel: #FF9900;
            --qy-shadow: 0 8px 20px rgba(0,0,0,0.15);
            --qy-hover: 0 15px 35px rgba(0,0,0,0.25);
        }

        /* 局部重置，防止主题样式干扰 */
        .qy-floatbar, .qy-mobilebar, .qy-modal, .qy-toast-msg {
            box-sizing: border-box;
            line-height: 1.5;
        }
        .qy-floatbar *, .qy-mobilebar *, .qy-modal * {
            box-sizing: border-box;
        }

        /* ================= PC 端悬浮条 (≥992px) ================= */
        .qy-floatbar {
            position: fixed;
            right: 25px;
            top: 50%;
            transform: translateY(-50%);
            display: flex;
            flex-direction: column;
            gap: 25px;
            z-index: var(--qy-z);
        }

        .qy-floatbtn {
            position: relative;
            width: 50px; 
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: var(--qy-shadow);
            border: 2px solid #fff; 
            background: #fff; /* Fallback */
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            text-decoration: none !important; /* 强制去掉下划线 */
        }

        .qy-floatbtn svg {
            width: 24px; height: 24px;
            fill: #fff;
            z-index: 2;
            transition: transform 0.3s;
            display: block; /* 消除间隙 */
        }

        /* 颜色 */
        .qy-floatbtn.wechat { background: var(--qy-wx); }
        .qy-floatbtn.call { background: var(--qy-tel); }

        /* --- 雷达波纹 (仅PC端微信) --- */
        .qy-floatbtn.wechat::before, .qy-floatbtn.wechat::after {
            content: ''; position: absolute; top:0; left:0; right:0; bottom:0; 
            border-radius: 50%;
            border: 1px solid var(--qy-wx); 
            box-shadow: 0 0 10px rgba(7,193,96,0.5); 
            animation: qyRadar 2s infinite linear;
            opacity: 0; z-index: -1;
            pointer-events: none;
        }
        .qy-floatbtn.wechat::after { animation-delay: 1s; }

        @keyframes qyRadar {
            0% { transform: scale(1); opacity: 0.8; border-width: 2px; }
            100% { transform: scale(2.2); opacity: 0; border-width: 0px; }
        }

        /* --- 悬停交互 --- */
        .qy-floatbtn:hover {
            transform: scale(1.15); 
            box-shadow: var(--qy-hover);
            z-index: 100;
        }
        .qy-floatbtn:hover svg { transform: rotate(10deg) scale(1.1); }

        /* --- 提示框 (歪头杀) --- */
        .qy-tooltip {
            position: absolute;
            right: 70px; 
            top: 50%;
            transform: translateY(-50%) translateX(15px) rotate(15deg) scale(0.8);
            background: #fff;
            padding: 8px 15px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 800; 
            white-space: nowrap;
            opacity: 0;
            visibility: hidden;
            box-shadow: 0 8px 20px rgba(0,0,0,0.15);
            transition: all 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
            pointer-events: none;
            color: #333;
        }
        /* 小三角 */
        .qy-tooltip::after {
            content: ''; position: absolute; right: -5px; top: 50%; margin-top: -5px;
            border-width: 5px 0 5px 5px;
            border-style: solid;
            border-color: transparent transparent transparent #fff;
        }

        /* 文字颜色定制 */
        .qy-floatbtn.wechat .qy-tooltip { color: var(--qy-wx); }
        .qy-floatbtn.call .qy-tooltip { color: var(--qy-tel); }

        /* 悬停显示 */
        .qy-floatbtn:hover .qy-tooltip {
            opacity: 1; visibility: visible;
            transform: translateY(-50%) translateX(0) rotate(-5deg) scale(1);
        }

        /* ================= 手机端底部 (≤991px) ================= */
        .qy-mobilebar {
            position: fixed; left: 10px; right: 10px; bottom: 10px;
            padding-bottom: calc(0px + env(safe-area-inset-bottom));
            background: transparent; 
            z-index: var(--qy-z); 
            display: none; 
            pointer-events: none;
        }

        .qy-mobilebar .qy-row { 
            display: flex; gap: 15px; pointer-events: auto; 
        }
        
        .qy-m-btn {
            flex: 1; display: flex; align-items: center; justify-content: center;
            gap: 6px; height: 50px; border-radius: 50px;
            font-weight: 700; font-size: 16px; color: #fff !important;
            text-decoration: none !important; border: none; cursor: pointer;
            box-shadow: 0 8px 25px rgba(0,0,0,0.2); 
            position: relative; overflow: hidden;
            -webkit-tap-highlight-color: transparent;
            /* 呼吸动画 */
            animation: qyBreathe 3s infinite ease-in-out;
        }
        
        .qy-m-btn svg { width: 22px; height: 22px; fill: #fff; z-index: 2; }
        .qy-m-btn span { position: relative; z-index: 2; }

        .qy-m-btn.wechat { background: var(--qy-wx); }
        .qy-m-btn.call { background: var(--qy-tel); animation-delay: 1.5s; }

        @keyframes qyBreathe {
            0% { transform: scale(1); }
            50% { transform: scale(1.03); }
            100% { transform: scale(1); }
        }

        /* 流光扫光特效 */
        .qy-m-btn::after {
            content: ''; position: absolute; top: 0; left: -100%; width: 100%; height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            transform: skewX(-20deg); 
            animation: qySheen 4s infinite;
            pointer-events: none;
        }
        @keyframes qySheen {
            0% { left: -100%; }
            20% { left: 200%; }
            100% { left: 200%; }
        }

        /* ================= 弹窗 (Modal) ================= */
        .qy-modal-overlay {
            position: fixed; inset: 0; background: rgba(0,0,0,0.6); 
            z-index: 2147483647; display: none; backdrop-filter: blur(4px);
            animation: qyFadeIn 0.3s;
        }
        .qy-modal-dialog {
            position: fixed; left: 50%; top: 50%; transform: translate(-50%, -50%);
            background: #fff; border-radius: 20px; padding: 30px 24px;
            text-align: center; z-index: 2147483647; display: none;
            width: 85%; max-width: 340px;
            box-shadow: 0 25px 60px rgba(0,0,0,0.4);
            animation: qyPopUp 0.3s cubic-bezier(0.18, 0.89, 0.32, 1.28);
        }
        .qy-modal-active .qy-modal-overlay, .qy-modal-active .qy-modal-dialog { display: block; }
        
        .qy-modal-dialog img { 
            width: 200px; height: 200px; 
            border: 1px solid #eee; border-radius: 12px; 
            margin-bottom: 20px; display: inline-block; 
        }
        .qy-copy-box { 
            background: #f5f7fa; border-radius: 10px; padding: 12px; 
            display: flex; justify-content: space-between; align-items: center; 
            margin-bottom: 20px; border: 1px solid #eee; 
        }
        .qy-num { font-size: 18px; font-weight: bold; color: #333; margin:0; }
        
        .qy-btn-copy { 
            font-size: 13px; color: #07C160; background: rgba(7,193,96,0.12); 
            padding: 6px 12px; border-radius: 6px; cursor: pointer; font-weight: bold; border:none;
        }
        
        .qy-close { 
            position: absolute; top: 15px; right: 15px; width: 30px; height: 30px; 
            background: #f5f5f5; border-radius: 50%; color: #999; 
            display: flex; align-items: center; justify-content: center; cursor: pointer; 
            font-size: 18px; border:none; padding:0;
        }
        
        .qy-toast { 
            position: fixed; left: 50%; top: 50%; transform: translate(-50%,-50%); 
            background: rgba(0,0,0,0.85); color: #fff; padding: 12px 24px; 
            border-radius: 8px; font-size: 14px; display: none; z-index: 2147483648; 
        }

        @keyframes qyFadeIn { from{opacity:0} to{opacity:1} }
        @keyframes qyPopUp { from{transform:translate(-50%,-45%) scale(0.9);opacity:0} to{transform:translate(-50%,-50%) scale(1);opacity:1} }

        /* ================= 响应式开关 ================= */
        @media (max-width: 991.98px) {
            .qy-floatbar { display: none !important; }
            .qy-mobilebar { display: block !important; }
        }
    </style>

    <div class="qy-floatbar">
        <div class="qy-floatbtn wechat" onclick="qyToggleModal(true)">
            <svg viewBox="0 0 1024 1024"><path d="M512 64C264.6 64 64 238.7 64 460.8c0 126.7 65.1 239.1 167.6 313.5l-44.2 132.2 152.9-84.1c52.5 15.2 108.4 23.4 171.7 23.4 247.4 0 448-174.7 448-396.8S759.4 64 512 64z"></path><path d="M352 448m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z" fill="#fff"></path><path d="M544 448m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z" fill="#fff"></path></svg>
            <div class="qy-tooltip">添加微信</div>
        </div>
        
        <a class="qy-floatbtn call" href="tel:13506993986">
            <svg viewBox="0 0 24 24"><path d="M22 16.92v3a2 2 0 0 1-2.18 2A19.79 19.79 0 0 1 3.09 5.18 2 2 0 0 1 5 3h3a2 2 0 0 1 2 1.72c.12.89.32 1.76.59 2.6a2 2 0 0 1-.45 2.11L9.1 10.9a16 16 0 0 0 4 4l1.47-1.05a2 2 0 0 1 2.11-.45c.84.27 1.71.47 2.6.59A2 2 0 0 1 22 16.92Z"></path></svg>
            <div class="qy-tooltip">拨打电话</div>
        </a>
    </div>

    <div class="qy-mobilebar">
        <div class="qy-row">
            <button class="qy-m-btn wechat" onclick="qyToggleModal(true)">
                <svg viewBox="0 0 1024 1024"><path d="M512 64C264.6 64 64 238.7 64 460.8c0 126.7 65.1 239.1 167.6 313.5l-44.2 132.2 152.9-84.1c52.5 15.2 108.4 23.4 171.7 23.4 247.4 0 448-174.7 448-396.8S759.4 64 512 64z" fill="#fff"></path><path d="M352 448m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z" fill="#07C160"></path><path d="M544 448m-48 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0Z" fill="#07C160"></path></svg>
                <span>微信咨询</span>
            </button>
            <a class="qy-m-btn call" href="tel:13506993986">
                <svg viewBox="0 0 24 24" fill="none"><path d="M22 16.92v3a2 2 0 0 1-2.18 2A19.79 19.79 0 0 1 3.09 5.18 2 2 0 0 1 5 3h3a2 2 0 0 1 2 1.72c.12.89.32 1.76.59 2.6a2 2 0 0 1-.45 2.11L9.1 10.9a16 16 0 0 0 4 4l1.47-1.05a2 2 0 0 1 2.11-.45c.84.27 1.71.47 2.6.59A2 2 0 0 1 22 16.92Z" fill="#fff" stroke-width="0"></path></svg>
                <span>拨打电话</span>
            </a>
        </div>
    </div>

    <div id="qy-modal-container">
        <div class="qy-modal-overlay" onclick="qyToggleModal(false)"></div>
        <div class="qy-modal-dialog">
            <button class="qy-close" onclick="qyToggleModal(false)">×</button>
            <h3>扫码添加客服微信</h3>
            <img src="https://www.shuojiner.cn/wp-content/uploads/2025/09/wx.jpg" alt="QR">
            <div class="qy-copy-box">
                <p class="qy-num" id="qy-wx-txt">fzqianya</p>
                <button class="qy-btn-copy" onclick="qyCopyText()">复制</button>
            </div>
        </div>
    </div>
    <div class="qy-toast" id="qy-toast">已复制微信号</div>

    <script>
        function qyToggleModal(show) {
            var el = document.getElementById('qy-modal-container');
            if(show) { el.classList.add('qy-modal-active'); document.body.style.overflow='hidden'; } 
            else { el.classList.remove('qy-modal-active'); document.body.style.overflow=''; }
        }
        function qyCopyText() {
            var txt = document.getElementById('qy-wx-txt').innerText;
            var toast = document.getElementById('qy-toast');
            if(navigator.clipboard && window.isSecureContext) {
                navigator.clipboard.writeText(txt).then(show);
            } else {
                var t = document.createElement("textarea"); t.value = txt; document.body.appendChild(t); t.select();
                try{document.execCommand('copy'); show();}catch(e){} document.body.removeChild(t);
            }
            function show() { toast.style.display='block'; setTimeout(function(){toast.style.display='none'},1500); }
        }
    </script>
    <?php
}