<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Widgetareas theme-options filter.
 */
function optionsframework_widgetareas_interface( $output, $value ) {

    // Name
    $output .= '<label for="widgetareas-name">' . _x('Sidebar name', 'theme-options', LANGUAGE_ZONE) . '</label>';
    $output .= '<input type="text" id="widgetareas-name" class="of_fields_gen_title" value=""/>';

    // Description
	$output .= '<label for="widgetareas-description">' . _x('Sidebar description (optional)', 'theme-options', LANGUAGE_ZONE) . '</label>';
    $output .= '<textarea id="widgetareas-description"></textarea>';    

    // Button
    $output .= '<button id="widgetareas-add" class="of_fields_gen_add">' . _x('Update', 'theme-options', LANGUAGE_ZONE) . '</button>';

    return $output;
}

/**
 * Widgetareas ajax handler.
 */
function optionsframework_widgetareas_ajax() {
	$action = empty($_POST['type']) ? '' : $_POST['type'];
	$nonce = empty($_POST['waNonce']) ? '' : $_POST['waNonce'];
 	$wa_id = empty($_POST['waId']) ? 0 : absint($_POST['waId']);
 	$wa_title = empty($_POST['waTitle']) ? '' : $_POST['waTitle'];
 	$wa_desc = empty($_POST['waDesc']) ? '' : $_POST['waDesc'];

	// check to see if the submitted nonce matches with the
	// generated nonce we created earlier
	if ( ! wp_verify_nonce( $nonce, 'options-framework-nonce' ) ) {		
		die ( 'Busted!');
 	}

	// ignore the request if the current user doesn't have
	// sufficient permissions
	if ( current_user_can( 'edit_theme_options' ) ) {
 		
 		$response = array( 'success' => false );
		$wa_array = of_get_option('widgetareas', array());

		if ( 'get' == $action && $wa_id ) {

			if ( $wa_array && isset($wa_array[ $wa_id ]) ) {

				$response['title'] = $wa_array[ $wa_id ]['title'];
				$response['desc'] = $wa_array[ $wa_id ]['desc'];
				$response['success'] = true;
			}
		} else if ( 'update' == $action && $wa_title ) {

			$known_options = get_option( 'optionsframework', array() );
			$saved_options = get_option( $known_options['id'], array() );
			
			if ( isset($saved_options['widgetareas']) ) {
				$wa_array = $saved_options['widgetareas'];
				
				// Get field id
				if ( !$wa_id ) { $wa_id = $wa_array['next_id']++; }
				
				// Update/Add new field
				$wa_array[ $wa_id ] = array(
					'title' => $wa_title,
					'desc'	=> $wa_desc
				);

				// Sanitize
				$saved_options['widgetareas'] = apply_filters('of_sanitize_widgetareas', $wa_array);

				// Update options
				$response['success'] = update_option($known_options['id'], $saved_options);
				$response['id'] = $wa_id;
			}
		}

		// generate the response
		$response = json_encode($response);
 
		// response output
		header( "Content-Type: application/json" );
		echo $response;
	}
 
	// IMPORTANT: don't forget to "exit"
	exit;
}
add_action('wp_ajax_process_widgetarea', 'optionsframework_widgetareas_ajax');

// get google fonts list
function dt_get_google_fonts_list( $get_defaults = false ) {
	$default_lst = optionsframework_get_web_fonts_defaults();
	if ( $get_defaults ) { return $default_lst; }

	$fonts_lst = $default_lst;
	return $fonts_lst;
}

// get images for options framework
function dt_get_images_in( $dir = '', $one_img_dir = '' ){
    $noimage = '/images/noimage_small.jpg';
    $basedir = dirname(__FILE__) . '/../../../';
    $dirname = $basedir .$dir;
    $res = $full_dir = $thumbs_dir = array();
	
    // full dir
    if ( file_exists($dirname. '/full') && $handle = opendir( $dirname. '/full') ) {
        while (false !== ($file = readdir($handle))) {
            if ($file != "." && $file != ".." && $file != 'Thumb.db' && $file != 'Thumbs.db' && $file !='.DS_Store' && preg_match('/[.jpeg|.jpg|.png|.gif]$/', $file)) {
                $f_name = preg_split( '/\.[^.]+$/', $file );
                $full_dir[$f_name[0]] = $file;
            }
        }
        closedir($handle);
    }
    unset($file);
    
    // thumbs dir
    if ( file_exists($dirname. '/thumbs') && $handle = opendir( $dirname. '/thumbs') ) {
        while (false !== ($file = readdir($handle))) {
            if ($file != "." && $file != ".." && $file != 'Thumb.db' && $file != 'Thumbs.db') {
                $f_name = preg_split( '/\.[^.]+$/', $file );
                $thumbs_dir[$f_name[0]] = $file;
            }
        }
        closedir($handle);
    }
    unset($file);
    asort($full_dir);
    
    foreach( $full_dir as $name=>$file ){
        $full_link = '/' . $dir . '/full/' . $file;
    	$thumb_link = $full_link;
        if( array_key_exists( $name, $thumbs_dir ) ){
            $thumb_link = '/' . $dir . '/thumbs/' . $thumbs_dir[$name];
        }else {
            $one_img = explode('.', $name);
            $file_name = $basedir . $one_img_dir . '/' . $one_img[0];

            if ( count($one_img) > 1 && $one_img[0] != $name && $one_img_dir && file_exists($file_name . '.png') ) {
                $thumb_link = '/'.$one_img_dir.'/'.$one_img[0].'.png';
            }

            if ( count($one_img) > 1 && $one_img[0] != $name && $one_img_dir && file_exists($file_name . '.jpg') ) {
                $thumb_link = '/'.$one_img_dir.'/'.$one_img[0].'.jpg';
            }
        }

        $res[$full_link] = $thumb_link;
    }
    
    return $res;
}

/* find option pages in array */
function optionsframework_options_page_filter( $item ) {
    if( isset($item['type']) && 'page' == $item['type'] ) {
        return true;
    }
    return false;
}

/* find options for current page */
function optionsframework_options_for_page_filter( $item ) {
    static $bingo = false;
    static $found_main = false;

    if ( $item == 0 ) { $bingo = $found_main = false; }

    if( !isset($_GET['page']) ) {
        if( !isset($_POST['_wp_http_referer']) ) {
            return true;
        }else {
            $arr = array();
            wp_parse_str($_POST['_wp_http_referer'], $arr);
            $current = current($arr);
        }
    }else {
        $current = $_GET['page'];
    }

    if( 'options-framework' == $current && !$found_main ) {
        $bingo = true;
        $found_main = true;
    }

    if( isset($item['type']) && 'page' == $item['type'] && $item['menu_slug'] == $current ) {
        $bingo = true;
        return false;
    }elseif( isset($item['type']) && 'page' == $item['type'] ) {
        $bingo = false;
    }

    return $bingo;
}

function optionsframework_get_presets_list () {

	return apply_filters( 'optionsframework_get_presets_list', array() );
}

function optionsframework_presets_data( $id ) {
    static $presets = null;

    if ( null === $presets ) {
		
		$presets = array();

		foreach ( optionsframework_get_presets_list() as $fname=>$thumb ) {
			
			$file = OPTIONS_FRAMEWORK_PRESETS_DIR . $fname . '.php';
			
			if ( is_readable( $file ) ) {
				include_once( $file );
			}
		}
	}

    if ( isset( $presets[ $id ] ) ) {
        return $presets[ $id ];
    }

    return array();
}

/**
 * Web Fonts defaults.
 *
 * @return array
 */
function optionsframework_get_web_fonts_defaults() {
	$web_fonts_list = array (
	  'ABeeZee' => 'ABeeZee',
	  'ABeeZee:400italic' => 'ABeeZee  italic',
	  'Abel' => 'Abel',
	  'Abril Fatface' => 'Abril Fatface',
	  'Abril Fatface&subset=latin-ext' => 'Abril Fatface latin-ext',
	  'Aclonica' => 'Aclonica',
	  'Acme' => 'Acme',
	  'Actor' => 'Actor',
	  'Adamina' => 'Adamina',
	  'Advent Pro:100' => 'Advent Pro bold (100) ',
	  'Advent Pro:200' => 'Advent Pro bold (200) ',
	  'Advent Pro:300' => 'Advent Pro bold (300) ',
	  'Advent Pro' => 'Advent Pro',
	  'Advent Pro:500' => 'Advent Pro bold (500) ',
	  'Advent Pro:600' => 'Advent Pro bold (600) ',
	  'Advent Pro:700' => 'Advent Pro bold (700) ',
	  'Advent Pro&subset=latin-ext' => 'Advent Pro latin-ext',
	  'Advent Pro&subset=greek' => 'Advent Pro greek',
	  'Advent Pro:100&subset=latin-ext' => 'Advent Pro bold (100)  latin-ext',
	  'Advent Pro:100&subset=greek' => 'Advent Pro bold (100)  greek',
	  'Advent Pro:200&subset=latin-ext' => 'Advent Pro bold (200)  latin-ext',
	  'Advent Pro:200&subset=greek' => 'Advent Pro bold (200)  greek',
	  'Advent Pro:300&subset=latin-ext' => 'Advent Pro bold (300)  latin-ext',
	  'Advent Pro:300&subset=greek' => 'Advent Pro bold (300)  greek',
	  'Advent Pro:500&subset=latin-ext' => 'Advent Pro bold (500)  latin-ext',
	  'Advent Pro:500&subset=greek' => 'Advent Pro bold (500)  greek',
	  'Advent Pro:600&subset=latin-ext' => 'Advent Pro bold (600)  latin-ext',
	  'Advent Pro:600&subset=greek' => 'Advent Pro bold (600)  greek',
	  'Advent Pro:700&subset=latin-ext' => 'Advent Pro bold (700)  latin-ext',
	  'Advent Pro:700&subset=greek' => 'Advent Pro bold (700)  greek',
	  'Aguafina Script' => 'Aguafina Script',
	  'Aguafina Script&subset=latin-ext' => 'Aguafina Script latin-ext',
	  'Akronim' => 'Akronim',
	  'Akronim&subset=latin-ext' => 'Akronim latin-ext',
	  'Aladin' => 'Aladin',
	  'Aladin&subset=latin-ext' => 'Aladin latin-ext',
	  'Aldrich' => 'Aldrich',
	  'Alef' => 'Alef',
	  'Alef:700' => 'Alef bold (700) ',
	  'Alegreya' => 'Alegreya',
	  'Alegreya:400italic' => 'Alegreya  italic',
	  'Alegreya:700' => 'Alegreya bold (700) ',
	  'Alegreya:700italic' => 'Alegreya bold (700) italic',
	  'Alegreya:900' => 'Alegreya bold (900) ',
	  'Alegreya:900italic' => 'Alegreya bold (900) italic',
	  'Alegreya&subset=latin-ext' => 'Alegreya latin-ext',
	  'Alegreya:400italic&subset=latin-ext' => 'Alegreya  italic latin-ext',
	  'Alegreya:700&subset=latin-ext' => 'Alegreya bold (700)  latin-ext',
	  'Alegreya:700italic&subset=latin-ext' => 'Alegreya bold (700) italic latin-ext',
	  'Alegreya:900&subset=latin-ext' => 'Alegreya bold (900)  latin-ext',
	  'Alegreya:900italic&subset=latin-ext' => 'Alegreya bold (900) italic latin-ext',
	  'Alegreya SC' => 'Alegreya SC',
	  'Alegreya SC:400italic' => 'Alegreya SC  italic',
	  'Alegreya SC:700' => 'Alegreya SC bold (700) ',
	  'Alegreya SC:700italic' => 'Alegreya SC bold (700) italic',
	  'Alegreya SC:900' => 'Alegreya SC bold (900) ',
	  'Alegreya SC:900italic' => 'Alegreya SC bold (900) italic',
	  'Alegreya SC&subset=latin-ext' => 'Alegreya SC latin-ext',
	  'Alegreya SC:400italic&subset=latin-ext' => 'Alegreya SC  italic latin-ext',
	  'Alegreya SC:700&subset=latin-ext' => 'Alegreya SC bold (700)  latin-ext',
	  'Alegreya SC:700italic&subset=latin-ext' => 'Alegreya SC bold (700) italic latin-ext',
	  'Alegreya SC:900&subset=latin-ext' => 'Alegreya SC bold (900)  latin-ext',
	  'Alegreya SC:900italic&subset=latin-ext' => 'Alegreya SC bold (900) italic latin-ext',
	  'Alex Brush' => 'Alex Brush',
	  'Alex Brush&subset=latin-ext' => 'Alex Brush latin-ext',
	  'Alfa Slab One' => 'Alfa Slab One',
	  'Alice' => 'Alice',
	  'Alike' => 'Alike',
	  'Alike Angular' => 'Alike Angular',
	  'Allan' => 'Allan',
	  'Allan:700' => 'Allan bold (700) ',
	  'Allan&subset=latin-ext' => 'Allan latin-ext',
	  'Allan:700&subset=latin-ext' => 'Allan bold (700)  latin-ext',
	  'Allerta' => 'Allerta',
	  'Allerta Stencil' => 'Allerta Stencil',
	  'Allura' => 'Allura',
	  'Allura&subset=latin-ext' => 'Allura latin-ext',
	  'Almendra' => 'Almendra',
	  'Almendra:400italic' => 'Almendra  italic',
	  'Almendra:700' => 'Almendra bold (700) ',
	  'Almendra:700italic' => 'Almendra bold (700) italic',
	  'Almendra&subset=latin-ext' => 'Almendra latin-ext',
	  'Almendra:400italic&subset=latin-ext' => 'Almendra  italic latin-ext',
	  'Almendra:700&subset=latin-ext' => 'Almendra bold (700)  latin-ext',
	  'Almendra:700italic&subset=latin-ext' => 'Almendra bold (700) italic latin-ext',
	  'Almendra Display' => 'Almendra Display',
	  'Almendra Display&subset=latin-ext' => 'Almendra Display latin-ext',
	  'Almendra SC' => 'Almendra SC',
	  'Amarante' => 'Amarante',
	  'Amarante&subset=latin-ext' => 'Amarante latin-ext',
	  'Amaranth' => 'Amaranth',
	  'Amaranth:400italic' => 'Amaranth  italic',
	  'Amaranth:700' => 'Amaranth bold (700) ',
	  'Amaranth:700italic' => 'Amaranth bold (700) italic',
	  'Amatic SC' => 'Amatic SC',
	  'Amatic SC:700' => 'Amatic SC bold (700) ',
	  'Amethysta' => 'Amethysta',
	  'Anaheim' => 'Anaheim',
	  'Anaheim&subset=latin-ext' => 'Anaheim latin-ext',
	  'Andada' => 'Andada',
	  'Andada&subset=latin-ext' => 'Andada latin-ext',
	  'Andika' => 'Andika',
	  'Andika&subset=latin-ext' => 'Andika latin-ext',
	  'Andika&subset=cyrillic-ext' => 'Andika cyrillic-ext',
	  'Andika&subset=cyrillic' => 'Andika cyrillic',
	  'Angkor' => 'Angkor',
	  'Annie Use Your Telescope' => 'Annie Use Your Telescope',
	  'Anonymous Pro' => 'Anonymous Pro',
	  'Anonymous Pro:400italic' => 'Anonymous Pro  italic',
	  'Anonymous Pro:700' => 'Anonymous Pro bold (700) ',
	  'Anonymous Pro:700italic' => 'Anonymous Pro bold (700) italic',
	  'Anonymous Pro&subset=latin-ext' => 'Anonymous Pro latin-ext',
	  'Anonymous Pro&subset=greek-ext' => 'Anonymous Pro greek-ext',
	  'Anonymous Pro&subset=cyrillic-ext' => 'Anonymous Pro cyrillic-ext',
	  'Anonymous Pro&subset=cyrillic' => 'Anonymous Pro cyrillic',
	  'Anonymous Pro&subset=greek' => 'Anonymous Pro greek',
	  'Anonymous Pro:400italic&subset=latin-ext' => 'Anonymous Pro  italic latin-ext',
	  'Anonymous Pro:400italic&subset=greek-ext' => 'Anonymous Pro  italic greek-ext',
	  'Anonymous Pro:400italic&subset=cyrillic-ext' => 'Anonymous Pro  italic cyrillic-ext',
	  'Anonymous Pro:400italic&subset=cyrillic' => 'Anonymous Pro  italic cyrillic',
	  'Anonymous Pro:400italic&subset=greek' => 'Anonymous Pro  italic greek',
	  'Anonymous Pro:700&subset=latin-ext' => 'Anonymous Pro bold (700)  latin-ext',
	  'Anonymous Pro:700&subset=greek-ext' => 'Anonymous Pro bold (700)  greek-ext',
	  'Anonymous Pro:700&subset=cyrillic-ext' => 'Anonymous Pro bold (700)  cyrillic-ext',
	  'Anonymous Pro:700&subset=cyrillic' => 'Anonymous Pro bold (700)  cyrillic',
	  'Anonymous Pro:700&subset=greek' => 'Anonymous Pro bold (700)  greek',
	  'Anonymous Pro:700italic&subset=latin-ext' => 'Anonymous Pro bold (700) italic latin-ext',
	  'Anonymous Pro:700italic&subset=greek-ext' => 'Anonymous Pro bold (700) italic greek-ext',
	  'Anonymous Pro:700italic&subset=cyrillic-ext' => 'Anonymous Pro bold (700) italic cyrillic-ext',
	  'Anonymous Pro:700italic&subset=cyrillic' => 'Anonymous Pro bold (700) italic cyrillic',
	  'Anonymous Pro:700italic&subset=greek' => 'Anonymous Pro bold (700) italic greek',
	  'Antic' => 'Antic',
	  'Antic Didone' => 'Antic Didone',
	  'Antic Slab' => 'Antic Slab',
	  'Anton' => 'Anton',
	  'Anton&subset=latin-ext' => 'Anton latin-ext',
	  'Arapey' => 'Arapey',
	  'Arapey:400italic' => 'Arapey  italic',
	  'Arbutus' => 'Arbutus',
	  'Arbutus&subset=latin-ext' => 'Arbutus latin-ext',
	  'Arbutus Slab' => 'Arbutus Slab',
	  'Arbutus Slab&subset=latin-ext' => 'Arbutus Slab latin-ext',
	  'Architects Daughter' => 'Architects Daughter',
	  'Archivo Black' => 'Archivo Black',
	  'Archivo Black&subset=latin-ext' => 'Archivo Black latin-ext',
	  'Archivo Narrow' => 'Archivo Narrow',
	  'Archivo Narrow:400italic' => 'Archivo Narrow  italic',
	  'Archivo Narrow:700' => 'Archivo Narrow bold (700) ',
	  'Archivo Narrow:700italic' => 'Archivo Narrow bold (700) italic',
	  'Archivo Narrow&subset=latin-ext' => 'Archivo Narrow latin-ext',
	  'Archivo Narrow:400italic&subset=latin-ext' => 'Archivo Narrow  italic latin-ext',
	  'Archivo Narrow:700&subset=latin-ext' => 'Archivo Narrow bold (700)  latin-ext',
	  'Archivo Narrow:700italic&subset=latin-ext' => 'Archivo Narrow bold (700) italic latin-ext',
	  'Arimo' => 'Arimo',
	  'Arimo:400italic' => 'Arimo  italic',
	  'Arimo:700' => 'Arimo bold (700) ',
	  'Arimo:700italic' => 'Arimo bold (700) italic',
	  'Arimo&subset=latin-ext' => 'Arimo latin-ext',
	  'Arimo&subset=greek-ext' => 'Arimo greek-ext',
	  'Arimo&subset=cyrillic-ext' => 'Arimo cyrillic-ext',
	  'Arimo&subset=cyrillic' => 'Arimo cyrillic',
	  'Arimo&subset=vietnamese' => 'Arimo vietnamese',
	  'Arimo&subset=greek' => 'Arimo greek',
	  'Arimo:400italic&subset=latin-ext' => 'Arimo  italic latin-ext',
	  'Arimo:400italic&subset=greek-ext' => 'Arimo  italic greek-ext',
	  'Arimo:400italic&subset=cyrillic-ext' => 'Arimo  italic cyrillic-ext',
	  'Arimo:400italic&subset=cyrillic' => 'Arimo  italic cyrillic',
	  'Arimo:400italic&subset=vietnamese' => 'Arimo  italic vietnamese',
	  'Arimo:400italic&subset=greek' => 'Arimo  italic greek',
	  'Arimo:700&subset=latin-ext' => 'Arimo bold (700)  latin-ext',
	  'Arimo:700&subset=greek-ext' => 'Arimo bold (700)  greek-ext',
	  'Arimo:700&subset=cyrillic-ext' => 'Arimo bold (700)  cyrillic-ext',
	  'Arimo:700&subset=cyrillic' => 'Arimo bold (700)  cyrillic',
	  'Arimo:700&subset=vietnamese' => 'Arimo bold (700)  vietnamese',
	  'Arimo:700&subset=greek' => 'Arimo bold (700)  greek',
	  'Arimo:700italic&subset=latin-ext' => 'Arimo bold (700) italic latin-ext',
	  'Arimo:700italic&subset=greek-ext' => 'Arimo bold (700) italic greek-ext',
	  'Arimo:700italic&subset=cyrillic-ext' => 'Arimo bold (700) italic cyrillic-ext',
	  'Arimo:700italic&subset=cyrillic' => 'Arimo bold (700) italic cyrillic',
	  'Arimo:700italic&subset=vietnamese' => 'Arimo bold (700) italic vietnamese',
	  'Arimo:700italic&subset=greek' => 'Arimo bold (700) italic greek',
	  'Arizonia' => 'Arizonia',
	  'Arizonia&subset=latin-ext' => 'Arizonia latin-ext',
	  'Armata' => 'Armata',
	  'Armata&subset=latin-ext' => 'Armata latin-ext',
	  'Artifika' => 'Artifika',
	  'Arvo' => 'Arvo',
	  'Arvo:400italic' => 'Arvo  italic',
	  'Arvo:700' => 'Arvo bold (700) ',
	  'Arvo:700italic' => 'Arvo bold (700) italic',
	  'Asap' => 'Asap',
	  'Asap:400italic' => 'Asap  italic',
	  'Asap:700' => 'Asap bold (700) ',
	  'Asap:700italic' => 'Asap bold (700) italic',
	  'Asap&subset=latin-ext' => 'Asap latin-ext',
	  'Asap:400italic&subset=latin-ext' => 'Asap  italic latin-ext',
	  'Asap:700&subset=latin-ext' => 'Asap bold (700)  latin-ext',
	  'Asap:700italic&subset=latin-ext' => 'Asap bold (700) italic latin-ext',
	  'Asset' => 'Asset',
	  'Astloch' => 'Astloch',
	  'Astloch:700' => 'Astloch bold (700) ',
	  'Asul' => 'Asul',
	  'Asul:700' => 'Asul bold (700) ',
	  'Atomic Age' => 'Atomic Age',
	  'Aubrey' => 'Aubrey',
	  'Audiowide' => 'Audiowide',
	  'Audiowide&subset=latin-ext' => 'Audiowide latin-ext',
	  'Autour One' => 'Autour One',
	  'Autour One&subset=latin-ext' => 'Autour One latin-ext',
	  'Average' => 'Average',
	  'Average&subset=latin-ext' => 'Average latin-ext',
	  'Average Sans' => 'Average Sans',
	  'Average Sans&subset=latin-ext' => 'Average Sans latin-ext',
	  'Averia Gruesa Libre' => 'Averia Gruesa Libre',
	  'Averia Gruesa Libre&subset=latin-ext' => 'Averia Gruesa Libre latin-ext',
	  'Averia Libre:300' => 'Averia Libre bold (300) ',
	  'Averia Libre:300italic' => 'Averia Libre bold (300) italic',
	  'Averia Libre' => 'Averia Libre',
	  'Averia Libre:400italic' => 'Averia Libre  italic',
	  'Averia Libre:700' => 'Averia Libre bold (700) ',
	  'Averia Libre:700italic' => 'Averia Libre bold (700) italic',
	  'Averia Sans Libre:300' => 'Averia Sans Libre bold (300) ',
	  'Averia Sans Libre:300italic' => 'Averia Sans Libre bold (300) italic',
	  'Averia Sans Libre' => 'Averia Sans Libre',
	  'Averia Sans Libre:400italic' => 'Averia Sans Libre  italic',
	  'Averia Sans Libre:700' => 'Averia Sans Libre bold (700) ',
	  'Averia Sans Libre:700italic' => 'Averia Sans Libre bold (700) italic',
	  'Averia Serif Libre:300' => 'Averia Serif Libre bold (300) ',
	  'Averia Serif Libre:300italic' => 'Averia Serif Libre bold (300) italic',
	  'Averia Serif Libre' => 'Averia Serif Libre',
	  'Averia Serif Libre:400italic' => 'Averia Serif Libre  italic',
	  'Averia Serif Libre:700' => 'Averia Serif Libre bold (700) ',
	  'Averia Serif Libre:700italic' => 'Averia Serif Libre bold (700) italic',
	  'Bad Script' => 'Bad Script',
	  'Bad Script&subset=cyrillic' => 'Bad Script cyrillic',
	  'Balthazar' => 'Balthazar',
	  'Bangers' => 'Bangers',
	  'Basic' => 'Basic',
	  'Basic&subset=latin-ext' => 'Basic latin-ext',
	  'Battambang' => 'Battambang',
	  'Battambang:700' => 'Battambang bold (700) ',
	  'Baumans' => 'Baumans',
	  'Bayon' => 'Bayon',
	  'Belgrano' => 'Belgrano',
	  'Belleza' => 'Belleza',
	  'Belleza&subset=latin-ext' => 'Belleza latin-ext',
	  'BenchNine:300' => 'BenchNine bold (300) ',
	  'BenchNine' => 'BenchNine',
	  'BenchNine:700' => 'BenchNine bold (700) ',
	  'BenchNine&subset=latin-ext' => 'BenchNine latin-ext',
	  'BenchNine:300&subset=latin-ext' => 'BenchNine bold (300)  latin-ext',
	  'BenchNine:700&subset=latin-ext' => 'BenchNine bold (700)  latin-ext',
	  'Bentham' => 'Bentham',
	  'Berkshire Swash' => 'Berkshire Swash',
	  'Berkshire Swash&subset=latin-ext' => 'Berkshire Swash latin-ext',
	  'Bevan' => 'Bevan',
	  'Bigelow Rules' => 'Bigelow Rules',
	  'Bigelow Rules&subset=latin-ext' => 'Bigelow Rules latin-ext',
	  'Bigshot One' => 'Bigshot One',
	  'Bilbo' => 'Bilbo',
	  'Bilbo&subset=latin-ext' => 'Bilbo latin-ext',
	  'Bilbo Swash Caps' => 'Bilbo Swash Caps',
	  'Bilbo Swash Caps&subset=latin-ext' => 'Bilbo Swash Caps latin-ext',
	  'Bitter' => 'Bitter',
	  'Bitter:400italic' => 'Bitter  italic',
	  'Bitter:700' => 'Bitter bold (700) ',
	  'Bitter&subset=latin-ext' => 'Bitter latin-ext',
	  'Bitter:400italic&subset=latin-ext' => 'Bitter  italic latin-ext',
	  'Bitter:700&subset=latin-ext' => 'Bitter bold (700)  latin-ext',
	  'Black Ops One' => 'Black Ops One',
	  'Black Ops One&subset=latin-ext' => 'Black Ops One latin-ext',
	  'Bokor' => 'Bokor',
	  'Bonbon' => 'Bonbon',
	  'Boogaloo' => 'Boogaloo',
	  'Bowlby One' => 'Bowlby One',
	  'Bowlby One SC' => 'Bowlby One SC',
	  'Bowlby One SC&subset=latin-ext' => 'Bowlby One SC latin-ext',
	  'Brawler' => 'Brawler',
	  'Bree Serif' => 'Bree Serif',
	  'Bree Serif&subset=latin-ext' => 'Bree Serif latin-ext',
	  'Bubblegum Sans' => 'Bubblegum Sans',
	  'Bubblegum Sans&subset=latin-ext' => 'Bubblegum Sans latin-ext',
	  'Bubbler One' => 'Bubbler One',
	  'Bubbler One&subset=latin-ext' => 'Bubbler One latin-ext',
	  'Buda:300' => 'Buda bold (300) ',
	  'Buenard' => 'Buenard',
	  'Buenard:700' => 'Buenard bold (700) ',
	  'Buenard&subset=latin-ext' => 'Buenard latin-ext',
	  'Buenard:700&subset=latin-ext' => 'Buenard bold (700)  latin-ext',
	  'Butcherman' => 'Butcherman',
	  'Butcherman&subset=latin-ext' => 'Butcherman latin-ext',
	  'Butterfly Kids' => 'Butterfly Kids',
	  'Butterfly Kids&subset=latin-ext' => 'Butterfly Kids latin-ext',
	  'Cabin' => 'Cabin',
	  'Cabin:400italic' => 'Cabin  italic',
	  'Cabin:500' => 'Cabin bold (500) ',
	  'Cabin:500italic' => 'Cabin bold (500) italic',
	  'Cabin:600' => 'Cabin bold (600) ',
	  'Cabin:600italic' => 'Cabin bold (600) italic',
	  'Cabin:700' => 'Cabin bold (700) ',
	  'Cabin:700italic' => 'Cabin bold (700) italic',
	  'Cabin Condensed' => 'Cabin Condensed',
	  'Cabin Condensed:500' => 'Cabin Condensed bold (500) ',
	  'Cabin Condensed:600' => 'Cabin Condensed bold (600) ',
	  'Cabin Condensed:700' => 'Cabin Condensed bold (700) ',
	  'Cabin Sketch' => 'Cabin Sketch',
	  'Cabin Sketch:700' => 'Cabin Sketch bold (700) ',
	  'Caesar Dressing' => 'Caesar Dressing',
	  'Cagliostro' => 'Cagliostro',
	  'Calligraffitti' => 'Calligraffitti',
	  'Cambo' => 'Cambo',
	  'Candal' => 'Candal',
	  'Cantarell' => 'Cantarell',
	  'Cantarell:400italic' => 'Cantarell  italic',
	  'Cantarell:700' => 'Cantarell bold (700) ',
	  'Cantarell:700italic' => 'Cantarell bold (700) italic',
	  'Cantata One' => 'Cantata One',
	  'Cantata One&subset=latin-ext' => 'Cantata One latin-ext',
	  'Cantora One' => 'Cantora One',
	  'Cantora One&subset=latin-ext' => 'Cantora One latin-ext',
	  'Capriola' => 'Capriola',
	  'Capriola&subset=latin-ext' => 'Capriola latin-ext',
	  'Cardo' => 'Cardo',
	  'Cardo:400italic' => 'Cardo  italic',
	  'Cardo:700' => 'Cardo bold (700) ',
	  'Cardo&subset=latin-ext' => 'Cardo latin-ext',
	  'Cardo&subset=greek-ext' => 'Cardo greek-ext',
	  'Cardo&subset=greek' => 'Cardo greek',
	  'Cardo:400italic&subset=latin-ext' => 'Cardo  italic latin-ext',
	  'Cardo:400italic&subset=greek-ext' => 'Cardo  italic greek-ext',
	  'Cardo:400italic&subset=greek' => 'Cardo  italic greek',
	  'Cardo:700&subset=latin-ext' => 'Cardo bold (700)  latin-ext',
	  'Cardo:700&subset=greek-ext' => 'Cardo bold (700)  greek-ext',
	  'Cardo:700&subset=greek' => 'Cardo bold (700)  greek',
	  'Carme' => 'Carme',
	  'Carrois Gothic' => 'Carrois Gothic',
	  'Carrois Gothic SC' => 'Carrois Gothic SC',
	  'Carter One' => 'Carter One',
	  'Caudex' => 'Caudex',
	  'Caudex:400italic' => 'Caudex  italic',
	  'Caudex:700' => 'Caudex bold (700) ',
	  'Caudex:700italic' => 'Caudex bold (700) italic',
	  'Caudex&subset=latin-ext' => 'Caudex latin-ext',
	  'Caudex&subset=greek-ext' => 'Caudex greek-ext',
	  'Caudex&subset=greek' => 'Caudex greek',
	  'Caudex:400italic&subset=latin-ext' => 'Caudex  italic latin-ext',
	  'Caudex:400italic&subset=greek-ext' => 'Caudex  italic greek-ext',
	  'Caudex:400italic&subset=greek' => 'Caudex  italic greek',
	  'Caudex:700&subset=latin-ext' => 'Caudex bold (700)  latin-ext',
	  'Caudex:700&subset=greek-ext' => 'Caudex bold (700)  greek-ext',
	  'Caudex:700&subset=greek' => 'Caudex bold (700)  greek',
	  'Caudex:700italic&subset=latin-ext' => 'Caudex bold (700) italic latin-ext',
	  'Caudex:700italic&subset=greek-ext' => 'Caudex bold (700) italic greek-ext',
	  'Caudex:700italic&subset=greek' => 'Caudex bold (700) italic greek',
	  'Cedarville Cursive' => 'Cedarville Cursive',
	  'Ceviche One' => 'Ceviche One',
	  'Changa One' => 'Changa One',
	  'Changa One:400italic' => 'Changa One  italic',
	  'Chango' => 'Chango',
	  'Chango&subset=latin-ext' => 'Chango latin-ext',
	  'Chau Philomene One' => 'Chau Philomene One',
	  'Chau Philomene One:400italic' => 'Chau Philomene One  italic',
	  'Chau Philomene One&subset=latin-ext' => 'Chau Philomene One latin-ext',
	  'Chau Philomene One:400italic&subset=latin-ext' => 'Chau Philomene One  italic latin-ext',
	  'Chela One' => 'Chela One',
	  'Chela One&subset=latin-ext' => 'Chela One latin-ext',
	  'Chelsea Market' => 'Chelsea Market',
	  'Chelsea Market&subset=latin-ext' => 'Chelsea Market latin-ext',
	  'Chenla' => 'Chenla',
	  'Cherry Cream Soda' => 'Cherry Cream Soda',
	  'Cherry Swash' => 'Cherry Swash',
	  'Cherry Swash:700' => 'Cherry Swash bold (700) ',
	  'Cherry Swash&subset=latin-ext' => 'Cherry Swash latin-ext',
	  'Cherry Swash:700&subset=latin-ext' => 'Cherry Swash bold (700)  latin-ext',
	  'Chewy' => 'Chewy',
	  'Chicle' => 'Chicle',
	  'Chicle&subset=latin-ext' => 'Chicle latin-ext',
	  'Chivo' => 'Chivo',
	  'Chivo:400italic' => 'Chivo  italic',
	  'Chivo:900' => 'Chivo bold (900) ',
	  'Chivo:900italic' => 'Chivo bold (900) italic',
	  'Cinzel' => 'Cinzel',
	  'Cinzel:700' => 'Cinzel bold (700) ',
	  'Cinzel:900' => 'Cinzel bold (900) ',
	  'Cinzel Decorative' => 'Cinzel Decorative',
	  'Cinzel Decorative:700' => 'Cinzel Decorative bold (700) ',
	  'Cinzel Decorative:900' => 'Cinzel Decorative bold (900) ',
	  'Clicker Script' => 'Clicker Script',
	  'Clicker Script&subset=latin-ext' => 'Clicker Script latin-ext',
	  'Coda' => 'Coda',
	  'Coda:800' => 'Coda bold (800) ',
	  'Coda Caption:800' => 'Coda Caption bold (800) ',
	  'Codystar:300' => 'Codystar bold (300) ',
	  'Codystar' => 'Codystar',
	  'Codystar&subset=latin-ext' => 'Codystar latin-ext',
	  'Codystar:300&subset=latin-ext' => 'Codystar bold (300)  latin-ext',
	  'Combo' => 'Combo',
	  'Combo&subset=latin-ext' => 'Combo latin-ext',
	  'Comfortaa:300' => 'Comfortaa bold (300) ',
	  'Comfortaa' => 'Comfortaa',
	  'Comfortaa:700' => 'Comfortaa bold (700) ',
	  'Comfortaa&subset=latin-ext' => 'Comfortaa latin-ext',
	  'Comfortaa&subset=cyrillic-ext' => 'Comfortaa cyrillic-ext',
	  'Comfortaa&subset=cyrillic' => 'Comfortaa cyrillic',
	  'Comfortaa&subset=greek' => 'Comfortaa greek',
	  'Comfortaa:300&subset=latin-ext' => 'Comfortaa bold (300)  latin-ext',
	  'Comfortaa:300&subset=cyrillic-ext' => 'Comfortaa bold (300)  cyrillic-ext',
	  'Comfortaa:300&subset=cyrillic' => 'Comfortaa bold (300)  cyrillic',
	  'Comfortaa:300&subset=greek' => 'Comfortaa bold (300)  greek',
	  'Comfortaa:700&subset=latin-ext' => 'Comfortaa bold (700)  latin-ext',
	  'Comfortaa:700&subset=cyrillic-ext' => 'Comfortaa bold (700)  cyrillic-ext',
	  'Comfortaa:700&subset=cyrillic' => 'Comfortaa bold (700)  cyrillic',
	  'Comfortaa:700&subset=greek' => 'Comfortaa bold (700)  greek',
	  'Coming Soon' => 'Coming Soon',
	  'Concert One' => 'Concert One',
	  'Concert One&subset=latin-ext' => 'Concert One latin-ext',
	  'Condiment' => 'Condiment',
	  'Condiment&subset=latin-ext' => 'Condiment latin-ext',
	  'Content' => 'Content',
	  'Content:700' => 'Content bold (700) ',
	  'Contrail One' => 'Contrail One',
	  'Convergence' => 'Convergence',
	  'Cookie' => 'Cookie',
	  'Copse' => 'Copse',
	  'Corben' => 'Corben',
	  'Corben:700' => 'Corben bold (700) ',
	  'Courgette' => 'Courgette',
	  'Courgette&subset=latin-ext' => 'Courgette latin-ext',
	  'Cousine' => 'Cousine',
	  'Cousine:400italic' => 'Cousine  italic',
	  'Cousine:700' => 'Cousine bold (700) ',
	  'Cousine:700italic' => 'Cousine bold (700) italic',
	  'Coustard' => 'Coustard',
	  'Coustard:900' => 'Coustard bold (900) ',
	  'Covered By Your Grace' => 'Covered By Your Grace',
	  'Crafty Girls' => 'Crafty Girls',
	  'Creepster' => 'Creepster',
	  'Crete Round' => 'Crete Round',
	  'Crete Round:400italic' => 'Crete Round  italic',
	  'Crete Round&subset=latin-ext' => 'Crete Round latin-ext',
	  'Crete Round:400italic&subset=latin-ext' => 'Crete Round  italic latin-ext',
	  'Crimson Text' => 'Crimson Text',
	  'Crimson Text:400italic' => 'Crimson Text  italic',
	  'Crimson Text:600' => 'Crimson Text bold (600) ',
	  'Crimson Text:600italic' => 'Crimson Text bold (600) italic',
	  'Crimson Text:700' => 'Crimson Text bold (700) ',
	  'Crimson Text:700italic' => 'Crimson Text bold (700) italic',
	  'Croissant One' => 'Croissant One',
	  'Croissant One&subset=latin-ext' => 'Croissant One latin-ext',
	  'Crushed' => 'Crushed',
	  'Cuprum' => 'Cuprum',
	  'Cuprum:400italic' => 'Cuprum  italic',
	  'Cuprum:700' => 'Cuprum bold (700) ',
	  'Cuprum:700italic' => 'Cuprum bold (700) italic',
	  'Cuprum&subset=latin-ext' => 'Cuprum latin-ext',
	  'Cuprum&subset=cyrillic' => 'Cuprum cyrillic',
	  'Cuprum:400italic&subset=latin-ext' => 'Cuprum  italic latin-ext',
	  'Cuprum:400italic&subset=cyrillic' => 'Cuprum  italic cyrillic',
	  'Cuprum:700&subset=latin-ext' => 'Cuprum bold (700)  latin-ext',
	  'Cuprum:700&subset=cyrillic' => 'Cuprum bold (700)  cyrillic',
	  'Cuprum:700italic&subset=latin-ext' => 'Cuprum bold (700) italic latin-ext',
	  'Cuprum:700italic&subset=cyrillic' => 'Cuprum bold (700) italic cyrillic',
	  'Cutive' => 'Cutive',
	  'Cutive&subset=latin-ext' => 'Cutive latin-ext',
	  'Cutive Mono' => 'Cutive Mono',
	  'Cutive Mono&subset=latin-ext' => 'Cutive Mono latin-ext',
	  'Damion' => 'Damion',
	  'Dancing Script' => 'Dancing Script',
	  'Dancing Script:700' => 'Dancing Script bold (700) ',
	  'Dangrek' => 'Dangrek',
	  'Dawning of a New Day' => 'Dawning of a New Day',
	  'Days One' => 'Days One',
	  'Delius' => 'Delius',
	  'Delius Swash Caps' => 'Delius Swash Caps',
	  'Delius Unicase' => 'Delius Unicase',
	  'Delius Unicase:700' => 'Delius Unicase bold (700) ',
	  'Della Respira' => 'Della Respira',
	  'Denk One' => 'Denk One',
	  'Denk One&subset=latin-ext' => 'Denk One latin-ext',
	  'Devonshire' => 'Devonshire',
	  'Devonshire&subset=latin-ext' => 'Devonshire latin-ext',
	  'Didact Gothic' => 'Didact Gothic',
	  'Didact Gothic&subset=latin-ext' => 'Didact Gothic latin-ext',
	  'Didact Gothic&subset=greek-ext' => 'Didact Gothic greek-ext',
	  'Didact Gothic&subset=cyrillic-ext' => 'Didact Gothic cyrillic-ext',
	  'Didact Gothic&subset=cyrillic' => 'Didact Gothic cyrillic',
	  'Didact Gothic&subset=greek' => 'Didact Gothic greek',
	  'Diplomata' => 'Diplomata',
	  'Diplomata&subset=latin-ext' => 'Diplomata latin-ext',
	  'Diplomata SC' => 'Diplomata SC',
	  'Diplomata SC&subset=latin-ext' => 'Diplomata SC latin-ext',
	  'Domine' => 'Domine',
	  'Domine:700' => 'Domine bold (700) ',
	  'Domine&subset=latin-ext' => 'Domine latin-ext',
	  'Domine:700&subset=latin-ext' => 'Domine bold (700)  latin-ext',
	  'Donegal One' => 'Donegal One',
	  'Donegal One&subset=latin-ext' => 'Donegal One latin-ext',
	  'Doppio One' => 'Doppio One',
	  'Doppio One&subset=latin-ext' => 'Doppio One latin-ext',
	  'Dorsa' => 'Dorsa',
	  'Dosis:200' => 'Dosis bold (200) ',
	  'Dosis:300' => 'Dosis bold (300) ',
	  'Dosis' => 'Dosis',
	  'Dosis:500' => 'Dosis bold (500) ',
	  'Dosis:600' => 'Dosis bold (600) ',
	  'Dosis:700' => 'Dosis bold (700) ',
	  'Dosis:800' => 'Dosis bold (800) ',
	  'Dosis&subset=latin-ext' => 'Dosis latin-ext',
	  'Dosis:200&subset=latin-ext' => 'Dosis bold (200)  latin-ext',
	  'Dosis:300&subset=latin-ext' => 'Dosis bold (300)  latin-ext',
	  'Dosis:500&subset=latin-ext' => 'Dosis bold (500)  latin-ext',
	  'Dosis:600&subset=latin-ext' => 'Dosis bold (600)  latin-ext',
	  'Dosis:700&subset=latin-ext' => 'Dosis bold (700)  latin-ext',
	  'Dosis:800&subset=latin-ext' => 'Dosis bold (800)  latin-ext',
	  'Dr Sugiyama' => 'Dr Sugiyama',
	  'Dr Sugiyama&subset=latin-ext' => 'Dr Sugiyama latin-ext',
	  'Droid Sans' => 'Droid Sans',
	  'Droid Sans:700' => 'Droid Sans bold (700) ',
	  'Droid Sans Mono' => 'Droid Sans Mono',
	  'Droid Serif' => 'Droid Serif',
	  'Droid Serif:400italic' => 'Droid Serif  italic',
	  'Droid Serif:700' => 'Droid Serif bold (700) ',
	  'Droid Serif:700italic' => 'Droid Serif bold (700) italic',
	  'Duru Sans' => 'Duru Sans',
	  'Duru Sans&subset=latin-ext' => 'Duru Sans latin-ext',
	  'Dynalight' => 'Dynalight',
	  'Dynalight&subset=latin-ext' => 'Dynalight latin-ext',
	  'EB Garamond' => 'EB Garamond',
	  'EB Garamond&subset=latin-ext' => 'EB Garamond latin-ext',
	  'EB Garamond&subset=cyrillic-ext' => 'EB Garamond cyrillic-ext',
	  'EB Garamond&subset=cyrillic' => 'EB Garamond cyrillic',
	  'EB Garamond&subset=vietnamese' => 'EB Garamond vietnamese',
	  'Eagle Lake' => 'Eagle Lake',
	  'Eagle Lake&subset=latin-ext' => 'Eagle Lake latin-ext',
	  'Eater' => 'Eater',
	  'Eater&subset=latin-ext' => 'Eater latin-ext',
	  'Economica' => 'Economica',
	  'Economica:400italic' => 'Economica  italic',
	  'Economica:700' => 'Economica bold (700) ',
	  'Economica:700italic' => 'Economica bold (700) italic',
	  'Economica&subset=latin-ext' => 'Economica latin-ext',
	  'Economica:400italic&subset=latin-ext' => 'Economica  italic latin-ext',
	  'Economica:700&subset=latin-ext' => 'Economica bold (700)  latin-ext',
	  'Economica:700italic&subset=latin-ext' => 'Economica bold (700) italic latin-ext',
	  'Electrolize' => 'Electrolize',
	  'Elsie' => 'Elsie',
	  'Elsie:900' => 'Elsie bold (900) ',
	  'Elsie&subset=latin-ext' => 'Elsie latin-ext',
	  'Elsie:900&subset=latin-ext' => 'Elsie bold (900)  latin-ext',
	  'Elsie Swash Caps' => 'Elsie Swash Caps',
	  'Elsie Swash Caps:900' => 'Elsie Swash Caps bold (900) ',
	  'Elsie Swash Caps&subset=latin-ext' => 'Elsie Swash Caps latin-ext',
	  'Elsie Swash Caps:900&subset=latin-ext' => 'Elsie Swash Caps bold (900)  latin-ext',
	  'Emblema One' => 'Emblema One',
	  'Emblema One&subset=latin-ext' => 'Emblema One latin-ext',
	  'Emilys Candy' => 'Emilys Candy',
	  'Emilys Candy&subset=latin-ext' => 'Emilys Candy latin-ext',
	  'Engagement' => 'Engagement',
	  'Englebert' => 'Englebert',
	  'Englebert&subset=latin-ext' => 'Englebert latin-ext',
	  'Enriqueta' => 'Enriqueta',
	  'Enriqueta:700' => 'Enriqueta bold (700) ',
	  'Enriqueta&subset=latin-ext' => 'Enriqueta latin-ext',
	  'Enriqueta:700&subset=latin-ext' => 'Enriqueta bold (700)  latin-ext',
	  'Erica One' => 'Erica One',
	  'Esteban' => 'Esteban',
	  'Esteban&subset=latin-ext' => 'Esteban latin-ext',
	  'Euphoria Script' => 'Euphoria Script',
	  'Euphoria Script&subset=latin-ext' => 'Euphoria Script latin-ext',
	  'Ewert' => 'Ewert',
	  'Ewert&subset=latin-ext' => 'Ewert latin-ext',
	  'Exo:100' => 'Exo bold (100) ',
	  'Exo:100italic' => 'Exo bold (100) italic',
	  'Exo:200' => 'Exo bold (200) ',
	  'Exo:200italic' => 'Exo bold (200) italic',
	  'Exo:300' => 'Exo bold (300) ',
	  'Exo:300italic' => 'Exo bold (300) italic',
	  'Exo' => 'Exo',
	  'Exo:400italic' => 'Exo  italic',
	  'Exo:500' => 'Exo bold (500) ',
	  'Exo:500italic' => 'Exo bold (500) italic',
	  'Exo:600' => 'Exo bold (600) ',
	  'Exo:600italic' => 'Exo bold (600) italic',
	  'Exo:700' => 'Exo bold (700) ',
	  'Exo:700italic' => 'Exo bold (700) italic',
	  'Exo:800' => 'Exo bold (800) ',
	  'Exo:800italic' => 'Exo bold (800) italic',
	  'Exo:900' => 'Exo bold (900) ',
	  'Exo:900italic' => 'Exo bold (900) italic',
	  'Exo&subset=latin-ext' => 'Exo latin-ext',
	  'Exo:100&subset=latin-ext' => 'Exo bold (100)  latin-ext',
	  'Exo:100italic&subset=latin-ext' => 'Exo bold (100) italic latin-ext',
	  'Exo:200&subset=latin-ext' => 'Exo bold (200)  latin-ext',
	  'Exo:200italic&subset=latin-ext' => 'Exo bold (200) italic latin-ext',
	  'Exo:300&subset=latin-ext' => 'Exo bold (300)  latin-ext',
	  'Exo:300italic&subset=latin-ext' => 'Exo bold (300) italic latin-ext',
	  'Exo:400italic&subset=latin-ext' => 'Exo  italic latin-ext',
	  'Exo:500&subset=latin-ext' => 'Exo bold (500)  latin-ext',
	  'Exo:500italic&subset=latin-ext' => 'Exo bold (500) italic latin-ext',
	  'Exo:600&subset=latin-ext' => 'Exo bold (600)  latin-ext',
	  'Exo:600italic&subset=latin-ext' => 'Exo bold (600) italic latin-ext',
	  'Exo:700&subset=latin-ext' => 'Exo bold (700)  latin-ext',
	  'Exo:700italic&subset=latin-ext' => 'Exo bold (700) italic latin-ext',
	  'Exo:800&subset=latin-ext' => 'Exo bold (800)  latin-ext',
	  'Exo:800italic&subset=latin-ext' => 'Exo bold (800) italic latin-ext',
	  'Exo:900&subset=latin-ext' => 'Exo bold (900)  latin-ext',
	  'Exo:900italic&subset=latin-ext' => 'Exo bold (900) italic latin-ext',
	  'Expletus Sans' => 'Expletus Sans',
	  'Expletus Sans:400italic' => 'Expletus Sans  italic',
	  'Expletus Sans:500' => 'Expletus Sans bold (500) ',
	  'Expletus Sans:500italic' => 'Expletus Sans bold (500) italic',
	  'Expletus Sans:600' => 'Expletus Sans bold (600) ',
	  'Expletus Sans:600italic' => 'Expletus Sans bold (600) italic',
	  'Expletus Sans:700' => 'Expletus Sans bold (700) ',
	  'Expletus Sans:700italic' => 'Expletus Sans bold (700) italic',
	  'Fanwood Text' => 'Fanwood Text',
	  'Fanwood Text:400italic' => 'Fanwood Text  italic',
	  'Fascinate' => 'Fascinate',
	  'Fascinate Inline' => 'Fascinate Inline',
	  'Faster One' => 'Faster One',
	  'Fasthand' => 'Fasthand',
	  'Fauna One' => 'Fauna One',
	  'Fauna One&subset=latin-ext' => 'Fauna One latin-ext',
	  'Federant' => 'Federant',
	  'Federo' => 'Federo',
	  'Felipa' => 'Felipa',
	  'Felipa&subset=latin-ext' => 'Felipa latin-ext',
	  'Fenix' => 'Fenix',
	  'Fenix&subset=latin-ext' => 'Fenix latin-ext',
	  'Finger Paint' => 'Finger Paint',
	  'Fjalla One' => 'Fjalla One',
	  'Fjalla One&subset=latin-ext' => 'Fjalla One latin-ext',
	  'Fjord One' => 'Fjord One',
	  'Flamenco:300' => 'Flamenco bold (300) ',
	  'Flamenco' => 'Flamenco',
	  'Flavors' => 'Flavors',
	  'Fondamento' => 'Fondamento',
	  'Fondamento:400italic' => 'Fondamento  italic',
	  'Fondamento&subset=latin-ext' => 'Fondamento latin-ext',
	  'Fondamento:400italic&subset=latin-ext' => 'Fondamento  italic latin-ext',
	  'Fontdiner Swanky' => 'Fontdiner Swanky',
	  'Forum' => 'Forum',
	  'Forum&subset=latin-ext' => 'Forum latin-ext',
	  'Forum&subset=cyrillic-ext' => 'Forum cyrillic-ext',
	  'Forum&subset=cyrillic' => 'Forum cyrillic',
	  'Francois One' => 'Francois One',
	  'Francois One&subset=latin-ext' => 'Francois One latin-ext',
	  'Freckle Face' => 'Freckle Face',
	  'Freckle Face&subset=latin-ext' => 'Freckle Face latin-ext',
	  'Fredericka the Great' => 'Fredericka the Great',
	  'Fredoka One' => 'Fredoka One',
	  'Freehand' => 'Freehand',
	  'Fresca' => 'Fresca',
	  'Fresca&subset=latin-ext' => 'Fresca latin-ext',
	  'Frijole' => 'Frijole',
	  'Fruktur' => 'Fruktur',
	  'Fruktur&subset=latin-ext' => 'Fruktur latin-ext',
	  'Fugaz One' => 'Fugaz One',
	  'GFS Didot' => 'GFS Didot',
	  'GFS Neohellenic' => 'GFS Neohellenic',
	  'GFS Neohellenic:400italic' => 'GFS Neohellenic  italic',
	  'GFS Neohellenic:700' => 'GFS Neohellenic bold (700) ',
	  'GFS Neohellenic:700italic' => 'GFS Neohellenic bold (700) italic',
	  'Gabriela' => 'Gabriela',
	  'Gabriela&subset=latin-ext' => 'Gabriela latin-ext',
	  'Gafata' => 'Gafata',
	  'Gafata&subset=latin-ext' => 'Gafata latin-ext',
	  'Galdeano' => 'Galdeano',
	  'Galindo' => 'Galindo',
	  'Galindo&subset=latin-ext' => 'Galindo latin-ext',
	  'Gentium Basic' => 'Gentium Basic',
	  'Gentium Basic:400italic' => 'Gentium Basic  italic',
	  'Gentium Basic:700' => 'Gentium Basic bold (700) ',
	  'Gentium Basic:700italic' => 'Gentium Basic bold (700) italic',
	  'Gentium Basic&subset=latin-ext' => 'Gentium Basic latin-ext',
	  'Gentium Basic:400italic&subset=latin-ext' => 'Gentium Basic  italic latin-ext',
	  'Gentium Basic:700&subset=latin-ext' => 'Gentium Basic bold (700)  latin-ext',
	  'Gentium Basic:700italic&subset=latin-ext' => 'Gentium Basic bold (700) italic latin-ext',
	  'Gentium Book Basic' => 'Gentium Book Basic',
	  'Gentium Book Basic:400italic' => 'Gentium Book Basic  italic',
	  'Gentium Book Basic:700' => 'Gentium Book Basic bold (700) ',
	  'Gentium Book Basic:700italic' => 'Gentium Book Basic bold (700) italic',
	  'Gentium Book Basic&subset=latin-ext' => 'Gentium Book Basic latin-ext',
	  'Gentium Book Basic:400italic&subset=latin-ext' => 'Gentium Book Basic  italic latin-ext',
	  'Gentium Book Basic:700&subset=latin-ext' => 'Gentium Book Basic bold (700)  latin-ext',
	  'Gentium Book Basic:700italic&subset=latin-ext' => 'Gentium Book Basic bold (700) italic latin-ext',
	  'Geo' => 'Geo',
	  'Geo:400italic' => 'Geo  italic',
	  'Geostar' => 'Geostar',
	  'Geostar Fill' => 'Geostar Fill',
	  'Germania One' => 'Germania One',
	  'Gilda Display' => 'Gilda Display',
	  'Gilda Display&subset=latin-ext' => 'Gilda Display latin-ext',
	  'Give You Glory' => 'Give You Glory',
	  'Glass Antiqua' => 'Glass Antiqua',
	  'Glass Antiqua&subset=latin-ext' => 'Glass Antiqua latin-ext',
	  'Glegoo' => 'Glegoo',
	  'Glegoo&subset=latin-ext' => 'Glegoo latin-ext',
	  'Gloria Hallelujah' => 'Gloria Hallelujah',
	  'Goblin One' => 'Goblin One',
	  'Gochi Hand' => 'Gochi Hand',
	  'Gorditas' => 'Gorditas',
	  'Gorditas:700' => 'Gorditas bold (700) ',
	  'Goudy Bookletter 1911' => 'Goudy Bookletter 1911',
	  'Graduate' => 'Graduate',
	  'Grand Hotel' => 'Grand Hotel',
	  'Grand Hotel&subset=latin-ext' => 'Grand Hotel latin-ext',
	  'Gravitas One' => 'Gravitas One',
	  'Great Vibes' => 'Great Vibes',
	  'Great Vibes&subset=latin-ext' => 'Great Vibes latin-ext',
	  'Griffy' => 'Griffy',
	  'Griffy&subset=latin-ext' => 'Griffy latin-ext',
	  'Gruppo' => 'Gruppo',
	  'Gruppo&subset=latin-ext' => 'Gruppo latin-ext',
	  'Gudea' => 'Gudea',
	  'Gudea:400italic' => 'Gudea  italic',
	  'Gudea:700' => 'Gudea bold (700) ',
	  'Gudea&subset=latin-ext' => 'Gudea latin-ext',
	  'Gudea:400italic&subset=latin-ext' => 'Gudea  italic latin-ext',
	  'Gudea:700&subset=latin-ext' => 'Gudea bold (700)  latin-ext',
	  'Habibi' => 'Habibi',
	  'Habibi&subset=latin-ext' => 'Habibi latin-ext',
	  'Hammersmith One' => 'Hammersmith One',
	  'Hammersmith One&subset=latin-ext' => 'Hammersmith One latin-ext',
	  'Hanalei' => 'Hanalei',
	  'Hanalei&subset=latin-ext' => 'Hanalei latin-ext',
	  'Hanalei Fill' => 'Hanalei Fill',
	  'Hanalei Fill&subset=latin-ext' => 'Hanalei Fill latin-ext',
	  'Handlee' => 'Handlee',
	  'Hanuman' => 'Hanuman',
	  'Hanuman:700' => 'Hanuman bold (700) ',
	  'Happy Monkey' => 'Happy Monkey',
	  'Happy Monkey&subset=latin-ext' => 'Happy Monkey latin-ext',
	  'Headland One' => 'Headland One',
	  'Headland One&subset=latin-ext' => 'Headland One latin-ext',
	  'Henny Penny' => 'Henny Penny',
	  'Herr Von Muellerhoff' => 'Herr Von Muellerhoff',
	  'Herr Von Muellerhoff&subset=latin-ext' => 'Herr Von Muellerhoff latin-ext',
	  'Holtwood One SC' => 'Holtwood One SC',
	  'Homemade Apple' => 'Homemade Apple',
	  'Homenaje' => 'Homenaje',
	  'Homenaje&subset=latin-ext' => 'Homenaje latin-ext',
	  'IM Fell DW Pica' => 'IM Fell DW Pica',
	  'IM Fell DW Pica:400italic' => 'IM Fell DW Pica  italic',
	  'IM Fell DW Pica SC' => 'IM Fell DW Pica SC',
	  'IM Fell Double Pica' => 'IM Fell Double Pica',
	  'IM Fell Double Pica:400italic' => 'IM Fell Double Pica  italic',
	  'IM Fell Double Pica SC' => 'IM Fell Double Pica SC',
	  'IM Fell English' => 'IM Fell English',
	  'IM Fell English:400italic' => 'IM Fell English  italic',
	  'IM Fell English SC' => 'IM Fell English SC',
	  'IM Fell French Canon' => 'IM Fell French Canon',
	  'IM Fell French Canon:400italic' => 'IM Fell French Canon  italic',
	  'IM Fell French Canon SC' => 'IM Fell French Canon SC',
	  'IM Fell Great Primer' => 'IM Fell Great Primer',
	  'IM Fell Great Primer:400italic' => 'IM Fell Great Primer  italic',
	  'IM Fell Great Primer SC' => 'IM Fell Great Primer SC',
	  'Iceberg' => 'Iceberg',
	  'Iceland' => 'Iceland',
	  'Imprima' => 'Imprima',
	  'Imprima&subset=latin-ext' => 'Imprima latin-ext',
	  'Inconsolata' => 'Inconsolata',
	  'Inconsolata:700' => 'Inconsolata bold (700) ',
	  'Inconsolata&subset=latin-ext' => 'Inconsolata latin-ext',
	  'Inconsolata:700&subset=latin-ext' => 'Inconsolata bold (700)  latin-ext',
	  'Inder' => 'Inder',
	  'Inder&subset=latin-ext' => 'Inder latin-ext',
	  'Indie Flower' => 'Indie Flower',
	  'Inika' => 'Inika',
	  'Inika:700' => 'Inika bold (700) ',
	  'Inika&subset=latin-ext' => 'Inika latin-ext',
	  'Inika:700&subset=latin-ext' => 'Inika bold (700)  latin-ext',
	  'Irish Grover' => 'Irish Grover',
	  'Istok Web' => 'Istok Web',
	  'Istok Web:400italic' => 'Istok Web  italic',
	  'Istok Web:700' => 'Istok Web bold (700) ',
	  'Istok Web:700italic' => 'Istok Web bold (700) italic',
	  'Istok Web&subset=latin-ext' => 'Istok Web latin-ext',
	  'Istok Web&subset=cyrillic-ext' => 'Istok Web cyrillic-ext',
	  'Istok Web&subset=cyrillic' => 'Istok Web cyrillic',
	  'Istok Web:400italic&subset=latin-ext' => 'Istok Web  italic latin-ext',
	  'Istok Web:400italic&subset=cyrillic-ext' => 'Istok Web  italic cyrillic-ext',
	  'Istok Web:400italic&subset=cyrillic' => 'Istok Web  italic cyrillic',
	  'Istok Web:700&subset=latin-ext' => 'Istok Web bold (700)  latin-ext',
	  'Istok Web:700&subset=cyrillic-ext' => 'Istok Web bold (700)  cyrillic-ext',
	  'Istok Web:700&subset=cyrillic' => 'Istok Web bold (700)  cyrillic',
	  'Istok Web:700italic&subset=latin-ext' => 'Istok Web bold (700) italic latin-ext',
	  'Istok Web:700italic&subset=cyrillic-ext' => 'Istok Web bold (700) italic cyrillic-ext',
	  'Istok Web:700italic&subset=cyrillic' => 'Istok Web bold (700) italic cyrillic',
	  'Italiana' => 'Italiana',
	  'Italianno' => 'Italianno',
	  'Italianno&subset=latin-ext' => 'Italianno latin-ext',
	  'Jacques Francois' => 'Jacques Francois',
	  'Jacques Francois Shadow' => 'Jacques Francois Shadow',
	  'Jim Nightshade' => 'Jim Nightshade',
	  'Jim Nightshade&subset=latin-ext' => 'Jim Nightshade latin-ext',
	  'Jockey One' => 'Jockey One',
	  'Jockey One&subset=latin-ext' => 'Jockey One latin-ext',
	  'Jolly Lodger' => 'Jolly Lodger',
	  'Jolly Lodger&subset=latin-ext' => 'Jolly Lodger latin-ext',
	  'Josefin Sans:100' => 'Josefin Sans bold (100) ',
	  'Josefin Sans:100italic' => 'Josefin Sans bold (100) italic',
	  'Josefin Sans:300' => 'Josefin Sans bold (300) ',
	  'Josefin Sans:300italic' => 'Josefin Sans bold (300) italic',
	  'Josefin Sans' => 'Josefin Sans',
	  'Josefin Sans:400italic' => 'Josefin Sans  italic',
	  'Josefin Sans:600' => 'Josefin Sans bold (600) ',
	  'Josefin Sans:600italic' => 'Josefin Sans bold (600) italic',
	  'Josefin Sans:700' => 'Josefin Sans bold (700) ',
	  'Josefin Sans:700italic' => 'Josefin Sans bold (700) italic',
	  'Josefin Slab:100' => 'Josefin Slab bold (100) ',
	  'Josefin Slab:100italic' => 'Josefin Slab bold (100) italic',
	  'Josefin Slab:300' => 'Josefin Slab bold (300) ',
	  'Josefin Slab:300italic' => 'Josefin Slab bold (300) italic',
	  'Josefin Slab' => 'Josefin Slab',
	  'Josefin Slab:400italic' => 'Josefin Slab  italic',
	  'Josefin Slab:600' => 'Josefin Slab bold (600) ',
	  'Josefin Slab:600italic' => 'Josefin Slab bold (600) italic',
	  'Josefin Slab:700' => 'Josefin Slab bold (700) ',
	  'Josefin Slab:700italic' => 'Josefin Slab bold (700) italic',
	  'Joti One' => 'Joti One',
	  'Joti One&subset=latin-ext' => 'Joti One latin-ext',
	  'Judson' => 'Judson',
	  'Judson:400italic' => 'Judson  italic',
	  'Judson:700' => 'Judson bold (700) ',
	  'Julee' => 'Julee',
	  'Julius Sans One' => 'Julius Sans One',
	  'Julius Sans One&subset=latin-ext' => 'Julius Sans One latin-ext',
	  'Junge' => 'Junge',
	  'Jura:300' => 'Jura bold (300) ',
	  'Jura' => 'Jura',
	  'Jura:500' => 'Jura bold (500) ',
	  'Jura:600' => 'Jura bold (600) ',
	  'Jura&subset=latin-ext' => 'Jura latin-ext',
	  'Jura&subset=greek-ext' => 'Jura greek-ext',
	  'Jura&subset=cyrillic-ext' => 'Jura cyrillic-ext',
	  'Jura&subset=cyrillic' => 'Jura cyrillic',
	  'Jura&subset=greek' => 'Jura greek',
	  'Jura:300&subset=latin-ext' => 'Jura bold (300)  latin-ext',
	  'Jura:300&subset=greek-ext' => 'Jura bold (300)  greek-ext',
	  'Jura:300&subset=cyrillic-ext' => 'Jura bold (300)  cyrillic-ext',
	  'Jura:300&subset=cyrillic' => 'Jura bold (300)  cyrillic',
	  'Jura:300&subset=greek' => 'Jura bold (300)  greek',
	  'Jura:500&subset=latin-ext' => 'Jura bold (500)  latin-ext',
	  'Jura:500&subset=greek-ext' => 'Jura bold (500)  greek-ext',
	  'Jura:500&subset=cyrillic-ext' => 'Jura bold (500)  cyrillic-ext',
	  'Jura:500&subset=cyrillic' => 'Jura bold (500)  cyrillic',
	  'Jura:500&subset=greek' => 'Jura bold (500)  greek',
	  'Jura:600&subset=latin-ext' => 'Jura bold (600)  latin-ext',
	  'Jura:600&subset=greek-ext' => 'Jura bold (600)  greek-ext',
	  'Jura:600&subset=cyrillic-ext' => 'Jura bold (600)  cyrillic-ext',
	  'Jura:600&subset=cyrillic' => 'Jura bold (600)  cyrillic',
	  'Jura:600&subset=greek' => 'Jura bold (600)  greek',
	  'Just Another Hand' => 'Just Another Hand',
	  'Just Me Again Down Here' => 'Just Me Again Down Here',
	  'Just Me Again Down Here&subset=latin-ext' => 'Just Me Again Down Here latin-ext',
	  'Kameron' => 'Kameron',
	  'Kameron:700' => 'Kameron bold (700) ',
	  'Karla' => 'Karla',
	  'Karla:400italic' => 'Karla  italic',
	  'Karla:700' => 'Karla bold (700) ',
	  'Karla:700italic' => 'Karla bold (700) italic',
	  'Karla&subset=latin-ext' => 'Karla latin-ext',
	  'Karla:400italic&subset=latin-ext' => 'Karla  italic latin-ext',
	  'Karla:700&subset=latin-ext' => 'Karla bold (700)  latin-ext',
	  'Karla:700italic&subset=latin-ext' => 'Karla bold (700) italic latin-ext',
	  'Kaushan Script' => 'Kaushan Script',
	  'Kaushan Script&subset=latin-ext' => 'Kaushan Script latin-ext',
	  'Kavoon' => 'Kavoon',
	  'Kavoon&subset=latin-ext' => 'Kavoon latin-ext',
	  'Keania One' => 'Keania One',
	  'Keania One&subset=latin-ext' => 'Keania One latin-ext',
	  'Kelly Slab' => 'Kelly Slab',
	  'Kelly Slab&subset=latin-ext' => 'Kelly Slab latin-ext',
	  'Kelly Slab&subset=cyrillic' => 'Kelly Slab cyrillic',
	  'Kenia' => 'Kenia',
	  'Khmer' => 'Khmer',
	  'Kite One' => 'Kite One',
	  'Knewave' => 'Knewave',
	  'Knewave&subset=latin-ext' => 'Knewave latin-ext',
	  'Kotta One' => 'Kotta One',
	  'Kotta One&subset=latin-ext' => 'Kotta One latin-ext',
	  'Koulen' => 'Koulen',
	  'Kranky' => 'Kranky',
	  'Kreon:300' => 'Kreon bold (300) ',
	  'Kreon' => 'Kreon',
	  'Kreon:700' => 'Kreon bold (700) ',
	  'Kristi' => 'Kristi',
	  'Krona One' => 'Krona One',
	  'Krona One&subset=latin-ext' => 'Krona One latin-ext',
	  'La Belle Aurore' => 'La Belle Aurore',
	  'Lancelot' => 'Lancelot',
	  'Lato:100' => 'Lato bold (100) ',
	  'Lato:100italic' => 'Lato bold (100) italic',
	  'Lato:300' => 'Lato bold (300) ',
	  'Lato:300italic' => 'Lato bold (300) italic',
	  'Lato' => 'Lato',
	  'Lato:400italic' => 'Lato  italic',
	  'Lato:700' => 'Lato bold (700) ',
	  'Lato:700italic' => 'Lato bold (700) italic',
	  'Lato:900' => 'Lato bold (900) ',
	  'Lato:900italic' => 'Lato bold (900) italic',
	  'League Script' => 'League Script',
	  'Leckerli One' => 'Leckerli One',
	  'Ledger' => 'Ledger',
	  'Ledger&subset=latin-ext' => 'Ledger latin-ext',
	  'Ledger&subset=cyrillic' => 'Ledger cyrillic',
	  'Lekton' => 'Lekton',
	  'Lekton:400italic' => 'Lekton  italic',
	  'Lekton:700' => 'Lekton bold (700) ',
	  'Lekton&subset=latin-ext' => 'Lekton latin-ext',
	  'Lekton:400italic&subset=latin-ext' => 'Lekton  italic latin-ext',
	  'Lekton:700&subset=latin-ext' => 'Lekton bold (700)  latin-ext',
	  'Lemon' => 'Lemon',
	  'Libre Baskerville' => 'Libre Baskerville',
	  'Libre Baskerville:400italic' => 'Libre Baskerville  italic',
	  'Libre Baskerville:700' => 'Libre Baskerville bold (700) ',
	  'Libre Baskerville&subset=latin-ext' => 'Libre Baskerville latin-ext',
	  'Libre Baskerville:400italic&subset=latin-ext' => 'Libre Baskerville  italic latin-ext',
	  'Libre Baskerville:700&subset=latin-ext' => 'Libre Baskerville bold (700)  latin-ext',
	  'Life Savers' => 'Life Savers',
	  'Life Savers:700' => 'Life Savers bold (700) ',
	  'Life Savers&subset=latin-ext' => 'Life Savers latin-ext',
	  'Life Savers:700&subset=latin-ext' => 'Life Savers bold (700)  latin-ext',
	  'Lilita One' => 'Lilita One',
	  'Lilita One&subset=latin-ext' => 'Lilita One latin-ext',
	  'Lily Script One' => 'Lily Script One',
	  'Lily Script One&subset=latin-ext' => 'Lily Script One latin-ext',
	  'Limelight' => 'Limelight',
	  'Limelight&subset=latin-ext' => 'Limelight latin-ext',
	  'Linden Hill' => 'Linden Hill',
	  'Linden Hill:400italic' => 'Linden Hill  italic',
	  'Lobster' => 'Lobster',
	  'Lobster&subset=latin-ext' => 'Lobster latin-ext',
	  'Lobster&subset=cyrillic-ext' => 'Lobster cyrillic-ext',
	  'Lobster&subset=cyrillic' => 'Lobster cyrillic',
	  'Lobster Two' => 'Lobster Two',
	  'Lobster Two:400italic' => 'Lobster Two  italic',
	  'Lobster Two:700' => 'Lobster Two bold (700) ',
	  'Lobster Two:700italic' => 'Lobster Two bold (700) italic',
	  'Londrina Outline' => 'Londrina Outline',
	  'Londrina Shadow' => 'Londrina Shadow',
	  'Londrina Sketch' => 'Londrina Sketch',
	  'Londrina Solid' => 'Londrina Solid',
	  'Lora' => 'Lora',
	  'Lora:400italic' => 'Lora  italic',
	  'Lora:700' => 'Lora bold (700) ',
	  'Lora:700italic' => 'Lora bold (700) italic',
	  'Love Ya Like A Sister' => 'Love Ya Like A Sister',
	  'Loved by the King' => 'Loved by the King',
	  'Lovers Quarrel' => 'Lovers Quarrel',
	  'Lovers Quarrel&subset=latin-ext' => 'Lovers Quarrel latin-ext',
	  'Luckiest Guy' => 'Luckiest Guy',
	  'Lusitana' => 'Lusitana',
	  'Lusitana:700' => 'Lusitana bold (700) ',
	  'Lustria' => 'Lustria',
	  'Macondo' => 'Macondo',
	  'Macondo Swash Caps' => 'Macondo Swash Caps',
	  'Magra' => 'Magra',
	  'Magra:700' => 'Magra bold (700) ',
	  'Magra&subset=latin-ext' => 'Magra latin-ext',
	  'Magra:700&subset=latin-ext' => 'Magra bold (700)  latin-ext',
	  'Maiden Orange' => 'Maiden Orange',
	  'Mako' => 'Mako',
	  'Marcellus' => 'Marcellus',
	  'Marcellus&subset=latin-ext' => 'Marcellus latin-ext',
	  'Marcellus SC' => 'Marcellus SC',
	  'Marcellus SC&subset=latin-ext' => 'Marcellus SC latin-ext',
	  'Marck Script' => 'Marck Script',
	  'Marck Script&subset=latin-ext' => 'Marck Script latin-ext',
	  'Marck Script&subset=cyrillic' => 'Marck Script cyrillic',
	  'Margarine' => 'Margarine',
	  'Margarine&subset=latin-ext' => 'Margarine latin-ext',
	  'Marko One' => 'Marko One',
	  'Marmelad' => 'Marmelad',
	  'Marmelad&subset=latin-ext' => 'Marmelad latin-ext',
	  'Marmelad&subset=cyrillic' => 'Marmelad cyrillic',
	  'Marvel' => 'Marvel',
	  'Marvel:400italic' => 'Marvel  italic',
	  'Marvel:700' => 'Marvel bold (700) ',
	  'Marvel:700italic' => 'Marvel bold (700) italic',
	  'Mate' => 'Mate',
	  'Mate:400italic' => 'Mate  italic',
	  'Mate SC' => 'Mate SC',
	  'Maven Pro' => 'Maven Pro',
	  'Maven Pro:500' => 'Maven Pro bold (500) ',
	  'Maven Pro:700' => 'Maven Pro bold (700) ',
	  'Maven Pro:900' => 'Maven Pro bold (900) ',
	  'McLaren' => 'McLaren',
	  'McLaren&subset=latin-ext' => 'McLaren latin-ext',
	  'Meddon' => 'Meddon',
	  'MedievalSharp' => 'MedievalSharp',
	  'MedievalSharp&subset=latin-ext' => 'MedievalSharp latin-ext',
	  'Medula One' => 'Medula One',
	  'Megrim' => 'Megrim',
	  'Meie Script' => 'Meie Script',
	  'Meie Script&subset=latin-ext' => 'Meie Script latin-ext',
	  'Merienda' => 'Merienda',
	  'Merienda:700' => 'Merienda bold (700) ',
	  'Merienda&subset=latin-ext' => 'Merienda latin-ext',
	  'Merienda:700&subset=latin-ext' => 'Merienda bold (700)  latin-ext',
	  'Merienda One' => 'Merienda One',
	  'Merriweather:300' => 'Merriweather bold (300) ',
	  'Merriweather:300italic' => 'Merriweather bold (300) italic',
	  'Merriweather' => 'Merriweather',
	  'Merriweather:400italic' => 'Merriweather  italic',
	  'Merriweather:700' => 'Merriweather bold (700) ',
	  'Merriweather:700italic' => 'Merriweather bold (700) italic',
	  'Merriweather:900' => 'Merriweather bold (900) ',
	  'Merriweather:900italic' => 'Merriweather bold (900) italic',
	  'Merriweather&subset=latin-ext' => 'Merriweather latin-ext',
	  'Merriweather:300&subset=latin-ext' => 'Merriweather bold (300)  latin-ext',
	  'Merriweather:300italic&subset=latin-ext' => 'Merriweather bold (300) italic latin-ext',
	  'Merriweather:400italic&subset=latin-ext' => 'Merriweather  italic latin-ext',
	  'Merriweather:700&subset=latin-ext' => 'Merriweather bold (700)  latin-ext',
	  'Merriweather:700italic&subset=latin-ext' => 'Merriweather bold (700) italic latin-ext',
	  'Merriweather:900&subset=latin-ext' => 'Merriweather bold (900)  latin-ext',
	  'Merriweather:900italic&subset=latin-ext' => 'Merriweather bold (900) italic latin-ext',
	  'Merriweather Sans:300' => 'Merriweather Sans bold (300) ',
	  'Merriweather Sans:300italic' => 'Merriweather Sans bold (300) italic',
	  'Merriweather Sans' => 'Merriweather Sans',
	  'Merriweather Sans:400italic' => 'Merriweather Sans  italic',
	  'Merriweather Sans:700' => 'Merriweather Sans bold (700) ',
	  'Merriweather Sans:700italic' => 'Merriweather Sans bold (700) italic',
	  'Merriweather Sans:800' => 'Merriweather Sans bold (800) ',
	  'Merriweather Sans:800italic' => 'Merriweather Sans bold (800) italic',
	  'Merriweather Sans&subset=latin-ext' => 'Merriweather Sans latin-ext',
	  'Merriweather Sans:300&subset=latin-ext' => 'Merriweather Sans bold (300)  latin-ext',
	  'Merriweather Sans:300italic&subset=latin-ext' => 'Merriweather Sans bold (300) italic latin-ext',
	  'Merriweather Sans:400italic&subset=latin-ext' => 'Merriweather Sans  italic latin-ext',
	  'Merriweather Sans:700&subset=latin-ext' => 'Merriweather Sans bold (700)  latin-ext',
	  'Merriweather Sans:700italic&subset=latin-ext' => 'Merriweather Sans bold (700) italic latin-ext',
	  'Merriweather Sans:800&subset=latin-ext' => 'Merriweather Sans bold (800)  latin-ext',
	  'Merriweather Sans:800italic&subset=latin-ext' => 'Merriweather Sans bold (800) italic latin-ext',
	  'Metal' => 'Metal',
	  'Metal Mania' => 'Metal Mania',
	  'Metal Mania&subset=latin-ext' => 'Metal Mania latin-ext',
	  'Metamorphous' => 'Metamorphous',
	  'Metamorphous&subset=latin-ext' => 'Metamorphous latin-ext',
	  'Metrophobic' => 'Metrophobic',
	  'Michroma' => 'Michroma',
	  'Milonga' => 'Milonga',
	  'Milonga&subset=latin-ext' => 'Milonga latin-ext',
	  'Miltonian' => 'Miltonian',
	  'Miltonian Tattoo' => 'Miltonian Tattoo',
	  'Miniver' => 'Miniver',
	  'Miss Fajardose' => 'Miss Fajardose',
	  'Miss Fajardose&subset=latin-ext' => 'Miss Fajardose latin-ext',
	  'Modern Antiqua' => 'Modern Antiqua',
	  'Modern Antiqua&subset=latin-ext' => 'Modern Antiqua latin-ext',
	  'Molengo' => 'Molengo',
	  'Molengo&subset=latin-ext' => 'Molengo latin-ext',
	  'Molle:400italic' => 'Molle  italic',
	  'Molle&subset=latin-ext' => 'Molle latin-ext',
	  'Molle:400italic&subset=latin-ext' => 'Molle  italic latin-ext',
	  'Monda' => 'Monda',
	  'Monda:700' => 'Monda bold (700) ',
	  'Monda&subset=latin-ext' => 'Monda latin-ext',
	  'Monda:700&subset=latin-ext' => 'Monda bold (700)  latin-ext',
	  'Monofett' => 'Monofett',
	  'Monoton' => 'Monoton',
	  'Monsieur La Doulaise' => 'Monsieur La Doulaise',
	  'Monsieur La Doulaise&subset=latin-ext' => 'Monsieur La Doulaise latin-ext',
	  'Montaga' => 'Montaga',
	  'Montez' => 'Montez',
	  'Montserrat' => 'Montserrat',
	  'Montserrat:700' => 'Montserrat bold (700) ',
	  'Montserrat Alternates' => 'Montserrat Alternates',
	  'Montserrat Alternates:700' => 'Montserrat Alternates bold (700) ',
	  'Montserrat Subrayada' => 'Montserrat Subrayada',
	  'Montserrat Subrayada:700' => 'Montserrat Subrayada bold (700) ',
	  'Moul' => 'Moul',
	  'Moulpali' => 'Moulpali',
	  'Mountains of Christmas' => 'Mountains of Christmas',
	  'Mountains of Christmas:700' => 'Mountains of Christmas bold (700) ',
	  'Mouse Memoirs' => 'Mouse Memoirs',
	  'Mouse Memoirs&subset=latin-ext' => 'Mouse Memoirs latin-ext',
	  'Mr Bedfort' => 'Mr Bedfort',
	  'Mr Bedfort&subset=latin-ext' => 'Mr Bedfort latin-ext',
	  'Mr Dafoe' => 'Mr Dafoe',
	  'Mr Dafoe&subset=latin-ext' => 'Mr Dafoe latin-ext',
	  'Mr De Haviland' => 'Mr De Haviland',
	  'Mr De Haviland&subset=latin-ext' => 'Mr De Haviland latin-ext',
	  'Mrs Saint Delafield' => 'Mrs Saint Delafield',
	  'Mrs Saint Delafield&subset=latin-ext' => 'Mrs Saint Delafield latin-ext',
	  'Mrs Sheppards' => 'Mrs Sheppards',
	  'Mrs Sheppards&subset=latin-ext' => 'Mrs Sheppards latin-ext',
	  'Muli:300' => 'Muli bold (300) ',
	  'Muli:300italic' => 'Muli bold (300) italic',
	  'Muli' => 'Muli',
	  'Muli:400italic' => 'Muli  italic',
	  'Mystery Quest' => 'Mystery Quest',
	  'Mystery Quest&subset=latin-ext' => 'Mystery Quest latin-ext',
	  'Neucha' => 'Neucha',
	  'Neucha&subset=cyrillic' => 'Neucha cyrillic',
	  'Neuton:200' => 'Neuton bold (200) ',
	  'Neuton:300' => 'Neuton bold (300) ',
	  'Neuton' => 'Neuton',
	  'Neuton:400italic' => 'Neuton  italic',
	  'Neuton:700' => 'Neuton bold (700) ',
	  'Neuton:800' => 'Neuton bold (800) ',
	  'Neuton&subset=latin-ext' => 'Neuton latin-ext',
	  'Neuton:200&subset=latin-ext' => 'Neuton bold (200)  latin-ext',
	  'Neuton:300&subset=latin-ext' => 'Neuton bold (300)  latin-ext',
	  'Neuton:400italic&subset=latin-ext' => 'Neuton  italic latin-ext',
	  'Neuton:700&subset=latin-ext' => 'Neuton bold (700)  latin-ext',
	  'Neuton:800&subset=latin-ext' => 'Neuton bold (800)  latin-ext',
	  'New Rocker' => 'New Rocker',
	  'New Rocker&subset=latin-ext' => 'New Rocker latin-ext',
	  'News Cycle' => 'News Cycle',
	  'News Cycle:700' => 'News Cycle bold (700) ',
	  'News Cycle&subset=latin-ext' => 'News Cycle latin-ext',
	  'News Cycle:700&subset=latin-ext' => 'News Cycle bold (700)  latin-ext',
	  'Niconne' => 'Niconne',
	  'Niconne&subset=latin-ext' => 'Niconne latin-ext',
	  'Nixie One' => 'Nixie One',
	  'Nobile' => 'Nobile',
	  'Nobile:400italic' => 'Nobile  italic',
	  'Nobile:700' => 'Nobile bold (700) ',
	  'Nobile:700italic' => 'Nobile bold (700) italic',
	  'Nokora' => 'Nokora',
	  'Nokora:700' => 'Nokora bold (700) ',
	  'Norican' => 'Norican',
	  'Norican&subset=latin-ext' => 'Norican latin-ext',
	  'Nosifer' => 'Nosifer',
	  'Nosifer&subset=latin-ext' => 'Nosifer latin-ext',
	  'Nothing You Could Do' => 'Nothing You Could Do',
	  'Noticia Text' => 'Noticia Text',
	  'Noticia Text:400italic' => 'Noticia Text  italic',
	  'Noticia Text:700' => 'Noticia Text bold (700) ',
	  'Noticia Text:700italic' => 'Noticia Text bold (700) italic',
	  'Noticia Text&subset=latin-ext' => 'Noticia Text latin-ext',
	  'Noticia Text&subset=vietnamese' => 'Noticia Text vietnamese',
	  'Noticia Text:400italic&subset=latin-ext' => 'Noticia Text  italic latin-ext',
	  'Noticia Text:400italic&subset=vietnamese' => 'Noticia Text  italic vietnamese',
	  'Noticia Text:700&subset=latin-ext' => 'Noticia Text bold (700)  latin-ext',
	  'Noticia Text:700&subset=vietnamese' => 'Noticia Text bold (700)  vietnamese',
	  'Noticia Text:700italic&subset=latin-ext' => 'Noticia Text bold (700) italic latin-ext',
	  'Noticia Text:700italic&subset=vietnamese' => 'Noticia Text bold (700) italic vietnamese',
	  'Noto Sans' => 'Noto Sans',
	  'Noto Sans:400italic' => 'Noto Sans  italic',
	  'Noto Sans:700' => 'Noto Sans bold (700) ',
	  'Noto Sans:700italic' => 'Noto Sans bold (700) italic',
	  'Noto Sans&subset=latin-ext' => 'Noto Sans latin-ext',
	  'Noto Sans&subset=greek-ext' => 'Noto Sans greek-ext',
	  'Noto Sans&subset=cyrillic-ext' => 'Noto Sans cyrillic-ext',
	  'Noto Sans&subset=cyrillic' => 'Noto Sans cyrillic',
	  'Noto Sans&subset=vietnamese' => 'Noto Sans vietnamese',
	  'Noto Sans&subset=greek' => 'Noto Sans greek',
	  'Noto Sans:400italic&subset=latin-ext' => 'Noto Sans  italic latin-ext',
	  'Noto Sans:400italic&subset=greek-ext' => 'Noto Sans  italic greek-ext',
	  'Noto Sans:400italic&subset=cyrillic-ext' => 'Noto Sans  italic cyrillic-ext',
	  'Noto Sans:400italic&subset=cyrillic' => 'Noto Sans  italic cyrillic',
	  'Noto Sans:400italic&subset=vietnamese' => 'Noto Sans  italic vietnamese',
	  'Noto Sans:400italic&subset=greek' => 'Noto Sans  italic greek',
	  'Noto Sans:700&subset=latin-ext' => 'Noto Sans bold (700)  latin-ext',
	  'Noto Sans:700&subset=greek-ext' => 'Noto Sans bold (700)  greek-ext',
	  'Noto Sans:700&subset=cyrillic-ext' => 'Noto Sans bold (700)  cyrillic-ext',
	  'Noto Sans:700&subset=cyrillic' => 'Noto Sans bold (700)  cyrillic',
	  'Noto Sans:700&subset=vietnamese' => 'Noto Sans bold (700)  vietnamese',
	  'Noto Sans:700&subset=greek' => 'Noto Sans bold (700)  greek',
	  'Noto Sans:700italic&subset=latin-ext' => 'Noto Sans bold (700) italic latin-ext',
	  'Noto Sans:700italic&subset=greek-ext' => 'Noto Sans bold (700) italic greek-ext',
	  'Noto Sans:700italic&subset=cyrillic-ext' => 'Noto Sans bold (700) italic cyrillic-ext',
	  'Noto Sans:700italic&subset=cyrillic' => 'Noto Sans bold (700) italic cyrillic',
	  'Noto Sans:700italic&subset=vietnamese' => 'Noto Sans bold (700) italic vietnamese',
	  'Noto Sans:700italic&subset=greek' => 'Noto Sans bold (700) italic greek',
	  'Noto Serif' => 'Noto Serif',
	  'Noto Serif:400italic' => 'Noto Serif  italic',
	  'Noto Serif:700' => 'Noto Serif bold (700) ',
	  'Noto Serif:700italic' => 'Noto Serif bold (700) italic',
	  'Noto Serif&subset=latin-ext' => 'Noto Serif latin-ext',
	  'Noto Serif&subset=greek-ext' => 'Noto Serif greek-ext',
	  'Noto Serif&subset=cyrillic-ext' => 'Noto Serif cyrillic-ext',
	  'Noto Serif&subset=cyrillic' => 'Noto Serif cyrillic',
	  'Noto Serif&subset=vietnamese' => 'Noto Serif vietnamese',
	  'Noto Serif&subset=greek' => 'Noto Serif greek',
	  'Noto Serif:400italic&subset=latin-ext' => 'Noto Serif  italic latin-ext',
	  'Noto Serif:400italic&subset=greek-ext' => 'Noto Serif  italic greek-ext',
	  'Noto Serif:400italic&subset=cyrillic-ext' => 'Noto Serif  italic cyrillic-ext',
	  'Noto Serif:400italic&subset=cyrillic' => 'Noto Serif  italic cyrillic',
	  'Noto Serif:400italic&subset=vietnamese' => 'Noto Serif  italic vietnamese',
	  'Noto Serif:400italic&subset=greek' => 'Noto Serif  italic greek',
	  'Noto Serif:700&subset=latin-ext' => 'Noto Serif bold (700)  latin-ext',
	  'Noto Serif:700&subset=greek-ext' => 'Noto Serif bold (700)  greek-ext',
	  'Noto Serif:700&subset=cyrillic-ext' => 'Noto Serif bold (700)  cyrillic-ext',
	  'Noto Serif:700&subset=cyrillic' => 'Noto Serif bold (700)  cyrillic',
	  'Noto Serif:700&subset=vietnamese' => 'Noto Serif bold (700)  vietnamese',
	  'Noto Serif:700&subset=greek' => 'Noto Serif bold (700)  greek',
	  'Noto Serif:700italic&subset=latin-ext' => 'Noto Serif bold (700) italic latin-ext',
	  'Noto Serif:700italic&subset=greek-ext' => 'Noto Serif bold (700) italic greek-ext',
	  'Noto Serif:700italic&subset=cyrillic-ext' => 'Noto Serif bold (700) italic cyrillic-ext',
	  'Noto Serif:700italic&subset=cyrillic' => 'Noto Serif bold (700) italic cyrillic',
	  'Noto Serif:700italic&subset=vietnamese' => 'Noto Serif bold (700) italic vietnamese',
	  'Noto Serif:700italic&subset=greek' => 'Noto Serif bold (700) italic greek',
	  'Nova Cut' => 'Nova Cut',
	  'Nova Flat' => 'Nova Flat',
	  'Nova Mono' => 'Nova Mono',
	  'Nova Mono&subset=greek' => 'Nova Mono greek',
	  'Nova Oval' => 'Nova Oval',
	  'Nova Round' => 'Nova Round',
	  'Nova Script' => 'Nova Script',
	  'Nova Slim' => 'Nova Slim',
	  'Nova Square' => 'Nova Square',
	  'Numans' => 'Numans',
	  'Nunito:300' => 'Nunito bold (300) ',
	  'Nunito' => 'Nunito',
	  'Nunito:700' => 'Nunito bold (700) ',
	  'Odor Mean Chey' => 'Odor Mean Chey',
	  'Offside' => 'Offside',
	  'Old Standard TT' => 'Old Standard TT',
	  'Old Standard TT:400italic' => 'Old Standard TT  italic',
	  'Old Standard TT:700' => 'Old Standard TT bold (700) ',
	  'Oldenburg' => 'Oldenburg',
	  'Oldenburg&subset=latin-ext' => 'Oldenburg latin-ext',
	  'Oleo Script' => 'Oleo Script',
	  'Oleo Script:700' => 'Oleo Script bold (700) ',
	  'Oleo Script&subset=latin-ext' => 'Oleo Script latin-ext',
	  'Oleo Script:700&subset=latin-ext' => 'Oleo Script bold (700)  latin-ext',
	  'Oleo Script Swash Caps' => 'Oleo Script Swash Caps',
	  'Oleo Script Swash Caps:700' => 'Oleo Script Swash Caps bold (700) ',
	  'Oleo Script Swash Caps&subset=latin-ext' => 'Oleo Script Swash Caps latin-ext',
	  'Oleo Script Swash Caps:700&subset=latin-ext' => 'Oleo Script Swash Caps bold (700)  latin-ext',
	  'Open Sans:300' => 'Open Sans bold (300) ',
	  'Open Sans:300italic' => 'Open Sans bold (300) italic',
	  'Open Sans' => 'Open Sans',
	  'Open Sans:400italic' => 'Open Sans  italic',
	  'Open Sans:600' => 'Open Sans bold (600) ',
	  'Open Sans:600italic' => 'Open Sans bold (600) italic',
	  'Open Sans:700' => 'Open Sans bold (700) ',
	  'Open Sans:700italic' => 'Open Sans bold (700) italic',
	  'Open Sans:800' => 'Open Sans bold (800) ',
	  'Open Sans:800italic' => 'Open Sans bold (800) italic',
	  'Open Sans&subset=latin-ext' => 'Open Sans latin-ext',
	  'Open Sans&subset=greek-ext' => 'Open Sans greek-ext',
	  'Open Sans&subset=cyrillic-ext' => 'Open Sans cyrillic-ext',
	  'Open Sans&subset=cyrillic' => 'Open Sans cyrillic',
	  'Open Sans&subset=vietnamese' => 'Open Sans vietnamese',
	  'Open Sans&subset=greek' => 'Open Sans greek',
	  'Open Sans:300&subset=latin-ext' => 'Open Sans bold (300)  latin-ext',
	  'Open Sans:300&subset=greek-ext' => 'Open Sans bold (300)  greek-ext',
	  'Open Sans:300&subset=cyrillic-ext' => 'Open Sans bold (300)  cyrillic-ext',
	  'Open Sans:300&subset=cyrillic' => 'Open Sans bold (300)  cyrillic',
	  'Open Sans:300&subset=vietnamese' => 'Open Sans bold (300)  vietnamese',
	  'Open Sans:300&subset=greek' => 'Open Sans bold (300)  greek',
	  'Open Sans:300italic&subset=latin-ext' => 'Open Sans bold (300) italic latin-ext',
	  'Open Sans:300italic&subset=greek-ext' => 'Open Sans bold (300) italic greek-ext',
	  'Open Sans:300italic&subset=cyrillic-ext' => 'Open Sans bold (300) italic cyrillic-ext',
	  'Open Sans:300italic&subset=cyrillic' => 'Open Sans bold (300) italic cyrillic',
	  'Open Sans:300italic&subset=vietnamese' => 'Open Sans bold (300) italic vietnamese',
	  'Open Sans:300italic&subset=greek' => 'Open Sans bold (300) italic greek',
	  'Open Sans:400italic&subset=latin-ext' => 'Open Sans  italic latin-ext',
	  'Open Sans:400italic&subset=greek-ext' => 'Open Sans  italic greek-ext',
	  'Open Sans:400italic&subset=cyrillic-ext' => 'Open Sans  italic cyrillic-ext',
	  'Open Sans:400italic&subset=cyrillic' => 'Open Sans  italic cyrillic',
	  'Open Sans:400italic&subset=vietnamese' => 'Open Sans  italic vietnamese',
	  'Open Sans:400italic&subset=greek' => 'Open Sans  italic greek',
	  'Open Sans:600&subset=latin-ext' => 'Open Sans bold (600)  latin-ext',
	  'Open Sans:600&subset=greek-ext' => 'Open Sans bold (600)  greek-ext',
	  'Open Sans:600&subset=cyrillic-ext' => 'Open Sans bold (600)  cyrillic-ext',
	  'Open Sans:600&subset=cyrillic' => 'Open Sans bold (600)  cyrillic',
	  'Open Sans:600&subset=vietnamese' => 'Open Sans bold (600)  vietnamese',
	  'Open Sans:600&subset=greek' => 'Open Sans bold (600)  greek',
	  'Open Sans:600italic&subset=latin-ext' => 'Open Sans bold (600) italic latin-ext',
	  'Open Sans:600italic&subset=greek-ext' => 'Open Sans bold (600) italic greek-ext',
	  'Open Sans:600italic&subset=cyrillic-ext' => 'Open Sans bold (600) italic cyrillic-ext',
	  'Open Sans:600italic&subset=cyrillic' => 'Open Sans bold (600) italic cyrillic',
	  'Open Sans:600italic&subset=vietnamese' => 'Open Sans bold (600) italic vietnamese',
	  'Open Sans:600italic&subset=greek' => 'Open Sans bold (600) italic greek',
	  'Open Sans:700&subset=latin-ext' => 'Open Sans bold (700)  latin-ext',
	  'Open Sans:700&subset=greek-ext' => 'Open Sans bold (700)  greek-ext',
	  'Open Sans:700&subset=cyrillic-ext' => 'Open Sans bold (700)  cyrillic-ext',
	  'Open Sans:700&subset=cyrillic' => 'Open Sans bold (700)  cyrillic',
	  'Open Sans:700&subset=vietnamese' => 'Open Sans bold (700)  vietnamese',
	  'Open Sans:700&subset=greek' => 'Open Sans bold (700)  greek',
	  'Open Sans:700italic&subset=latin-ext' => 'Open Sans bold (700) italic latin-ext',
	  'Open Sans:700italic&subset=greek-ext' => 'Open Sans bold (700) italic greek-ext',
	  'Open Sans:700italic&subset=cyrillic-ext' => 'Open Sans bold (700) italic cyrillic-ext',
	  'Open Sans:700italic&subset=cyrillic' => 'Open Sans bold (700) italic cyrillic',
	  'Open Sans:700italic&subset=vietnamese' => 'Open Sans bold (700) italic vietnamese',
	  'Open Sans:700italic&subset=greek' => 'Open Sans bold (700) italic greek',
	  'Open Sans:800&subset=latin-ext' => 'Open Sans bold (800)  latin-ext',
	  'Open Sans:800&subset=greek-ext' => 'Open Sans bold (800)  greek-ext',
	  'Open Sans:800&subset=cyrillic-ext' => 'Open Sans bold (800)  cyrillic-ext',
	  'Open Sans:800&subset=cyrillic' => 'Open Sans bold (800)  cyrillic',
	  'Open Sans:800&subset=vietnamese' => 'Open Sans bold (800)  vietnamese',
	  'Open Sans:800&subset=greek' => 'Open Sans bold (800)  greek',
	  'Open Sans:800italic&subset=latin-ext' => 'Open Sans bold (800) italic latin-ext',
	  'Open Sans:800italic&subset=greek-ext' => 'Open Sans bold (800) italic greek-ext',
	  'Open Sans:800italic&subset=cyrillic-ext' => 'Open Sans bold (800) italic cyrillic-ext',
	  'Open Sans:800italic&subset=cyrillic' => 'Open Sans bold (800) italic cyrillic',
	  'Open Sans:800italic&subset=vietnamese' => 'Open Sans bold (800) italic vietnamese',
	  'Open Sans:800italic&subset=greek' => 'Open Sans bold (800) italic greek',
	  'Open Sans Condensed:300' => 'Open Sans Condensed bold (300) ',
	  'Open Sans Condensed:300italic' => 'Open Sans Condensed bold (300) italic',
	  'Open Sans Condensed:700' => 'Open Sans Condensed bold (700) ',
	  'Open Sans Condensed&subset=latin-ext' => 'Open Sans Condensed latin-ext',
	  'Open Sans Condensed&subset=greek-ext' => 'Open Sans Condensed greek-ext',
	  'Open Sans Condensed&subset=cyrillic-ext' => 'Open Sans Condensed cyrillic-ext',
	  'Open Sans Condensed&subset=cyrillic' => 'Open Sans Condensed cyrillic',
	  'Open Sans Condensed&subset=vietnamese' => 'Open Sans Condensed vietnamese',
	  'Open Sans Condensed&subset=greek' => 'Open Sans Condensed greek',
	  'Open Sans Condensed:300&subset=latin-ext' => 'Open Sans Condensed bold (300)  latin-ext',
	  'Open Sans Condensed:300&subset=greek-ext' => 'Open Sans Condensed bold (300)  greek-ext',
	  'Open Sans Condensed:300&subset=cyrillic-ext' => 'Open Sans Condensed bold (300)  cyrillic-ext',
	  'Open Sans Condensed:300&subset=cyrillic' => 'Open Sans Condensed bold (300)  cyrillic',
	  'Open Sans Condensed:300&subset=vietnamese' => 'Open Sans Condensed bold (300)  vietnamese',
	  'Open Sans Condensed:300&subset=greek' => 'Open Sans Condensed bold (300)  greek',
	  'Open Sans Condensed:300italic&subset=latin-ext' => 'Open Sans Condensed bold (300) italic latin-ext',
	  'Open Sans Condensed:300italic&subset=greek-ext' => 'Open Sans Condensed bold (300) italic greek-ext',
	  'Open Sans Condensed:300italic&subset=cyrillic-ext' => 'Open Sans Condensed bold (300) italic cyrillic-ext',
	  'Open Sans Condensed:300italic&subset=cyrillic' => 'Open Sans Condensed bold (300) italic cyrillic',
	  'Open Sans Condensed:300italic&subset=vietnamese' => 'Open Sans Condensed bold (300) italic vietnamese',
	  'Open Sans Condensed:300italic&subset=greek' => 'Open Sans Condensed bold (300) italic greek',
	  'Open Sans Condensed:700&subset=latin-ext' => 'Open Sans Condensed bold (700)  latin-ext',
	  'Open Sans Condensed:700&subset=greek-ext' => 'Open Sans Condensed bold (700)  greek-ext',
	  'Open Sans Condensed:700&subset=cyrillic-ext' => 'Open Sans Condensed bold (700)  cyrillic-ext',
	  'Open Sans Condensed:700&subset=cyrillic' => 'Open Sans Condensed bold (700)  cyrillic',
	  'Open Sans Condensed:700&subset=vietnamese' => 'Open Sans Condensed bold (700)  vietnamese',
	  'Open Sans Condensed:700&subset=greek' => 'Open Sans Condensed bold (700)  greek',
	  'Oranienbaum' => 'Oranienbaum',
	  'Oranienbaum&subset=latin-ext' => 'Oranienbaum latin-ext',
	  'Oranienbaum&subset=cyrillic-ext' => 'Oranienbaum cyrillic-ext',
	  'Oranienbaum&subset=cyrillic' => 'Oranienbaum cyrillic',
	  'Orbitron' => 'Orbitron',
	  'Orbitron:500' => 'Orbitron bold (500) ',
	  'Orbitron:700' => 'Orbitron bold (700) ',
	  'Orbitron:900' => 'Orbitron bold (900) ',
	  'Oregano' => 'Oregano',
	  'Oregano:400italic' => 'Oregano  italic',
	  'Oregano&subset=latin-ext' => 'Oregano latin-ext',
	  'Oregano:400italic&subset=latin-ext' => 'Oregano  italic latin-ext',
	  'Orienta' => 'Orienta',
	  'Orienta&subset=latin-ext' => 'Orienta latin-ext',
	  'Original Surfer' => 'Original Surfer',
	  'Oswald:300' => 'Oswald bold (300) ',
	  'Oswald' => 'Oswald',
	  'Oswald:700' => 'Oswald bold (700) ',
	  'Oswald&subset=latin-ext' => 'Oswald latin-ext',
	  'Oswald:300&subset=latin-ext' => 'Oswald bold (300)  latin-ext',
	  'Oswald:700&subset=latin-ext' => 'Oswald bold (700)  latin-ext',
	  'Over the Rainbow' => 'Over the Rainbow',
	  'Overlock' => 'Overlock',
	  'Overlock:400italic' => 'Overlock  italic',
	  'Overlock:700' => 'Overlock bold (700) ',
	  'Overlock:700italic' => 'Overlock bold (700) italic',
	  'Overlock:900' => 'Overlock bold (900) ',
	  'Overlock:900italic' => 'Overlock bold (900) italic',
	  'Overlock&subset=latin-ext' => 'Overlock latin-ext',
	  'Overlock:400italic&subset=latin-ext' => 'Overlock  italic latin-ext',
	  'Overlock:700&subset=latin-ext' => 'Overlock bold (700)  latin-ext',
	  'Overlock:700italic&subset=latin-ext' => 'Overlock bold (700) italic latin-ext',
	  'Overlock:900&subset=latin-ext' => 'Overlock bold (900)  latin-ext',
	  'Overlock:900italic&subset=latin-ext' => 'Overlock bold (900) italic latin-ext',
	  'Overlock SC' => 'Overlock SC',
	  'Overlock SC&subset=latin-ext' => 'Overlock SC latin-ext',
	  'Ovo' => 'Ovo',
	  'Oxygen:300' => 'Oxygen bold (300) ',
	  'Oxygen' => 'Oxygen',
	  'Oxygen:700' => 'Oxygen bold (700) ',
	  'Oxygen&subset=latin-ext' => 'Oxygen latin-ext',
	  'Oxygen:300&subset=latin-ext' => 'Oxygen bold (300)  latin-ext',
	  'Oxygen:700&subset=latin-ext' => 'Oxygen bold (700)  latin-ext',
	  'Oxygen Mono' => 'Oxygen Mono',
	  'Oxygen Mono&subset=latin-ext' => 'Oxygen Mono latin-ext',
	  'PT Mono' => 'PT Mono',
	  'PT Mono&subset=latin-ext' => 'PT Mono latin-ext',
	  'PT Mono&subset=cyrillic-ext' => 'PT Mono cyrillic-ext',
	  'PT Mono&subset=cyrillic' => 'PT Mono cyrillic',
	  'PT Sans' => 'PT Sans',
	  'PT Sans:400italic' => 'PT Sans  italic',
	  'PT Sans:700' => 'PT Sans bold (700) ',
	  'PT Sans:700italic' => 'PT Sans bold (700) italic',
	  'PT Sans&subset=latin-ext' => 'PT Sans latin-ext',
	  'PT Sans&subset=cyrillic-ext' => 'PT Sans cyrillic-ext',
	  'PT Sans&subset=cyrillic' => 'PT Sans cyrillic',
	  'PT Sans:400italic&subset=latin-ext' => 'PT Sans  italic latin-ext',
	  'PT Sans:400italic&subset=cyrillic-ext' => 'PT Sans  italic cyrillic-ext',
	  'PT Sans:400italic&subset=cyrillic' => 'PT Sans  italic cyrillic',
	  'PT Sans:700&subset=latin-ext' => 'PT Sans bold (700)  latin-ext',
	  'PT Sans:700&subset=cyrillic-ext' => 'PT Sans bold (700)  cyrillic-ext',
	  'PT Sans:700&subset=cyrillic' => 'PT Sans bold (700)  cyrillic',
	  'PT Sans:700italic&subset=latin-ext' => 'PT Sans bold (700) italic latin-ext',
	  'PT Sans:700italic&subset=cyrillic-ext' => 'PT Sans bold (700) italic cyrillic-ext',
	  'PT Sans:700italic&subset=cyrillic' => 'PT Sans bold (700) italic cyrillic',
	  'PT Sans Caption' => 'PT Sans Caption',
	  'PT Sans Caption:700' => 'PT Sans Caption bold (700) ',
	  'PT Sans Caption&subset=latin-ext' => 'PT Sans Caption latin-ext',
	  'PT Sans Caption&subset=cyrillic-ext' => 'PT Sans Caption cyrillic-ext',
	  'PT Sans Caption&subset=cyrillic' => 'PT Sans Caption cyrillic',
	  'PT Sans Caption:700&subset=latin-ext' => 'PT Sans Caption bold (700)  latin-ext',
	  'PT Sans Caption:700&subset=cyrillic-ext' => 'PT Sans Caption bold (700)  cyrillic-ext',
	  'PT Sans Caption:700&subset=cyrillic' => 'PT Sans Caption bold (700)  cyrillic',
	  'PT Sans Narrow' => 'PT Sans Narrow',
	  'PT Sans Narrow:700' => 'PT Sans Narrow bold (700) ',
	  'PT Sans Narrow&subset=latin-ext' => 'PT Sans Narrow latin-ext',
	  'PT Sans Narrow&subset=cyrillic-ext' => 'PT Sans Narrow cyrillic-ext',
	  'PT Sans Narrow&subset=cyrillic' => 'PT Sans Narrow cyrillic',
	  'PT Sans Narrow:700&subset=latin-ext' => 'PT Sans Narrow bold (700)  latin-ext',
	  'PT Sans Narrow:700&subset=cyrillic-ext' => 'PT Sans Narrow bold (700)  cyrillic-ext',
	  'PT Sans Narrow:700&subset=cyrillic' => 'PT Sans Narrow bold (700)  cyrillic',
	  'PT Serif' => 'PT Serif',
	  'PT Serif:400italic' => 'PT Serif  italic',
	  'PT Serif:700' => 'PT Serif bold (700) ',
	  'PT Serif:700italic' => 'PT Serif bold (700) italic',
	  'PT Serif&subset=latin-ext' => 'PT Serif latin-ext',
	  'PT Serif&subset=cyrillic-ext' => 'PT Serif cyrillic-ext',
	  'PT Serif&subset=cyrillic' => 'PT Serif cyrillic',
	  'PT Serif:400italic&subset=latin-ext' => 'PT Serif  italic latin-ext',
	  'PT Serif:400italic&subset=cyrillic-ext' => 'PT Serif  italic cyrillic-ext',
	  'PT Serif:400italic&subset=cyrillic' => 'PT Serif  italic cyrillic',
	  'PT Serif:700&subset=latin-ext' => 'PT Serif bold (700)  latin-ext',
	  'PT Serif:700&subset=cyrillic-ext' => 'PT Serif bold (700)  cyrillic-ext',
	  'PT Serif:700&subset=cyrillic' => 'PT Serif bold (700)  cyrillic',
	  'PT Serif:700italic&subset=latin-ext' => 'PT Serif bold (700) italic latin-ext',
	  'PT Serif:700italic&subset=cyrillic-ext' => 'PT Serif bold (700) italic cyrillic-ext',
	  'PT Serif:700italic&subset=cyrillic' => 'PT Serif bold (700) italic cyrillic',
	  'PT Serif Caption' => 'PT Serif Caption',
	  'PT Serif Caption:400italic' => 'PT Serif Caption  italic',
	  'PT Serif Caption&subset=latin-ext' => 'PT Serif Caption latin-ext',
	  'PT Serif Caption&subset=cyrillic-ext' => 'PT Serif Caption cyrillic-ext',
	  'PT Serif Caption&subset=cyrillic' => 'PT Serif Caption cyrillic',
	  'PT Serif Caption:400italic&subset=latin-ext' => 'PT Serif Caption  italic latin-ext',
	  'PT Serif Caption:400italic&subset=cyrillic-ext' => 'PT Serif Caption  italic cyrillic-ext',
	  'PT Serif Caption:400italic&subset=cyrillic' => 'PT Serif Caption  italic cyrillic',
	  'Pacifico' => 'Pacifico',
	  'Paprika' => 'Paprika',
	  'Parisienne' => 'Parisienne',
	  'Parisienne&subset=latin-ext' => 'Parisienne latin-ext',
	  'Passero One' => 'Passero One',
	  'Passero One&subset=latin-ext' => 'Passero One latin-ext',
	  'Passion One' => 'Passion One',
	  'Passion One:700' => 'Passion One bold (700) ',
	  'Passion One:900' => 'Passion One bold (900) ',
	  'Passion One&subset=latin-ext' => 'Passion One latin-ext',
	  'Passion One:700&subset=latin-ext' => 'Passion One bold (700)  latin-ext',
	  'Passion One:900&subset=latin-ext' => 'Passion One bold (900)  latin-ext',
	  'Pathway Gothic One' => 'Pathway Gothic One',
	  'Pathway Gothic One&subset=latin-ext' => 'Pathway Gothic One latin-ext',
	  'Patrick Hand' => 'Patrick Hand',
	  'Patrick Hand&subset=latin-ext' => 'Patrick Hand latin-ext',
	  'Patrick Hand&subset=vietnamese' => 'Patrick Hand vietnamese',
	  'Patrick Hand SC' => 'Patrick Hand SC',
	  'Patrick Hand SC&subset=latin-ext' => 'Patrick Hand SC latin-ext',
	  'Patrick Hand SC&subset=vietnamese' => 'Patrick Hand SC vietnamese',
	  'Patua One' => 'Patua One',
	  'Paytone One' => 'Paytone One',
	  'Peralta' => 'Peralta',
	  'Peralta&subset=latin-ext' => 'Peralta latin-ext',
	  'Permanent Marker' => 'Permanent Marker',
	  'Petit Formal Script' => 'Petit Formal Script',
	  'Petit Formal Script&subset=latin-ext' => 'Petit Formal Script latin-ext',
	  'Petrona' => 'Petrona',
	  'Philosopher' => 'Philosopher',
	  'Philosopher:400italic' => 'Philosopher  italic',
	  'Philosopher:700' => 'Philosopher bold (700) ',
	  'Philosopher:700italic' => 'Philosopher bold (700) italic',
	  'Philosopher&subset=cyrillic' => 'Philosopher cyrillic',
	  'Philosopher:400italic&subset=cyrillic' => 'Philosopher  italic cyrillic',
	  'Philosopher:700&subset=cyrillic' => 'Philosopher bold (700)  cyrillic',
	  'Philosopher:700italic&subset=cyrillic' => 'Philosopher bold (700) italic cyrillic',
	  'Piedra' => 'Piedra',
	  'Piedra&subset=latin-ext' => 'Piedra latin-ext',
	  'Pinyon Script' => 'Pinyon Script',
	  'Pirata One' => 'Pirata One',
	  'Pirata One&subset=latin-ext' => 'Pirata One latin-ext',
	  'Plaster' => 'Plaster',
	  'Plaster&subset=latin-ext' => 'Plaster latin-ext',
	  'Play' => 'Play',
	  'Play:700' => 'Play bold (700) ',
	  'Play&subset=latin-ext' => 'Play latin-ext',
	  'Play&subset=greek-ext' => 'Play greek-ext',
	  'Play&subset=cyrillic-ext' => 'Play cyrillic-ext',
	  'Play&subset=cyrillic' => 'Play cyrillic',
	  'Play&subset=greek' => 'Play greek',
	  'Play:700&subset=latin-ext' => 'Play bold (700)  latin-ext',
	  'Play:700&subset=greek-ext' => 'Play bold (700)  greek-ext',
	  'Play:700&subset=cyrillic-ext' => 'Play bold (700)  cyrillic-ext',
	  'Play:700&subset=cyrillic' => 'Play bold (700)  cyrillic',
	  'Play:700&subset=greek' => 'Play bold (700)  greek',
	  'Playball' => 'Playball',
	  'Playball&subset=latin-ext' => 'Playball latin-ext',
	  'Playfair Display' => 'Playfair Display',
	  'Playfair Display:400italic' => 'Playfair Display  italic',
	  'Playfair Display:700' => 'Playfair Display bold (700) ',
	  'Playfair Display:700italic' => 'Playfair Display bold (700) italic',
	  'Playfair Display:900' => 'Playfair Display bold (900) ',
	  'Playfair Display:900italic' => 'Playfair Display bold (900) italic',
	  'Playfair Display&subset=latin-ext' => 'Playfair Display latin-ext',
	  'Playfair Display&subset=cyrillic' => 'Playfair Display cyrillic',
	  'Playfair Display:400italic&subset=latin-ext' => 'Playfair Display  italic latin-ext',
	  'Playfair Display:400italic&subset=cyrillic' => 'Playfair Display  italic cyrillic',
	  'Playfair Display:700&subset=latin-ext' => 'Playfair Display bold (700)  latin-ext',
	  'Playfair Display:700&subset=cyrillic' => 'Playfair Display bold (700)  cyrillic',
	  'Playfair Display:700italic&subset=latin-ext' => 'Playfair Display bold (700) italic latin-ext',
	  'Playfair Display:700italic&subset=cyrillic' => 'Playfair Display bold (700) italic cyrillic',
	  'Playfair Display:900&subset=latin-ext' => 'Playfair Display bold (900)  latin-ext',
	  'Playfair Display:900&subset=cyrillic' => 'Playfair Display bold (900)  cyrillic',
	  'Playfair Display:900italic&subset=latin-ext' => 'Playfair Display bold (900) italic latin-ext',
	  'Playfair Display:900italic&subset=cyrillic' => 'Playfair Display bold (900) italic cyrillic',
	  'Playfair Display SC' => 'Playfair Display SC',
	  'Playfair Display SC:400italic' => 'Playfair Display SC  italic',
	  'Playfair Display SC:700' => 'Playfair Display SC bold (700) ',
	  'Playfair Display SC:700italic' => 'Playfair Display SC bold (700) italic',
	  'Playfair Display SC:900' => 'Playfair Display SC bold (900) ',
	  'Playfair Display SC:900italic' => 'Playfair Display SC bold (900) italic',
	  'Playfair Display SC&subset=latin-ext' => 'Playfair Display SC latin-ext',
	  'Playfair Display SC&subset=cyrillic' => 'Playfair Display SC cyrillic',
	  'Playfair Display SC:400italic&subset=latin-ext' => 'Playfair Display SC  italic latin-ext',
	  'Playfair Display SC:400italic&subset=cyrillic' => 'Playfair Display SC  italic cyrillic',
	  'Playfair Display SC:700&subset=latin-ext' => 'Playfair Display SC bold (700)  latin-ext',
	  'Playfair Display SC:700&subset=cyrillic' => 'Playfair Display SC bold (700)  cyrillic',
	  'Playfair Display SC:700italic&subset=latin-ext' => 'Playfair Display SC bold (700) italic latin-ext',
	  'Playfair Display SC:700italic&subset=cyrillic' => 'Playfair Display SC bold (700) italic cyrillic',
	  'Playfair Display SC:900&subset=latin-ext' => 'Playfair Display SC bold (900)  latin-ext',
	  'Playfair Display SC:900&subset=cyrillic' => 'Playfair Display SC bold (900)  cyrillic',
	  'Playfair Display SC:900italic&subset=latin-ext' => 'Playfair Display SC bold (900) italic latin-ext',
	  'Playfair Display SC:900italic&subset=cyrillic' => 'Playfair Display SC bold (900) italic cyrillic',
	  'Podkova' => 'Podkova',
	  'Podkova:700' => 'Podkova bold (700) ',
	  'Poiret One' => 'Poiret One',
	  'Poiret One&subset=latin-ext' => 'Poiret One latin-ext',
	  'Poiret One&subset=cyrillic' => 'Poiret One cyrillic',
	  'Poller One' => 'Poller One',
	  'Poly' => 'Poly',
	  'Poly:400italic' => 'Poly  italic',
	  'Pompiere' => 'Pompiere',
	  'Pontano Sans' => 'Pontano Sans',
	  'Pontano Sans&subset=latin-ext' => 'Pontano Sans latin-ext',
	  'Port Lligat Sans' => 'Port Lligat Sans',
	  'Port Lligat Slab' => 'Port Lligat Slab',
	  'Prata' => 'Prata',
	  'Preahvihear' => 'Preahvihear',
	  'Press Start 2P' => 'Press Start 2P',
	  'Press Start 2P&subset=latin-ext' => 'Press Start 2P latin-ext',
	  'Press Start 2P&subset=cyrillic' => 'Press Start 2P cyrillic',
	  'Press Start 2P&subset=greek' => 'Press Start 2P greek',
	  'Princess Sofia' => 'Princess Sofia',
	  'Princess Sofia&subset=latin-ext' => 'Princess Sofia latin-ext',
	  'Prociono' => 'Prociono',
	  'Prosto One' => 'Prosto One',
	  'Prosto One&subset=latin-ext' => 'Prosto One latin-ext',
	  'Prosto One&subset=cyrillic' => 'Prosto One cyrillic',
	  'Puritan' => 'Puritan',
	  'Puritan:400italic' => 'Puritan  italic',
	  'Puritan:700' => 'Puritan bold (700) ',
	  'Puritan:700italic' => 'Puritan bold (700) italic',
	  'Purple Purse' => 'Purple Purse',
	  'Purple Purse&subset=latin-ext' => 'Purple Purse latin-ext',
	  'Quando' => 'Quando',
	  'Quando&subset=latin-ext' => 'Quando latin-ext',
	  'Quantico' => 'Quantico',
	  'Quantico:400italic' => 'Quantico  italic',
	  'Quantico:700' => 'Quantico bold (700) ',
	  'Quantico:700italic' => 'Quantico bold (700) italic',
	  'Quattrocento' => 'Quattrocento',
	  'Quattrocento:700' => 'Quattrocento bold (700) ',
	  'Quattrocento&subset=latin-ext' => 'Quattrocento latin-ext',
	  'Quattrocento:700&subset=latin-ext' => 'Quattrocento bold (700)  latin-ext',
	  'Quattrocento Sans' => 'Quattrocento Sans',
	  'Quattrocento Sans:400italic' => 'Quattrocento Sans  italic',
	  'Quattrocento Sans:700' => 'Quattrocento Sans bold (700) ',
	  'Quattrocento Sans:700italic' => 'Quattrocento Sans bold (700) italic',
	  'Quattrocento Sans&subset=latin-ext' => 'Quattrocento Sans latin-ext',
	  'Quattrocento Sans:400italic&subset=latin-ext' => 'Quattrocento Sans  italic latin-ext',
	  'Quattrocento Sans:700&subset=latin-ext' => 'Quattrocento Sans bold (700)  latin-ext',
	  'Quattrocento Sans:700italic&subset=latin-ext' => 'Quattrocento Sans bold (700) italic latin-ext',
	  'Questrial' => 'Questrial',
	  'Quicksand:300' => 'Quicksand bold (300) ',
	  'Quicksand' => 'Quicksand',
	  'Quicksand:700' => 'Quicksand bold (700) ',
	  'Quintessential' => 'Quintessential',
	  'Quintessential&subset=latin-ext' => 'Quintessential latin-ext',
	  'Qwigley' => 'Qwigley',
	  'Qwigley&subset=latin-ext' => 'Qwigley latin-ext',
	  'Racing Sans One' => 'Racing Sans One',
	  'Racing Sans One&subset=latin-ext' => 'Racing Sans One latin-ext',
	  'Radley' => 'Radley',
	  'Radley:400italic' => 'Radley  italic',
	  'Radley&subset=latin-ext' => 'Radley latin-ext',
	  'Radley:400italic&subset=latin-ext' => 'Radley  italic latin-ext',
	  'Raleway:100' => 'Raleway bold (100) ',
	  'Raleway:200' => 'Raleway bold (200) ',
	  'Raleway:300' => 'Raleway bold (300) ',
	  'Raleway' => 'Raleway',
	  'Raleway:500' => 'Raleway bold (500) ',
	  'Raleway:600' => 'Raleway bold (600) ',
	  'Raleway:700' => 'Raleway bold (700) ',
	  'Raleway:800' => 'Raleway bold (800) ',
	  'Raleway:900' => 'Raleway bold (900) ',
	  'Raleway Dots' => 'Raleway Dots',
	  'Raleway Dots&subset=latin-ext' => 'Raleway Dots latin-ext',
	  'Rambla' => 'Rambla',
	  'Rambla:400italic' => 'Rambla  italic',
	  'Rambla:700' => 'Rambla bold (700) ',
	  'Rambla:700italic' => 'Rambla bold (700) italic',
	  'Rambla&subset=latin-ext' => 'Rambla latin-ext',
	  'Rambla:400italic&subset=latin-ext' => 'Rambla  italic latin-ext',
	  'Rambla:700&subset=latin-ext' => 'Rambla bold (700)  latin-ext',
	  'Rambla:700italic&subset=latin-ext' => 'Rambla bold (700) italic latin-ext',
	  'Rammetto One' => 'Rammetto One',
	  'Rammetto One&subset=latin-ext' => 'Rammetto One latin-ext',
	  'Ranchers' => 'Ranchers',
	  'Ranchers&subset=latin-ext' => 'Ranchers latin-ext',
	  'Rancho' => 'Rancho',
	  'Rationale' => 'Rationale',
	  'Redressed' => 'Redressed',
	  'Reenie Beanie' => 'Reenie Beanie',
	  'Revalia' => 'Revalia',
	  'Revalia&subset=latin-ext' => 'Revalia latin-ext',
	  'Ribeye' => 'Ribeye',
	  'Ribeye&subset=latin-ext' => 'Ribeye latin-ext',
	  'Ribeye Marrow' => 'Ribeye Marrow',
	  'Ribeye Marrow&subset=latin-ext' => 'Ribeye Marrow latin-ext',
	  'Righteous' => 'Righteous',
	  'Righteous&subset=latin-ext' => 'Righteous latin-ext',
	  'Risque' => 'Risque',
	  'Risque&subset=latin-ext' => 'Risque latin-ext',
	  'Roboto:100' => 'Roboto bold (100) ',
	  'Roboto:100italic' => 'Roboto bold (100) italic',
	  'Roboto:300' => 'Roboto bold (300) ',
	  'Roboto:300italic' => 'Roboto bold (300) italic',
	  'Roboto' => 'Roboto',
	  'Roboto:400italic' => 'Roboto  italic',
	  'Roboto:500' => 'Roboto bold (500) ',
	  'Roboto:500italic' => 'Roboto bold (500) italic',
	  'Roboto:700' => 'Roboto bold (700) ',
	  'Roboto:700italic' => 'Roboto bold (700) italic',
	  'Roboto:900' => 'Roboto bold (900) ',
	  'Roboto:900italic' => 'Roboto bold (900) italic',
	  'Roboto&subset=latin-ext' => 'Roboto latin-ext',
	  'Roboto&subset=greek-ext' => 'Roboto greek-ext',
	  'Roboto&subset=cyrillic-ext' => 'Roboto cyrillic-ext',
	  'Roboto&subset=cyrillic' => 'Roboto cyrillic',
	  'Roboto&subset=vietnamese' => 'Roboto vietnamese',
	  'Roboto&subset=greek' => 'Roboto greek',
	  'Roboto:100&subset=latin-ext' => 'Roboto bold (100)  latin-ext',
	  'Roboto:100&subset=greek-ext' => 'Roboto bold (100)  greek-ext',
	  'Roboto:100&subset=cyrillic-ext' => 'Roboto bold (100)  cyrillic-ext',
	  'Roboto:100&subset=cyrillic' => 'Roboto bold (100)  cyrillic',
	  'Roboto:100&subset=vietnamese' => 'Roboto bold (100)  vietnamese',
	  'Roboto:100&subset=greek' => 'Roboto bold (100)  greek',
	  'Roboto:100italic&subset=latin-ext' => 'Roboto bold (100) italic latin-ext',
	  'Roboto:100italic&subset=greek-ext' => 'Roboto bold (100) italic greek-ext',
	  'Roboto:100italic&subset=cyrillic-ext' => 'Roboto bold (100) italic cyrillic-ext',
	  'Roboto:100italic&subset=cyrillic' => 'Roboto bold (100) italic cyrillic',
	  'Roboto:100italic&subset=vietnamese' => 'Roboto bold (100) italic vietnamese',
	  'Roboto:100italic&subset=greek' => 'Roboto bold (100) italic greek',
	  'Roboto:300&subset=latin-ext' => 'Roboto bold (300)  latin-ext',
	  'Roboto:300&subset=greek-ext' => 'Roboto bold (300)  greek-ext',
	  'Roboto:300&subset=cyrillic-ext' => 'Roboto bold (300)  cyrillic-ext',
	  'Roboto:300&subset=cyrillic' => 'Roboto bold (300)  cyrillic',
	  'Roboto:300&subset=vietnamese' => 'Roboto bold (300)  vietnamese',
	  'Roboto:300&subset=greek' => 'Roboto bold (300)  greek',
	  'Roboto:300italic&subset=latin-ext' => 'Roboto bold (300) italic latin-ext',
	  'Roboto:300italic&subset=greek-ext' => 'Roboto bold (300) italic greek-ext',
	  'Roboto:300italic&subset=cyrillic-ext' => 'Roboto bold (300) italic cyrillic-ext',
	  'Roboto:300italic&subset=cyrillic' => 'Roboto bold (300) italic cyrillic',
	  'Roboto:300italic&subset=vietnamese' => 'Roboto bold (300) italic vietnamese',
	  'Roboto:300italic&subset=greek' => 'Roboto bold (300) italic greek',
	  'Roboto:400italic&subset=latin-ext' => 'Roboto  italic latin-ext',
	  'Roboto:400italic&subset=greek-ext' => 'Roboto  italic greek-ext',
	  'Roboto:400italic&subset=cyrillic-ext' => 'Roboto  italic cyrillic-ext',
	  'Roboto:400italic&subset=cyrillic' => 'Roboto  italic cyrillic',
	  'Roboto:400italic&subset=vietnamese' => 'Roboto  italic vietnamese',
	  'Roboto:400italic&subset=greek' => 'Roboto  italic greek',
	  'Roboto:500&subset=latin-ext' => 'Roboto bold (500)  latin-ext',
	  'Roboto:500&subset=greek-ext' => 'Roboto bold (500)  greek-ext',
	  'Roboto:500&subset=cyrillic-ext' => 'Roboto bold (500)  cyrillic-ext',
	  'Roboto:500&subset=cyrillic' => 'Roboto bold (500)  cyrillic',
	  'Roboto:500&subset=vietnamese' => 'Roboto bold (500)  vietnamese',
	  'Roboto:500&subset=greek' => 'Roboto bold (500)  greek',
	  'Roboto:500italic&subset=latin-ext' => 'Roboto bold (500) italic latin-ext',
	  'Roboto:500italic&subset=greek-ext' => 'Roboto bold (500) italic greek-ext',
	  'Roboto:500italic&subset=cyrillic-ext' => 'Roboto bold (500) italic cyrillic-ext',
	  'Roboto:500italic&subset=cyrillic' => 'Roboto bold (500) italic cyrillic',
	  'Roboto:500italic&subset=vietnamese' => 'Roboto bold (500) italic vietnamese',
	  'Roboto:500italic&subset=greek' => 'Roboto bold (500) italic greek',
	  'Roboto:700&subset=latin-ext' => 'Roboto bold (700)  latin-ext',
	  'Roboto:700&subset=greek-ext' => 'Roboto bold (700)  greek-ext',
	  'Roboto:700&subset=cyrillic-ext' => 'Roboto bold (700)  cyrillic-ext',
	  'Roboto:700&subset=cyrillic' => 'Roboto bold (700)  cyrillic',
	  'Roboto:700&subset=vietnamese' => 'Roboto bold (700)  vietnamese',
	  'Roboto:700&subset=greek' => 'Roboto bold (700)  greek',
	  'Roboto:700italic&subset=latin-ext' => 'Roboto bold (700) italic latin-ext',
	  'Roboto:700italic&subset=greek-ext' => 'Roboto bold (700) italic greek-ext',
	  'Roboto:700italic&subset=cyrillic-ext' => 'Roboto bold (700) italic cyrillic-ext',
	  'Roboto:700italic&subset=cyrillic' => 'Roboto bold (700) italic cyrillic',
	  'Roboto:700italic&subset=vietnamese' => 'Roboto bold (700) italic vietnamese',
	  'Roboto:700italic&subset=greek' => 'Roboto bold (700) italic greek',
	  'Roboto:900&subset=latin-ext' => 'Roboto bold (900)  latin-ext',
	  'Roboto:900&subset=greek-ext' => 'Roboto bold (900)  greek-ext',
	  'Roboto:900&subset=cyrillic-ext' => 'Roboto bold (900)  cyrillic-ext',
	  'Roboto:900&subset=cyrillic' => 'Roboto bold (900)  cyrillic',
	  'Roboto:900&subset=vietnamese' => 'Roboto bold (900)  vietnamese',
	  'Roboto:900&subset=greek' => 'Roboto bold (900)  greek',
	  'Roboto:900italic&subset=latin-ext' => 'Roboto bold (900) italic latin-ext',
	  'Roboto:900italic&subset=greek-ext' => 'Roboto bold (900) italic greek-ext',
	  'Roboto:900italic&subset=cyrillic-ext' => 'Roboto bold (900) italic cyrillic-ext',
	  'Roboto:900italic&subset=cyrillic' => 'Roboto bold (900) italic cyrillic',
	  'Roboto:900italic&subset=vietnamese' => 'Roboto bold (900) italic vietnamese',
	  'Roboto:900italic&subset=greek' => 'Roboto bold (900) italic greek',
	  'Roboto Condensed:300' => 'Roboto Condensed bold (300) ',
	  'Roboto Condensed:300italic' => 'Roboto Condensed bold (300) italic',
	  'Roboto Condensed' => 'Roboto Condensed',
	  'Roboto Condensed:400italic' => 'Roboto Condensed  italic',
	  'Roboto Condensed:700' => 'Roboto Condensed bold (700) ',
	  'Roboto Condensed:700italic' => 'Roboto Condensed bold (700) italic',
	  'Roboto Condensed&subset=latin-ext' => 'Roboto Condensed latin-ext',
	  'Roboto Condensed&subset=greek-ext' => 'Roboto Condensed greek-ext',
	  'Roboto Condensed&subset=cyrillic-ext' => 'Roboto Condensed cyrillic-ext',
	  'Roboto Condensed&subset=cyrillic' => 'Roboto Condensed cyrillic',
	  'Roboto Condensed&subset=vietnamese' => 'Roboto Condensed vietnamese',
	  'Roboto Condensed&subset=greek' => 'Roboto Condensed greek',
	  'Roboto Condensed:300&subset=latin-ext' => 'Roboto Condensed bold (300)  latin-ext',
	  'Roboto Condensed:300&subset=greek-ext' => 'Roboto Condensed bold (300)  greek-ext',
	  'Roboto Condensed:300&subset=cyrillic-ext' => 'Roboto Condensed bold (300)  cyrillic-ext',
	  'Roboto Condensed:300&subset=cyrillic' => 'Roboto Condensed bold (300)  cyrillic',
	  'Roboto Condensed:300&subset=vietnamese' => 'Roboto Condensed bold (300)  vietnamese',
	  'Roboto Condensed:300&subset=greek' => 'Roboto Condensed bold (300)  greek',
	  'Roboto Condensed:300italic&subset=latin-ext' => 'Roboto Condensed bold (300) italic latin-ext',
	  'Roboto Condensed:300italic&subset=greek-ext' => 'Roboto Condensed bold (300) italic greek-ext',
	  'Roboto Condensed:300italic&subset=cyrillic-ext' => 'Roboto Condensed bold (300) italic cyrillic-ext',
	  'Roboto Condensed:300italic&subset=cyrillic' => 'Roboto Condensed bold (300) italic cyrillic',
	  'Roboto Condensed:300italic&subset=vietnamese' => 'Roboto Condensed bold (300) italic vietnamese',
	  'Roboto Condensed:300italic&subset=greek' => 'Roboto Condensed bold (300) italic greek',
	  'Roboto Condensed:400italic&subset=latin-ext' => 'Roboto Condensed  italic latin-ext',
	  'Roboto Condensed:400italic&subset=greek-ext' => 'Roboto Condensed  italic greek-ext',
	  'Roboto Condensed:400italic&subset=cyrillic-ext' => 'Roboto Condensed  italic cyrillic-ext',
	  'Roboto Condensed:400italic&subset=cyrillic' => 'Roboto Condensed  italic cyrillic',
	  'Roboto Condensed:400italic&subset=vietnamese' => 'Roboto Condensed  italic vietnamese',
	  'Roboto Condensed:400italic&subset=greek' => 'Roboto Condensed  italic greek',
	  'Roboto Condensed:700&subset=latin-ext' => 'Roboto Condensed bold (700)  latin-ext',
	  'Roboto Condensed:700&subset=greek-ext' => 'Roboto Condensed bold (700)  greek-ext',
	  'Roboto Condensed:700&subset=cyrillic-ext' => 'Roboto Condensed bold (700)  cyrillic-ext',
	  'Roboto Condensed:700&subset=cyrillic' => 'Roboto Condensed bold (700)  cyrillic',
	  'Roboto Condensed:700&subset=vietnamese' => 'Roboto Condensed bold (700)  vietnamese',
	  'Roboto Condensed:700&subset=greek' => 'Roboto Condensed bold (700)  greek',
	  'Roboto Condensed:700italic&subset=latin-ext' => 'Roboto Condensed bold (700) italic latin-ext',
	  'Roboto Condensed:700italic&subset=greek-ext' => 'Roboto Condensed bold (700) italic greek-ext',
	  'Roboto Condensed:700italic&subset=cyrillic-ext' => 'Roboto Condensed bold (700) italic cyrillic-ext',
	  'Roboto Condensed:700italic&subset=cyrillic' => 'Roboto Condensed bold (700) italic cyrillic',
	  'Roboto Condensed:700italic&subset=vietnamese' => 'Roboto Condensed bold (700) italic vietnamese',
	  'Roboto Condensed:700italic&subset=greek' => 'Roboto Condensed bold (700) italic greek',
	  'Roboto Slab:100' => 'Roboto Slab bold (100) ',
	  'Roboto Slab:300' => 'Roboto Slab bold (300) ',
	  'Roboto Slab' => 'Roboto Slab',
	  'Roboto Slab:700' => 'Roboto Slab bold (700) ',
	  'Roboto Slab&subset=latin-ext' => 'Roboto Slab latin-ext',
	  'Roboto Slab&subset=greek-ext' => 'Roboto Slab greek-ext',
	  'Roboto Slab&subset=cyrillic-ext' => 'Roboto Slab cyrillic-ext',
	  'Roboto Slab&subset=cyrillic' => 'Roboto Slab cyrillic',
	  'Roboto Slab&subset=vietnamese' => 'Roboto Slab vietnamese',
	  'Roboto Slab&subset=greek' => 'Roboto Slab greek',
	  'Roboto Slab:100&subset=latin-ext' => 'Roboto Slab bold (100)  latin-ext',
	  'Roboto Slab:100&subset=greek-ext' => 'Roboto Slab bold (100)  greek-ext',
	  'Roboto Slab:100&subset=cyrillic-ext' => 'Roboto Slab bold (100)  cyrillic-ext',
	  'Roboto Slab:100&subset=cyrillic' => 'Roboto Slab bold (100)  cyrillic',
	  'Roboto Slab:100&subset=vietnamese' => 'Roboto Slab bold (100)  vietnamese',
	  'Roboto Slab:100&subset=greek' => 'Roboto Slab bold (100)  greek',
	  'Roboto Slab:300&subset=latin-ext' => 'Roboto Slab bold (300)  latin-ext',
	  'Roboto Slab:300&subset=greek-ext' => 'Roboto Slab bold (300)  greek-ext',
	  'Roboto Slab:300&subset=cyrillic-ext' => 'Roboto Slab bold (300)  cyrillic-ext',
	  'Roboto Slab:300&subset=cyrillic' => 'Roboto Slab bold (300)  cyrillic',
	  'Roboto Slab:300&subset=vietnamese' => 'Roboto Slab bold (300)  vietnamese',
	  'Roboto Slab:300&subset=greek' => 'Roboto Slab bold (300)  greek',
	  'Roboto Slab:700&subset=latin-ext' => 'Roboto Slab bold (700)  latin-ext',
	  'Roboto Slab:700&subset=greek-ext' => 'Roboto Slab bold (700)  greek-ext',
	  'Roboto Slab:700&subset=cyrillic-ext' => 'Roboto Slab bold (700)  cyrillic-ext',
	  'Roboto Slab:700&subset=cyrillic' => 'Roboto Slab bold (700)  cyrillic',
	  'Roboto Slab:700&subset=vietnamese' => 'Roboto Slab bold (700)  vietnamese',
	  'Roboto Slab:700&subset=greek' => 'Roboto Slab bold (700)  greek',
	  'Rochester' => 'Rochester',
	  'Rock Salt' => 'Rock Salt',
	  'Rokkitt' => 'Rokkitt',
	  'Rokkitt:700' => 'Rokkitt bold (700) ',
	  'Romanesco' => 'Romanesco',
	  'Romanesco&subset=latin-ext' => 'Romanesco latin-ext',
	  'Ropa Sans' => 'Ropa Sans',
	  'Ropa Sans:400italic' => 'Ropa Sans  italic',
	  'Ropa Sans&subset=latin-ext' => 'Ropa Sans latin-ext',
	  'Ropa Sans:400italic&subset=latin-ext' => 'Ropa Sans  italic latin-ext',
	  'Rosario' => 'Rosario',
	  'Rosario:400italic' => 'Rosario  italic',
	  'Rosario:700' => 'Rosario bold (700) ',
	  'Rosario:700italic' => 'Rosario bold (700) italic',
	  'Rosarivo' => 'Rosarivo',
	  'Rosarivo:400italic' => 'Rosarivo  italic',
	  'Rosarivo&subset=latin-ext' => 'Rosarivo latin-ext',
	  'Rosarivo:400italic&subset=latin-ext' => 'Rosarivo  italic latin-ext',
	  'Rouge Script' => 'Rouge Script',
	  'Ruda' => 'Ruda',
	  'Ruda:700' => 'Ruda bold (700) ',
	  'Ruda:900' => 'Ruda bold (900) ',
	  'Ruda&subset=latin-ext' => 'Ruda latin-ext',
	  'Ruda:700&subset=latin-ext' => 'Ruda bold (700)  latin-ext',
	  'Ruda:900&subset=latin-ext' => 'Ruda bold (900)  latin-ext',
	  'Rufina' => 'Rufina',
	  'Rufina:700' => 'Rufina bold (700) ',
	  'Rufina&subset=latin-ext' => 'Rufina latin-ext',
	  'Rufina:700&subset=latin-ext' => 'Rufina bold (700)  latin-ext',
	  'Ruge Boogie' => 'Ruge Boogie',
	  'Ruge Boogie&subset=latin-ext' => 'Ruge Boogie latin-ext',
	  'Ruluko' => 'Ruluko',
	  'Ruluko&subset=latin-ext' => 'Ruluko latin-ext',
	  'Rum Raisin' => 'Rum Raisin',
	  'Rum Raisin&subset=latin-ext' => 'Rum Raisin latin-ext',
	  'Ruslan Display' => 'Ruslan Display',
	  'Ruslan Display&subset=latin-ext' => 'Ruslan Display latin-ext',
	  'Ruslan Display&subset=cyrillic-ext' => 'Ruslan Display cyrillic-ext',
	  'Ruslan Display&subset=cyrillic' => 'Ruslan Display cyrillic',
	  'Russo One' => 'Russo One',
	  'Russo One&subset=latin-ext' => 'Russo One latin-ext',
	  'Russo One&subset=cyrillic' => 'Russo One cyrillic',
	  'Ruthie' => 'Ruthie',
	  'Ruthie&subset=latin-ext' => 'Ruthie latin-ext',
	  'Rye' => 'Rye',
	  'Rye&subset=latin-ext' => 'Rye latin-ext',
	  'Sacramento' => 'Sacramento',
	  'Sacramento&subset=latin-ext' => 'Sacramento latin-ext',
	  'Sail' => 'Sail',
	  'Salsa' => 'Salsa',
	  'Sanchez' => 'Sanchez',
	  'Sanchez:400italic' => 'Sanchez  italic',
	  'Sanchez&subset=latin-ext' => 'Sanchez latin-ext',
	  'Sanchez:400italic&subset=latin-ext' => 'Sanchez  italic latin-ext',
	  'Sancreek' => 'Sancreek',
	  'Sancreek&subset=latin-ext' => 'Sancreek latin-ext',
	  'Sansita One' => 'Sansita One',
	  'Sarina' => 'Sarina',
	  'Sarina&subset=latin-ext' => 'Sarina latin-ext',
	  'Satisfy' => 'Satisfy',
	  'Scada' => 'Scada',
	  'Scada:400italic' => 'Scada  italic',
	  'Scada:700' => 'Scada bold (700) ',
	  'Scada:700italic' => 'Scada bold (700) italic',
	  'Scada&subset=latin-ext' => 'Scada latin-ext',
	  'Scada&subset=cyrillic' => 'Scada cyrillic',
	  'Scada:400italic&subset=latin-ext' => 'Scada  italic latin-ext',
	  'Scada:400italic&subset=cyrillic' => 'Scada  italic cyrillic',
	  'Scada:700&subset=latin-ext' => 'Scada bold (700)  latin-ext',
	  'Scada:700&subset=cyrillic' => 'Scada bold (700)  cyrillic',
	  'Scada:700italic&subset=latin-ext' => 'Scada bold (700) italic latin-ext',
	  'Scada:700italic&subset=cyrillic' => 'Scada bold (700) italic cyrillic',
	  'Schoolbell' => 'Schoolbell',
	  'Seaweed Script' => 'Seaweed Script',
	  'Seaweed Script&subset=latin-ext' => 'Seaweed Script latin-ext',
	  'Sevillana' => 'Sevillana',
	  'Sevillana&subset=latin-ext' => 'Sevillana latin-ext',
	  'Seymour One' => 'Seymour One',
	  'Seymour One&subset=latin-ext' => 'Seymour One latin-ext',
	  'Seymour One&subset=cyrillic' => 'Seymour One cyrillic',
	  'Shadows Into Light' => 'Shadows Into Light',
	  'Shadows Into Light Two' => 'Shadows Into Light Two',
	  'Shadows Into Light Two&subset=latin-ext' => 'Shadows Into Light Two latin-ext',
	  'Shanti' => 'Shanti',
	  'Share' => 'Share',
	  'Share:400italic' => 'Share  italic',
	  'Share:700' => 'Share bold (700) ',
	  'Share:700italic' => 'Share bold (700) italic',
	  'Share&subset=latin-ext' => 'Share latin-ext',
	  'Share:400italic&subset=latin-ext' => 'Share  italic latin-ext',
	  'Share:700&subset=latin-ext' => 'Share bold (700)  latin-ext',
	  'Share:700italic&subset=latin-ext' => 'Share bold (700) italic latin-ext',
	  'Share Tech' => 'Share Tech',
	  'Share Tech Mono' => 'Share Tech Mono',
	  'Shojumaru' => 'Shojumaru',
	  'Shojumaru&subset=latin-ext' => 'Shojumaru latin-ext',
	  'Short Stack' => 'Short Stack',
	  'Siemreap' => 'Siemreap',
	  'Sigmar One' => 'Sigmar One',
	  'Signika:300' => 'Signika bold (300) ',
	  'Signika' => 'Signika',
	  'Signika:600' => 'Signika bold (600) ',
	  'Signika:700' => 'Signika bold (700) ',
	  'Signika&subset=latin-ext' => 'Signika latin-ext',
	  'Signika:300&subset=latin-ext' => 'Signika bold (300)  latin-ext',
	  'Signika:600&subset=latin-ext' => 'Signika bold (600)  latin-ext',
	  'Signika:700&subset=latin-ext' => 'Signika bold (700)  latin-ext',
	  'Signika Negative:300' => 'Signika Negative bold (300) ',
	  'Signika Negative' => 'Signika Negative',
	  'Signika Negative:600' => 'Signika Negative bold (600) ',
	  'Signika Negative:700' => 'Signika Negative bold (700) ',
	  'Signika Negative&subset=latin-ext' => 'Signika Negative latin-ext',
	  'Signika Negative:300&subset=latin-ext' => 'Signika Negative bold (300)  latin-ext',
	  'Signika Negative:600&subset=latin-ext' => 'Signika Negative bold (600)  latin-ext',
	  'Signika Negative:700&subset=latin-ext' => 'Signika Negative bold (700)  latin-ext',
	  'Simonetta' => 'Simonetta',
	  'Simonetta:400italic' => 'Simonetta  italic',
	  'Simonetta:900' => 'Simonetta bold (900) ',
	  'Simonetta:900italic' => 'Simonetta bold (900) italic',
	  'Simonetta&subset=latin-ext' => 'Simonetta latin-ext',
	  'Simonetta:400italic&subset=latin-ext' => 'Simonetta  italic latin-ext',
	  'Simonetta:900&subset=latin-ext' => 'Simonetta bold (900)  latin-ext',
	  'Simonetta:900italic&subset=latin-ext' => 'Simonetta bold (900) italic latin-ext',
	  'Sintony' => 'Sintony',
	  'Sintony:700' => 'Sintony bold (700) ',
	  'Sintony&subset=latin-ext' => 'Sintony latin-ext',
	  'Sintony:700&subset=latin-ext' => 'Sintony bold (700)  latin-ext',
	  'Sirin Stencil' => 'Sirin Stencil',
	  'Six Caps' => 'Six Caps',
	  'Skranji' => 'Skranji',
	  'Skranji:700' => 'Skranji bold (700) ',
	  'Skranji&subset=latin-ext' => 'Skranji latin-ext',
	  'Skranji:700&subset=latin-ext' => 'Skranji bold (700)  latin-ext',
	  'Slackey' => 'Slackey',
	  'Smokum' => 'Smokum',
	  'Smythe' => 'Smythe',
	  'Sniglet:800' => 'Sniglet bold (800) ',
	  'Snippet' => 'Snippet',
	  'Snowburst One' => 'Snowburst One',
	  'Snowburst One&subset=latin-ext' => 'Snowburst One latin-ext',
	  'Sofadi One' => 'Sofadi One',
	  'Sofia' => 'Sofia',
	  'Sonsie One' => 'Sonsie One',
	  'Sonsie One&subset=latin-ext' => 'Sonsie One latin-ext',
	  'Sorts Mill Goudy' => 'Sorts Mill Goudy',
	  'Sorts Mill Goudy:400italic' => 'Sorts Mill Goudy  italic',
	  'Sorts Mill Goudy&subset=latin-ext' => 'Sorts Mill Goudy latin-ext',
	  'Sorts Mill Goudy:400italic&subset=latin-ext' => 'Sorts Mill Goudy  italic latin-ext',
	  'Source Code Pro:200' => 'Source Code Pro bold (200) ',
	  'Source Code Pro:300' => 'Source Code Pro bold (300) ',
	  'Source Code Pro' => 'Source Code Pro',
	  'Source Code Pro:500' => 'Source Code Pro bold (500) ',
	  'Source Code Pro:600' => 'Source Code Pro bold (600) ',
	  'Source Code Pro:700' => 'Source Code Pro bold (700) ',
	  'Source Code Pro:900' => 'Source Code Pro bold (900) ',
	  'Source Code Pro&subset=latin-ext' => 'Source Code Pro latin-ext',
	  'Source Code Pro:200&subset=latin-ext' => 'Source Code Pro bold (200)  latin-ext',
	  'Source Code Pro:300&subset=latin-ext' => 'Source Code Pro bold (300)  latin-ext',
	  'Source Code Pro:500&subset=latin-ext' => 'Source Code Pro bold (500)  latin-ext',
	  'Source Code Pro:600&subset=latin-ext' => 'Source Code Pro bold (600)  latin-ext',
	  'Source Code Pro:700&subset=latin-ext' => 'Source Code Pro bold (700)  latin-ext',
	  'Source Code Pro:900&subset=latin-ext' => 'Source Code Pro bold (900)  latin-ext',
	  'Source Sans Pro:200' => 'Source Sans Pro bold (200) ',
	  'Source Sans Pro:200italic' => 'Source Sans Pro bold (200) italic',
	  'Source Sans Pro:300' => 'Source Sans Pro bold (300) ',
	  'Source Sans Pro:300italic' => 'Source Sans Pro bold (300) italic',
	  'Source Sans Pro' => 'Source Sans Pro',
	  'Source Sans Pro:400italic' => 'Source Sans Pro  italic',
	  'Source Sans Pro:600' => 'Source Sans Pro bold (600) ',
	  'Source Sans Pro:600italic' => 'Source Sans Pro bold (600) italic',
	  'Source Sans Pro:700' => 'Source Sans Pro bold (700) ',
	  'Source Sans Pro:700italic' => 'Source Sans Pro bold (700) italic',
	  'Source Sans Pro:900' => 'Source Sans Pro bold (900) ',
	  'Source Sans Pro:900italic' => 'Source Sans Pro bold (900) italic',
	  'Source Sans Pro&subset=latin-ext' => 'Source Sans Pro latin-ext',
	  'Source Sans Pro:200&subset=latin-ext' => 'Source Sans Pro bold (200)  latin-ext',
	  'Source Sans Pro:200italic&subset=latin-ext' => 'Source Sans Pro bold (200) italic latin-ext',
	  'Source Sans Pro:300&subset=latin-ext' => 'Source Sans Pro bold (300)  latin-ext',
	  'Source Sans Pro:300italic&subset=latin-ext' => 'Source Sans Pro bold (300) italic latin-ext',
	  'Source Sans Pro:400italic&subset=latin-ext' => 'Source Sans Pro  italic latin-ext',
	  'Source Sans Pro:600&subset=latin-ext' => 'Source Sans Pro bold (600)  latin-ext',
	  'Source Sans Pro:600italic&subset=latin-ext' => 'Source Sans Pro bold (600) italic latin-ext',
	  'Source Sans Pro:700&subset=latin-ext' => 'Source Sans Pro bold (700)  latin-ext',
	  'Source Sans Pro:700italic&subset=latin-ext' => 'Source Sans Pro bold (700) italic latin-ext',
	  'Source Sans Pro:900&subset=latin-ext' => 'Source Sans Pro bold (900)  latin-ext',
	  'Source Sans Pro:900italic&subset=latin-ext' => 'Source Sans Pro bold (900) italic latin-ext',
	  'Special Elite' => 'Special Elite',
	  'Spicy Rice' => 'Spicy Rice',
	  'Spinnaker' => 'Spinnaker',
	  'Spinnaker&subset=latin-ext' => 'Spinnaker latin-ext',
	  'Spirax' => 'Spirax',
	  'Squada One' => 'Squada One',
	  'Stalemate' => 'Stalemate',
	  'Stalemate&subset=latin-ext' => 'Stalemate latin-ext',
	  'Stalinist One' => 'Stalinist One',
	  'Stalinist One&subset=latin-ext' => 'Stalinist One latin-ext',
	  'Stalinist One&subset=cyrillic' => 'Stalinist One cyrillic',
	  'Stardos Stencil' => 'Stardos Stencil',
	  'Stardos Stencil:700' => 'Stardos Stencil bold (700) ',
	  'Stint Ultra Condensed' => 'Stint Ultra Condensed',
	  'Stint Ultra Condensed&subset=latin-ext' => 'Stint Ultra Condensed latin-ext',
	  'Stint Ultra Expanded' => 'Stint Ultra Expanded',
	  'Stint Ultra Expanded&subset=latin-ext' => 'Stint Ultra Expanded latin-ext',
	  'Stoke:300' => 'Stoke bold (300) ',
	  'Stoke' => 'Stoke',
	  'Stoke&subset=latin-ext' => 'Stoke latin-ext',
	  'Stoke:300&subset=latin-ext' => 'Stoke bold (300)  latin-ext',
	  'Strait' => 'Strait',
	  'Sue Ellen Francisco' => 'Sue Ellen Francisco',
	  'Sunshiney' => 'Sunshiney',
	  'Supermercado One' => 'Supermercado One',
	  'Suwannaphum' => 'Suwannaphum',
	  'Swanky and Moo Moo' => 'Swanky and Moo Moo',
	  'Syncopate' => 'Syncopate',
	  'Syncopate:700' => 'Syncopate bold (700) ',
	  'Tangerine' => 'Tangerine',
	  'Tangerine:700' => 'Tangerine bold (700) ',
	  'Taprom' => 'Taprom',
	  'Tauri' => 'Tauri',
	  'Tauri&subset=latin-ext' => 'Tauri latin-ext',
	  'Telex' => 'Telex',
	  'Tenor Sans' => 'Tenor Sans',
	  'Tenor Sans&subset=latin-ext' => 'Tenor Sans latin-ext',
	  'Tenor Sans&subset=cyrillic-ext' => 'Tenor Sans cyrillic-ext',
	  'Tenor Sans&subset=cyrillic' => 'Tenor Sans cyrillic',
	  'Text Me One' => 'Text Me One',
	  'Text Me One&subset=latin-ext' => 'Text Me One latin-ext',
	  'The Girl Next Door' => 'The Girl Next Door',
	  'Tienne' => 'Tienne',
	  'Tienne:700' => 'Tienne bold (700) ',
	  'Tienne:900' => 'Tienne bold (900) ',
	  'Tinos' => 'Tinos',
	  'Tinos:400italic' => 'Tinos  italic',
	  'Tinos:700' => 'Tinos bold (700) ',
	  'Tinos:700italic' => 'Tinos bold (700) italic',
	  'Titan One' => 'Titan One',
	  'Titan One&subset=latin-ext' => 'Titan One latin-ext',
	  'Titillium Web:200' => 'Titillium Web bold (200) ',
	  'Titillium Web:200italic' => 'Titillium Web bold (200) italic',
	  'Titillium Web:300' => 'Titillium Web bold (300) ',
	  'Titillium Web:300italic' => 'Titillium Web bold (300) italic',
	  'Titillium Web' => 'Titillium Web',
	  'Titillium Web:400italic' => 'Titillium Web  italic',
	  'Titillium Web:600' => 'Titillium Web bold (600) ',
	  'Titillium Web:600italic' => 'Titillium Web bold (600) italic',
	  'Titillium Web:700' => 'Titillium Web bold (700) ',
	  'Titillium Web:700italic' => 'Titillium Web bold (700) italic',
	  'Titillium Web:900' => 'Titillium Web bold (900) ',
	  'Titillium Web&subset=latin-ext' => 'Titillium Web latin-ext',
	  'Titillium Web:200&subset=latin-ext' => 'Titillium Web bold (200)  latin-ext',
	  'Titillium Web:200italic&subset=latin-ext' => 'Titillium Web bold (200) italic latin-ext',
	  'Titillium Web:300&subset=latin-ext' => 'Titillium Web bold (300)  latin-ext',
	  'Titillium Web:300italic&subset=latin-ext' => 'Titillium Web bold (300) italic latin-ext',
	  'Titillium Web:400italic&subset=latin-ext' => 'Titillium Web  italic latin-ext',
	  'Titillium Web:600&subset=latin-ext' => 'Titillium Web bold (600)  latin-ext',
	  'Titillium Web:600italic&subset=latin-ext' => 'Titillium Web bold (600) italic latin-ext',
	  'Titillium Web:700&subset=latin-ext' => 'Titillium Web bold (700)  latin-ext',
	  'Titillium Web:700italic&subset=latin-ext' => 'Titillium Web bold (700) italic latin-ext',
	  'Titillium Web:900&subset=latin-ext' => 'Titillium Web bold (900)  latin-ext',
	  'Trade Winds' => 'Trade Winds',
	  'Trocchi' => 'Trocchi',
	  'Trocchi&subset=latin-ext' => 'Trocchi latin-ext',
	  'Trochut' => 'Trochut',
	  'Trochut:400italic' => 'Trochut  italic',
	  'Trochut:700' => 'Trochut bold (700) ',
	  'Trykker' => 'Trykker',
	  'Trykker&subset=latin-ext' => 'Trykker latin-ext',
	  'Tulpen One' => 'Tulpen One',
	  'Ubuntu:300' => 'Ubuntu bold (300) ',
	  'Ubuntu:300italic' => 'Ubuntu bold (300) italic',
	  'Ubuntu' => 'Ubuntu',
	  'Ubuntu:400italic' => 'Ubuntu  italic',
	  'Ubuntu:500' => 'Ubuntu bold (500) ',
	  'Ubuntu:500italic' => 'Ubuntu bold (500) italic',
	  'Ubuntu:700' => 'Ubuntu bold (700) ',
	  'Ubuntu:700italic' => 'Ubuntu bold (700) italic',
	  'Ubuntu&subset=latin-ext' => 'Ubuntu latin-ext',
	  'Ubuntu&subset=greek-ext' => 'Ubuntu greek-ext',
	  'Ubuntu&subset=cyrillic-ext' => 'Ubuntu cyrillic-ext',
	  'Ubuntu&subset=cyrillic' => 'Ubuntu cyrillic',
	  'Ubuntu&subset=greek' => 'Ubuntu greek',
	  'Ubuntu:300&subset=latin-ext' => 'Ubuntu bold (300)  latin-ext',
	  'Ubuntu:300&subset=greek-ext' => 'Ubuntu bold (300)  greek-ext',
	  'Ubuntu:300&subset=cyrillic-ext' => 'Ubuntu bold (300)  cyrillic-ext',
	  'Ubuntu:300&subset=cyrillic' => 'Ubuntu bold (300)  cyrillic',
	  'Ubuntu:300&subset=greek' => 'Ubuntu bold (300)  greek',
	  'Ubuntu:300italic&subset=latin-ext' => 'Ubuntu bold (300) italic latin-ext',
	  'Ubuntu:300italic&subset=greek-ext' => 'Ubuntu bold (300) italic greek-ext',
	  'Ubuntu:300italic&subset=cyrillic-ext' => 'Ubuntu bold (300) italic cyrillic-ext',
	  'Ubuntu:300italic&subset=cyrillic' => 'Ubuntu bold (300) italic cyrillic',
	  'Ubuntu:300italic&subset=greek' => 'Ubuntu bold (300) italic greek',
	  'Ubuntu:400italic&subset=latin-ext' => 'Ubuntu  italic latin-ext',
	  'Ubuntu:400italic&subset=greek-ext' => 'Ubuntu  italic greek-ext',
	  'Ubuntu:400italic&subset=cyrillic-ext' => 'Ubuntu  italic cyrillic-ext',
	  'Ubuntu:400italic&subset=cyrillic' => 'Ubuntu  italic cyrillic',
	  'Ubuntu:400italic&subset=greek' => 'Ubuntu  italic greek',
	  'Ubuntu:500&subset=latin-ext' => 'Ubuntu bold (500)  latin-ext',
	  'Ubuntu:500&subset=greek-ext' => 'Ubuntu bold (500)  greek-ext',
	  'Ubuntu:500&subset=cyrillic-ext' => 'Ubuntu bold (500)  cyrillic-ext',
	  'Ubuntu:500&subset=cyrillic' => 'Ubuntu bold (500)  cyrillic',
	  'Ubuntu:500&subset=greek' => 'Ubuntu bold (500)  greek',
	  'Ubuntu:500italic&subset=latin-ext' => 'Ubuntu bold (500) italic latin-ext',
	  'Ubuntu:500italic&subset=greek-ext' => 'Ubuntu bold (500) italic greek-ext',
	  'Ubuntu:500italic&subset=cyrillic-ext' => 'Ubuntu bold (500) italic cyrillic-ext',
	  'Ubuntu:500italic&subset=cyrillic' => 'Ubuntu bold (500) italic cyrillic',
	  'Ubuntu:500italic&subset=greek' => 'Ubuntu bold (500) italic greek',
	  'Ubuntu:700&subset=latin-ext' => 'Ubuntu bold (700)  latin-ext',
	  'Ubuntu:700&subset=greek-ext' => 'Ubuntu bold (700)  greek-ext',
	  'Ubuntu:700&subset=cyrillic-ext' => 'Ubuntu bold (700)  cyrillic-ext',
	  'Ubuntu:700&subset=cyrillic' => 'Ubuntu bold (700)  cyrillic',
	  'Ubuntu:700&subset=greek' => 'Ubuntu bold (700)  greek',
	  'Ubuntu:700italic&subset=latin-ext' => 'Ubuntu bold (700) italic latin-ext',
	  'Ubuntu:700italic&subset=greek-ext' => 'Ubuntu bold (700) italic greek-ext',
	  'Ubuntu:700italic&subset=cyrillic-ext' => 'Ubuntu bold (700) italic cyrillic-ext',
	  'Ubuntu:700italic&subset=cyrillic' => 'Ubuntu bold (700) italic cyrillic',
	  'Ubuntu:700italic&subset=greek' => 'Ubuntu bold (700) italic greek',
	  'Ubuntu Condensed' => 'Ubuntu Condensed',
	  'Ubuntu Condensed&subset=latin-ext' => 'Ubuntu Condensed latin-ext',
	  'Ubuntu Condensed&subset=greek-ext' => 'Ubuntu Condensed greek-ext',
	  'Ubuntu Condensed&subset=cyrillic-ext' => 'Ubuntu Condensed cyrillic-ext',
	  'Ubuntu Condensed&subset=cyrillic' => 'Ubuntu Condensed cyrillic',
	  'Ubuntu Condensed&subset=greek' => 'Ubuntu Condensed greek',
	  'Ubuntu Mono' => 'Ubuntu Mono',
	  'Ubuntu Mono:400italic' => 'Ubuntu Mono  italic',
	  'Ubuntu Mono:700' => 'Ubuntu Mono bold (700) ',
	  'Ubuntu Mono:700italic' => 'Ubuntu Mono bold (700) italic',
	  'Ubuntu Mono&subset=latin-ext' => 'Ubuntu Mono latin-ext',
	  'Ubuntu Mono&subset=greek-ext' => 'Ubuntu Mono greek-ext',
	  'Ubuntu Mono&subset=cyrillic-ext' => 'Ubuntu Mono cyrillic-ext',
	  'Ubuntu Mono&subset=cyrillic' => 'Ubuntu Mono cyrillic',
	  'Ubuntu Mono&subset=greek' => 'Ubuntu Mono greek',
	  'Ubuntu Mono:400italic&subset=latin-ext' => 'Ubuntu Mono  italic latin-ext',
	  'Ubuntu Mono:400italic&subset=greek-ext' => 'Ubuntu Mono  italic greek-ext',
	  'Ubuntu Mono:400italic&subset=cyrillic-ext' => 'Ubuntu Mono  italic cyrillic-ext',
	  'Ubuntu Mono:400italic&subset=cyrillic' => 'Ubuntu Mono  italic cyrillic',
	  'Ubuntu Mono:400italic&subset=greek' => 'Ubuntu Mono  italic greek',
	  'Ubuntu Mono:700&subset=latin-ext' => 'Ubuntu Mono bold (700)  latin-ext',
	  'Ubuntu Mono:700&subset=greek-ext' => 'Ubuntu Mono bold (700)  greek-ext',
	  'Ubuntu Mono:700&subset=cyrillic-ext' => 'Ubuntu Mono bold (700)  cyrillic-ext',
	  'Ubuntu Mono:700&subset=cyrillic' => 'Ubuntu Mono bold (700)  cyrillic',
	  'Ubuntu Mono:700&subset=greek' => 'Ubuntu Mono bold (700)  greek',
	  'Ubuntu Mono:700italic&subset=latin-ext' => 'Ubuntu Mono bold (700) italic latin-ext',
	  'Ubuntu Mono:700italic&subset=greek-ext' => 'Ubuntu Mono bold (700) italic greek-ext',
	  'Ubuntu Mono:700italic&subset=cyrillic-ext' => 'Ubuntu Mono bold (700) italic cyrillic-ext',
	  'Ubuntu Mono:700italic&subset=cyrillic' => 'Ubuntu Mono bold (700) italic cyrillic',
	  'Ubuntu Mono:700italic&subset=greek' => 'Ubuntu Mono bold (700) italic greek',
	  'Ultra' => 'Ultra',
	  'Uncial Antiqua' => 'Uncial Antiqua',
	  'Underdog' => 'Underdog',
	  'Underdog&subset=latin-ext' => 'Underdog latin-ext',
	  'Underdog&subset=cyrillic' => 'Underdog cyrillic',
	  'Unica One' => 'Unica One',
	  'Unica One&subset=latin-ext' => 'Unica One latin-ext',
	  'UnifrakturCook:700' => 'UnifrakturCook bold (700) ',
	  'UnifrakturMaguntia' => 'UnifrakturMaguntia',
	  'Unkempt' => 'Unkempt',
	  'Unkempt:700' => 'Unkempt bold (700) ',
	  'Unlock' => 'Unlock',
	  'Unna' => 'Unna',
	  'VT323' => 'VT323',
	  'Vampiro One' => 'Vampiro One',
	  'Vampiro One&subset=latin-ext' => 'Vampiro One latin-ext',
	  'Varela' => 'Varela',
	  'Varela&subset=latin-ext' => 'Varela latin-ext',
	  'Varela Round' => 'Varela Round',
	  'Vast Shadow' => 'Vast Shadow',
	  'Vibur' => 'Vibur',
	  'Vidaloka' => 'Vidaloka',
	  'Viga' => 'Viga',
	  'Viga&subset=latin-ext' => 'Viga latin-ext',
	  'Voces' => 'Voces',
	  'Voces&subset=latin-ext' => 'Voces latin-ext',
	  'Volkhov' => 'Volkhov',
	  'Volkhov:400italic' => 'Volkhov  italic',
	  'Volkhov:700' => 'Volkhov bold (700) ',
	  'Volkhov:700italic' => 'Volkhov bold (700) italic',
	  'Vollkorn' => 'Vollkorn',
	  'Vollkorn:400italic' => 'Vollkorn  italic',
	  'Vollkorn:700' => 'Vollkorn bold (700) ',
	  'Vollkorn:700italic' => 'Vollkorn bold (700) italic',
	  'Voltaire' => 'Voltaire',
	  'Waiting for the Sunrise' => 'Waiting for the Sunrise',
	  'Wallpoet' => 'Wallpoet',
	  'Walter Turncoat' => 'Walter Turncoat',
	  'Warnes' => 'Warnes',
	  'Warnes&subset=latin-ext' => 'Warnes latin-ext',
	  'Wellfleet' => 'Wellfleet',
	  'Wellfleet&subset=latin-ext' => 'Wellfleet latin-ext',
	  'Wendy One' => 'Wendy One',
	  'Wendy One&subset=latin-ext' => 'Wendy One latin-ext',
	  'Wire One' => 'Wire One',
	  'Yanone Kaffeesatz:200' => 'Yanone Kaffeesatz bold (200) ',
	  'Yanone Kaffeesatz:300' => 'Yanone Kaffeesatz bold (300) ',
	  'Yanone Kaffeesatz' => 'Yanone Kaffeesatz',
	  'Yanone Kaffeesatz:700' => 'Yanone Kaffeesatz bold (700) ',
	  'Yanone Kaffeesatz&subset=latin-ext' => 'Yanone Kaffeesatz latin-ext',
	  'Yanone Kaffeesatz:200&subset=latin-ext' => 'Yanone Kaffeesatz bold (200)  latin-ext',
	  'Yanone Kaffeesatz:300&subset=latin-ext' => 'Yanone Kaffeesatz bold (300)  latin-ext',
	  'Yanone Kaffeesatz:700&subset=latin-ext' => 'Yanone Kaffeesatz bold (700)  latin-ext',
	  'Yellowtail' => 'Yellowtail',
	  'Yeseva One' => 'Yeseva One',
	  'Yeseva One&subset=latin-ext' => 'Yeseva One latin-ext',
	  'Yeseva One&subset=cyrillic' => 'Yeseva One cyrillic',
	  'Yesteryear' => 'Yesteryear',
	  'Zeyada' => 'Zeyada',
	);
	return apply_filters( 'optionsframework_get_web_fonts_defaults', $web_fonts_list );
}
