<?php
/**
* 曼顿设备
*/
class Mandun{
    //配置
    public $config;

    //接口URL
    protected $api_url='https://open.snd02.com';

    protected $api_router_url="https://open.snd02.com:443/invoke/router.as";

    protected $QyAppKey="O000008102";

    public function __construct($config=[]){
        $config=[
         'appKey'=>'O000008102',
         'appSecret'=>'87927BA90EEFB027EE7298B139C9AACF',
         'uname'=>'qlgcs01',
         'passwd'=>'qlg888',
         'projectCode'=>'P00000016937',
         'api_url'=>'open.snd02.com',
        ];
        $data=[
            'appKey'=>isset($config['appKey'])?$config['appKey']:'',
            'appSecret'=>isset($config['appSecret'])?$config['appSecret']:'',
            'uname'=>isset($config['uname'])?$config['uname']:'',
            'passwd'=>isset($config['passwd'])?$config['passwd']:'',
            'projectCode'=>isset($config['projectCode'])?$config['projectCode']:'',
            'api_url'=>isset($config['api_url'])?$config['api_url']:'',
        ];      
        $this->config = (object)$data;
        $this->api_url="http://".$data['api_url'];
        $this->api_router_url="https://".$data['api_url'].":443/invoke/router.as";
    }
    //获取验证码
    public function getCode(){
        $action="/oauth/authverify2.as";
        $url=$this->api_url.$action;
        $post['redirect_uri']=$this->api_url."/demo.jsp";
        $post['response_type']="code";
        $post['uname']=$this->config->uname;
        $post['passwd']=$this->config->passwd;
        $post['client_id']=$this->config->appKey;

        $res=self::httpRequest($url,"POST",$post);
        if($res['code']!=1){
            return ['code'=>0,'data'=>$res['code']];
        }else{
            return ['code'=>1,'msg'=>'获取码错误'];
        }
    }
    
    //获取AccessToken
    public function getAccessToken(){
        
        $access_token=self::filecache('MANDUN_TOEKN'.$this->config->appKey);
        if($access_token){
         return ['code'=>0,'data'=>$access_token];
        }
        $action="/oauth/token.as";
        $url=$this->api_url.$action;
        $resCode=self::getCode();

        if($resCode['code']!=0){
            return $resCode;
        }
        $post['client_id']=$this->config->appKey;
        $post['grant_type']="authorization_code";
        $post['redirect_uri']="http://open.snd02.com/demo.jsp";
        $post['code']=$resCode['data'];
        $post['client_secret']=md5($this->config->appKey.'authorization_code'.$post['redirect_uri'].$post['code'].$this->config->appSecret);
        $res=self::httpRequest($url,"POST",$post);
        if($res['code']==0){
            self::filecache('MANDUN_TOEKN'.$this->config->appKey,$res['data']['accessToken'],5);
            return ['code'=>0,'data'=>$res['data']['accessToken']];
        }else{
            return ['code'=>1,'data'=>$res['message']];
        }
    }
    public function httpRequest($url="",$method="POST",$request=[],$header=["Content-Type: application/json","cache-control: no-cache"]){
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt_array($curl, array(
          CURLOPT_URL => $url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => $method,
          CURLOPT_POSTFIELDS => json_encode($request),
          CURLOPT_HTTPHEADER => $header,
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
          return ['code'=>1,'msg'=>"cURL Error #:" . $err];
        } else {
          return json_decode($response,1);
        }
    }
    /**
     * 缓存
     * @param $key 缓存名
     * @param $value 缓存值 为空时为 读,不为空为写
     */
    function filecache($key,$value='',$cachetime=3600){
        if(is_array($key))$key=md5(json_encode($key));
        $filename="./cache/".$key.'.log';
        self::clearcache();$time=time();
        if(empty($value)){
            $res=@file_get_contents($filename);
            $array= json_decode($res,true);
            if($array && $array['timestamp']>$time)return $array[0];
            else return false;
        }else{
            if(!is_array($value))$value=array($value);
            $value['timestamp']=$time+$cachetime;
            $value=json_encode($value);
            file_put_contents($filename,$value);
        }return $filename;
    }
    //清空所有缓存 每日清空
     
    function clearcache(){
       $cachepath="./cache/";
       $date=date('Y-m-d');$cachename='cachetime'.$date.'.log';
       if(file_exists($cachepath.$cachename))return false;
       foreach(scandir($cachepath) as $fn) {
        if(strpos($cachename,'.log')>0)unlink($cachepath.$fn);
       }file_put_contents($cachepath.$cachename,'1');
       return true;
    }
}
$form=new Mandun();
$res=$form->getAccessToken();
die(json_encode($res));

 

