<?php
namespace weixin;
use think\facade\Cache;
/**
* 微信
*/
class Wechat{

     public function sendWxopenTemplate($wechat,$template_id,$openidArr,$wxapp_path,$data,$is_wxapp_openid=false){
        if($is_wxapp_openid){
            $wxopen_template_url="https://api.weixin.qq.com/cgi-bin/message/wxopen/template/uniform_send?access_token=";
            $get_access_token=self::wxapp_access_token($wechat);
            $access_token=$get_access_token['data'];
        }else{
             $wxopen_template_url="https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";
             $get_access_token=self::web_wx_access_token($wechat);
             $access_token=$get_access_token['data'];
        }
        $resData=[];
        foreach ($openidArr as $openid) {
            if($is_wxapp_openid){
               
                $send_data=
                [
                    "touser"         =>$openid,// 小程序openid
                    "mp_template_msg"=>[
                        "appid"      => $wechat['wx_app_id'],         //绑定的公众号appid
                        "template_id"=>$template_id, //绑定的公众号创建的模板id
                        "miniprogram"=>[
                          "appid"    =>$wechat['wxapp_app_id'],         //小程序appid
                          "pagepath" =>$wxapp_path                  //跳转至小程序的路径
                        ],
                        'data'=>$data
                      ]
                ];
                $send_data=json_encode($send_data);
                $resData[]=self::setHttpRequest($wxopen_template_url.$access_token,$send_data);

            }else{
                $send_data=
                [
                    "touser"         =>$openid,//openid
                    "template_id"=>$template_id, //绑定的公众号创建的模板id
                    "miniprogram"=>[
                      "appid"    =>$wechat['wxapp_app_id'],         //小程序appid
                      "pagepath" =>$wxapp_path                  //跳转至小程序的路径
                    ],
                    'data'=>$data
                ];
                $send_data=json_encode($send_data);
               
                $resData[]=self::setHttpRequest($wxopen_template_url.$access_token,$send_data);
            }
        }
        return $resData;
        
    }
    //发送模板消息加强版
    public function sendWxopenTemplatePro($wechat,$template_id,$openidArr,$wxapp_path,$data,$is_wxapp_openid=false){
        $wxopen_template_url="https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";
        $http_host=$_SERVER['HTTP_HOST'];
        if(strstr($http_host,'192.168.')){
            return false;
        }
        if($is_wxapp_openid){
            $wxopen_template_url="https://api.weixin.qq.com/cgi-bin/message/wxopen/template/uniform_send?access_token=";
            $get_access_token=self::wxapp_access_token($wechat);
            $access_token=$get_access_token['data'];
        }else{
            $get_access_token=self::web_wx_access_token($wechat);
            $access_token=$get_access_token['data'];
        }
        $urls=[];
        
        $url=$wxopen_template_url.$access_token;
        foreach ($openidArr as $openid) {
            if($is_wxapp_openid){
                $params = json_encode( [
                    "touser"         =>$openid,// 小程序openid
                    "mp_template_msg"=>[
                        "appid"      => $wechat['wx_app_id'],         //绑定的公众号appid
                        "template_id"=>$template_id, //绑定的公众号创建的模板id
                        "miniprogram"=>[
                          "appid"    =>$wechat['wxapp_app_id'],         //小程序appid
                          "pagepath" =>$wxapp_path                  //跳转至小程序的路径
                        ],
                        'data'=>$data
                      ]
                ],JSON_UNESCAPED_UNICODE);
            }else{
                $params = json_encode([
                    "touser"         =>$openid,//openid
                    "template_id"=>$template_id, //绑定的公众号创建的模板id
                    "miniprogram"=>[
                      "appid"    =>$wechat['wxapp_app_id'], //小程序appid
                      "pagepath" =>$wxapp_path              //跳转至小程序的路径
                    ],
                    'data'=>$data
                ],JSON_UNESCAPED_UNICODE);
            }
            $urls[]=[
                'url'=>$url,
                'params'=>$params
            ];
        }
        $res=self::multiRequest($urls);
        return $res;
    }
    //ATroom模板消息
    public function atroomMsg($phones='',$data=[],$type=1,$order_no=""){
        $url='https://atroom.youdiy.cn/sass/we_chat/messageTpl';
        $res=self::setHttpRequest($url,json_encode([
            'phones'=>$phones,
            'data'=>json_encode($data,JSON_UNESCAPED_UNICODE),
            'type'=>$type,
            'domain_url'=>request()->domain(),
            'order_no'=>$order_no
        ]));
    }
    //ATroom数据通知模板消息
    public function atroomDataInform($phones='',$data=[]){
        $url='https://atroom.youdiy.cn/sass/we_chat/dataInformTpl';
        $res=self::setHttpRequest($url,json_encode([
            'phones'=>$phones,
            'data'=>json_encode($data,JSON_UNESCAPED_UNICODE),
        ]));
    }
    //发送模板消息加强版-数组版
    public function sendWxopenTemplateProArr($wechat,$template_id,$openidDataArr,$is_wxapp_openid=false){
        $wxopen_template_url="https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";
        $http_host=$_SERVER['HTTP_HOST'];
        if(strstr($http_host,'192.168.')){
            return false;
        }
        if($is_wxapp_openid){
            $wxopen_template_url="https://api.weixin.qq.com/cgi-bin/message/wxopen/template/uniform_send?access_token=";
            $get_access_token=self::wxapp_access_token($wechat);
            $access_token=$get_access_token['data'];
        }else{
            $get_access_token=self::web_wx_access_token($wechat);
            $access_token=$get_access_token['data'];
        }
        $urls=[];
        
        $url=$wxopen_template_url.$access_token;
        foreach ($openidDataArr as $openidData) {
            if($is_wxapp_openid){
                $params = json_encode( [
                    "touser"         =>$openidData['openid'],// 小程序openid
                    "mp_template_msg"=>[
                        "appid"      => $wechat['wx_app_id'],         //绑定的公众号appid
                        "template_id"=>$template_id, //绑定的公众号创建的模板id
                        "miniprogram"=>[
                          "appid"    =>$wechat['wxapp_app_id'],         //小程序appid
                          "pagepath" =>$openidData['wxapp_path']                  //跳转至小程序的路径
                        ],
                        'data'=>$openidData['data']
                      ]
                ],JSON_UNESCAPED_UNICODE);
            }else{
                $params = json_encode([
                    "touser"         =>$openidData['openid'],//openid
                    "template_id"=>$template_id, //绑定的公众号创建的模板id
                    "miniprogram"=>[
                      "appid"    =>$wechat['wxapp_app_id'], //小程序appid
                      "pagepath" =>$openidData['wxapp_path'] //跳转至小程序的路径
                    ],
                    'data'=>$openidData['data']
                ],JSON_UNESCAPED_UNICODE);
            }
            $urls[]=[
                'url'=>$url,
                'params'=>$params
            ];
        }
        $res=self::multiRequest($urls);
        return $res;
    }
    //并发POST请求
    public function multiRequest($urls) {
        $mh = curl_multi_init();
        $urlHandlers = [];
        $urlData = [];
        // 初始化多个请求句柄为一个
        foreach($urls as $value) {
            $ch = curl_init();
            $url = $value['url'];
            $params = $value['params'];
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-type: application/json'));
            curl_setopt($ch, CURLOPT_URL, $url);
            // 设置数据通过字符串返回，而不是直接输出
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $urlHandlers[] = $ch;
            curl_multi_add_handle($mh, $ch);
        }
        $active = null;
        // 检测操作的初始状态是否OK，CURLM_CALL_MULTI_PERFORM为常量值-1
        do {
            // 返回的$active是活跃连接的数量，$mrc是返回值，正常为0，异常为-1
            $mrc = curl_multi_exec($mh, $active);
        } while ($mrc == CURLM_CALL_MULTI_PERFORM);
        // 如果还有活动的请求，同时操作状态OK，CURLM_OK为常量值0
        while ($active && $mrc == CURLM_OK) {
            // 持续查询状态并不利于处理任务，每50ms检查一次，此时释放CPU，降低机器负载
            usleep(50000);
            // 如果批处理句柄OK，重复检查操作状态直至OK。select返回值异常时为-1，正常为1（因为只有1个批处理句柄）
            if (curl_multi_select($mh) != -1) {
                do {
                    $mrc = curl_multi_exec($mh, $active);
                } while ($mrc == CURLM_CALL_MULTI_PERFORM);
            }
        }
        // 获取返回结果
        foreach($urlHandlers as $index => $ch) {
            $urlData[$index] = curl_multi_getcontent($ch);
            // 移除单个curl句柄
            curl_multi_remove_handle($mh, $ch);
        }
        curl_multi_close($mh);
        return $urlData;
    }
     //获取access_token
    public function web_wx_access_token($wx){
      $access_token=Cache::get('web_wx_access_token_acid'.$wx['wx_app_id']);
      if ($access_token) {
        return ['code'=>0,'msg'=>'','data'=>$access_token];
      }
      $url="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$wx['wx_app_id']}&secret={$wx['wx_app_secret']}";
      $res=self::setHttpRequest($url);
      if(isset($res->access_token)){
        Cache::set('web_wx_access_token_acid'.$wx['wx_app_id'],$res->access_token,300);
        return ['code'=>0,'msg'=>'','data'=>$res->access_token];
      }else{
        return ['code'=>$res->errcode,'data'=>'','msg'=>$res->errmsg];
      }
    }
     //获取access_token
    public function wxapp_access_token($wx){
        $access_token=Cache::get('wxapp_access_token_acid'.$wx['wxapp_app_id']);
        if ($access_token) {
          return ['code'=>0,'msg'=>'','data'=>$access_token];
        }
        $url="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$wx['wxapp_app_id']}&secret={$wx['wxapp_app_secret']}";
        $res=self::setHttpRequest($url);
        if(isset($res->access_token)){
          Cache::set('wxapp_access_token_acid'.$wx['wxapp_app_id'],$res->access_token,180);
          return ['code'=>0,'msg'=>'','data'=>$res->access_token];
        }else{
          return ['code'=>$res->errcode,'data'=>'','msg'=>$res->errmsg];
        }
    }
    public function sendSubscibeMsg($wx=[],$data=[]){
        $wxapp=self::wxapp_access_token($wx);
        $access_token=$wxapp['data'];
        $api = 'https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token='. $access_token;
        $data=json_encode($data);
        return self::setHttpRequest($api,$data);
    }
    public  function setHttpRequest($url,$params=array(),$headers='',$method="POST") {
            set_time_limit(0);
            $ci = curl_init();
            curl_setopt($ci, CURLOPT_CONNECTTIMEOUT, 30);
            curl_setopt($ci, CURLOPT_TIMEOUT, 30);
            curl_setopt($ci, CURLOPT_CUSTOMREQUEST, $method);
            curl_setopt($ci, CURLOPT_URL, $url);
            curl_setopt($ci, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ci, CURLOPT_HEADER, FALSE);
            curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, false); // 对认证证书来源的检查
            curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, false); // 从证书中检查SSL加密算法是否存在
            if($headers!=""){
                curl_setopt($ci, CURLOPT_HTTPHEADER, $headers);
            }else {
                curl_setopt($ci, CURLOPT_HTTPHEADER, array('Content-type: application/json'));
            }
            switch (strtoupper($method)){
                case 'POST':
                    curl_setopt($ci, CURLOPT_POST, TRUE);
                    curl_setopt($ci, CURLOPT_POSTFIELDS, $params);
                    break;
                case 'PUT':
                    curl_setopt($ci, CURLOPT_CUSTOMREQUEST, 'PUT');
                    curl_setopt($ci, CURLOPT_POSTFIELDS, $params);
                    break;
                case 'PATCH':
                    curl_setopt($ci, CURLOPT_CUSTOMREQUEST, 'PATCH');
                    curl_setopt($ci, CURLOPT_POSTFIELDS, $params);
                    break;
                case 'DELETE':
                    curl_setopt($ci, CURLOPT_CUSTOMREQUEST, 'DELETE');
                    curl_setopt($ci, CURLOPT_POSTFIELDS, $params);
                    break;
                default:
                    curl_setopt($ci, CURLOPT_HTTPGET, TRUE);
                    break;
            }
            $response = curl_exec($ci);
            $httpCode = curl_getinfo($ci);
            curl_close($ci);
            return json_decode($response);
    }


}
