<?php
namespace counter;
use think\facade\Cache;
/**
* 佳简新零售货柜
*/
class Yunshoukex{

	  //api 接口地址
	  private $apiUrl="http://sales.yunshoukex.com";

	  private $appId="2022102501157";

	  private $appPrivateKey="qianya508do6psses";
	  /*
	  	设备是否在线
		@deviceId  机器编号
	  */
	  public function deviceOnline($deviceId=''){
	  	    $url=$this->apiUrl.'/web/qianya/is_online';
	  	    $data['deviceId']=$deviceId;
	  	    $res=self::httpRequest($url,$data);
	  	    if($res['code']==1){
	  	    	return ['code'=>1,"msg"=>$res['msg']];
	  	    }else{
	  	    	return ['code'=>0,'data'=>['is_online'=>$res['is_online']],"msg"=>$res['msg']];
	  	    }
	  }
	  /*
		设备出货
		deviceId 机器编号
		data:{
			{motoNum:'1'}
			{motoNum:'2'}
		}
		(motoNum:货柜编号)
	  */
	  public function deviceOutGood($deviceId='',$motoNums=''){
	  	    $url=$this->apiUrl.'/web/qianya/out_good';
	  	    $post['deviceId']=$deviceId;
	  	    
	  	    $motoNums=explode(',',$motoNums);
	  	    $data=[];
	  	    foreach($motoNums as $value){
	  	    	$data[]=['motoNum'=>$value];
	  	    }
	  	    $post['data']=$data;
	  	    $res=self::httpRequest($url,$post);
	  	    if($res['code']==1){
	  	    	return ['code'=>1,"msg"=>$res['msg']];
	  	    }else{
	  	    	return ['code'=>0,'data'=>['trade_no'=>$res['trade_no']],"msg"=>$res['msg']];
	  	    }
	  }

	  /*
		流量卡接口
		@deviceId  机器编号
	  */
	  public function deviceMacSim($deviceId=''){
	  	    $url=$this->apiUrl.'/web/qianya/mac_sim';
	  	    $data['deviceId']=$deviceId;
	  	    $res=self::httpRequest($url,$data);
	  	    if($res['code']==1){
	  	    	return ['code'=>1,"msg"=>$res['msg']];
	  	    }else{
	  	    	return ['code'=>0,'data'=>['left_count'=>$res['left_count']],"msg"=>'流量查询'];
	  	    }
	  }
	  /*
		一键开锁全部锁
		@deviceId  机器编号
	  */
	  public function deviceOpenalldoor($deviceId=''){
	  	    $url=$this->apiUrl.'/web/qianya/openalldoor';
	  	    $data['deviceId']=$deviceId;
	  	    $res=self::httpRequest($url,$data);
	  	    if($res['code']==1){
	  	    	return ['code'=>1,"msg"=>$res['msg']];
	  	    }else{
	  	    	return ['code'=>0,'data'=>[],"msg"=>'开锁成功'];
	  	    }
	  }
	  /*
		一键开锁全部锁
		@deviceId  机器编号
	  */
	  public function deviceOpendoor($deviceId='',$motoNum=''){
	  	    $url=$this->apiUrl.'/web/qianya/opendoor';
	  	    $data['deviceId']=$deviceId;
	  	    $data['motoNum']=$motoNum;
	  	    $res=self::httpRequest($url,$data);
	  	    if($res['code']==1){
	  	    	return ['code'=>1,"msg"=>$res['msg']];
	  	    }else{
	  	    	return ['code'=>0,'data'=>[],"msg"=>'开锁成功'];
	  	    }
	  }
	  //url请求
	   public function httpRequest($url="",$request=[],$method="POST"){
	        $curl = curl_init();
	        $header=["Content-Type: application/json","cache-control: no-cache","appId: {$this->appId}","appPrivateKey: {$this->appPrivateKey}"];
	        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);	
	        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	        curl_setopt_array($curl, array(
	          CURLOPT_URL => $url,
	          CURLOPT_RETURNTRANSFER => true,
	          CURLOPT_ENCODING => "",
	          CURLOPT_MAXREDIRS => 10,
	          CURLOPT_TIMEOUT => 30,
	          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	          CURLOPT_CUSTOMREQUEST => $method,
	          CURLOPT_POSTFIELDS => json_encode($request),
	          CURLOPT_HTTPHEADER => $header,
	        ));
	        $response = curl_exec($curl);
	        $err = curl_error($curl);
	        curl_close($curl);
	        if ($err) {
	          return ['code'=>1,'msg'=>"cURL Error #:" . $err];
	        } else {
	          return json_decode($response,1);
	        }
    }

}