<?php
namespace counter;
use think\facade\Cache;
/**
*/
class Ksepton{

	  //api 接口地址
	  private $apiUrl="http://vm.ksepton.com";

	  private $app_key="";

	  private $app_secret="";

	  public function __construct($app_key='',$app_secret='') {
	    if(!$app_key){
	    	die(json_encode(['code'=>1,"msg"=>"app_key不能为空"]));
	    }   
        if(!$app_secret){
	    	die(json_encode(['code'=>1,"msg"=>"app_secret不能为空"]));
	    }
	    $this->app_secret =$app_secret;
	    $this->app_key =$app_key;
      }
	  //获取TOKEN
	  public function getOtherToken(){
	      $token=Cache::get('Ksepton_'.$this->app_key);
	      if($token){
	          return ['code'=>0,'data'=>$token];
	      }
	      $url=$this->apiUrl.'/api/mall/get.other.token?app_secret='.$this->app_secret.'&app_key='.$this->app_key.'&version=2.0';
	      $data[]=[];
  	      $res=self::httpRequest($url,$data);
  	      if($res['code']==1){
  	    	  die(json_encode(['code'=>1,"msg"=>$res['msg']]));
  	      }else{
  	          Cache::set('Ksepton_'.$this->app_key,$res['api_token'],3600);
  	    	  return ['code'=>0,'data'=>$res['api_token']];
  	      }
	  }
	  //设备列表
	  public function queryMachineList(){
	      $token=self::getOtherToken();
	      $api_token=$token['data'];
	      $data['version']='1.0';
	      $data['api_token']=$api_token;
	      $url=$this->apiUrl.'/api/mall/query.machine.list?'.http_build_query($data);
  	      $res=self::httpRequest($url);
  	      if($res['code']==1){
  	    	  die(json_encode(['code'=>1,"msg"=>$res['msg']]));
  	      }else{
  	    	  return ['code'=>0,'data'=>$res['content']];
  	      }
	  }
	  //货道列表
	  public function queryShelfList($machine_id="867975051880537"){
	  	  $token=self::getOtherToken();
	      $api_token=$token['data'];
	      $data['version']='1.0';
	      $data['api_token']=$api_token;
	      $data['machine_id']=$machine_id;
	      $url=$this->apiUrl.'/api/mall/query.shelf.list?'.http_build_query($data);
  	      $res=self::httpRequest($url);
  	      if($res['code']==1){
  	    	  die(json_encode(['code'=>1,"msg"=>$res['msg']]));
  	      }else{
  	    	  return ['code'=>0,'data'=>$res,"msg"=>'出货成功'];
  	      }
	      
	  }
	  //单商品主动出货
	  public function payDelivery($machine_id="867975051880537",$shelf_id="1"){
	      $token=self::getOtherToken();
	      $api_token=$token['data'];
	      $data['version']='1.0';
	      $data['api_token']=$api_token;
	      $data['machine_id']=$machine_id;
	      $data['shelf_id']=$shelf_id;
	      $data['trade_no']=time().rand(1000,9999);
	      $data['pay_price']=1;
	      $data['pay_person_id']=1;
	      $data['notify_url']="https://www.baidu.com";
	      $data['sign_type']="MD5";
	      $data['nonce_str']=md5(time());
	      $data['sign']=self::generateSign($data);
	      $url=$this->apiUrl.'/api/mall/pay.delivery?'.http_build_query($data);
  	      $res=self::httpRequest($url);
  	      if($res['code']==1){
  	    	  die(json_encode(['code'=>1,"msg"=>$res['msg']]));
  	      }else{
  	          $shelf_data[]=[
	      		"index"=>$shelf_id,
	      		"stock"=>"255",
	      		"maxStock"=>"255",
	      	// 	"price"=>"999",
	      	// 	"couponPrice"=>"1"
	      	  ];
  	          $res=self::shelfEditList($machine_id,$shelf_data);
  	    	  return ['code'=>0,'data'=>$res,"msg"=>'出货成功'];
  	      }
	  }
	  public function payMultiDelivery($machine_id="",$multi_pay='1,2'){
	  	  $token=self::getOtherToken();
	      $api_token=$token['data'];
	      $multi_pay_arr=explode(',', $multi_pay);
	      $multi_payarray_all=[];
	      $multi_payarray=[];
	      $shelf_data=[];
	      foreach($multi_pay_arr as $key=>$value){
	      	if(($key+1)%6==0){
	      		$multi_payarray[]=[$value*1=>1];
	      		$multi_payarray_all[]=$multi_payarray;
	      		$multi_payarray=[];
	      	}else{
	      		$multi_payarray[]=[$value*1=>1];
	      	}
	      	$shelf_data[]=[
	      		"index"=>$value,
	      		"stock"=>"255",
	      		"maxStock"=>"255",
	      		//"price"=>"268"
	      	];
	      }
	      $multi_payarray_all=array_merge($multi_payarray_all,[$multi_payarray]);
	      $resArr=[];
	      $trade_no=time().rand(1000,9999);
	      foreach($multi_payarray_all as $item){
	          $data['version']='1.0';
	          $data['api_token']=$api_token;
	          $data['machine_id']=$machine_id;
	      	  $data['multi_pay']=json_encode($item,JSON_UNESCAPED_UNICODE);
		      $data['trade_no']=$trade_no;
		      $data['pay_price']=1;
		      $data['pay_person_id']=1;
		      $data['notify_url']="https://www.baidu.com";
		      $data['sign_type']="MD5";
		      $data['nonce_str']=md5(time().rand(1000,9999));
		      $data['sign']=self::generateSign($data);
		      $url=$this->apiUrl.'/api/mall/pay.multi.delivery?'.http_build_query($data);
	  	      $res=self::httpRequest($url);
	  	      $data=[];
	  	      if($res['code']!=0){
      	    	  die(json_encode(['code'=>1,"msg"=>$res['msg']]));
      	      }
	      }
	      self::shelfEditList($machine_id,$shelf_data);
	      return ['code'=>0,'data'=>[
	      	'trade_no'=>$trade_no
	      ],'msg'=>'出货成功'];
	  }
	  //下发配置(批量)
	  private function shelfEditList($machine_id="867975051880537",$shelf_data=[]){
	  	  $token=self::getOtherToken();
	      $api_token=$token['data'];
	      $data['version']='1.0';
	      $data['api_token']=$api_token;
	      $data['machine_id']=$machine_id;
	      $data['isCoupon']=1;
	      $data['shelf_data']=json_encode($shelf_data,JSON_UNESCAPED_UNICODE);
	      //Index 货道号, stock库存,maxStock容量，price价格, couponPrice 优惠劵
	      //$data['shelf_data']='[{"index":"1","stock":"255","maxStock":"255","price":"268"}]';
	      $url=$this->apiUrl.'/api/mall/shelf.edit.list?'.http_build_query($data);
  	      $res=self::httpRequest($url);
  	      if($res['code']!=0){
  	    	  return ['code'=>1,"msg"=>$res['msg']];
  	      }else{
  	    	  return ['code'=>0,'data'=>$res,"msg"=>'成功'];
  	      }
	  }

      public function generateSign($params) {
		    // 对传入参数按照字段名的Unicode码从小到大排序
		    ksort($params);
		    
		    // 将排序后的参数拼接成url参数串
		    $paramStr = '';
		    foreach ($params as $key => $value) {
		        $paramStr .= $key . '=' . $value . '&';
		    }
		    // 在参数串末尾加上"&key=密钥"
		    $paramStr .= 'key=' . $this->app_secret;
		    // 使用md5算法对参数串进行加密
		    $sign = md5($paramStr);
		    
		    return $sign;
	  }

	  //url请求
	  public function httpRequest($url="",$request=[],$method="POST"){
	        $curl = curl_init();
	        //$header=["Content-Type: application/json","cache-control: no-cache","appId: {$this->appId}","appPrivateKey: {$this->appPrivateKey}"];
	        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);	
	        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	        curl_setopt_array($curl, array(
	          CURLOPT_URL => $url,
	          CURLOPT_RETURNTRANSFER => true,
	          CURLOPT_ENCODING => "",
	          CURLOPT_MAXREDIRS => 10,
	          CURLOPT_TIMEOUT => 30,
	          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	          CURLOPT_CUSTOMREQUEST => $method,
	          CURLOPT_POSTFIELDS => json_encode($request),
	         // CURLOPT_HTTPHEADER => $header,
	        ));
	        $response = curl_exec($curl);
	        $err = curl_error($curl);
	        curl_close($curl);
	        if ($err) {
	          return ['code'=>1,'msg'=>"cURL Error #:" . $err];
	        } else {
	          return json_decode($response,1);
	        }
      }


}