<?php
namespace Douyin;
use think\facade\Cache;
class Live{
	private $api_url="https://open.douyin.com";
	private $client_key="awpwnwctwg6qmyo1";
	private $client_secret="c08ff5e310e188b2d8ae50f11ce3b908";
	public function __construct($config=[]){
			if(isset($config['douyin_client_key'])&&isset($config['douyin_client_secret'])){
				if($config['douyin_client_key']&&$config['douyin_client_secret']){
					$this->client_key=$config['douyin_client_key'];
					$this->client_secret=$config['douyin_client_secret'];
				}	
			}
	}
	public function get_encrypted_data($url=""){
		$realityUrl=self::get_redirect_url_by_header($url);
		$douyinUrl=parse_url($realityUrl);
		if(isset($douyinUrl['query'])){
			parse_str($douyinUrl['query'],$urlData);
			if(isset($urlData['object_id'])){
				$encrypted_data =$urlData['object_id'];
				return $encrypted_data;
			}
		}
		die(json_encode(['code'=>1,'msg'=>"链接错误"],JSON_UNESCAPED_UNICODE));
	}
	public function certificateVerify($poi_id='',$code=''){
		$access_token=$res=self::getAccessToken();
		if(preg_match("/http[s]?:\/\/[\w.]+[\w\/]*[\w.]*\??[\w=&\+\%]*/is",$code)){
			$code=self::get_encrypted_data($code);
			$url=$this->api_url."/goodlife/v1/fulfilment/certificate/prepare?encrypted_data=".$code;
		}else{
			$url=$this->api_url."/goodlife/v1/fulfilment/certificate/prepare?code=".$code;
		}
		
		$res=self::httpRequest($url,'GET',[],[
			"Content-Type: application/json",
			"access-token: {$access_token}"
		]);
		$res_test='
		{"data":{"certificates":[{"amount":{"coupon_pay_amount":990,"original_amount":990,"pay_amount":990},"encrypted_code":"CgwIARDhJxjLLyABKAESLgosRtbsVpR1CVfGP2vaQfLdLmcYXm5NPOFlsRkoYEt+sIDSZqzvPHog3lLJ/3QaAA==","expire_time":1687449599,"sku":{"sku_id":"1763529309449219","sold_start_time":1682007960,"third_sku_id":"","title":"[开业特惠]小包每小时9.9+3茶叶+3样精致茶点（3小时起）","account_id":"7223026305712556087","groupon_type":1,"market_price":13300}}],"verify_token":"30da3e6f-4c77-4b0b-99ff-0ba83020f659","error_code":0,"description":"success"},"extra":{"description":"success","error_code":0,"logid":"202305101037540B706C72B3103640F454","now":1683686274,"sub_description":"","sub_error_code":0}}
		';
		$res=@json_decode($res,true);
		if(isset($res['data'])){
			$data=$res['data'];
			if(isset($data['certificates'])){
				$verify_token=$data['verify_token'];
				$certificates=$data['certificates'];
				$encrypted_codes=[];
				$sku_price=0;
				$pay_amount=0;
				$expire_time=0;
				$sku_title=[];
				foreach($certificates as $value){
					$encrypted_codes[]=$value['encrypted_code'];
					$sku_price+=$value['sku']['market_price']*0.01;
					$sku_title[]=$value['sku']['title'];
					$pay_amount+=$value['amount']['pay_amount']*0.01;
					if($expire_time==0){
						$expire_time=$value['expire_time'];
					}
				}
				$url=$this->api_url."/goodlife/v1/fulfilment/certificate/verify/";
				$resVerify=self::httpRequest($url,'POST',json_encode([
					'verify_token'=>$verify_token,
					'poi_id'=>$poi_id,
					'encrypted_codes'=>$encrypted_codes
				]),[
					"Content-Type: application/json",
					"access-token: {$access_token}"
				]);
				$resVerify=@json_decode($resVerify,true);
				if(isset($resVerify['data']['error_code'])){

					//验券成功
					if($resVerify['data']['error_code']==0){
						return [
							'code'=>0,
							'data'=>[
								'sku_price'=>$sku_price,
								'pay_amount'=>$pay_amount,
								'sku_title'=>$sku_title,
								'expire_time'=>$expire_time,
								'code'=>$code,
								'certificates'=>$certificates
							]
						];
					}
				}
				die(json_encode(['code'=>1,'msg'=>"应用未获商家授权"],JSON_UNESCAPED_UNICODE));
			}else{
				die(json_encode(['code'=>1,'msg'=>$data['description'].'|'.$data['error_code']],JSON_UNESCAPED_UNICODE));
			}
		}else{
			die(json_encode(['code'=>1,'msg'=>"数据请求错误"],JSON_UNESCAPED_UNICODE));
		}
	}
	public function getAccessToken(){
		$url=$this->api_url.'/oauth/client_token/';
		$access_token=Cache::get('douyin'.$this->client_key);
		if($access_token){
			return $access_token;
		}
		$res=self::httpRequest($url,'POST',[
			"client_key"=>$this->client_key,
			'client_secret'=>$this->client_secret,
			'grant_type'=>"client_credential"
		]);
		$res=@json_decode($res,true);
		if(isset($res['data'])){
			if(isset($res['data']['access_token'])){
				$access_token=$res['data']['access_token'];
				Cache::set('douyin'.$this->client_key,$access_token,3600);
				return $access_token;
			}else{
				die(json_encode(['code'=>1,'msg'=>$res['data']['description'].''.$res['data']['error_code']],JSON_UNESCAPED_UNICODE));
			}
		}
		die(json_encode(['code'=>1,'msg'=>"数据请求错误"]));
	}
    public function httpRequest($url, $method = "GET", $postfields = null, $headers = array(), $debug = false){
	    $method = strtoupper($method);
	    $ci = curl_init();
	    /* Curl settings */
	    curl_setopt($ci, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);//版本
	    curl_setopt($ci, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 6.2; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0");//在HTTP请求中包含一个"User-Agent: "头的字符串。
	    curl_setopt($ci, CURLOPT_CONNECTTIMEOUT, 120); /* 在发起连接前等待的时间，如果设置为0，则无限等待 */
	    curl_setopt($ci, CURLOPT_TIMEOUT,120); /* 设置cURL允许执行的最长秒数 */
	    curl_setopt($ci, CURLOPT_RETURNTRANSFER, true);//将curl_exec()获取的信息以文件流的形式返回，而不是直接输出。
	    switch ($method) {
	        case "POST":
	            curl_setopt($ci, CURLOPT_POST, true);//启用时会发送一个常规的POST请求，类型为：application/x-www-form-urlencoded，就像表单提交的一样。
	            if (!empty($postfields)) {
	                $tmpdatastr = is_array($postfields) ? http_build_query($postfields) : $postfields;
	                curl_setopt($ci, CURLOPT_POSTFIELDS, $tmpdatastr);
	            }
	            break;
	        default:
	            curl_setopt($ci, CURLOPT_CUSTOMREQUEST, $method); /* //设置请求方式 */
	            break;
	    }
	    $ssl = preg_match('/^https:\/\//i', $url) ? TRUE : FALSE;
	    curl_setopt($ci, CURLOPT_URL, $url);//需要获取的URL地址，也可以在curl_init()函数中设置
	    if ($ssl) {
	        curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, FALSE); // https请求 不验证证书和hosts
	        curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, FALSE); // 不从证书中检查SSL加密算法是否存在
	    }
	    //curl_setopt($ci, CURLOPT_HEADER, true); /*启用时会将头文件的信息作为数据流输出*/
	    curl_setopt($ci, CURLOPT_FOLLOWLOCATION, 1);
	    curl_setopt($ci, CURLOPT_MAXREDIRS, 2);/*指定最多的HTTP重定向的数量，这个选项是和CURLOPT_FOLLOWLOCATION一起使用的*/
	    curl_setopt($ci, CURLOPT_HTTPHEADER, $headers);
	    curl_setopt($ci, CURLINFO_HEADER_OUT, true);
	    /*curl_setopt($ci, CURLOPT_COOKIE, $Cookiestr); * *COOKIE带过去** */
	    $response = curl_exec($ci);
	    $requestinfo = curl_getinfo($ci);
	    curl_close($ci);
	    return $response;
	}
	protected function get_redirect_url_by_header($url)
	{
	  try {
	  	  $header = @get_headers($url, 1);
		  if (strpos($header[0], '301') !== false || strpos($header[0], '302') !== false) {
		    if (is_array($header['Location'])) {
		      return $header['Location'][count($header['Location']) - 1];
		    } else {
		      return $header['Location'];
		    }
		  } else {
		    return $url;
		  }
	  } catch (Exception $e) {
	  	 return false;
	  }
	  
	}

}