<?php


namespace app\shared\model;

use think\Model as ThinkModel;
use think\facade\Db;
class User extends ThinkModel
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'shared_user';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;

    //所有父亲
    static public function parentAll($user_id=1,$level=1,$field='',$page=0,$is_all=0){
    	if($field){
    		$field=explode(',', $field);
    	}else{
    		$field=['id','parent_id'];
    	}
    	foreach ($field as &$value) {
    		$value='T2.'.$value;
    	}
    	$field=implode(',', $field);
    	if($is_all==1){
    		$search_level="T1.plevel <= {$level}";
    	}else{
    		$search_level="T1.plevel = {$level}";
    	}
    	if($page>0){
    		$page-=1;
    	}
    	$limit=10;
    	$page=$page*$limit;
    	$table=self::getTable();
		$sql3="
		SELECT
			{$field},
			T1.plevel
		FROM
			(
			SELECT
				@r AS _id,
				( SELECT @r := parent_id FROM `{$table}` WHERE id = _id ) AS parent_id,
				@l := @l + 1 AS plevel 
			FROM
				( SELECT @r := {$user_id} ) vars,	-- 查询id为9的所有上级
				( SELECT @l :=- 1 ) plevel,
				{$table} h 
			WHERE
				@r <> - 1 
			) T1
			JOIN {$table} T2 ON T1._id = T2.id 
		WHERE
			T1.plevel > 0 
			AND 
			{$search_level}
		ORDER BY
			id ASC
		LIMIT {$page},{$limit};
		";
		return Db::query($sql3);

    }
    //所有父亲
    static public function parentCount($user_id=1,$level=1,$is_all=0){
    	if($is_all==1){
    		$search_level="T1.plevel <= {$level}";
    	}else{
    		$search_level="T1.plevel = {$level}";
    	}
    	$table=self::getTable();
		$sql3="
		SELECT COUNT(*) AS count FROM
			(
			SELECT
				@r AS _id,
				( SELECT @r := parent_id FROM `{$table}` WHERE id = _id ) AS parent_id,
				@l := @l + 1 AS plevel 
			FROM
				( SELECT @r := {$user_id} ) vars,	-- 查询id为9的所有上级
				( SELECT @l :=- 1 ) plevel,
				{$table} h 
			WHERE
				@r <> - 1 
			) T1
			JOIN {$table} T2 ON T1._id = T2.id 
		WHERE
			T1.plevel > 0 
			AND 
			{$search_level}
		ORDER BY
			id ASC;
		";
		$data=Db::query($sql3);
		if(isset($data[0]['count'])){
			return $data[0]['count'];
		}else{
			return 0;
		}
    }

    //孩子
    static public function childAll($user_id=1,$level=1,$field='',$page=0,$is_all=0){
    	if($field){
    		$field=explode(',', $field);
    	}else{
    		$field=['id','parent_id'];
    	}
    	foreach ($field as &$value) {
    		$value='T2.'.$value;
    	}
    	$field=implode(',', $field);
    	if($is_all==1){
    		$search_level="T1.clevel <= {$level}";
    	}else{
    		$search_level="T1.clevel = {$level}";
    	}
    	if($page>0){
    		$page-=1;
    	}
    	$limit=10;
    	$page=$page*$limit;
    	$table=self::getTable();
		$sql3="
		SELECT
			{$field},
			T1.clevel 
		FROM
			(
			SELECT
				@r AS _pid,
				(
				SELECT
					@r := group_concat( id ) 
				FROM
					`{$table}` 
				WHERE
				FIND_IN_SET( parent_id, _pid )) AS cid,
				@l := @l + 1 AS clevel 
			FROM
				( SELECT @r := {$user_id} ) vars,-- 查询id为4的所有子节点
				( SELECT @l := 0 ) clevel,
				{$table} h 
			WHERE
				@r IS NOT NULL 
			) T1
			INNER JOIN {$table} T2 ON FIND_IN_SET( T2.parent_id, T1._pid ) 
		WHERE
			{$search_level}
		ORDER BY
			id DESC
		LIMIT {$page},{$limit};	
		";
		return Db::query($sql3);
    }
    //孩子
    static public function childCount($user_id=1,$level=1,$is_all=0){
    	if($is_all==1){
    		$search_level="T1.clevel <= {$level}";
    	}else{
    		$search_level="T1.clevel = {$level}";
    	}
    	$table=self::getTable();
		$sql3="
		SELECT COUNT(*) AS count FROM
			(
			SELECT
				@r AS _pid,
				(
				SELECT
					@r := group_concat( id ) 
				FROM
					`{$table}` 
				WHERE
				FIND_IN_SET( parent_id, _pid )) AS cid,
				@l := @l + 1 AS clevel 
			FROM
				( SELECT @r := {$user_id} ) vars,-- 查询id为4的所有子节点
				( SELECT @l := 0 ) clevel,
				{$table} h 
			WHERE
				@r IS NOT NULL 
			) T1
			INNER JOIN {$table} T2 ON FIND_IN_SET( T2.parent_id, T1._pid ) 
		WHERE
			{$search_level}
		ORDER BY
			id ASC;
		";
		$data=Db::query($sql3);
		if(isset($data[0]['count'])){
			return $data[0]['count'];
		}else{
			return 0;
		}
    }
    //直属
    public static function shareOne($uid){
        return User::where('parent_id',$uid)->column('id');
    }
    //间接
    public static function shareTwo($uid_one){
        if(!count($uid_one)) return [];
        return User::where('parent_id','>',0)->whereIn('parent_id',$uid_one)->column('id');
    }
}