<?php


namespace app\shared\model;
use app\shared\model\StoreCouponUser;
use think\Model as ThinkModel;
//商家优惠券
class StoreCoupon extends ThinkModel
{
    //茶室预订
    const TYPE_HOTEL=1;
    //茶艺师
    const TYPE_TEASPECIALIST=2;
    //茶室预订
    const TYPE_GOODS=3;
    //优惠券核销物品
    const TYPE_VERIFIER=4;
    //优惠券货柜
    const TYPE_HUOGUI=5;

    //新人注册
    const SEND_TYPE_NEW=1;
    //转发
    const SEND_TYPE_FORWARD=2;
    //领券中心
    const SEND_TYPE_RECEIVE=3;

    //下单订单
    const SEND_TYPE_ORDER_PRICE=4;
    // 设置当前模型对应的完整数据表名称
    protected $name = 'shared_store_coupon';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;

    //给用户发放优惠券
    static public function giveUserCoupon($user_id=-1,$send_type=1,$acid=1,$ids=-1){
    	if($user_id==-1){
    		return false;
    	}
    	//type 1新人注册 2转发,3领券中心,4下单支付，5后台发放
        if($ids!=-1){
            if(empty($ids)){
                return false;
            }
            $ids=explode(',',$ids);
            $list=self::where(['acid'=>$acid,'status'=>1,'is_delete'=>0])->where('id','in',$ids)->select()->toArray();
            $giveIds=explode(',',$ids);
            $couponData=[];
            foreach($list as $couponVal){
                $couponData[$couponVal['id']]=$couponVal;
            }
            $dataList=[];
            foreach($giveIds as $couponId){
                if(isset($couponData[$couponId])){
                    $dataList[]=$couponData[$couponId];
                }
            }
            $list=$dataList;
        }else{
            $list=self::where(['acid'=>$acid,'send_type'=>$send_type,'status'=>1,'is_delete'=>0])->select()->toArray();
        }
        $couponNum=0;
		foreach ($list as $key => $value) {
            if($send_type==4||$send_type==5){
                if($value['type']==4){
                    //优惠券核销物品
                    $isCoupon=StoreCouponUser::where([
                        'acid'=>$acid,
                        'user_id'=>$user_id,
                        'coupon_id'=>$value['id'],
                        'store_id'=>$value['store_id'],
                        'type'=>$value['type'],
                    ])->whereDay('create_time')->count();
                    if(!$isCoupon){
                        $form=new StoreCouponUser();
                        $form->acid=$acid;
                        $form->save([
                            'user_id'=>$user_id,
                            'coupon_id'=>$value['id'],
                            'store_id'=>$value['store_id'],
                            'type'=>$value['type'],
                        ]);
                        $couponNum++;
                    }
                }else{
                    $form=new StoreCouponUser();
                    $form->acid=$acid;
                    $form->save([
                        'user_id'=>$user_id,
                        'coupon_id'=>$value['id'],
                        'store_id'=>$value['store_id'],
                        'type'=>$value['type'],
                    ]);
                    $couponNum++;
                }
                
            }else{
                $form=StoreCouponUser::where(['user_id'=>$user_id,'coupon_id'=>$value['id']])->find();
                if(!$form){
                    $form=new StoreCouponUser();
                    $form->acid=$acid;
                }
                $form->save([
                    'user_id'=>$user_id,
                    'coupon_id'=>$value['id'],
                    'store_id'=>$value['store_id'],
                    'type'=>$value['type'],
                ]);
                $couponNum++;
            }
            
		}
        if($couponNum){
            return true;
        }
		return false;
    }
}