<?php


namespace app\shared\model;

use think\Model as ThinkModel;

class Option extends ThinkModel
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'shared_option';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    
    static public function set_data($acid=null,$module=null,$name=null,$value=[],$cache=0){
    	$form=self::where(['acid'=>$acid,'module'=>$module,'name'=>$name])->find();
    	if($form){
            if($cache){
                self::where(['acid'=>$acid,'module'=>$module,'name'=>$name])->cache('value')->update(['value'=>json_encode($value)]);
            }else{
                $form->save(['value'=>json_encode($value)]);
            }
    	}else{
    		(new self)->save([
    			'acid'=>$acid,
    			'module'=>$module,
    			'name'=>$name,
    			'value'=>json_encode($value),
    		]);
    	}
    	return true;
    }
    static public function get_data($acid=null,$module=null,$name=null,$cache=0){
        if($cache){
            $value=self::where(['acid'=>$acid,'module'=>$module,'name'=>$name])->cache($cache)->value('value');
        }else{
            $value=self::where(['acid'=>$acid,'module'=>$module,'name'=>$name])->value('value');
        }
    	
    	return json_decode($value,1);
    }
    static public function get_multi_data($acid=null,$multi=[],$cache=0){
        if($cache){
            $list=self::where(['acid'=>$acid])->where('name','in',$multi)->cache($cache)->column('name,value');
        }else{
            $list=self::where(['acid'=>$acid,])->where('name','in',$multi)->column('name,value');
        }
        $data=[];
        foreach($list as $value){
            $data[$value['name']]=@json_decode($value['value'],1);
        }
        $dataAll=[];
        foreach($multi as $v){
            $dataAll[$v]=isset($data[$v])?$data[$v]:'';
        }   
        return $dataAll;
    }
}