<?php


namespace app\shared\model;

use think\Model as ThinkModel;
use app\shared\model\User;
use think\facade\Db;
//消息通知
class Message extends ThinkModel
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'shared_message';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;

    const messagesApi="http://qy-push.youdiy.cn/api/";
    //订单类型
    const TYPE_SYSTEM=1;//系统消息

    const TYPE_HOUSE=2;//茶室消息

    const TYPE_GOODS=3;//商品消息

    const TYPE_MEMBER=4;//会员消息
    
    //账户类型平台
    const ACCOUNT_TYPE_PLATFORM=1;
     //账户类型商户
    const ACCOUNT_TYPE_STORE=2;
     //账户类型用户
    const ACCOUNT_TYPE_USER=3;
    //茶艺师
    const ACCOUNT_TYPE_TEASPECIALIST=4;
    //推送个人消息
    static public function pushMsg($acid='',$account_type="",$type="",$form_id="",$user_id="",$title="",$content="",$images="",$details=""){
        if($acid){
            $url=Message::messagesApi.'sendToClient';
            $client_id=User::where('id',$user_id)->value('client_id');
            $form=new Message();
            $form->save([
                'acid'=>$acid,
                'account_type'=>$account_type,
                'type'=>$type,
                'form_id'=>$form_id,
                'user_id'=>$user_id,
                'title'=>$title,
                'images'=>$images,
                'content'=>$content,
                'details'=>$details,
            ]);
            if($client_id){
                $res=httpRequest($url,"POST",[
                    'client_id'=>$client_id,
                    'message'=>(json_encode([
                        'type'=>$type,
                        'title'=>$title,
                        'form_id'=>$form_id
                    ],JSON_UNESCAPED_UNICODE))
                ]);
            }
            return true;
        }
        return false;
    }
    //推送多个人消息
    static public function pushGroupMsg($acid='',$account_type="",$type="",$form_id="",$user_ids="",$title="",$content="",$images="",$details=""){
        if($acid){
            if($user_ids=="-1"){
                $url=Message::messagesApi.'sendToGroup';
                $domain=request()->domain();
                $domain=str_replace('http://','',$domain);
                $domain=str_replace('https://','',$domain);
                $group=base64_encode(json_encode(['domain'=>$domain,'acid'=>"{$acid}"]));
                $res=httpRequest($url,"POST",[
                    'group'=>$group,
                    'message'=>(json_encode([
                        'type'=>$type,
                        'title'=>$title,
                        'form_id'=>$form_id
                    ],JSON_UNESCAPED_UNICODE))
                ]);
                $userCount=User::where('acid',$acid)->count();
                $limit=10000;
                $page=ceil($userCount/$limit);
                set_time_limit(0);
                // 启动事务
                Db::startTrans();
                try {
                    for($pi=1;$pi<=$page;$pi++){
                        $userList=User::where('acid',$acid)->page($pi)->limit($limit)->column('id,client_id');
                        $install=[];
                        foreach($userList as $user){
                            $install[]=[
                                'acid'=>$acid,
                                'account_type'=>$account_type,
                                'type'=>$type,
                                'form_id'=>$form_id,
                                'user_id'=>$user['id'],
                                'title'=>$title,
                                'images'=>$images,
                                'content'=>$content,
                                'details'=>$details,
                            ];
                        }
                        $form=new Message();
                        $form->limit(1000)->insertAll($install);
                    }
                    // 提交事务
                    Db::commit();
                } catch (\Exception $e) {
                    // 回滚事务
                    Db::rollback();
                }
            }else{
                $url=Message::messagesApi.'sendToClient';
                $userList=User::where('id','in',$user_ids)->column('id,client_id');
                $install=[];
                foreach($userList as $user){
                    $install[]=[
                        'acid'=>$acid,
                        'account_type'=>$account_type,
                        'type'=>$type,
                        'form_id'=>$form_id,
                        'user_id'=>$user['id'],
                        'title'=>$title,
                        'images'=>$images,
                        'content'=>$content,
                        'details'=>$details,
                    ];
                    if($user_ids!="-1"){
                        httpRequest($url,"POST",[
                            'client_id'=>$user['client_id'],
                            'message'=>(json_encode([
                                'type'=>$type,
                                'title'=>$title,
                                'form_id'=>$form_id
                            ],JSON_UNESCAPED_UNICODE))
                        ]);
                    }
                }
                $form=new Message();
                $form->saveAll($install);
            }
            return true;
        }
        return false;
    }
}