<?php
namespace app\shared\logic\user;
use app\shared\model\TeaCircle;
use app\shared\model\TeaCircleComment;
use app\shared\model\TeaCircleType;
use app\shared\model\User;
use app\shared\model\Collection;
use think\exception\ValidateException;
use app\BaseController;
//茶圈管理
class TeaCircleForm extends  UserForm
{
	public function index(){
		$query=TeaCircle::alias('t_c')
		->leftJoin([User::getTable()=>'u'],'t_c.user_id=u.id')
		->where(['t_c.acid'=>$this->acid,'t_c.is_delete'=>0,'t_c.status'=>1]);
		$list=$query->limit($this->limit)->page($this->page)->field('t_c.title,t_c.images cover,t_c.id,u.avatar_url,u.nickname,t_c.likeNum')->order('id DESC')->select();
		foreach ($list as $key => &$value) {
			$value['cover']=get_file_url($value['cover']);
		}
	    return fetchJson($list);
	}
	//详细
	public function detail(){
		$info=TeaCircle::alias('t_c')
			->leftJoin([User::getTable()=>'u'],'t_c.user_id=u.id')
			->where(['t_c.acid'=>$this->acid,'t_c.is_delete'=>0,'t_c.status'=>1,'t_c.id'=>input('id')])
			->field('t_c.*,u.nickname,u.avatar_url')
			->find();
		if(!$info){
			return fetchJson([],'暂无数据',1);
		}
		$commentList=TeaCircleComment::alias('c')
		->leftJoin([User::getTable()=>'u'],'c.user_id=u.id')->where(['c.tea_circle_id'=>$info['id'],'c.status'=>1,'c.is_delete'=>0])->order('c.id DESC')->field('c.id,u.nickname,u.avatar_url,c.content,c.parent_id,c.create_time,c.user_id')->select()->toArray();
		$info['comment_list']=generateTree($commentList,'parent_id');	
	    $info['images']=get_file_urls($info['images']);
	    $info['pv']+=1;
	    //点赞
	    $info['is_like']=Collection::where(['acid'=>$this->acid,'is_delete'=>0,'form_id'=>$info['id'],'type'=>Collection::TYPE_CQDZ,'user_id'=>$this->user_id])->count();
	    $info['is_like']=$info['is_like']==1?1:0;
	    $info['likeNum']=Collection::where(['acid'=>$this->acid,'is_delete'=>0,'form_id'=>$info['id'],'type'=>Collection::TYPE_CQDZ])->count();
	    //收藏
	    $info['is_collection']=Collection::where(['acid'=>$this->acid,'is_delete'=>0,'form_id'=>$info['id'],'type'=>Collection::TYPE_CQSC,'user_id'=>$this->user_id])->count();
	    $info['is_collection']=$info['is_collection']==1?1:0;
	    $info['collectionNum']=Collection::where(['acid'=>$this->acid,'is_delete'=>0,'form_id'=>$info['id'],'type'=>Collection::TYPE_CQSC])->count();
	    TeaCircle::where('id',$info['id'])->update(['likenum'=>$info['likeNum'],'pv'=>$info['pv']]);
		return fetchJson($info);
	}
	//我的列表
	public function myList(){
		$query=TeaCircle::alias('t_c')
		->leftJoin([TeaCircleType::getTable()=>'t'],'t_c.type_id=t.id')
		->where(['t_c.acid'=>$this->acid,'t_c.is_delete'=>0,'t_c.user_id'=>$this->user_id]);
		$list=$query->limit($this->limit)->page($this->page)->field('t_c.*,t.title type_title')->select();
		foreach ($list as $key => &$value) {
			$value['cover']=get_file_url($value['images']);
			$value['images']=get_file_urls($value['images']);
		}
	    return fetchJson($list);
	}
	//编辑
	public function edit(){
		try {
          $data=request()->post();
          $rule = [
               'id|ID' => 'require',
               'title|标题'=>'require',
               'type_id|类型ID'=>'require',
               'content|内容'=>'require',
               'images|图片'=>'require',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $form=TeaCircle::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'id'=>$data['id']])->find();
       if(!$form){
       	  $form=new TeaCircle();
       	  $form->acid=$this->acid;
       	  $form->user_id=$this->user_id;
       	  $form->status=1;
       }
       $form->save([
       	 'title'=>$data['title'],
       	 'content'=>$data['content'],
       	 'images'=>$data['images'],
       	 'type_id'=>$data['type_id'],
       	 'tags'=>input('tags'),
       ]);
       return fetchJson([],'保存成功');
	}
	public function typeList(){
		$list=TeaCircleType::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->order('sort DESC')->column('id,title');
		return fetchJson($list);
	}
	public function delete(){
		TeaCircle::where(['acid'=>$this->acid,'id'=>input('id'),'user_id'=>$this->user_id])->update(['is_delete'=>1]);
        return fetchJson([],'删除成功');
	}
	//评论编辑
	public function commentEdit(){
		try {
          $data=request()->post();
          $rule = [
               'id|ID' => 'require|number',
               'parent_id|父级ID'=>'require|number',
               'tea_circle_id|茶圈ID'=>'require',
               'content|内容'=>'require',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $form=TeaCircleComment::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'id'=>$data['id']])->find();
       if(!$form){
       	  $form=new TeaCircleComment();
       	  $form->acid=$this->acid;
       	  $form->user_id=$this->user_id;
       	  $form->status=1;
       }
       $form->save([
       	 'parent_id'=>$data['parent_id'],
       	 'content'=>$data['content'],
       	 'tea_circle_id'=>$data['tea_circle_id'],
       ]);
       return fetchJson([],'保存成功');
	}
	//评论删除
	public function commentDel(){
		TeaCircleComment::where(['acid'=>$this->acid,'id'=>input('id'),'user_id'=>$this->user_id])->update(['is_delete'=>1]);
        return fetchJson([],'删除成功');
	}

}