<?php
namespace app\shared\logic\user;
use app\shared\model\Store;
use app\shared\model\User;
use app\shared\model\App;
use app\shared\model\SubscribeBall;
use app\shared\model\SubscribeBallOrder;

use think\exception\ValidateException;
use app\BaseController;
use wechatpay\WechatPay;
//约球管理
class SubscribeBallForm extends  UserForm
{	
    public function list(){
        $lat=input('lat');
        $lng=input('lng');
        if(!is_numeric($lat)){
            $lat=0;
        }
        if(!is_numeric($lng)){
            $lng=0;
        }
        $query=SubscribeBall::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($area_id=input('area_id')   ){
            $query->where(['area_id'=>$area_id]);
        }
        if($keyword=input('keyword')   ){
            $query->where('name',"like","%{$keyword}%");
        }
    	$list=$query->where('status','in','1,2')
        ->field('*,(6378.138 * 2 * asin(sqrt(pow(sin((lat * pi() / 180 - ' . $lat . ' * pi() / 180) / 2),2) + cos(lat * pi() / 180) * cos(' . $lat . ' * pi() / 180) * pow(sin((lng * pi() / 180 - ' . $lng . ' * pi() / 180) / 2),2))) * 1000) as distance')
        ->order('distance ASC')
        ->page($this->page)
        ->order('id DESC')
        ->select();
        $userArr=[];
        foreach($list as &$value){
            $distance = $value['distance'] / 1000;
            $value['distance'] = round($distance,2).'km';
            $userArr[]=$value['user_id'];
            if($value['invitation_user_id']){
                $userArr[]=$value['invitation_user_id'];
            }
        }
        $userList=User::where('id','in',$userArr)->column('id,nickname,avatar_url');
        $nicknameArr=array_column($userList,'nickname','id');
        $avatarArr=array_column($userList,'avatar_url','id');
        foreach($list as &$value){
            $value['nickname']=$nicknameArr[$value['user_id']];
            $value['avatar_url']=$avatarArr[$value['user_id']];
            $value['invitation_nickname']=isset($nicknameArr[$value['invitation_user_id']])?$nicknameArr[$value['invitation_user_id']]:0;
            $value['invitation_avatar_url']=isset($avatarArr[$value['invitation_user_id']])?$avatarArr[$value['invitation_user_id']]:0;
        }
    	return fetchJson($list,$avatarArr);
    }
    //详情
    public function details(){
        $id=input('id');
        $lat=input('lat');
        $lng=input('lng');
        if(!is_numeric($lat)){
            $lat=0;
        }
        if(!is_numeric($lng)){
            $lng=0;
        }
        $form=SubscribeBall::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$id])
        ->field('*,(6378.138 * 2 * asin(sqrt(pow(sin((lat * pi() / 180 - ' . $lat . ' * pi() / 180) / 2),2) + cos(lat * pi() / 180) * cos(' . $lat . ' * pi() / 180) * pow(sin((lng * pi() / 180 - ' . $lng . ' * pi() / 180) / 2),2))) * 1000) as distance')
        ->find();
        $userArr=[];
        $distance = $form['distance'] / 1000;
        $form['distance'] = round($distance,2).'km';
        $userArr[]=$form['user_id'];
        if($form['invitation_user_id']){
            $userArr[]=$form['invitation_user_id'];
        }
        $userList=User::where('id','in',$userArr)->column('id,nickname,avatar_url');
        $nicknameArr=array_column($userList,'nickname','id');
        $avatarArr=array_column($userList,'avatar_url','id');
        $form['nickname']=$nicknameArr[$form['user_id']];
        $form['avatar_url']=$avatarArr[$form['user_id']];
        $form['invitation_nickname']=isset($nicknameArr[$form['invitation_user_id']])?$nicknameArr[$form['invitation_user_id']]:0;
        $form['invitation_avatar_url']=isset($avatarArr[$form['invitation_user_id']])?$avatarArr[$form['invitation_user_id']]:0;
        return fetchJson($form);
    }   
    //我的约球
    public function myList(){
        $status=input('status');
        $query=SubscribeBall::where(['acid'=>$this->acid,'is_delete'=>0,'user_id'=>$this->user_id]);
        if($status>-1){
            $query->where(['status'=>$status]);
        }
        $list=$query->page($this->page)
        ->limit(10)
        ->order('id DESC')
        ->select();
        $userArr=[];
        foreach($list as &$value){
            $userArr[]=$value['user_id'];
            if($value['invitation_user_id']){
                $userArr[]=$value['invitation_user_id'];
            }
        }
        $userList=User::where('id','in',$userArr)->column('id,nickname,avatar_url');
        $nicknameArr=array_column($userList,'nickname','id');
        $avatarArr=array_column($userList,'avatar_url','id');
        foreach($list as &$value){
            $value['nickname']=$nicknameArr[$value['user_id']];
            $value['avatar_url']=$avatarArr[$value['user_id']];
            $value['invitation_nickname']=isset($nicknameArr[$value['invitation_user_id']])?$nicknameArr[$value['invitation_user_id']]:0;
            $value['invitation_avatar_url']=isset($avatarArr[$value['invitation_user_id']])?$avatarArr[$value['invitation_user_id']]:0;
        }
        return fetchJson($list);
    }
    //发布
    public function publish(){
        try {
          $data=request()->post();
          $rule = [
              'id|ID' => 'require',
              'area_id|城市ID'=>'require',
              'store_id|商户ID'=>'require',
              'type|类型'=>'require',
              'grade|段位等级'=>'require',
              'start_time|开台时间'=>'require',
          ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=SubscribeBall::where(['acid'=>$this->acid,'is_delete'=>0,'user_id'=>$this->user_id,'id'=>$data['id'],'status'=>0])->find();
        if(!$form){
            $form=new SubscribeBall();
            $form->acid=$this->acid;
            $form->user_id=$this->user_id;
        }
        $form->area_id=$data['area_id'];
        $form->store_id=$data['store_id'];
        $form->type=$data['type'];
        $form->grade=$data['grade'];
        $form->start_time=$data['start_time'];
        $form->remark=input('remark');
        $store=Store::where('id',$data['store_id'])->field('id,name,address,lat,lng')->find();
        $form->address=$store['address'];
        $form->name=$store['name'];
        $form->lat=$store['lat'];
        $form->lng=$store['lng'];
        $form->save();
        return fetchJson($form);
    }
    //提交订单
    public function submitOrder(){
        try {
          $data=request()->post();
          $rule = [
              'id|发球Id' => 'require',
          ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       if(!SubscribeBall::where(['id'=>$data['id']])->where('status','in','0,1')->count()){
            return fetchJson([],'约球已结束',1);
       }
       $pay_price=5;
       $order=new SubscribeBallOrder();
       $order->order_no=SubscribeBallOrder::crateOrderNo();
       $order->acid=$this->acid;
       $order->user_id=$this->user_id;
       $order->subscribe_ball_id=$data['id'];
       $order->pay_price=$pay_price;
       $pay_type=input('pay_type')?input('pay_type'):1;
       $order->pay_type=$pay_type;
       $order->save();
       if($pay_type==2){
            return self::balancePayment($order);
       }
       if($pay_price==0){
            return self::balancePayment($order);
       }
       $app=App::find($this->acid);
       $appid=$app->wxapp_app_id;
       $app_secret=$app->wxapp_app_secret;
       $openid=$this->user->wxapp_open_id;
       $wx_config=[
            'appid'=>$appid,
            'appsecret'=>$app_secret,
            'mchid'=>$app->wx_mch_id,
            'key'=>$app->wx_key,
            'sslcert'=>$app->wx_cert_pem,
            'sslkey'=>$app->wx_key_pem,
       ];
       $wechatPay=new WechatPay($wx_config);
       $notify_url=request()->domain().str_replace('index.php', 'pay_shared.php',request()->baseFile());
       $paydata = [
            'body' =>'参与约球',
            'out_trade_no' => $order->order_no,
            'total_fee' => round($order->pay_price,2)* 100,
            'notify_url' =>$notify_url ,
            'trade_type' => 'JSAPI',
            'openid' => $openid,
        ];
       $res=$wechatPay->pay($paydata);
       $res['order_id']=$order->id;
       return fetchJson($res);
    }
    //余额支付
    private function balancePayment($order=[]){
         $user=User::where('id',$order['user_id'])->find();
         if($user->money<$order->pay_price){
            return fetchJson([],'余额不足',1);
         }
         $form=new \app\shared\logic\pay\SubscribeBallOrderForm();
         $res=$form->saveOrder($order->order_no);
         if($res=='success'){
            return fetchJson([],'支付成功');
         }
         return fetchJson([],'余额支付错误',1);
    }

}