<?php

namespace app\shared\logic\user;
use app\shared\model\User;
use app\shared\model\Store;
use app\shared\model\ApplyBecomeStore;
use app\shared\model\House;
use app\shared\model\HouseRoom;
use app\shared\model\HouseRoomStock;
use app\shared\model\HouseStockOem;
use app\shared\model\Option;
use app\shared\model\App;
use app\shared\model\District;
use app\shared\model\Area;
use app\shared\model\Tags;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\GoodsOrder;
use app\shared\model\Category;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\Facility;
use app\shared\model\HouseStock;
use app\shared\model\StoreCoupon;
use app\shared\model\StoreCouponUser;
use think\exception\ValidateException;
use app\shared\model\StoreRechargeOrder;
use app\shared\model\StoreRecharge;
use app\shared\model\Recharge;
use app\shared\model\Coupon;
use app\shared\model\StoreUserMoney;
use app\shared\model\Conversion;
use app\shared\model\Bill;
use app\shared\model\Counter;
use think\facade\Cache;
use app\BaseController;
use wechatpay\WechatPay;
use app\plugin\model\usercashgrade\Usercashgrade;
//用户商户信息OEM版本
class StoreOemForm extends Base
{
    //分类列表
    public function categoryList()
    {
        $list = Category::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1])->order('sort ASC')->cache(30)->column('id,name,cover,sort,type');
        foreach ($list as $key => &$value) {
            $value['cover_url'] = get_file_url($value['cover']);
        }
        return fetchJson($list);
    }
    //二维码
    public function qrcode()
    {
        $app = App::where('id', $this->acid)->cache(10)->find();
        $store_id = input('id');
        $wxappPath = 'aboutTea/teaStoreDetail?id=' . $store_id;
        $url = qrcodeUrl($this->acid, $wxappPath, $dirname = "store", $filename = $store_id);
        return fetchJson(['qrcode_url' => $url]);
    }
    //简单list
    public function smallList(){
        $area_id=input('area_id');
        $storeList = Store::where(['acid' => $this->acid,'is_delete'=>0,'status'=>1,'area_id'=>$area_id])->field('id,name')->select();
        return fetchJson($storeList);
    }
    //包间列表
    public function houseList()
    {
        $store_id = input('store_id');
        $dateTime = input('date') ? strtotime(input('date')) : strtotime(date('Y-m-d'));
        $store = Store::where(['id' => $store_id])
        ->withoutField('account,password,access_token,store_manager,shop_banner,sort,wx_mch_id,wx_key,wx_sslcert,wx_sslkey,wx_sub_config,douyin_config,meituan_config,smart_device,lvmi_developer,lvmi_device,counter_config,printer1_config,printer2_config,book_interval_status,advanced_clean,is_repeat_order_original,video_url,create_time,update_time')
        ->find();
        $business_hours = $store['business_hours'];
        $business_hours = json_decode($business_hours, 1);
        $is_bus_time = 0;
        $bus_start = 0;
        $bus_end = 0;
        $is_antitone = 0;
        //是否反序
        if (isset($business_hours['start_time']) && isset($business_hours['end_time'])) {
            $bus_start = date('Y-m-d ', $dateTime) . $business_hours['start_time'];
            $bus_end = date('Y-m-d ', $dateTime) . $business_hours['end_time'];
            if ($bus_end != $bus_start) {
                $is_bus_time = 1;
                if (strtotime($bus_end) < strtotime($bus_start)) {
                    $is_antitone = 1;
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                } else {
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                }
            }
        }
        $query = House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $store_id, 'status' => 1]);
        if ($house_id = input('house_id')) {
            $query->where('id', $house_id);
        }
        $house_ids1 = HouseOrder::where(['acid' => $this->acid, 'store_id' => $store_id])->where('status', 'in', '1,2')->where('start_time', '<', time())->where('end_time', '>', time())->group('house_id')->column('house_id');
        $house_ids2 = HouseOrderContinue::where(['acid' => $this->acid, 'store_id' => $store_id])->where('status', 'in', '1,2')->where('start_time', '<', time())->where('end_time', '>', time())->group('house_id')->column('house_id');
        if($house_ids2){
             $house_ids=array_merge($house_ids1,$house_ids2);
        }else{
             $house_ids=$house_ids1;
        }
        if ($house_ids) {
            $house_ids = implode(',', $house_ids);
            $query->orderRaw('field(id,' . $house_ids . ') ASC,sort ASC');
        } else {
            $query->order('sort ASC');
        }
        $discount = Card::where(['acid' => $this->acid, 'is_delete' => 0])->order('discount ASC')->value('discount');
        $list = $query->withoutField('lvelectricty_line_config,electricty_line_config,servicing_time,could_sound,electricityid')->cache(30)->page($this->page)->limit(10)->select()->toArray();
        $cover_ids = [];
        $house_id_arr = [];

        foreach ($list as $key => &$value) {
            $banner = explode(',', $value['banner']);
            $cover_ids = array_merge($cover_ids, $banner);
            $house_id_arr[] = $value['id'];
            if (!$discount) {
                $value['member_price'] = -1;
            } else {
                if ($value['member_price'] <= 0) {
                    $value['member_price'] = $value['price'] * $discount * 0.1;
                    $value['member_price'] = round($value['member_price'], 2);
                }
            }
            $value['discount'] = $discount;
        }
        $get_cache_file_urls = get_cache_file_urls($cover_ids);
        $todayRoomTime=strtotime(date('Y-m-d'))+86400;
        foreach ($list as $key => &$value) {
            $banner = explode(',', $value['banner']);
            foreach ($banner as $k => $v) {
                $banner[$k] = isset($get_cache_file_urls[$v]) ? $get_cache_file_urls[$v] : '';
            }
            $value['banner_list'] = $banner;
            //今天
            $stockToday = HouseStock::where(['acid' => $value['acid'], 'store_id' => $value['store_id'], 'house_id' => $value['id'], 'date' => $dateTime, 'status' => 0])->order('hour ASC')->column('hour,status,order_id');
            $tomorrowtime = $dateTime + 86400;
            $stockTomorrow = HouseStock::where(['acid' => $value['acid'], 'store_id' => $value['store_id'], 'house_id' =>$value['id'], 'date' => $tomorrowtime, 'status' => 0])->column('hour,status,order_id');
            $allstock = array_merge($stockToday, $stockTomorrow);

            $allstock = array_column($allstock, 'status', 'hour');
            //预定数量
            $value['booknum'] = isset($houseOrderCountArr[$value['id']]) ? $houseOrderCountArr[$value['id']] : 0;
            $virtual_sales = isset($value['virtual_sales']) ? $value['virtual_sales'] : 0;
            $value['booknum'] += $virtual_sales;
            $price_list = json_decode($value['price_list'], 1);
            if ($price_list) {
                $priceData = array_column($price_list, 'price', 'time');
            }
            $value['package_price']=json_decode($value['package_price'],true);
            unset($value['package_price']);
            $value['facility_servicing_list'] = Facility::where('id', 'in', $value['facility_servicing'])->column('id,title');
            $value['room_status_data']=self::roomStatusData($store,$value);
            $value['oem_servicing_time']=self::oemServicingTime($value);
        }
        return fetchJson($list);
    }
    //商家详情
    public function info()
    {
        $lat = input('lat') ? input('lat') : 0;
        $lng = input('lng') ? input('lng') : 0;
        if ($lng == 'undefined') {
            $lng = 0;
        }
        if ($lat == 'undefined') {
            $lat = 0;
        }
        $store_id = input('id');
        if(input('is_alliance')==1){
            //联盟数据
            $platform_acid=input('platform_acid');
            $url="https://atroom.youdiy.cn/sass/user.tea_house/storeInfo";
            $res=httpRequest($url,"POST",[
                'platform_acid'=>$platform_acid,
                'id'=>$store_id,
            ]);
            $res=@json_decode($res,true);
            $data=$res['data'];
            $house_list=isset($data['house_list'])?$data['house_list']:[];
            foreach($house_list as &$value){
                $value['is_alliance']=1;
                $value['acid']=$platform_acid;
            }
            $data['house_list']=$house_list;
            return fetchJson($data);
        }
        $store = Store::where(['acid' => $this->acid, 'id' => $store_id])
        ->withoutField('account,password,access_token,local,store_manager,shop_banner,sort,wx_mch_id,wx_key,wx_sslcert,wx_sslkey,wx_sub_config,douyin_poi_id,douyin_config,meituan_open_shop_uuid,meituan_config,smart_device,lvmi_developer,lvmi_device,counter_config,printer1_config,printer2_config,advanced_clean,is_repeat_order_original,video_url,create_time,update_time,dec,service_facilities,policy')
        ->cache(30)->find();
        if (!$store) {
            return fetchJson([], '暂无数据', 1);
        }
        $store['banner'] = get_file_urls($store['banner']);
        $store['logo'] = get_file_url($store['logo']);
        $store['logo'] = str_replace("http://", "https://", $store['logo']);
        $tags = Tags::where(['acid' => $this->acid])->where('id', 'in', explode(',', $store['tags']))->column('id,title');
        $store['tags'] = $tags;
        $config = json_decode($store['config'], 1);
        $store['wifi_username'] = isset($config['wifi_config']['username']) ? $config['wifi_config']['username'] : '';
        $store['wifi_password'] = isset($config['wifi_config']['password']) ? $config['wifi_config']['password'] : '';
        $business_hours = json_decode($store['business_hours'], 1);
        if (isset($business_hours['start_time']) && isset($business_hours['end_time'])) {
            if ($business_hours['start_time'] == $business_hours['end_time']) {
                $business_hours['start_time'] = '00:00';
                $business_hours['end_time'] = '24:00';
            }
        }
        $is_bus_time = 0;
        $bus_start = 0;
        $bus_end = 0;
        $is_antitone = 0;
        $dateTime = input('date') ? strtotime(input('date')) : strtotime(date('Y-m-d'));
        //是否反序
        if (isset($business_hours['start_time']) && isset($business_hours['end_time'])) {
            $bus_start = date('Y-m-d ', $dateTime) . $business_hours['start_time'];
            $bus_end = date('Y-m-d ', $dateTime) . $business_hours['end_time'];
            if ($bus_end != $bus_start) {
                $is_bus_time = 1;
                if (strtotime($bus_end) < strtotime($bus_start)) {
                    $is_antitone = 1;
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                } else {
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                }
            }
        }
        $store['distance']=(6378.138 * 2 * asin(sqrt(pow(sin(($store['lat'] * pi() / 180 - $lat  * pi() / 180) / 2),2) + cos($store['lat'] * pi() / 180) * cos($lat * pi() / 180) * pow(sin(($store['lng'] * pi() / 180 - $lng * pi() / 180) / 2),2))) * 1000);
        $store['distance'] = $store['distance'] / 1000;
        $store['distance'] ='距我'. round($store['distance'], 2) . 'km';
        $store['business_hours'] = $business_hours;
        $store['select_name'] = isset($config['select_name']) ? $config['select_name'] : '';
        $keyword = input('keyword');
        $query = House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $store_id, 'status' => 1]);

        $house_ids1 = HouseOrder::where(['acid' => $this->acid, 'store_id' => $store_id])
        ->where('status', 'in', '1,2')
        ->where('start_time', '<', time())
        ->where('end_time', '>', time())
        ->distinct(true)
        ->field('house_id')
        ->column('house_id');
        $house_ids2 = HouseOrderContinue::where(['acid' => $this->acid, 'store_id' => $store_id])
        ->where('status', 'in', '1,2')
        ->where('start_time', '<', time())
        ->where('end_time', '>', time())
        ->distinct(true)
        ->field('house_id')
        ->column('house_id');
        if($house_ids2){
             $house_ids=array_merge($house_ids1,$house_ids2);
        }else{
             $house_ids=$house_ids1;
        }
        if ($house_ids) {
            $house_ids = implode(',', $house_ids);
            $query->orderRaw('field(id,' . $house_ids . ') ASC,sort ASC');
        } else {
            $query->order('sort ASC');
        }
        $list = $query->withoutField('lvelectricty_line_config,electricty_line_config,servicing_time,could_sound,electricityid,price_list,update_time')->cache(60)->select()->toArray();
        $discount = Card::where(['acid' => $this->acid, 'is_delete' => 0])->order('discount ASC')->value('discount');
        $cover_ids = [];
        $house_id_arr = [];
        $package_price_id = '';
        $package_price = [];
        $todayRoomTime=strtotime(date('Y-m-d'))+86400;
        
        foreach ($list as $key => &$value) {
            $banner = explode(',', $value['banner']);
            $cover_ids = array_merge($cover_ids, $banner);
            $house_id_arr[] = $value['id'];
            $value['is_alliance']=0;
            if (!$discount) {
                $value['member_price'] = -1;
            } else {
                if ($value['member_price'] <= 0) {
                    $value['member_price'] = $value['price'] * $discount * 0.1;
                    $value['member_price'] = round($value['member_price'], 2);
                }
            }
            $value['package_price'] = json_decode($value['package_price'], 1);
            $value['discount'] = $discount;
            if($value['package_price']){
                if (!$package_price) {
                    $package_price = $value['package_price'];
                    $package_price_id = $value['id'];
                }
            }
            $value['booktime'] = $value['booktime'] * 1;
           
            $value['facility_servicing_list'] = Facility::where('id', 'in', $value['facility_servicing'])->column('id,title');

            $room_status_data=self::roomStatusData($store,$value);
            $value['servicing_time']=self::oemServicingTime($value);
            $value['room_qy_sort']=isset($room_status_data['status'])?$room_status_data['status']:0;
            $value['room_status_data']=$room_status_data;
            
        }
         // 使用usort和一个自定义比较函数进行排序
        usort($list, function($a, $b) {
            return $a['room_qy_sort'] - $b['room_qy_sort'];
        });
        $store['package_price_id'] = $package_price_id;
        $store['package_price'] = $package_price;
        $houseOrderCountArr = HouseOrder::where(['acid' => $this->acid, 'is_pay' => 1])->where('house_id', 'in', $house_id_arr)->where('status', '<>', 4)->field('house_id,count(house_id) booknum')->group('house_id')->select();
        if ($houseOrderCountArr) {
            $houseOrderCountArr = $houseOrderCountArr->toArray();
            $houseOrderCountArr = array_column($houseOrderCountArr, 'booknum', 'house_id');
        }
        $houseStockCountArr = HouseStockOem::where(['acid' => $this->acid])->where('house_id', 'in', $house_id_arr)
        ->whereTime('start_time','<=',time())
        ->whereTime('end_time','>=',time()+3600*2)
        ->field('house_id,count(house_id) booknum')->group('house_id')->select();
        if ($houseStockCountArr) {
            $houseStockCountArr = $houseStockCountArr->toArray();
            $houseStockCountArr = array_column($houseStockCountArr, 'booknum', 'house_id');
        }
        $get_cache_file_urls = get_cache_file_urls($cover_ids);
        $houseList=[];
        $billiardList=[];
        $houseFreeNum=0;
        $billiardFreeNum=0;
        $store['housePice']=House::where(['type'=>1,'store_id'=>$store['id'],'is_delete'=>0,'status'=>1])->order('price ASC')->value('price');
        $store['billiardPice']=House::where(['type'=>2,'store_id'=>$store['id'],'is_delete'=>0,'status'=>1])->order('price ASC')->value('price');
        $store['housePice']=$store['housePice']?$store['housePice']:0;
        $store['billiardPice']=$store['billiardPice']?$store['billiardPice']:0;
        foreach ($list as $key => &$value) {
            $banner = explode(',', $value['banner']);
            foreach ($banner as $k => $v) {
                $banner[$k] = isset($get_cache_file_urls[$v]) ? $get_cache_file_urls[$v] : '';
            }
            $value['banner_list'] = $banner;
            //预定数量
            $value['booknum'] = isset($houseOrderCountArr[$value['id']]) ? $houseOrderCountArr[$value['id']] : 0;
            $virtual_sales = isset($value['virtual_sales']) ? $value['virtual_sales'] : 0;
            $value['booknum'] += $virtual_sales;
            $value['is_book'] = isset($houseStockCountArr[$value['id']]) ? 1 : 0;
            if($value['type']==1){
                $billiardList[]=$value;
                if($value['room_status']==1){
                    $billiardFreeNum++;
                }
            }
            if($value['type']==2){
                $houseList[]=$value;
                if($value['room_status']==1){
                    $houseFreeNum++;
                }
            }
        }
        $user_id = User::where('access_token', input('access_token'))->value('id');
        $cardUser = CardUser::alias('c_u')->leftJoin([Card::getTable() => 'c'], 'c_u.card_id=c.id')->where(['c_u.status' => 1, 'c_u.user_id' => $user_id, 'c.is_delete' => 0])->where('c_u.start_time', '<', time())->where('c_u.end_time', '>', strtotime(date('Y-m-d', time() + 86400)))->order('c_u.level DESC')->field('c_u.*,c.discount')->find();
        $discount = -1;
        if ($cardUser) {
            $discount = $cardUser['discount'];
        }
        $store['user_discount'] = $discount;
        unset($store['config']);

        //商户访问量
        \app\shared\model\UserUv::todayUv($this->acid, 1, $store['id'], $user_id, $store['id']);
        $storeUser = [];
        if ($user_id = input('user_id')) {
            $storeUser = StoreUserMoney::where(['acid' => $this->acid, 'store_id' => $store['id'], 'user_id' => $user_id])->field('money,tea_money')->find();
        }
        $is_counter = Counter::where(['store_id' => $store['id'], 'is_delete' => 0, 'status' => 1])->limit(1)->count();
        $is_hotel = House::where(['store_id' => $store['id'], 'is_delete' => 0, 'status' => 1,'type'=>2])->limit(1)->count();
        return fetchJson([
            'info' => $store, 
            'storeUser' => $storeUser,
            'billiard_list'=>$billiardList, 
            'house_list' => $houseList, 
            'is_counter' => $is_counter,
            'houseFreeNum'=>$houseFreeNum,
            'billiardFreeNum'=>$billiardFreeNum,
            'is_hotel'=>$is_hotel>0?1:0
        ]);
    }
    //商户列表
    public function list()
    {
        $lat = input('lat') ? input('lat') : 0;
        $lng = input('lng') ? input('lng') : 0;
        if ($lng == 'undefined') {
            $lng = 0;
        }
        if ($lat == 'undefined') {
            $lat = 0;
        }
        $query = Store::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1])->field('id,name,address,tel,lat,lng,score,(6378.138 * 2 * asin(sqrt(pow(sin((lat * pi() / 180 - ' . $lat . ' * pi() / 180) / 2),2) + cos(lat * pi() / 180) * cos(' . $lat . ' * pi() / 180) * pow(sin((lng * pi() / 180 - ' . $lng . ' * pi() / 180) / 2),2))) * 1000) as distance');
        if ($keyword = input('keyword')) {
            $query->where('name', 'like', "%{$keyword}%");
        }
        if($is_check_ticket=input('is_check_ticket')){
            $query->where('douyin_poi_id','<>',null);
        }
        if($poi_id=input('poi_id')){
            $query->where('douyin_poi_id',$poi_id);
        }
        if ($area_id = input('area_id')) {
            $query->where('area_id', $area_id);
        }
        if ($category = input('category')) {
            $query->whereFindInSet('category', $category);
        }
        $new_sort=input('new_sort');
        if($new_sort==1){//距离
            $query->order('distance ASC');
        }else if($new_sort==2){//置顶
            $query->order('sort ASC');
        }else if($new_sort==3){//价格低到高
             $query->order('tea_price ASC');
        }else if($new_sort==4){//高到低
             $query->order('tea_price DESC');
        }else{
            $query->order('distance ASC');
        }
        $query->page($this->page);
        if ($limit = input('limit')) {
            $query->limit($limit);
        }
        $list = $query->cache(30)->select();
        foreach ($list as $key => &$value) {
            $billiard = House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $value['id'],'status' =>1,'type'=>1])
            ->field('id,price')
            ->order('sort ASC')
            ->find();
            if($billiard){
                $value['billiard']=[
                    'price'=>$billiard['price'],
                    'free_num'=>House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $value['id'], 'status' => 1,'type'=>1,'room_status'=>1])->count()
                ];
            }else{
                $value['billiard']=[];
            }
            $house = House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $value['id'], 'status' => 1,'type'=>2])
            ->field('id,price')
            ->order('sort ASC')
            ->find();
            if($house){
                $value['house']=[
                    'price'=>$house['price'],
                    'free_num'=>House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $value['id'], 'status' => 1,'type'=>2,'room_status'=>1])->count()
                ];
            }else{
                $value['house']=[];
            }
            $value['distance'] = $value['distance'] / 1000;
            $value['distance'] ='距离'. round($value['distance'], 2) . 'km';
        }
        return fetchJson($list);
    }
    private function changeHouseStock($stockToday)
    {
        $orderNew = [];
        foreach ($stockToday as &$t) {
            $orderNew[$t['order_id']][] = $t;
        }
        foreach ($orderNew as &$n) {
            $n = array_merge([['hour' => $n[0]['hour'] - 1800, 'status' => $n[0]['status'], 'order_id' => $n[0]['order_id']]], $n);
        }
        $stockToday = [];
        foreach ($orderNew as &$d) {
            foreach ($d as $s) {
                $stockToday[] = $s;
            }
        }
        $dateTime = input('date') ? strtotime(input('date')) : time();
        $stockDatas = [];
        for ($j = 0; $j < 96; $j++) {
            $time = strtotime(date('Y-m-d H:i', $dateTime)) + 1800 * $j;
            foreach ($stockToday as $v) {
                if ($time > $v['hour'] - 1800 && $time < $v['hour'] + 1800) {
                    $stockDatas[$time] = ['hour' => $time, 'status' => $v['status'], 'order_id' => $v['order_id']];
                }
            }
        }
        return $stockDatas;
    }
    //空间信息
    public function houseInfo()
    {

        $form = House::where(['acid' => $this->acid, 'is_delete' => 0, 'id' => input('house_id'), 'status' => 1])->withoutField('servicing_time,lvelectricty_line_config,electricty_line_config,electricity_yy_config,could_sound,price_list')->cache(30)->find();
        if (!$form) {
            return fetchJson([], '暂无数据', 1);
        }
        $dateTime = input('date') ? strtotime(input('date')) : strtotime(date('Y-m-d'));
        $store = Store::where(['id' => $form['store_id']])->find();
        $business_hours = $store['business_hours'];
        $business_hours = json_decode($business_hours, 1);
        $is_bus_time = 0;
        $bus_start = 0;
        $bus_end = 0;
        $is_antitone = 0;
        $form['banner_list'] = get_file_urls($form['banner']);
        $form['facility_servicing_list'] = Facility::where('id', 'in', $form['facility_servicing'])->column('id,title');
        $form['tel'] = $store['tel'];
        $form['lat'] = $store['lat'];
        $form['lng'] = $store['lng'];
        $form['address'] = $store['address'];
        $form['is_wallet'] = $store['is_wallet'];
        $form['book_mode']=isset($store['book_mode'])?$store['book_mode']:1;//1共存，2小时，3套餐
        $form['package_price'] = json_decode($form['package_price'], 1);
        
        $discount = Card::where(['acid' => $this->acid, 'is_delete' => 0])->order('discount ASC')->value('discount');
        if (!$discount) {
            $form['member_price'] = -1;
        } else {
            if ($form['member_price'] <= 0) {
                $form['member_price'] = $form['price'] * $discount * 0.1;
                $form['member_price'] = round($form['member_price'], 2);
            }
        }
        $form['douyin_poi_id']=$store['douyin_poi_id'];
        $form['store_name']=$store['name'];
        $form['discount'] = $discount;
        $form['booknum'] = HouseOrder::where(['acid' => $this->acid, 'is_pay' => 1, 'house_id' => $form['id']])->where('status', '<>', 4)->count();
        $virtual_sales = isset($form['virtual_sales']) ? $form['virtual_sales'] : 0;
        $form['booknum'] += $virtual_sales;
        $form['is_book'] = HouseStockOem::where(['acid' => $this->acid, 'store_id' => $form->store_id, 'house_id' => $form['id']])
        ->whereTime('start_time','<=',time())
        ->whereTime('end_time','>=',time()+3600*$form['booktime'])
        ->count();
        $form['is_book'] =$form['is_book']>=1?1:0;
        $form['is_book'] = $form['is_book'] > 0 ? 1 : 0;
        //茶室访问量
        $user_id = User::where('access_token', input('access_token'))->value('id');
        \app\shared\model\UserUv::todayUv($this->acid, 2, $form['store_id'], $user_id, $form['id']);
        $user_cash_grade = Usercashgrade::whereFindInSet('store_ids', $form['store_id'])->where(['acid' => $this->acid, 'status' => 1, 'is_delete' => 0])->column('id');
        $form['is_can_book'] = 1;
        if ($user_cash_grade) {
            $user_cash_grade_id = User::where('access_token', input('access_token'))->value('user_cash_grade_id');
            if (!in_array($user_cash_grade_id, $user_cash_grade)) {
                $form['is_can_book'] = 0;
            }
        }
        if (isset($business_hours['start_time']) && isset($business_hours['end_time'])) {
            if ($business_hours['start_time'] == $business_hours['end_time']) {
                $business_hours['start_time'] = '00:00';
                $business_hours['end_time'] = '24:00';
            }
        }
        
        $form['room_status_data']=self::roomStatusData($store,$form);
        $form['servicing_time']=self::oemServicingTime($form);
        $form['business_hours']=$business_hours;
        return fetchJson($form);
    }

    public function iQuery($array,$dayArr,$end=0){
        foreach($dayArr as $key=>$val){
            if(isset($array[date('Y-m-d H:i',$val)])){
                $start_time=$array[date('Y-m-d H:i',$val)];
                unset($array[$key]);
                return self::iQuery($array,$dayArr,$start_time);
            }else{
                unset($array[$key]);
            }
        }
        return $end;
    }
    function findFreeTimeSlots($bookedTimeSlots, $startTime, $endTime) {  
            $freeTimeSlots = [];  
            $currentEnd = $startTime; // 当前空闲时间段的结束时间  
          
            // 遍历所有已预约的时间段  
            foreach ($bookedTimeSlots as $slot) {  
                $start = $slot['start'];  
                $end = $slot['end'];  
          
                // 如果当前空闲时间段的结束时间小于已预约时间段的开始时间  
                // 则找到了一个空闲时间段  
                if ($currentEnd < $start) {  
                    $freeTimeSlots[] = [  
                        'start' => $currentEnd,  
                        'end' => $start  
                    ];  
                }  
          
                // 更新当前空闲时间段的结束时间为已预约时间段的结束时间  
                $currentEnd = max($currentEnd, $end);  
            }  
          
            // 检查最后一个空闲时间段到指定结束时间之间是否有空闲  
            if ($currentEnd < $endTime) {  
                $freeTimeSlots[] = [  
                    'start' => $currentEnd,  
                    'end' => $endTime  
                ];  
            }  
          
            return $freeTimeSlots;  
       }
       private function qianyaIquery($bookings,$hour=1){
            $bookHour=$hour*3600+180;  
            // 对预约时间段按开始时间进行排序  
            usort($bookings, function($a, $b) {  
                return $a['start_time'] - $b['start_time'];  
            });  
              
            // 计算未被预约的时间段  
            $freeTimes = [];  
            $currentEnd = null;  
            $startFreeTime=0;    
            foreach ($bookings as $booking) {  
                // 如果当前时间段不是第一个时间段，并且它的开始时间与上一个时间段的结束时间有间隔  
                if ($currentEnd !== null && $booking['start_time'] > $currentEnd) {  
                    // 添加这个间隔到未被预约的时间段数组  
                    $freeTimes[] = ['start_time' => $currentEnd, 'end_time' => $booking['start_time']];  
                }  
                $startFreeTime=$booking['start_time'];  
                // 更新当前结束时间为当前时间段的结束时间  
                $currentEnd = $booking['end_time'];  
            }  
           
            // 打印未被预约的时间段  
            foreach ($freeTimes as $freeTime) {
                $jiange=$freeTime['end_time']-$freeTime['start_time'];
                if($jiange>=$bookHour){
                     return $freeTime['start_time'];
                } 
            }
            return $startFreeTime;
    }      
    private function roomStatusData($store,$form){
        $newDate=date('Y-m-d');
        $date=input('date');
        if($date){
            if($date==$newDate){
                $newTime=time();
            }else{
                $newTime=strtotime($date);
            }
        }else{
            $newTime=time();
        }
        $bookTimeOem=$form['booktime']*3600;
        $starttime=$newTime;
        $endtime=$newTime+$bookTimeOem;
        $oemStockTime=[];
        $dayArr=houseTimePoxPus($starttime,$endtime);
        $bookIntervalStatus=$store['book_interval_status'];
        $bookIntervalStatusTime=$bookIntervalStatus==1?1800:0;
        $bookTimeRetain=60*3;
        $listArray=HouseStockOem::where(['store_id'=>$form['store_id'],'acid'=>$form['acid'],'house_id'=>$form['id'],'status'=>1])
        ->whereTime('end_time','>=',$newTime)
        ->column('start_time,end_time,order_id');
        $bookTime=0;
        if($listArray){
            $astartT=HouseStockOem::where(['store_id'=>$form['store_id'],'acid'=>$form['acid'],'house_id'=>$form['id'],'status'=>1])
            ->whereTime('end_time','>=',$newTime)
            ->order('start_time ASC')->value('start_time');
            $aendT=HouseStockOem::where(['store_id'=>$form['store_id'],'acid'=>$form['acid'],'house_id'=>$form['id'],'status'=>1])
            ->whereTime('end_time','>=',$newTime)->order('end_time DESC')->value('end_time');
            $starttimeOem=$newTime;
            $endtimeOem=$aendT+180+$bookTimeOem;
            if($astartT>$starttimeOem+$bookTimeOem){
                $listArray=array_merge($listArray,[
                    [
                        'start_time'=>$starttimeOem,
                        'end_time'=>$starttimeOem,
                    ],
                    [
                        'start_time'=>$endtimeOem,
                        'end_time'=>$endtimeOem,
                    ]
                ]);
            }else{
                $listArray=array_merge($listArray,[
                    [
                        'start_time'=>$endtimeOem,
                        'end_time'=>$endtimeOem
                    ]
                ]);
            }
            $bookTime=self::qianyaIquery($listArray,$form['booktime']);
        }
        if($bookTime<=0){
            if($date==$newDate){
                $bookTime=$newTime+$bookTimeRetain;
            }else{
                $bookTime=$newTime;
            }
        }else{
            if($bookTime==$newTime){
                if($starttimeOem!=$bookTime){
                    $bookTime+=$bookTimeRetain;
                }
            }else if($endtimeOem==$bookTime){
                $bookTime=$aendT+$bookTimeRetain;
            }else{
                $bookTime+=$bookTimeRetain;
            }
        }
        foreach($dayArr as $time){
             $oemStockTime=HouseStockOem::where(['store_id'=>$form['store_id'],'acid'=>$form['acid'],'house_id'=>$form['id'],'status'=>1])
            ->whereTime('start_time','<=',$time)
            ->whereTime('end_time','>=',$time)
            ->field('id,start_time,end_time,order_id')->find();
            if($oemStockTime){
               break;
            }
        }
        if($oemStockTime){
            $newHourEndTime=$oemStockTime->end_time;   
            if($oemStockTime->start_time>$newTime){
                $room_status_data=[
                    'title'=>'已预约',
                    'remark'=>date('H:i',$newHourEndTime).'结束',
                    'status'=>2,
                    'time'=>$bookTime
                ];
            }else{
                $room_status_data=[
                    'title'=>'使用中',
                    'remark'=>date('H:i',$newHourEndTime).'结束',
                    'status'=>2,
                    'time'=>$bookTime
                ];
            }
            if($room_status_data['time']==$newTime){
                $room_status_data['time']+=60*3;
            }
        }else{
            if($form['room_status']==2){
                $room_status_data=[
                    'title'=>'待打扫',
                    'remark'=>'',
                    'status'=>3,
                    'time'=>$bookTime,
                ];
            }else{
                $room_status_data=[
                    'title'=>'可预订',
                    'remark'=>'',
                    'status'=>1,
                    'time'=>$bookTime
                ];
            }
        }
        if($store['is_room_status']==2){
            if($form['room_status']==2){
                $room_status_data=[
                    'title'=>'待打扫',
                    'remark'=>'',
                    'status'=>3,
                    'time'=>$bookTime
                ];
            }
        }
        $room_status_data['btime']=date("Y-m-d H:i",$room_status_data['time']);
        
        if(input('test')){
            p($room_status_data);
            die;    
        }
        return $room_status_data;
    }    
    private function roomStatusDataNOld($store,$form){
        $newDate=date('Y-m-d');
        $date=input('date');
        if($date){
            if($date==$newDate){
                $newTime=time();
            }else{
                $newTime=strtotime($date);
            }

        }else{
            $newTime=time();
        }
        $starttime=$newTime;
        $endtime=$newTime+$form['booktime']*3600;
        $oemStockTime=[];
        $dayArr=houseTimePoxPus($starttime,$endtime);
        
        $bookIntervalStatus=$store['book_interval_status'];
        $bookIntervalStatusTime=$bookIntervalStatus==1?1800:0;
        $bookTimeRetain=60*3;

        $listArray=HouseStockOem::where(['store_id'=>$form['store_id'],'acid'=>$form['acid'],'house_id'=>$form['id'],'status'=>1])
        ->whereTime('end_time','>=',$newTime)
        ->column('start_time,end_time,id,order_id');
        $bookTime=$starttime;
        $array9=[];
        foreach($listArray as $value){
           $array=houseTimePoxPus($value['start_time'],$value['end_time'],1);
           $array9=array_merge($array,$array9);
        }
        ksort($array9);
        $array99=[];
        foreach($array9 as $k=>$v){
           $array99[($k)]=$v;
        }
        $keys = array_keys($array99);
        $bookStart=strtotime(array_shift($keys));
        $bookEnd=strtotime(array_pop($keys));
        $bookNum=($bookEnd-$bookStart)/1800;
        $array88=[];
        for($a=0;$a<=$bookNum;$a++){
            $atime=$bookStart+1800*$a;
            $adtime=date('Y-m-d H:i',$atime);
            if(!in_array($adtime,$keys)){
                $array88[$adtime]=$atime;
            }
        }
        // 查找间隔为30分钟的相连时间段  
        $findTime = findOemHours($array88,$form['booktime']); 
        if($findTime){
            $bookTime=array_shift($findTime);
            if($bookTime<=0){
                $bookTime=$newTime;
            }
        }else{
            if($bookEnd>0){
                $bookTime=$bookEnd+$bookTimeRetain;
            }else{
                $bookTime=$newTime;
            }
        }

        foreach($dayArr as $time){
             $oemStockTime=HouseStockOem::where(['store_id'=>$form['store_id'],'acid'=>$form['acid'],'house_id'=>$form['id'],'status'=>1])
            ->whereTime('start_time','<=',$time)
            ->whereTime('end_time','>=',$time)
            ->field('id,start_time,end_time,order_id')->find();
            if($oemStockTime){
               break;
            }
        }
        if($oemStockTime){
            $newHourEndTime=$oemStockTime->end_time;   
            if($oemStockTime->start_time>$newTime){
                $room_status_data=[
                    'title'=>'已预约',
                    'remark'=>date('H:i',$newHourEndTime).'结束',
                    'status'=>2,
                    'time'=>$bookTime
                ];
            }else{
                $room_status_data=[
                    'title'=>'使用中',
                    'remark'=>date('H:i',$newHourEndTime).'结束',
                    'status'=>2,
                    'time'=>$bookTime
                ];
            }
            
        }else{
            if($form['room_status']==2){
                $room_status_data=[
                    'title'=>'待打扫',
                    'remark'=>'',
                    'status'=>3,
                    'time'=>$bookTime,

                ];
            }else{
                $room_status_data=[
                    'title'=>'可预订',
                    'remark'=>'',
                    'status'=>1,
                    'time'=>$bookTime
                ];
            }
        }
        if($store['is_room_status']==2){
            if($form['room_status']==2){
                $room_status_data=[
                    'title'=>'待打扫',
                    'remark'=>'',
                    'status'=>3,
                    'time'=>$bookTime
                ];
            }
        }
        return $room_status_data;
    }   
    //OEM服务时间
    private function oemServicingTime($form){
        $num=48;
        $time=1800;
        $date=input('date')?input('date'):date('Y-m-d');
        if($date==date('Y-m-d')){
            $start_time=date('Y-m-d H').':00';
        }else{
            $start_time=date('Y-m-d H',strtotime($date)).':00';
        }
        $start_time=strtotime($start_time);

        
        $findArray=[];
        $listArray=HouseStockOem::where(['store_id'=>$form['store_id'],'acid'=>$form['acid'],'house_id'=>$form['id'],'status'=>1])
        ->whereTime('end_time','>=',$start_time)
        ->column('start_time,end_time,id,order_id');
        
        $arrayNew=[];
        $array=[];

        foreach($listArray as $value){
            $array=houseTimePoxPus($value['start_time'],$value['end_time'],0,0);
            $arrayNew=array_merge($array,$arrayNew);
        }
        
        sort($arrayNew);
        $arrayNew=array_unique($arrayNew);

        $arrayNewOem=[];
        foreach($arrayNew as $v){
           $arrayNewOem[$v]=1;
        }
        $arrayT=[];
        for ($i=0; $i < $num; $i++) { 
            $newTime=$start_time+($i*$time);
            $status=1;
            if(isset($arrayNewOem[$newTime])){
                $status=0;
            }
            $findArray[]=date('Y-m-d H:i',$newTime);
            $arrayT[]=[
                'time'=>date('H:i',$newTime),
                'dateTime'=>date('Y-m-d H:i',$newTime),
                'status'=>$status,
            ];
        }
        return $arrayT;
    }
}