<?php

namespace app\shared\logic\user;

use app\shared\model\User;
use app\shared\model\Store;
use app\shared\model\ApplyBecomeStore;
use app\shared\model\House;
use app\shared\model\HouseRoom;
use app\shared\model\HouseRoomStock;
use app\shared\model\Option;
use app\shared\model\App;
use app\shared\model\District;
use app\shared\model\Area;
use app\shared\model\Tags;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\GoodsOrder;
use app\shared\model\Category;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\Facility;
use app\shared\model\HouseStock;
use app\shared\model\StoreCoupon;
use app\shared\model\StoreCouponUser;
use think\exception\ValidateException;
use app\shared\model\StoreRechargeOrder;
use app\shared\model\StoreRecharge;
use app\shared\model\Recharge;
use app\shared\model\Coupon;
use app\shared\model\StoreUserMoney;
use app\shared\model\Conversion;
use app\shared\model\Bill;
use app\shared\model\Counter;
use think\facade\Cache;
use app\BaseController;
use wechatpay\WechatPay;
use app\plugin\model\usercashgrade\Usercashgrade;
class StoreForm extends Base
{
    //分类列表
    public function categoryList()
    {
        $list = Category::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1])->order('sort ASC')->cache(30)->column('id,name,cover,sort,type');
        foreach ($list as $key => &$value) {
            $value['cover_url'] = get_file_url($value['cover']);
        }
        return fetchJson($list);
    }
    
    //房间列表
    public function houseList()
    {
        $store_id = input('store_id');
        $dateTime = input('date') ? strtotime(input('date')) : strtotime(date('Y-m-d'));
        $store = Store::where(['id' => $store_id])
        ->withoutField('account,password,access_token,store_manager,shop_banner,sort,wx_mch_id,wx_key,wx_sslcert,wx_sslkey,wx_sub_config,douyin_poi_id,douyin_config,meituan_open_shop_uuid,meituan_config,smart_device,lvmi_developer,lvmi_device,counter_config,printer1_config,printer2_config,book_interval_status,advanced_clean,is_repeat_order_original,video_url,create_time,update_time')
        ->find();
        $business_hours = $store['business_hours'];
        $business_hours = json_decode($business_hours, 1);
        $is_bus_time = 0;
        $bus_start = 0;
        $bus_end = 0;
        $is_antitone = 0;
        //是否反序
        if (isset($business_hours['start_time']) && isset($business_hours['end_time'])) {
            $bus_start = date('Y-m-d ', $dateTime) . $business_hours['start_time'];
            $bus_end = date('Y-m-d ', $dateTime) . $business_hours['end_time'];
            if ($bus_end != $bus_start) {
                $is_bus_time = 1;
                if (strtotime($bus_end) < strtotime($bus_start)) {
                    $is_antitone = 1;
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                } else {
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                }
            }
        }
        $query = House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $store_id, 'status' => 1]);
        if ($house_id = input('house_id')) {
            $query->where('id', $house_id);
        }
        $house_ids = HouseOrder::where(['acid' => $this->acid, 'store_id' => $store_id])->where('status', 'in', '1,2')->where('start_time', '<', time())->where('end_time', '>', time())->group('house_id')->column('house_id');
        if ($house_ids) {
            $house_ids = implode(',', $house_ids);
            $query->orderRaw('field(id,' . $house_ids . ') ASC,sort ASC');
        } else {
            $query->order('sort ASC');
        }
        $discount = Card::where(['acid' => $this->acid, 'is_delete' => 0])->order('discount ASC')->value('discount');
        $list = $query->withoutField('lvelectricty_line_config,electricty_line_config,servicing_time,price_list,could_sound,electricityid')->cache(30)->page($this->page)->limit(10)->select();
        $cover_ids = [];
        $house_id_arr = [];

        foreach ($list as $key => &$value) {
            $banner = explode(',', $value['banner']);
            $cover_ids = array_merge($cover_ids, $banner);
            $house_id_arr[] = $value['id'];
            if (!$discount) {
                $value['member_price'] = -1;
            } else {
                if ($value['member_price'] <= 0) {
                    $value['member_price'] = $value['price'] * $discount * 0.1;
                    $value['member_price'] = round($value['member_price'], 2);
                }
            }
            $value['discount'] = $discount;
        }
        $houseStockCountArr = HouseStock::where(['acid' => $this->acid])->where('house_id', 'in', $house_id_arr)->where('hour', "<", time() + 2 * 3600)->where('hour', ">", time())->field('house_id,count(house_id) booknum')->group('house_id')->select();
        if ($houseStockCountArr) {
            $houseStockCountArr = $houseStockCountArr->toArray();
            $houseStockCountArr = array_column($houseStockCountArr, 'booknum', 'house_id');
        }
        $get_cache_file_urls = get_cache_file_urls($cover_ids);
        $todayRoomTime=strtotime(date('Y-m-d'))+86400;
        foreach ($list as $key => &$value) {
            $banner = explode(',', $value['banner']);
            foreach ($banner as $k => $v) {
                $banner[$k] = isset($get_cache_file_urls[$v]) ? $get_cache_file_urls[$v] : '';
            }
            $value['banner_list'] = $banner;
            //今天
            $stockToday = HouseStock::where(['acid' => $value['acid'], 'store_id' => $value['store_id'], 'house_id' => $value['id'], 'date' => $dateTime, 'status' => 0])->order('hour ASC')->column('hour,status,order_id');
            $tomorrowtime = $dateTime + 86400;
            $stockTomorrow = HouseStock::where(['acid' => $value['acid'], 'store_id' => $value['store_id'], 'house_id' =>$value['id'], 'date' => $tomorrowtime, 'status' => 0])->column('hour,status,order_id');
            $allstock = array_merge($stockToday, $stockTomorrow);

            $allstock = array_column($allstock, 'status', 'hour');
            //预定数量
            $value['booknum'] = isset($houseOrderCountArr[$value['id']]) ? $houseOrderCountArr[$value['id']] : 0;
            $virtual_sales = isset($value['virtual_sales']) ? $value['virtual_sales'] : 0;
            $value['booknum'] += $virtual_sales;
            $value['is_book'] = isset($houseStockCountArr[$value['id']]) ? 1 : 0;
            $price_list = json_decode($value['price_list'], 1);
            if ($price_list) {
                $priceData = array_column($price_list, 'price', 'time');
            }

            $value['package_price_list']=json_decode($value['package_price'],true);
            unset($value['package_price']);
            $servicing_today_time = [];
            $servicing_tomorrow_time = [];
            
            for ($j = 0; $j < 24; $j++) {
                $timeTomorrow = strtotime(date('Y-m-d H:i', $dateTime + 86400)) + 3600 * $j;
                $time = strtotime(date('Y-m-d H:i', $dateTime)) + 3600 * $j;
                $t = date('H', $time);
                $tt = date('H', $timeTomorrow);
                //是否有营业时间
                if ($is_bus_time == 1) {
                    //正序
                    if ($is_antitone == 0) {
                        if ($time >= $bus_startNew && $time < $bus_endNew) {
                            $servicing_today_time[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                        } else {
                            $servicing_today_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                        }
                    } else {
                        if ($time >= $bus_startNew && $time < $bus_endNew) {
                            $servicing_today_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                        } else {
                            $servicing_today_time[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                        }
                    }
                } else {
                    $servicing_today_time[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                }
                 //明日时间表//新加的
                //是否有营业时间
                if ($is_bus_time == 1) {
                    //正序
                    if ($is_antitone == 0) {
                        if ($timeTomorrow >= $bus_startTom && $timeTomorrow < $bus_endTom) {
                            $servicing_tomorrow_time[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                        } else {
                            $servicing_tomorrow_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                        }
                    } else {
                        if ($timeTomorrow >= $bus_startTom && $timeTomorrow < $bus_endTom) {
                            $servicing_tomorrow_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                        } else {
                            $servicing_tomorrow_time[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                        }
                    }
                } else {
                    $servicing_tomorrow_time[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                }

            }
            $value['servicing_today_time'] = $servicing_today_time;
            $value['servicing_tomorrow_time'] = $servicing_tomorrow_time;
            $value['facility_servicing_list'] = Facility::where('id', 'in', $value['facility_servicing'])->column('id,title');
            $value['room_status_data']=[];
            if(isset($store['is_show_room_status'])){
                if($store['is_show_room_status']==1&&$store['is_room_status']==0){
                    $hour=HouseOrderContinue::where(['acid' => $this->acid,'house_id'=>$value['id']])->where('status','in','1,2')->whereBetweenTimeField('start_time', 'end_time')->order('end_time DESC')->value('end_time');
                    if(!$hour){
                        $hour=HouseOrder::where(['acid' => $this->acid,'house_id'=>$value['id']])->where('status','in','1,2')->whereBetweenTimeField('start_time', 'end_time')->order('end_time DESC')->value('end_time');
                    }
                    
                    // $hour=HouseStock::where(['acid' => $this->acid,'house_id'=>$value['id'],'status'=>0])->where('hour', ">", time())->where('hour','<',$todayRoomTime)->order('hour DESC')->value('hour');
                    if($hour){
                        $value['room_status_data']=[
                            'title'=>'使用中',
                            'remark'=>date('H:i',$hour).'结束',
                            'status'=>2
                        ];
                    }else{
                        if($value['room_status']==2){
                            $value['room_status_data']=[
                                'title'=>'待打扫',
                                'remark'=>'',
                                'status'=>3
                            ];
                        }else{
                            $value['room_status_data']=[
                                'title'=>'可预订',
                                'remark'=>'',
                                'status'=>1
                            ];
                        }
                    }
                    if($store['is_room_status']==2){
                        if($value['room_status']==2){
                            $value['room_status_data']=[
                                'title'=>'待打扫',
                                'remark'=>'',
                                'status'=>3
                            ];
                        }
                    }
                }
            }
        }
        return fetchJson($list);
    }
    //详情
    public function info()
    {
        $store_id = input('id');
        if(input('is_alliance')==1){
            //联盟数据
            $platform_acid=input('platform_acid');
            $url="https://atroom.youdiy.cn/sass/user.tea_house/storeInfo";
            $res=httpRequest($url,"POST",[
                'platform_acid'=>$platform_acid,
                'id'=>$store_id,
            ]);
            $res=@json_decode($res,true);
            $data=$res['data'];
            $house_list=isset($data['house_list'])?$data['house_list']:[];
            foreach($house_list as &$value){
                $value['is_alliance']=1;
                $value['acid']=$platform_acid;
            }
            $data['house_list']=$house_list;
            return fetchJson($data);
        }
        $store = Store::where(['acid' => $this->acid, 'id' => $store_id])
        // ->field('id,name,address,tags,tel,dec,lng,lat,banner,logo,service_facilities,facilities,policy,is_shop,config,local,video_url,share_img,business_hours,is_repast,is_direct_checkout,is_room_status')
        ->withoutField('account,password,access_token,store_manager,shop_banner,sort,wx_mch_id,wx_key,wx_sslcert,wx_sslkey,wx_sub_config,douyin_poi_id,douyin_config,meituan_open_shop_uuid,meituan_config,smart_device,lvmi_developer,lvmi_device,counter_config,printer1_config,printer2_config,book_interval_status,advanced_clean,is_repeat_order_original,video_url,create_time,update_time')
        ->cache(30)->find();
        if (!$store) {
            return fetchJson([], '暂无数据', 1);
        }
        $store['banner'] = get_file_urls($store['banner']);
        $store['logo'] = get_file_url($store['logo']);
        $store['logo'] = str_replace("http://", "https://", $store['logo']);
        $tags = Tags::where(['acid' => $this->acid])->where('id', 'in', explode(',', $store['tags']))->column('id,title');
        $store['tags'] = $tags;
        $config = json_decode($store['config'], 1);
        $store['wifi_username'] = isset($config['wifi_config']['username']) ? $config['wifi_config']['username'] : '';
        $store['wifi_password'] = isset($config['wifi_config']['password']) ? $config['wifi_config']['password'] : '';
        $icon_config = isset($config['icon_config']['home']['icon']) ? $config['icon_config'] : [];
        $icon_config = isset($config['icon_config']['home']['icon']) ? $config['icon_config'] : [];
        $business_hours = json_decode($store['business_hours'], 1);
        if (isset($business_hours['start_time']) && isset($business_hours['end_time'])) {
            if ($business_hours['start_time'] == $business_hours['end_time']) {
                $business_hours['start_time'] = '00:00';
                $business_hours['end_time'] = '24:00';
            }
        }
        $is_bus_time = 0;
        $bus_start = 0;
        $bus_end = 0;
        $is_antitone = 0;
        $dateTime = input('date') ? strtotime(input('date')) : strtotime(date('Y-m-d'));
        //是否反序
        if (isset($business_hours['start_time']) && isset($business_hours['end_time'])) {
            $bus_start = date('Y-m-d ', $dateTime) . $business_hours['start_time'];
            $bus_end = date('Y-m-d ', $dateTime) . $business_hours['end_time'];
            if ($bus_end != $bus_start) {
                $is_bus_time = 1;
                if (strtotime($bus_end) < strtotime($bus_start)) {
                    $is_antitone = 1;
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                } else {
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                }
            }
        }


        $store['business_hours'] = $business_hours;
        if (!$icon_config) {
            $url = request()->domain() . str_replace('index.php', '', request()->baseFile()) . 'static/shared/';
            $icon_config = ['home' => ['title' => '首页', 'status' => 1, 'icon' => $url . 'store_icon/home.png'], 'shop' => ['title' => '茶城', 'status' => 1, 'icon' => $url . 'store_icon/shop.png'], 'kefu' => ['title' => '客服', 'status' => 1, 'icon' => $url . 'store_icon/kefu.png'], 'wifi' => ['title' => 'WiFi', 'status' => 1, 'icon' => $url . 'store_icon/wifi.png'], 'code' => ['title' => '商家码', 'status' => 1, 'icon' => $url . 'store_icon/code.png']];
        }
        $store['select_name'] = isset($config['select_name']) ? $config['select_name'] : '';
        $store['icon_config'] = $icon_config;
        $keyword = input('keyword');
        $query = House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $store_id, 'status' => 1]);

        $house_ids = HouseOrder::where(['acid' => $this->acid, 'store_id' => $store_id])
        ->where('status', 'in', '1,2')
        ->where('start_time', '<', time())
        ->where('end_time', '>', time())
        ->distinct(true)
        ->field('house_id')
        ->column('house_id');
        if ($house_ids) {
            $house_ids = implode(',', $house_ids);
            $query->orderRaw('field(id,' . $house_ids . ') ASC,sort ASC');
        } else {
            $query->order('sort ASC');
        }
        $list = $query->withoutField('lvelectricty_line_config,electricty_line_config,servicing_time,could_sound,electricityid')->cache(60)->select()->toArray();
        $discount = Card::where(['acid' => $this->acid, 'is_delete' => 0])->order('discount ASC')->value('discount');
        $cover_ids = [];
        $house_id_arr = [];
        $package_price_id = '';
        $package_price = [];
        $todayRoomTime=strtotime(date('Y-m-d'))+86400;
        foreach ($list as $key => &$value) {
            $banner = explode(',', $value['banner']);
            $cover_ids = array_merge($cover_ids, $banner);
            $house_id_arr[] = $value['id'];
            $value['is_alliance']=0;
            if (!$discount) {
                $value['member_price'] = -1;
            } else {
                if ($value['member_price'] <= 0) {
                    $value['member_price'] = $value['price'] * $discount * 0.1;
                    $value['member_price'] = round($value['member_price'], 2);
                }
            }
            $value['package_price'] = json_decode($value['package_price'], 1);
            $value['discount'] = $discount;
            if (!$package_price) {
                $package_price = $value['package_price'];
                $package_price_id = $value['id'];
            }
            $value['booktime'] = $value['booktime'] * 1;
            //今天
            $stockToday = HouseStock::where(['acid' => $value['acid'], 'store_id' => $value['store_id'], 'house_id' => $value['id'], 'date' => $dateTime, 'status' => 0])->order('hour ASC')->column('hour,status,order_id');
            $tomorrowtime = $dateTime + 86400;
            $stockTomorrow = HouseStock::where(['acid' => $value['acid'], 'store_id' => $value['store_id'], 'house_id' =>$value['id'], 'date' => $tomorrowtime, 'status' => 0])->column('hour,status,order_id');
            $allstock = array_merge($stockToday, $stockTomorrow);
            $allstock = array_column($allstock, 'status', 'hour');
            $value['facility_servicing_list'] = Facility::where('id', 'in', $value['facility_servicing'])->column('id,title');
            $priceData=[];
            $price_list = json_decode($value['price_list'], 1);
            if ($price_list) {
                $priceData = array_column($price_list, 'price', 'time');
            }
            $servicing_today_time = [];
            $servicing_tomorrow_time = [];

            for ($j = 0; $j < 24; $j++) {
                $time = strtotime(date('Y-m-d H:i', $dateTime)) + 3600 * $j;
                $timeTomorrow = strtotime(date('Y-m-d H:i', $dateTime + 86400)) + 3600 * $j;
                $t = date('H', $time);
                $tt = date('H', $timeTomorrow);
                //是否有营业时间
                if ($is_bus_time == 1) {
                    //正序
                    if ($is_antitone == 0) {
                        if ($time >= $bus_startNew && $time < $bus_endNew) {
                            $servicing_today_time[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                        } else {
                            $servicing_today_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                        }
                    } else {
                        if ($time >= $bus_startNew && $time < $bus_endNew) {
                            $servicing_today_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                        } else {
                            $servicing_today_time[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                        }
                    }
                } else {
                    $servicing_today_time[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 1 : $value['price'] / 1];
                }
                 //明日时间表//新加的
                //是否有营业时间
                if ($is_bus_time == 1) {
                    //正序
                    if ($is_antitone == 0) {
                        if ($timeTomorrow >= $bus_startTom && $timeTomorrow < $bus_endTom) {
                            $servicing_tomorrow_time[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                        } else {
                            $servicing_tomorrow_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                        }
                    } else {
                        if ($timeTomorrow >= $bus_startTom && $timeTomorrow < $bus_endTom) {
                            $servicing_tomorrow_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                        } else {
                            $servicing_tomorrow_time[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                        }
                    }
                } else {
                    $servicing_tomorrow_time[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $value['price'] / 2];
                }



            }
            $value['servicing_today_time'] = $servicing_today_time;
            $value['servicing_tomorrow_time'] = $servicing_tomorrow_time;
            $value['room_status_data']=[];
            if(isset($store['is_show_room_status'])){
                //if($store['is_show_room_status']==1&&$store['is_room_status']==0){
                if($store['is_show_room_status']==1){
                    $hour=HouseOrderContinue::where(['acid' => $this->acid,'house_id'=>$value['id']])->where('status','in','1,2')->whereBetweenTimeField('start_time', 'end_time')->order('end_time DESC')->value('end_time');
                    if(!$hour){
                        $hour=HouseOrder::where(['acid' => $this->acid,'house_id'=>$value['id']])->where('status','in','1,2')->whereBetweenTimeField('start_time', 'end_time')->order('end_time DESC')->value('end_time');
                    }
                    // $hour=HouseStock::where(['acid' => $this->acid,'house_id'=>$value['id'],'status'=>0])->where('hour', ">", time())->where('hour','<',$todayRoomTime)->order('hour DESC')->value('hour');
                    if($hour){
                        $value['room_status_data']=[
                            'title'=>'使用中',
                            'remark'=>date('H:i',$hour).'结束',
                            'status'=>2
                        ];
                    }else{
                        if($value['room_status']==2){
                            $value['room_status_data']=[
                                'title'=>'待打扫',
                                'remark'=>'',
                                'status'=>3
                            ];
                        }else{
                            $value['room_status_data']=[
                                'title'=>'可预订',
                                'remark'=>'',
                                'status'=>1
                            ];
                        }
                    }
                    if($store['is_room_status']==2){
                        if($value['room_status']==2){
                            $value['room_status_data']=[
                                'title'=>'待打扫',
                                'remark'=>'',
                                'status'=>3
                            ];
                        }
                    }
                }
            }
        }
        $store['package_price_id'] = $package_price_id;
        $store['package_price'] = $package_price;
        $houseOrderCountArr = HouseOrder::where(['acid' => $this->acid, 'is_pay' => 1])->where('house_id', 'in', $house_id_arr)->where('status', '<>', 4)->field('house_id,count(house_id) booknum')->group('house_id')->select();
        if ($houseOrderCountArr) {
            $houseOrderCountArr = $houseOrderCountArr->toArray();
            $houseOrderCountArr = array_column($houseOrderCountArr, 'booknum', 'house_id');
        }
        $houseStockCountArr = HouseStock::where(['acid' => $this->acid])->where('house_id', 'in', $house_id_arr)->where('hour', "<", time() + 2 * 3600)->where('hour', ">", time())->field('house_id,count(house_id) booknum')->group('house_id')->select();
        if ($houseStockCountArr) {
            $houseStockCountArr = $houseStockCountArr->toArray();
            $houseStockCountArr = array_column($houseStockCountArr, 'booknum', 'house_id');
        }
        $get_cache_file_urls = get_cache_file_urls($cover_ids);
        foreach ($list as $key => &$value) {
            $banner = explode(',', $value['banner']);
            foreach ($banner as $k => $v) {
                $banner[$k] = isset($get_cache_file_urls[$v]) ? $get_cache_file_urls[$v] : '';
            }
            $value['banner_list'] = $banner;
            //预定数量
            $value['booknum'] = isset($houseOrderCountArr[$value['id']]) ? $houseOrderCountArr[$value['id']] : 0;
            $virtual_sales = isset($value['virtual_sales']) ? $value['virtual_sales'] : 0;
            $value['booknum'] += $virtual_sales;
            $value['is_book'] = isset($houseStockCountArr[$value['id']]) ? 1 : 0;
        }
        $user_id = User::where('access_token', input('access_token'))->value('id');
        $cardUser = CardUser::alias('c_u')->leftJoin([Card::getTable() => 'c'], 'c_u.card_id=c.id')->where(['c_u.status' => 1, 'c_u.user_id' => $user_id, 'c.is_delete' => 0])->where('c_u.start_time', '<', time())->where('c_u.end_time', '>', strtotime(date('Y-m-d', time() + 86400)))->order('c_u.level DESC')->field('c_u.*,c.discount')->find();
        $discount = -1;
        if ($cardUser) {
            $discount = $cardUser['discount'];
        }
        $store['user_discount'] = $discount;
        //商户访问量
        \app\shared\model\UserUv::todayUv($this->acid, 1, $store['id'], $user_id, $store['id']);
        $storeUser = [];
        if ($user_id = input('user_id')) {
            $storeUser = StoreUserMoney::where(['acid' => $this->acid, 'store_id' => $store['id'], 'user_id' => $user_id])->field('money,tea_money')->find();
        }
        $is_counter = Counter::where(['store_id' => $store['id'], 'is_delete' => 0, 'status' => 1])->limit(1)->count();
        $is_hotel = House::where(['store_id' => $store['id'], 'is_delete' => 0, 'status' => 1,'type'=>2])->limit(1)->count();
        return fetchJson(['info' => $store, 'storeUser' => $storeUser, 'house_list' => $list, 'is_counter' => $is_counter,'is_hotel'=>$is_hotel>0?1:0]);
    }
    //商户列表
    public function list()
    {
        $lat = input('lat') ? input('lat') : 0;
        $lng = input('lng') ? input('lng') : 0;
        if ($lng == 'undefined') {
            $lng = 0;
        }
        if ($lat == 'undefined') {
            $lat = 0;
        }
        $app_home_theme=Option::get_data($this->acid,'shared','app_home_theme',10);
        $app_home_theme=@json_decode($app_home_theme,true);
        if($app_home_theme['type']=='selected_lm'){
            $is_unify_login=1;
        }else{
            $is_unify_login=0;
        }
        if($is_unify_login){
            $url="https://atroom.youdiy.cn/index.php?_acid=1&_version=1.1.23&platform=wxapp&s=/sass/user.tea_house/storeList";
            $area_id=input('area_id');
            $res=httpRequest($url,"POST",[
                'lng'=>$lng,
                'lat'=>$lat,
                'city_id'=>$area_id,
                'page'=>$this->page
            ]);
            $res=@json_decode($res,true);
            $data=$res['data'];
            $app=App::find($this->acid);
            foreach($data as &$value){
                if($value['wxapp_app_id']==$app['wxapp_app_id']){
                    $value['is_alliance']=0;
                }else{
                    $value['is_alliance']=1;
                }
            }
            return fetchJson($data);
        }
        $query = Store::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1])->field('id,name,logo,banner,local,is_list_open,config,is_room_status,address,douyin_poi_id,business_hours,tel,lat,lng,score,(6378.138 * 2 * asin(sqrt(pow(sin((lat * pi() / 180 - ' . $lat . ' * pi() / 180) / 2),2) + cos(lat * pi() / 180) * cos(' . $lat . ' * pi() / 180) * pow(sin((lng * pi() / 180 - ' . $lng . ' * pi() / 180) / 2),2))) * 1000) as distance');
        if ($keyword = input('keyword')) {
            $query->where('name', 'like', "%{$keyword}%");
        }
        if($is_check_ticket=input('is_check_ticket')){
            $query->where('douyin_poi_id','<>',null);
        }
        if($poi_id=input('poi_id')){
            $query->where('douyin_poi_id',$poi_id);
        }
        if ($area_id = input('area_id')) {
            $query->where('area_id', $area_id);
        }
        if ($category = input('category')) {
            $query->whereFindInSet('category', $category);
        }
        $new_sort=input('new_sort');
        if($new_sort==1){//距离
            $query->order('distance ASC');
        }else if($new_sort==2){//置顶
            $query->order('sort ASC');
        }else if($new_sort==3){//价格低到高
             $query->order('tea_price ASC');
        }else if($new_sort==4){//高到低
             $query->order('tea_price DESC');
        }else{
            $query->order('distance ASC');
        }
        $query->page($this->page);
        if ($limit = input('limit')) {
            $query->limit($limit);
        }
        $list = $query->cache(30)->select();
        $discount = Card::where(['acid' => $this->acid, 'is_delete' => 0])->order('discount ASC')->value('discount');
        foreach ($list as $key => &$value) {
            $value['logo'] = get_file_url($value['logo']);
            $value['banner_list'] = get_file_urls($value['banner']);
            $house = House::where(['acid' => $this->acid, 'is_delete' => 0, 'store_id' => $value['id'], 'status' => 1])
            ->field('id,booktime,half_price,price,original_price,package_price')
            ->order('booktime ASC')
            ->orderRaw("field(package_price,'[]') ASC")
            ->find();
            if (!$house) {
                $value['price'] = 0;
                $value['booktime'] = 1;
                $value['business_time'] = "00:00-24:00";
            } else {
                $house['booktime'] = $house['booktime'] ? $house['booktime'] : 1;
                $value['price'] = $house['price'] * $house['booktime'];
                $value['booktime'] = $house['booktime'];
                $value['original_price'] = $house['original_price'];
                $value['business_time'] = "00:00-24:00";
                if (!$discount) {
                    $value['member_price'] = -1;
                } else {
                    if ($value['member_price'] <= 0) {
                        $value['member_price'] = $value['price'] * $discount * 0.1;
                        $value['member_price'] = round($value['member_price'], 2);
                    }
                }
                $value['discount'] = $discount;
                $value['local'] = json_decode($value['local'], 1);
            }
            $order_book_time=HouseOrder::where(['store_id'=>$value['id']])->where('status','in','1,2')->whereDay('create_time')->order('create_time desc')->value('create_time');
            if($order_book_time){
                $order_book_time=date('Y-m-d H:i:s',$order_book_time);
                $order_book_time=format_date($order_book_time).'有人预定';
            }else{
                $order_book_time=0;
            }
            $value['order_book_time']=$order_book_time;
            $value['house_id'] = $house['id'];
            $value['package_price'] = json_decode($house['package_price'], true);
            $config = json_decode($value['config'], 1);
            $value['select_name'] = isset($config['select_name']) ? $config['select_name'] : '茶厅';
            $business_hours=@json_decode($value['business_hours'], 1);
            if(isset($business_hours['start_time'])&&isset($business_hours['end_time'])){
                $business_hours['end_time']=$business_hours['start_time']==$business_hours['end_time']?"24:00":$business_hours['end_time'];
            }
            $value['business_hours'] = $business_hours;
        }
        return fetchJson($list);
    }
    private function changeHouseStock($stockToday)
    {
        $orderNew = [];
        foreach ($stockToday as &$t) {
            $orderNew[$t['order_id']][] = $t;
        }
        foreach ($orderNew as &$n) {
            $n = array_merge([['hour' => $n[0]['hour'] - 1800, 'status' => $n[0]['status'], 'order_id' => $n[0]['order_id']]], $n);
        }
        $stockToday = [];
        foreach ($orderNew as &$d) {
            foreach ($d as $s) {
                $stockToday[] = $s;
            }
        }
        $dateTime = input('date') ? strtotime(input('date')) : time();
        $stockDatas = [];
        for ($j = 0; $j < 96; $j++) {
            $time = strtotime(date('Y-m-d H:i', $dateTime)) + 1800 * $j;
            foreach ($stockToday as $v) {
                if ($time > $v['hour'] - 1800 && $time < $v['hour'] + 1800) {
                    $stockDatas[$time] = ['hour' => $time, 'status' => $v['status'], 'order_id' => $v['order_id']];
                }
            }
        }
        return $stockDatas;
    }
    //房型日期价格
    public function houseDatePrice()
    {
        $form = House::where(['acid' => $this->acid, 'is_delete' => 0, 'id' => input('house_id'), 'status' => 1])->cache(30)->find();
        if (!$form) {
            return fetchJson([], '暂无数据', 1);
        }
        $dateTime = input('date') ? strtotime(input('date')) : strtotime(date('Y-m'));
        $month=date('Y-m',$dateTime);
        $monthDate=monthDate($dateTime);
        $bookDate=[];
        $stockDate=[];
        $stock=HouseRoomStock::where(['house_id'=>$form['id']])->whereMonth('date',$month)->column('id,date,price,status');
        foreach($stock as $dayStock){
            $stockDate[$dayStock['date']]=[
                'price'=>$dayStock['price'],
                'day'=>$dayStock['date'],
                'status'=>$dayStock['status']>0?1:0,
            ];
        }
        $todayTime=strtotime(date('Y-m-d'));
        foreach($monthDate as $key=>$day){
            $dayTime=strtotime($day);
            if(isset($stockDate[$day])){
                $data=$stockDate[$day];
                if($todayTime<=$dayTime){
                    $data['is_exceed']=1;
                }else{
                    $data['is_exceed']=0;
                }
                $bookDate[]=$data;
            }else{
                if($todayTime<=$dayTime){
                    $is_exceed=1;
                }else{
                    $is_exceed=0;
                }
                $bookDate[]=[
                    'price'=>$form['price'],
                    'day'=>$day,
                    'status'=>0,
                    'is_exceed'=>$is_exceed
                ];
            }
        }
        return fetchJson([
            'bookDate'=>$bookDate,
        ]);
    }
    //茶室信息
    public function houseInfo()
    {
        $form = House::where(['acid' => $this->acid, 'is_delete' => 0, 'id' => input('house_id'), 'status' => 1])->cache(30)->find();
        if (!$form) {
            return fetchJson([], '暂无数据', 1);
        }
        $dateTime = input('date') ? strtotime(input('date')) : strtotime(date('Y-m-d'));
        $store = Store::where(['id' => $form['store_id']])->find();
        $business_hours = $store['business_hours'];
        $business_hours = json_decode($business_hours, 1);
        $is_bus_time = 0;
        $bus_start = 0;
        $bus_end = 0;
        $is_antitone = 0;
        $form['banner_list'] = get_file_urls($form['banner']);
        $form['facility_servicing_list'] = Facility::where('id', 'in', $form['facility_servicing'])->column('id,title');
        $form['tel'] = $store['tel'];
        $form['local'] = $store['local'];
        $form['lat'] = $store['lat'];
        $form['lng'] = $store['lng'];
        $form['address'] = $store['address'];
        $form['is_wallet'] = $store['is_wallet'];
        //判断是否是民宿
        if($form['type']==2){
            $monthDate=monthDate($dateTime);
            $bookDate=[];
            foreach($monthDate as $day){
                $bookDate[]=[
                    'price'=>$form['price'],
                    'day'=>$day,
                    'status'=>1
                ];
            }
            $form['bookDate']=$bookDate;
            return fetchJson($form);
        }
        //是否反序
        if (isset($business_hours['start_time']) && isset($business_hours['end_time'])) {
            $bus_start = date('Y-m-d ', $dateTime) . $business_hours['start_time'];
            $bus_end = date('Y-m-d ', $dateTime) . $business_hours['end_time'];
            if ($bus_end != $bus_start) {
                $is_bus_time = 1;
                if (strtotime($bus_end) < strtotime($bus_start)) {
                    $is_antitone = 1;
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                } else {
                    $bus_startNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['start_time']);
                    $bus_endNew = strtotime(date('Y-m-d ', $dateTime) . $business_hours['end_time']);
                    $bus_startTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['start_time']);
                    $bus_endTom = strtotime(date('Y-m-d ', $dateTime + 86400) . $business_hours['end_time']);
                }
            }
        }
        $form['package_price'] = json_decode($form['package_price'], 1);
        //___________________________________________________
        //今天
        $stockToday = HouseStock::where(['acid' => $this->acid, 'store_id' => $form->store_id, 'house_id' => $form['id'], 'date' => $dateTime, 'status' => 0])->order('hour ASC')->column('hour,status,order_id');
        $tomorrowtime = $dateTime + 86400;
        $stockTomorrow = HouseStock::where(['acid' => $this->acid, 'store_id' => $form->store_id, 'house_id' => $form['id'], 'date' => $tomorrowtime, 'status' => 0])->column('hour,status,order_id');
        $allstock = array_merge($stockToday, $stockTomorrow);
        $orderNew = [];
        $allstock = self::changeHouseStock($allstock);
        $allstock = array_column($allstock, 'status', 'hour');
        $servicing_today_time = [];
        $price_list = json_decode($form['price_list'], 1);
        if ($price_list) {
            $priceData = array_column($price_list, 'price', 'time');
        }
        
        for ($j = 0; $j < 49; $j++) {
            $time = strtotime(date('Y-m-d H:i', $dateTime)) + 1800 * $j;
            $timeTomorrow = strtotime(date('Y-m-d H:i', $dateTime + 86400)) + 1800 * $j;
            $t = date('H', $time);
            $tt = date('H', $timeTomorrow);
            //是否有营业时间
            if ($is_bus_time == 1) {
                //正序
                if ($is_antitone == 0) {
                    if ($time >= $bus_startNew && $time < $bus_endNew) {
                        $servicing_today_time[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 2 : $form['price'] / 2];
                    } else {
                        $servicing_today_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 2 : $form['price'] / 2];
                    }
                } else {
                    if ($time >= $bus_startNew && $time < $bus_endNew) {
                        $servicing_today_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 2 : $form['price'] / 2];
                    } else {
                        $servicing_today_time[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 2 : $form['price'] / 2];
                    }
                }
            } else {
                $servicing_today_time[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] / 2 : $form['price'] / 2];
            }
            //明日时间表
            //是否有营业时间
            if ($is_bus_time == 1) {
                //正序
                if ($is_antitone == 0) {
                    if ($timeTomorrow >= $bus_startTom && $timeTomorrow < $bus_endTom) {
                        $servicing_tomorrow_time[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $form['price'] / 2];
                    } else {
                        $servicing_tomorrow_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $form['price'] / 2];
                    }
                } else {
                    if ($timeTomorrow >= $bus_startTom && $timeTomorrow < $bus_endTom) {
                        $servicing_tomorrow_time[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $form['price'] / 2];
                    } else {
                        $servicing_tomorrow_time[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $form['price'] / 2];
                    }
                }
            } else {
                $servicing_tomorrow_time[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt] / 2 : $form['price'] / 2];
            }
        }
        $form['servicing_today_time'] = $servicing_today_time;
        $form['servicing_tomorrow_time'] = $servicing_tomorrow_time;
        $servicing_today_hour=[];
        $servicing_tomorrow_hour=[];
        for ($j = 0; $j < 24; $j++) {
            $time = strtotime(date('Y-m-d H:i', $dateTime)) + 3600 * $j;
            $timeTomorrow = strtotime(date('Y-m-d H:i', $dateTime + 86400)) + 3600 * $j;
            $t = date('H', $time);
            $tt = date('H', $timeTomorrow);
            //是否有营业时间
            if ($is_bus_time == 1) {
                //正序
                if ($is_antitone == 0) {
                    if ($time >= $bus_startNew && $time < $bus_endNew) {
                        $servicing_today_hour[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t]  : $form['price'] ];
                    } else {
                        $servicing_today_hour[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t]  : $form['price']];
                    }
                } else {
                    if ($time >= $bus_startNew && $time < $bus_endNew) {
                        $servicing_today_hour[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t] : $form['price']];
                    } else {
                        $servicing_today_hour[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t]  : $form['price'] ];
                    }
                }
            } else {
                $servicing_today_hour[] = ['status' => isset($allstock[$time]) ? $allstock[$time] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$t]) ? $priceData[$t]  : $form['price'] ];
            }
            //明日时间表
            //是否有营业时间
            if ($is_bus_time == 1) {
                //正序
                if ($is_antitone == 0) {
                    if ($timeTomorrow >= $bus_startTom && $timeTomorrow < $bus_endTom) {
                        $servicing_tomorrow_hour[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt]  : $form['price'] ];
                    } else {
                        $servicing_tomorrow_hour[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt]  : $form['price'] ];
                    }
                } else {
                    if ($timeTomorrow >= $bus_startTom && $timeTomorrow < $bus_endTom) {
                        $servicing_tomorrow_hour[] = ['status' => 0, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt]: $form['price'] ];
                    } else {
                        $servicing_tomorrow_hour[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt]  : $form['price'] ];
                    }
                }
            } else {
                $servicing_tomorrow_hour[] = ['status' => isset($allstock[$timeTomorrow]) ? $allstock[$timeTomorrow] : 1, 'time' => date('H:i', $time), 'price' => isset($priceData[$tt]) ? $priceData[$tt]  : $form['price'] ];
            }
        }
        $form['servicing_today_hour'] = $servicing_today_hour;
        $form['servicing_tomorrow_hour'] = $servicing_tomorrow_hour;
        
        $discount = Card::where(['acid' => $this->acid, 'is_delete' => 0])->order('discount ASC')->value('discount');
        if (!$discount) {
            $form['member_price'] = -1;
        } else {
            if ($form['member_price'] <= 0) {
                $form['member_price'] = $form['price'] * $discount * 0.1;
                $form['member_price'] = round($form['member_price'], 2);
            }
        }
        $form['price_list']=$price_list;
        $form['douyin_poi_id']=$store['douyin_poi_id'];
        $form['store_name']=$store['name'];
        $form['discount'] = $discount;
        $form['booknum'] = HouseOrder::where(['acid' => $this->acid, 'is_pay' => 1, 'house_id' => $form['id']])->where('status', '<>', 4)->count();
        $virtual_sales = isset($form['virtual_sales']) ? $form['virtual_sales'] : 0;
        $form['booknum'] += $virtual_sales;
        $form['is_book'] = HouseStock::where(['acid' => $this->acid, 'store_id' => $form->store_id, 'house_id' => $form['id']])->where('hour', "<", time() + $form['booktime'] * 3600)->where('hour', ">", time())->count();
        $form['is_book'] = $form['is_book'] > 0 ? 1 : 0;
        //茶室访问量
        $user_id = User::where('access_token', input('access_token'))->value('id');
        \app\shared\model\UserUv::todayUv($this->acid, 2, $form['store_id'], $user_id, $form['id']);
        $user_cash_grade = Usercashgrade::whereFindInSet('store_ids', $form['store_id'])->where(['acid' => $this->acid, 'status' => 1, 'is_delete' => 0])->column('id');
        $form['is_can_book'] = 1;
        if ($user_cash_grade) {
            $user_cash_grade_id = User::where('access_token', input('access_token'))->value('user_cash_grade_id');
            if (!in_array($user_cash_grade_id, $user_cash_grade)) {
                $form['is_can_book'] = 0;
            }
        }
        if (isset($business_hours['start_time']) && isset($business_hours['end_time'])) {
            if ($business_hours['start_time'] == $business_hours['end_time']) {
                $business_hours['start_time'] = '00:00';
                $business_hours['end_time'] = '24:00';
            }
        }
        $form['business_hours']=$business_hours;
        return fetchJson($form);
    }
    //二维码
    public function qrcode()
    {
        $app = App::where('id', $this->acid)->cache(10)->find();
        $store_id = input('id');
        $wxappPath = 'aboutTea/teaStoreDetail?id=' . $store_id;
        $url = qrcodeUrl($this->acid, $wxappPath, $dirname = "store", $filename = $store_id);
        return fetchJson(['qrcode_url' => $url]);
    }
    //申请成为商家
    public function applyBecomeStore()
    {
        $that = new UserForm();
        $data = request()->post();
        try {
            $rule = ['account|账号' => 'require', 'area_id|区域ID' => 'require', 'name|名称' => 'require'];
            $this->validate($data, $rule);
        } catch (ValidateException $e) {
            return fetchJson([], $e->getError(), 1);
        }
        $form = ApplyBecomeStore::where(['user_id' => $that->user_id, 'status' => 0])->find();
        if ($form) {
            return fetchJson([], '已有提交申请，请等待审核通过', 1);
        }
        // $store=Store::where(['account'=>$data['account'],'is_delete'=>1])->count();
        // if($store){
        //    return fetchJson([],'请用其他账号注册',1);
        // }
        $form = new ApplyBecomeStore();
        $form->save(['acid' => $this->acid, 'user_id' => $that->user_id, 'account' => $data['account'], 'area_id' => $data['area_id'], 'name' => $data['name'], 'logo' => 0, 'banner' => 0, 'address' => 0, 'lng' => 0, 'lat' => 0]);
        return fetchJson([], '提交成功');
    }
    //优惠券列表
    public function couponList()
    {
        $user = new UserForm();
        $user_id = $user->user_id;
        $store_id = input('store_id');
        $type = input('type');
        $query = StoreCouponUser::alias('a')->leftJoin([StoreCoupon::getTable() => 'b'], 'a.coupon_id=b.id')->where(['a.is_use' => 0, 'a.user_id' => $user_id, 'a.store_id' => $store_id])->where('b.start_time', '<=', time());
        if ($type) {
            $query->where('a.type', 'in', $type);
        }
        $list = $query->where('b.end_time', '>=', strtotime(date('Y-m-d', time())) + 86399)->field('b.start_time,b.end_time,b.price,b.full_price,b.name,a.id,a.is_use,a.type,a.use_time,b.detail')->page($this->page)->select()->toArray();
        foreach ($list as $key => &$value) {
            $value['end_time'] = date('Y-m-d', $value['end_time']);
            $value['start_time'] = date('Y-m-d', $value['start_time']);
        }
        return fetchJson($list);
    }
    /**
     * 领券中心
     * @return \think\response\Json
     */
    public function couponCenter()
    {
        $user = new UserForm();
        $user_id = $user->user_id;
        $store_id = input('store_id');
        $condition = [['a.status', '=', 1], ['a.store_id', '=', $store_id], ['a.send_type', '=', StoreCoupon::SEND_TYPE_RECEIVE], ['a.end_time', '>', time()], ['a.is_delete', '=', 0]];
        $list = StoreCoupon::where($condition)->alias('a')->leftJoin([StoreCouponUser::getTable() => 'b'], 'a.id=b.coupon_id and b.user_id=' . $user_id)->whereNull('b.id')->order('a.id desc')->field('a.*')->select();
        return fetchJson($list);
    }
    /**
     * 领取优惠券
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function receiveCoupon()
    {
        $user = new UserForm();
        $user_id = $user->user_id;
        $coupon_id = (int) input('coupon_id');
        $condition = [['id', '=', $coupon_id], ['status', '=', 1], ['send_type', '=', StoreCoupon::SEND_TYPE_RECEIVE], ['end_time', '>', time()], ['is_delete', '=', 0]];
        $coupon = StoreCoupon::where($condition)->find();
        if (!$coupon) {
            return fetchJson([], '所领优惠券不存在');
        }
        $user_coupon = StoreCouponUser::where(['user_id' => $user_id, 'coupon_id' => $coupon_id])->find();
        if (!$user_coupon) {
            $create = ['acid' => $this->acid, 'store_id' => $coupon->store_id, 'coupon_id' => $coupon_id, 'type' => $coupon->type, 'user_id' => $user_id, 'is_use' => 0];
            StoreCouponUser::create($create);
            return fetchJson([], '领取成功');
        } else {
            return fetchJson([], '不可重复领取', 1);
        }
    }
    //充值金额
    public function recharge()
    {
        $user = new UserForm();
        $money = input('money');
        if ($money < 0) {
            return fetchJson([], '金额不得小于0', 1);
        }
        $store_id = input('store_id');
        if (!Store::where(['id' => $store_id, 'is_delete' => 0, 'status' => 1, 'acid' => $this->acid])->count()) {
            return fetchJson([], '暂无商户ID', 1);
        }
        $order = new StoreRechargeOrder();
        $order->order_no = StoreRechargeOrder::crateOrderNo();
        $order->money = $money;
        $order->acid = $this->acid;
        $order->user_id = $user->user_id;
        $order->store_id = $store_id;
        $app = App::find($this->acid);
        $appid = $app->wxapp_app_id;
        $app_secret = $app->wxapp_app_secret;
        $openid = $user->user->wxapp_open_id;
        $platformRecharge = Recharge::where(['acid' => $order->acid, 'status' => 1, 'is_delete' => 0, 'store_status' => 1, 'price' => $money])->find();
        if ($platformRecharge) {
            $rechNum=StoreRechargeOrder::where(['user_id'=>$user->user_id,'is_pay'=>1,'money'=>$money])
            ->where(function ($query){
                $query->where('card_ids','<>',null)
                      ->whereOr('platform_coupon_ids','<>',null);
            })->count();
            if(!($rechNum>=$platformRecharge['people_num']&&$platformRecharge['people_num']>0)){
                $order->platform_coupon_ids = $platformRecharge->coupon_ids;
                $order->card_ids = $platformRecharge->card_ids;
                $order->give_price = $platformRecharge->give_price;
            }
        }else{
            $recharge = StoreRecharge::where(['acid' => $order->acid, 'status' => 1, 'is_delete' => 0, 'store_id' => $store_id, 'price' => $money])->find();
            if ($recharge) {
                $order->give_price = $recharge->give_price;
                $order->give_tea_price = $recharge->give_tea_price;
                $order->coupon_ids = $recharge->coupon_ids;
                $order->card_ids = -1;
            }
        }
        $order->save();
        if (input('is_weixin') == 1) {
            $appid = $app->wx_app_id;
            $app_secret = $app->wx_app_secret;
            $openid = $user->user->wx_open_id;
        }
        //App
        if ($this->platform == 'app' || $this->platform == 'ios' || $this->platform == 'android') {
            $appConfig = Option::get_data($this->acid, 'platform', 'app_config');
            $appConfig = json_decode($appConfig);
            $appid = isset($appConfig->appid) ? $appConfig->appid : '';
            $app_secret = isset($appConfig->app_secret) ? $appConfig->app_secret : '';
        }
        $wx_config = ['appid' => $appid, 'appsecret' => $app_secret, 'mchid' => $app->wx_mch_id, 'key' => $app->wx_key, 'sslcert' => $app->wx_cert_pem, 'sslkey' => $app->wx_key_pem];
        if (isset($app->wx_pay_type)) {
            $storeWx = Store::where('id', $store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey,fee,wx_sub_config')->find();
            //服务商模式
            if ($app->wx_pay_type == 2) {
                $wx_config = ['appid' => $appid, 'mchid' => $storeWx['wx_mch_id'] != 0 ? $storeWx['wx_mch_id'] : $app->wx_mch_id, 'wx_server_appid' => $app->wx_server_appid, 'appsecret' => $app_secret, 'wx_server_mch_id' => $app->wx_server_mch_id, 'key' => $app->wx_server_key, 'sslcert' => $app->wx_server_cert_pem, 'sslkey' => $app->wx_server_key_pem, 'sub_appid' => $appid, 'sub_mch_id' => $app->wx_mch_id, 'wx_pay_type' => $app->wx_pay_type];
                $wx_sub_config = json_decode($storeWx['wx_sub_config'], 1);
                if (isset($wx_sub_config['recharge']['status'])) {
                    $wx_sub_config['recharge']['status'] = $wx_sub_config['recharge']['status'] * 1;
                    if (isset($wx_sub_config['recharge']['fee']) && $wx_sub_config['recharge']['status'] == 1) {
                        $store_fee = $wx_sub_config['recharge']['fee'];
                        $order->sub_account_status = 1;
                        $order->save();
                        $wx_config['wx_profit_sharing'] = $app->wx_profit_sharing;
                    }
                }
            } else {
                if ($storeWx['wx_mch_id']) {
                    $wx_config = ['appid' => $appid, 'appsecret' => $app_secret, 'mchid' => $storeWx['wx_mch_id'], 'key' => $storeWx['wx_key'], 'sslcert' => $storeWx['wx_sslcert'], 'sslkey' => $storeWx['wx_sslkey']];
                    $wx_sub_config = json_decode($storeWx['wx_sub_config'], 1);
                    if (isset($wx_sub_config['recharge']['status'])) {
                        $wx_sub_config['recharge']['status'] = $wx_sub_config['recharge']['status'] * 1;
                        if (isset($wx_sub_config['recharge']['fee']) && $wx_sub_config['recharge']['status'] == 1) {
                            $store_fee = $wx_sub_config['recharge']['fee'];
                            $order->sub_account_status = 1;
                            $order->save();
                            $wx_config['wx_profit_sharing'] = $app->wx_profit_sharing;
                        }
                    }
                }
            }
        }
        $wechatPay = new WechatPay($wx_config);
        $notify_url = request()->domain() . str_replace('index.php', 'pay_shared.php', request()->baseFile());
        $paydata = ['body' => '余额充值', 'out_trade_no' => $order->order_no, 'total_fee' => round($order->money, 2) * 100, 'notify_url' => $notify_url, 'trade_type' => 'JSAPI', 'openid' => $openid];
        //字节跳动支付
        if ($this->platform == 'ttapp') {
            $paydata = ['body' => '余额充值', 'appid' => $app->wx_app_id, 'attach' => '余额充值', 'mch_id' => $app->mch_id, 'notify_url' => $notify_url, 'out_trade_no' => $order->order_no, 'total_fee' => round($order->money, 2) * 100, 'trade_type' => 'MWEB', 'openid' => $openid, 'scene_info' => '{"h5_info":{"type":"Wap","wap_url":"' . request()->domain() . '","wap_name":"测试支付"}}'];
            $ttapp = Option::get_data($this->acid, 'platform', 'ttapp_config');
            $ttapp = json_decode($ttapp);
            $res = $wechatPay->toutiaoh5pay($paydata, $ttapp);
            if ($res['code'] == 0) {
                return fetchJson($res);
            } else {
                return fetchJson([], $res['msg'], 1);
            }
        }
        //微信外部支付
        if ($this->platform == 'h5' && input('is_weixin') == 0) {
            $paydata = ['body' => '余额充值', 'appid' => $app->wx_app_id, 'attach' => '余额充值', 'mch_id' => $app->mch_id, 'notify_url' => $notify_url, 'out_trade_no' => $order->order_no, 'total_fee' => round($order->money, 2) * 100, 'trade_type' => 'MWEB', 'openid' => $openid, 'scene_info' => '{"h5_info":{"type":"Wap","wap_url":"' . request()->domain() . '","wap_name":"测试支付"}}'];
            $rest['order_id'] = $order->id;
            $res = $wechatPay->h5pay($paydata);
            if ($res['code'] == 0) {
                $rest['mweb_url'] = $res['data'];
                return fetchJson($rest);
            } else {
                return fetchJson([], $res['msg'], 1);
            }
        }
        if ($this->platform == 'app' || $this->platform == 'ios' || $this->platform == 'android') {
            unset($paydata['openid']);
            $paydata['trade_type'] = "APP";
            $res = $wechatPay->appPay($paydata);
        } else {
            $res = $wechatPay->pay($paydata);
        }
        $res['order_id'] = $order->id;
        return fetchJson($res);
    }
    /**
     * 余额明细列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function moneyBill()
    {
        $user = new UserForm();
        $params = request()->only(['status']);
        $store_id = input('store_id');
        $condition = [['b.account_type', '=', Bill::ACCOUNT_TYPE_USER], ['b.form_id', '=', $user->user_id], ['b.is_delete', '=', 0], ['o.store_id', '=', $store_id]];
        if (isset($params['status']) && in_array($params['status'], [1, -1])) {
            $condition[] = ['b.status', '=', $params['status']];
        }
        $query = Bill::alias('b');
        $type = input('type');
        if ($type == Bill::TYPE_STORE_USER_RECHARGE) {
            $query->leftJoin([StoreRechargeOrder::getTable() => 'o'], 'b.order_id=o.id');
            $query->where('b.type', Bill::TYPE_STORE_USER_RECHARGE);
        } else {
            if ($type == Bill::TYPE_STORE_USER_HOUSE) {
                $query->leftJoin([HouseOrder::getTable() => 'o'], 'b.order_id=o.id');
                $query->where('b.type', Bill::TYPE_STORE_USER_HOUSE);
            } else {
                if ($type == Bill::TYPE_STORE_USER_GOODS) {
                    $query->leftJoin([GoodsOrder::getTable() => 'o'], 'b.order_id=o.id');
                    $query->where('b.type', Bill::TYPE_STORE_USER_GOODS);
                } else {
                    if ($type == Bill::TYPE_STORE_USER_CONVERSION) {
                        $query->leftJoin([Conversion::getTable() => 'o'], 'b.order_id=o.id');
                        $query->where('b.type', Bill::TYPE_STORE_USER_CONVERSION);
                    } else {
                        $query->leftJoin([StoreRechargeOrder::getTable() => 'o'], 'b.order_id=o.id');
                        $query->where('b.type', Bill::TYPE_STORE_USER_RECHARGE);
                    }
                }
            }
        }
        $query->where($condition)->field('b.*,b.create_time time');
        $count = $query->count();
        $list = $query->order('b.create_time desc')->page($this->page)->limit($this->limit)->select()->toArray();
        $month_data = [];
        $year = date('Y年');
        foreach ($list as $item) {
            $item_year = date('Y年', $item['time']);
            $key = ($item_year == $year ? '' : $item_year) . date('n月', $item['time']);
            $month_data[$key][] = $item;
        }
        $month_list = [];
        foreach ($month_data as $key => $item) {
            $month_list[] = ['month' => $key, 'list' => $item];
        }
        return fetchJson(compact('count', 'month_list'));
    }
    //充值列表
    public function rechargeList()
    {
        $user = new UserForm();
        $query = StoreRecharge::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1, 'store_id' => input('store_id')]);
        $list = $query->order('price ASC')->column('id,price,give_price,give_tea_price,coupon_ids');
        $query = Recharge::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1, 'store_status' => 1]);
        $platformList = $query->order('price ASC')->column('id,price,give_price,coupon_ids,card_ids,people_num');
         if ($platformList) {
            foreach($platformList as $key=>&$val){
                $rechNum=StoreRechargeOrder::where(['user_id'=>$user->user_id,'is_pay'=>1,'money'=>$val['price']])->where(function ($query){
                    $query->where('card_ids','<>',null)
                          ->whereOr('platform_coupon_ids','<>',null);
                })->count();
                if($rechNum>=$val['people_num']&&$val['people_num']>0){
                    unset($platformList[$key]);
                }else{
                    $val['is_platform']=1;
                }
            }
            $list = array_merge($list, $platformList);
        }
        foreach ($list as $key => &$value) {
            $value['give_text'] = '送' . $value['give_price'] . '元';
            $value['give_tea_price'] = isset($value['give_tea_price']) ? $value['give_tea_price'] : 0;
            $value['coupon_ids'] = isset($value['coupon_ids']) ? $value['coupon_ids'] : 0;
            if (isset($value['is_platform'])) {
               $value['card_ids'] = isset($value['card_ids']) ? $value['card_ids'] : 0;
                if ($value['card_ids']) {
                    $value['card_list'] = Card::where(['acid' => $this->acid])->where('id', 'in', $value['card_ids'])->column('id,title,discount,cover');
                    $value['give_text'] = '送平台会员卡';
                }
                if ($value['coupon_ids']) {
                    $coupon_ids_arr = explode(',', $value['coupon_ids']);
                    $coupon_ids_arr = array_count_values($coupon_ids_arr);
                    $coupon_list = Coupon::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1])->where('id', 'in', $value['coupon_ids'])->column('id,name,price,full_price');
                    foreach ($coupon_list as &$v) {
                        $v['num'] = $coupon_ids_arr[$v['id']];
                    }
                    $value['coupon_list'] = $coupon_list;
                    if (!$value['card_ids']) {
                        $value['give_text'] = '送平台优惠券';
                    }
                }
                if($value['give_price']>0){
                    $value['give_text'] ="送".$value['give_price'].'元';
                }
            } else {
                 if ($value['coupon_ids']) {
                    $coupon_ids_arr = explode(',', $value['coupon_ids']);
                    $coupon_ids_arr = array_count_values($coupon_ids_arr);
                    $coupon_list = StoreCoupon::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1])->where('id', 'in', $value['coupon_ids'])->column('id,name,price,full_price');
                    foreach ($coupon_list as &$v) {
                        $v['num'] = $coupon_ids_arr[$v['id']];
                    }
                    $value['coupon_list'] = $coupon_list;
                    $value['give_text'] = '送优惠券';
                    $value['num'] = 1;
                }
                if($value['give_price']>0){
                    $value['give_text'] ="送".$value['give_price'].'元';
                } 
                
            }
        }
        //根据字段num对数组$data进行降序排列
        $all_num = array_column($list, 'price');
        array_multisort($all_num, SORT_ASC, $list);
        return fetchJson($list);
    }
    //用户金额
    public function userMoney()
    {
        $user = new UserForm();
        $query = Store::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1, 'is_wallet' => 1]);
        $lat = input('lat') ? input('lat') : 0;
        $lng = input('lng') ? input('lng') : 0;
        $query = Store::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1, 'is_wallet' => 1])->field('id,name,lat,lng,(6378.138 * 2 * asin(sqrt(pow(sin((lat * pi() / 180 - ' . $lat . ' * pi() / 180) / 2),2) + cos(lat * pi() / 180) * cos(' . $lat . ' * pi() / 180) * pow(sin((lng * pi() / 180 - ' . $lng . ' * pi() / 180) / 2),2))) * 1000) as distance');
        if ($lat && $lng) {
            $query->order('distance ASC');
        } else {
            $query->order('id DESC');
        }
        $list = $query->page($this->page)->select()->toArray();
        $recharge = Recharge::where(['acid' => $this->acid, 'is_delete' => 0, 'status' => 1, 'store_status' => 1])->count();
        foreach ($list as $key => &$value) {
            $storeUser = StoreUserMoney::where(['store_id' => $value['id'], 'user_id' => $user->user_id])->field('money,tea_money')->find();
            $value['money'] = $storeUser['money'] > 0 ? $storeUser['money'] . '元' : "0元";
            $value['tea_money'] = $storeUser['tea_money'] > 0 ? $storeUser['tea_money'] . '元' : "0元";
            $value['distance'] = $value['distance'] / 1000;
            $value['distance'] = round($value['distance'], 2) . 'km';
            $value['activity'] = ['status' => $recharge > 0 ? 1 : 0, 'logo' => '', 'title' => '活动'];
        }
        return fetchJson($list);
    }
}