<?php
namespace app\shared\logic\user;
use app\shared\model\Recharge;
use app\shared\model\StoreRecharge;
use app\shared\model\Coupon;
use app\shared\model\Card;
use think\exception\ValidateException;
use app\BaseController;
class RechargeForm extends  UserForm
{
   //充值列表
	public function index(){
         $query=Recharge::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1]);
         if($type=input('type')){
            $query->where('type',$type);
            $list=$query->order('price ASC')->page($this->page)->limit(20)->field('id,price,give_price,coupon_ids,card_ids,details')
             ->select()
             ->toArray();
         }else{
            $list=$query->order('price ASC')->page($this->page)->limit(20)->field('id,price,give_price,coupon_ids,card_ids')
             ->select()
             ->toArray();
         }
         foreach ($list as $key => &$value) {
             $value['give_text']='买'.$value['price'].'元送'.$value['give_price'].'元';
             $value['card_list']=Card::where(['acid'=>$this->acid])->where('id','in',$value['card_ids'])->column('id,title,discount,cover');
             $coupon_ids_arr=explode(',',$value['coupon_ids']);
             $coupon_ids_arr=array_count_values($coupon_ids_arr);
             $coupon_list=Coupon::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->where('id','in',$value['coupon_ids'])->column('id,name,price,full_price,end_time,type');
             foreach($coupon_list as &$v){
                $v['end_time']=date('Y-m-d',$v['end_time']);
                $v['num']=$coupon_ids_arr[$v['id']];
             }
             $value['coupon_list']=$coupon_list;
             $value['into_price']= $value['give_price']+$value['price'];
             $value['details']=isset($value['details'])?$value['details']!=null?$value['details']:'':'';
         }
         return fetchJson($list);
    }
    
}