<?php
namespace app\shared\logic\user;
use app\shared\model\Message;
use app\shared\model\App;
use think\exception\ValidateException;
use app\BaseController;
use wechatpay\WechatPay;
//消息管理
class MessageForm extends  UserForm
{	
    public function page(){
      return fetchJson([
         'system_num'=>Message::where(['acid'=>$this->acid,'type'=>Message::TYPE_SYSTEM,'account_type'=>Message::ACCOUNT_TYPE_USER,'user_id'=>$this->user_id,'status'=>0,'is_delete'=>0])->count(),
         'house_num'=>Message::where(['acid'=>$this->acid,'type'=>Message::TYPE_HOUSE,'account_type'=>Message::ACCOUNT_TYPE_USER,'user_id'=>$this->user_id,'status'=>0,'is_delete'=>0])->count(),
         'goods_num'=>Message::where(['acid'=>$this->acid,'type'=>Message::TYPE_GOODS,'account_type'=>Message::ACCOUNT_TYPE_USER,'user_id'=>$this->user_id,'status'=>0,'is_delete'=>0])->count(),
         'member_num'=>Message::where(['acid'=>$this->acid,'type'=>Message::TYPE_MEMBER,'account_type'=>Message::ACCOUNT_TYPE_USER,'user_id'=>$this->user_id,'status'=>0,'is_delete'=>0])->count(),
      ]);
    }
    //消息列表
    public function list(){
      $type=input('type');
      $query=Message::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'account_type'=>Message::ACCOUNT_TYPE_USER,'is_delete'=>0]);
      if($type){
        $query->where('type',$type);
      }
      $status=input('status');
      if($status==-1){
        $query->where('status',0);
      }
      $list=$query->order('id DESC')->page($this->page)->limit(10)->select();
      return fetchJson($list);
    }
    //详情
    public function details(){
      $id=input('id');
      $form=Message::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'account_type'=>Message::ACCOUNT_TYPE_USER,'id'=>$id,'is_delete'=>0])->find();
      if($form){
        if($form->status==0){
          $form->status=1;
          $form->save();
        }
      }
      return fetchJson($form);
    }
    //删除消息
    public function delete(){
       $id=input('id');
       Message::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'account_type'=>Message::ACCOUNT_TYPE_USER,'id'=>$id])->update(['is_delete'=>1]);
       return fetchJson([],'删除成功');
    }
}