<?php
namespace app\shared\logic\user;
use think\Controller;
use think\facade\Request;
use think\facade\Cache;
use app\shared\model\WeixinUser;
use app\shared\model\Store;
use app\shared\model\User;
use app\shared\model\Option;
use app\shared\model\SendMsgCode;
use app\shared\model\App;
use think\exception\ValidateException;
class LoginForm extends Base
{
	//账号登录
	public function account_login(){
		
		if($data=request()->post()){
			 try {
	            $rule = [
		             'account|账号'   => 'require',
		             'password|密码'=>'require',
		         ];
	            $this->validate($data,$rule);
	         }catch (ValidateException $e){
	            return fetchJson([],$e->getError(),1);
	         }
	        $account=User::where(['acid'=>$this->acid,'account'=>$data['account'],'password'=>md5($data['account'])])->find();
            if(!$account){
           		return fetchJson('','账号或密码错误',1);
            }
            $account->access_token=create_access_token(4);
            $account->save();
            return fetchJson($account,'登录成功');
	    }
	    return fetchJson('','请求错误',1);
	}
	//手机号码登录
	public function phoneLogin(){
		if($data=request()->post()){
			 try {
	            $rule = [
		             'phone|账号'   => 'require',
		             'acid|平台ID'=>'require|number',
		         ];
	            $this->validate($data,$rule);
	         }catch (ValidateException $e){
	            return fetchJson([],$e->getError(),1);
	         }
	        $account=User::where(['acid'=>$data['acid'],'account'=>$data['phone']])->find();
           if(!$account){
           		return fetchJson('','暂无登录过小程序',1);
           }
           $account['s_access_token']=Store::where(['acid'=>$data['acid'],'is_delete'=>0])->whereFindInSet('store_manager',$data['phone'])->value('access_token');
           return fetchJson($account,'登录成功');
	    }
	    return fetchJson('','请求错误',1);
	}
	//小程序登录
	public function wxapp_login(){
        if($data=request()->post()){
			 try {
	            $rule = [
		             'code|Code'   => 'require',
		             'encryptedData|EncryptedData'=>'require',
		             'iv|IV' => 'require',
		         ];
	            $this->validate($data,$rule);
	         }catch (ValidateException $e){
	            return fetchJson([],$e->getError(),1);
	         }
	         $wechatapp=App::where('id',$this->acid)->find();
			 $appid = $wechatapp->wxapp_app_id;
			 $appsecret=$wechatapp->wxapp_app_secret;
	         $url = "https://api.weixin.qq.com/sns/jscode2session?appid={$appid}&secret={$appsecret}&js_code={$data['code']}&grant_type=authorization_code";
			 $request=httpRequest($url);
	         $request=@json_decode($request);
	         if(isset($request->openid)){
	         	$sessionKey=$request->session_key;
	         	$encryptedData=$data['encryptedData'];
	         	$iv=$data['iv'];
		        $pc = new WXBizDataCrypt($appid, $sessionKey);
				$errCode = $pc->decryptData($encryptedData, $iv, $data);
				if ($errCode == 0) {
				   $data=@json_decode($data,true);

				   $unionid=isset($data['unionId'])?$data['unionId']:-1;
				   if($unionid==-1){
				   		$user=WeixinUser::where([
				   			'acid'=>$this->acid,
				   			'wxapp_open_id'=>$request->openid
				   		])->find();
				   }else{
				   		//开放平台的
				   		$user=WeixinUser::where([
				   			'acid'=>$this->acid,
				   			'wx_union_id'=>$data['unionId']
				   		])->find();
				   }
		           if(!$user)
		           	   $user=new WeixinUser();
					   $user->acid=$this->acid;
					   $user->avatar_url=$data['avatarUrl'];
					   $user->sex=$data['gender']==1?'男':'女';
					   $user->city=$data['city'];
					   $user->country=$data['country'];
					   $user->province=$data['province'];
					   $user->wx_union_id=$unionid;
					   $user->save();
		           }
		           $user->nickname=emoji_decode($data['nickName']);
				   $user->avatar_url=$data['avatarUrl'];
		           $user->mobile=input('phone');
		           $user->wxapp_open_id=$request->openid;
		           $user->save();
		           if(!$user->mobile){
		            	return fetchJson('','请获取手机号码',1);
		           }
		           $account=User::where(['acid'=>$this->acid,'account'=>$user->mobile])->find();
		           $user['is_new_user']=0;
		           if(!$account){
		           		$account=new User();
		           		$account->acid=$this->acid;
		           		$account->account=$user->mobile;
		           		$account->password=md5($user->mobile);
		           		$account->parent_id=input('parent_id');
		           		$account->save();
		           		//发放新人优惠券
		           		$isSend=\app\shared\model\Coupon::giveUserCoupon($account->id,1,$this->acid);
		           		$user['is_new_user']=$isSend?1:0;
		           }
		           $account->nickname=$user->nickname;
		           $account->avatar_url=$user->avatar_url;
		           $account->access_token=create_access_token(4);
		           $account->save();
		           $user['access_token']=$account->access_token;
		           return fetchJson($user,'登录成功');
				}else{
	               return fetchJson('','解析错误',1);
				}
	         }
	         return fetchJson('','检查微信参数是否错误',1);
     }
     public function getWxapp(){
     	  if($data=request()->post()){
			 try {
	            $rule = [
		             'code|Code'   => 'require',
		         ];
	            $this->validate($data,$rule);
	         }catch (ValidateException $e){
	            return fetchJson([],$e->getError(),1);
	         }
	         $wechatapp=App::where('id',$this->acid)->find();
			   $appid = $wechatapp->wxapp_app_id;
			   $appsecret=$wechatapp->wxapp_app_secret;
	         $url = "https://api.weixin.qq.com/sns/jscode2session?appid={$appid}&secret={$appsecret}&js_code={$data['code']}&grant_type=authorization_code";
			   $request=httpRequest($url);
	         $request=@json_decode($request);
	         //
	         if(isset($request->openid)){
		        if(input('weixin_login_status')){
		        	  $user=WeixinUser::where([
			   			'acid'=>$this->acid,
			   			'wxapp_open_id'=>$request->openid
			   		])->find();
			   		if(!$user){
		           	   $user=new WeixinUser();
		           	   $user->avatar_url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/header.jpg';
						   $user->acid=$this->acid;
						   $user->save();
		           }
		           $user->wxapp_open_id=$request->openid;
		           $user->save();
		           $user['is_new_user']=1;
		           if($user->mobile&&$user->mobile!='undefined'){
		   		 		 $user['is_new_user']=0;
		   		 		 $user['access_token']=User::where(['acid'=>$this->acid,'account'=>$user->mobile])->value('access_token');
		   		 		 if(!$user['access_token']){
		   		 		 	$user['is_new_user']=1;
		   		 		 }
		   		  }else{
		   		       $user->mobile='';
		   		  }
		           return fetchJson($user,'登录成功');
		        }
		        $sessionKey=$request->session_key;
	         	$encryptedData=input('encryptedData');
	         	$iv=input('iv');
		        $pc = new WXBizDataCrypt($appid, $sessionKey);
				 $errCode = $pc->decryptData($encryptedData, $iv, $data);
				if ($errCode == 0) {
				   $data=@json_decode($data,true);

				   $unionid=isset($data['unionId'])?$data['unionId']:-1;
				   if($unionid==-1){
				   		$user=WeixinUser::where([
				   			'acid'=>$this->acid,
				   			'wxapp_open_id'=>$request->openid
				   		])->find();
				   }else{
				   		//开放平台的
				   		$user=WeixinUser::where([
				   			'acid'=>$this->acid,
				   			'wx_union_id'=>$data['unionId']
				   		])->find();
				   }
		           if(!$user)
		           	   $user=new WeixinUser();
					   $user->acid=$this->acid;
					   $user->avatar_url=$data['avatarUrl'];
					   $user->sex=$data['gender']==1?'男':'女';
					   $user->city=$data['city'];
					   $user->country=$data['country'];
					   $user->province=$data['province'];
					   $user->wx_union_id=$unionid;
					   $user->save();
		           }
		           $user->nickname=emoji_decode($data['nickName']);
				     $user->avatar_url=$data['avatarUrl'];
		           $user->wxapp_open_id=$request->openid;
		           $user->save();
		           $user['is_new_user']=1;
		           if($user->mobile){
		   		 		 $user['is_new_user']=0;
		   		 		 $user['access_token']=User::where(['acid'=>$this->acid,'account'=>$user->mobile])->value('access_token');
		   		 		 if(!$user['access_token']){
		   		 		 	$user['is_new_user']=1;
		   		 		 }
		   		   }
		           return fetchJson($user,'登录成功');
				}else{
	               return fetchJson('','解析错误',1);
				}
	         }
	         return fetchJson('','检查微信参数是否错误',1);
     }
    public function mobileLogin(){
    	$data=request()->post();
    	try {
            $rule = [
	            'mobile|手机号码'   => 'require',
	            // mobile和phone必须输入一个
					'wxapp_open_id|小程序OpenId' => 'requireWithout:wx_open_id',
					'wx_open_id|微信公众号OpenId'  => 'requireWithout:wxapp_open_id'
	         ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         if($wxapp_open_id=input('wxapp_open_id')){
         	if(WeixinUser::where([
		 		 	'acid'=>$this->acid,
		 		 	'mobile'=>$data['mobile']
		 		 ])->where('wx_open_id','<>','')->count()>1){
		 		 	 WeixinUser::where([
			 		 	'acid'=>$this->acid,
			 		 	'mobile'=>$data['mobile']
			 		 ])->where('wx_open_id','<>','')->update([
			 		 	'is_delete'=>1,
			 		 ]);
		 		}
	         $user=WeixinUser::where([
	   			'acid'=>$this->acid,
	   			'wxapp_open_id'=>$wxapp_open_id
	   		])->find();

         }else{
         	$wx_open_id=input('wx_open_id');
         	if(WeixinUser::where([
		 		 	'acid'=>$this->acid,
		 		 	'mobile'=>$data['mobile']
		 		 ])->where('wx_open_id','<>','')->count()>1){
		 		 	 WeixinUser::where([
			 		 	'acid'=>$this->acid,
			 		 	'mobile'=>$data['mobile']
			 		 ])->where('wxapp_open_id','')->update([
			 		 	'is_delete'=>1,
			 		 ]);
		 		}
	         $user=WeixinUser::where([
	   			'acid'=>$this->acid,
	   			'wx_open_id'=>$wx_open_id
	   		])->find(); 
         }
   		$is_new_user=0;
   		if($user){
   		 	$user->mobile=$data['mobile'];
   		 	$user->is_delete=0;
   		 	$user->save();
   		 }else{
   		 	return fetchJson([],'登录错误',1);
   		 }
   		 $account=User::where(['acid'=>$this->acid,'account'=>$user->mobile])->find();
          if(!$account){
       		$account=new User();
       		$account->acid=$this->acid;
       		$account->account=$user->mobile;
       		$account->password=md5($user->mobile);
       		$account->parent_id=input('parent_id');
       		if($avatar_url=input('avatar_url')){
       			$account->avatar_url=$avatar_url;
       		}
       		if($nickname=input('nickname')){
       			$account->nickname=$nickname; 
       		}else{
       			$account->nickname=empty($user->nickname)?substr_replace($account->account,'****',3,4):$user->nickname;
       		}
       		if(input('wx_open_id')){
       			$account->nickname=$user->nickname;
       			$account->avatar_url=$user->avatar_url;
       		}
       		$account->save();
       		//发放新人优惠券
       		$send=\app\shared\model\Coupon::giveUserCoupon($account->id,1,$this->acid);
       		$is_new_user=$send?1:0;;
        }else{
        	if(!$account->parent_id){
        		$parent_id=input('parent_id');
		        $account->parent_id=$parent_id!=$user->id?$parent_id:0;
        	}
        }
        $account->access_token=create_access_token(4);
        $account->save();
        $account['is_new_user']=$is_new_user;
        return fetchJson($account,'登录成功');
    }
	//获取手机号码
	public function wxapp_getphone(){
		if($data=request()->post()){
			try {
	            $rule = [
		             'code|Code'   => 'require',
		             'encryptedData|EncryptedData'=>'require',
		             'iv|IV' => 'require',
		         ];
	            $this->validate($data,$rule);
	         }catch (ValidateException $e){
	            return fetchJson([],$e->getError(),1);
	         }
	         $wechatapp=App::where('id',$this->acid)->find();
			 $appid = $wechatapp->wxapp_app_id;
			 $appsecret=$wechatapp->wxapp_app_secret;
	         $url = "https://api.weixin.qq.com/sns/jscode2session?appid={$appid}&secret={$appsecret}&js_code={$data['code']}&grant_type=authorization_code";
			 $request=httpRequest($url);
	         $request=@json_decode($request);

	     	 $sessionKey=$request->session_key;
	     	 $encryptedData=$data['encryptedData'];
	     	 $iv=$data['iv'];
	         $pc = new WXBizDataCrypt($appid, $sessionKey);
			 $errCode = $pc->decryptData($encryptedData, $iv, $res);
			 if ($errCode == 0) {
			 	 $data=@json_decode($res,true);
			    return fetchJson($data);
			 }else{
			 	return fetchJson('','检查微信参数是否错误',1);
			 }
		}
		return fetchJson('','请求错误',1);
	}
	//获取手机验证码
	public function getPhoneCaptcha(){
		   $data=request()->post();
		   try {
              $rule = [
	             'mobile|手机号码'   => 'require',
	          ];
              $this->validate($data,$rule);
           }catch (ValidateException $e){
               return fetchJson([],$e->getError(),1);
           }
			//发送手机短信
	       $config=Option::get_data($this->acid,'shared','cloudSheetConfig');
	       $res=[];
	       if($config){
	          $config=@json_decode($config,1);
	          $could=new  \CloudSheet\CloudSheet($config['title'],$config['apiKey']);
	          $code=rand(100000,999999);
	          //云片验证码模板
	          $captchaTpl=Option::get_data($this->acid,'shared','cloudSheetCaptchaTpl');
	          $captchaTpl=$captchaTpl?$captchaTpl:"验证码：#code# （验证码五分钟有效）。";
	          $title=str_replace('#code#', $code, $captchaTpl);
	          $mobile=$data['mobile'];
	          if(Cache::get('PhoneCaptcha'.$mobile)){
	          	 return fetchJson([],"您已获取验证码了，请稍后再试",1);
	          }
	          $count=SendMsgCode::where(['status'=>0,'acid'=>$this->acid,'phone'=>$data['mobile']])->whereDay('create_time')->count();
	          if($count>=5){
	          	return fetchJson([],"您今日已获取验证码次数过多,请明日再试试",1);
	          }
	          $res=$could->SendMsg($title,$mobile);
	          (new SendMsgCode())->save([
	          	'acid'=>$this->acid,
	          	'phone'=>$data['mobile'],
	          	'code'=>$code
	          ]);
	          Cache::set('PhoneCaptcha'.$mobile,$code,60);
	          return fetchJson([],'获取成功');
	      }
	      return fetchJson([],'请求错误',1);       
	}
	//手机验证码登录
	public function captchaPhoneLogin(){
    	$data=request()->post();
    	try {
            $rule = [
	             'mobile|手机号码'   => 'require',
	             'code|验证码'=>'require',
	             'wx_open_id|公众号OpenId'   => 'require',
	         ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $msgCode=SendMsgCode::where(['status'=>0,'acid'=>$this->acid,'phone'=>$data['mobile'],'code'=>$data['code']])->where('create_time','>',time()-600)->find();
         if(!$msgCode){
         	return fetchJson([],'验证码错误',1);
         }
         $msgCode->save([
         	'status'=>1
         ]);
         $user=WeixinUser::where([
   			'acid'=>$this->acid,
   			'wx_open_id'=>$data['wx_open_id']
   		 ])->find();
   		 $is_new_user=0;
   		 if($user){
   		 	$user->mobile=$data['mobile'];
   		 	$user->save();
   		 }else{
   		 	return fetchJson([],'登录错误',1);
   		 }
   		 $account=User::where(['acid'=>$this->acid,'account'=>$user->mobile])->find();
         if(!$account){
       		$account=new User();
       		$account->acid=$this->acid;
       		$account->account=$user->mobile;
       		$account->password=md5($user->mobile);
       		$account->parent_id=input('parent_id');
       		if($avatar_url=input('avatar_url')){
       			$account->avatar_url=$avatar_url;
       		}else{
       			$account->avatar_url=$user->avatar_url;
       		}
       		if($nickname=input('nickname')){
       			$account->nickname=$nickname; 
       		}else{
       			$account->nickname=empty($user->nickname)?substr_replace($account->account,'****',3,4):$user->nickname;
       		}
       		$account->save();
       		//发放新人优惠券
       		$send=\app\shared\model\Coupon::giveUserCoupon($account->id,1,$this->acid);
       		$is_new_user=$send?1:0;;
        }else{
        	if(!$account->parent_id){
        		$parent_id=input('parent_id');
		        $account->parent_id=$parent_id!=$user->id?$parent_id:0;
        	}
        }
        $account->access_token=create_access_token(4);
        $account->save();
        $account['is_new_user']=$is_new_user;
        return fetchJson($account,'登录成功');
    }
	//一键登录
	public function oneKeyLogin(){
		if($data=request()->post()){
			 try {
	            $rule = [
		             'code|Code'   => 'require',
		             'phone|手机号码'   => 'require',
		         ];
	            $this->validate($data,$rule);
	         }catch (ValidateException $e){
	            return fetchJson([],$e->getError(),1);
	         }
	         $wechatapp=App::where('id',$this->acid)->find();
			   $appid = $wechatapp->wxapp_app_id;
			   $appsecret=$wechatapp->wxapp_app_secret;
	         $url = "https://api.weixin.qq.com/sns/jscode2session?appid={$appid}&secret={$appsecret}&js_code={$data['code']}&grant_type=authorization_code";
			   $request=httpRequest($url);
	         $request=@json_decode($request);
	         $is_new_user=0;
	         if(isset($request->openid)){
	         	$wxUser=WeixinUser::where([
		   			'acid'=>$this->acid,
		   			'wxapp_open_id'=>$request->openid
		   		])->find();
		   		if(!$wxUser){
	           	   $wxUser=new WeixinUser();
	           	   $wxUser->avatar_url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/header.jpg';
				   $wxUser->acid=$this->acid;
				   $wxUser->save();
	           }
	           $wxUser->wxapp_open_id=$request->openid;
	           $wxUser->mobile=$data['phone'];
	           $wxUser->save();
	           $user=User::where(['acid'=>$this->acid,'account'=>$wxUser->mobile])->find();
		       if(!$user){
		       		$user=new User();
		       		$user->acid=$this->acid;
		       		$user->account=$wxUser->mobile;
		       		$user->password=md5($wxUser->mobile);
		       		$user->parent_id=input('parent_id');
		       		if($avatar_url=input('avatar_url')){
		       			$user->avatar_url=$avatar_url;
		       		}
		       		if($nickname=input('nickname')){
		       			$user->nickname=$nickname; 
		       		}else{
		       			$user->nickname=substr_replace($user->account,'****',3,4);
		       		}
		       		$user->save();
		       		//发放新人优惠券
		       		$send=\app\shared\model\Coupon::giveUserCoupon($user->id,1,$this->acid);
		       		$is_new_user=$send?1:0;;
		        }else{
		        	if(!$user->parent_id){
		        		$parent_id=input('parent_id');
		        		$user->parent_id=$parent_id!=$user->id?$parent_id:0;
		        	}
		        }
		        $user->access_token=create_access_token(4);
		        $user->save();
		        $user['is_new_user']=$is_new_user;
		        return fetchJson($user,'登录成功');
		    }
		}  
	    return fetchJson('','检查微信参数是否错误',1);
	}
	//H5公众号登录
	public function web_wx_login(){
    	$wechatapp=App::where('id',$this->acid)->find();
		$appid =$wechatapp->wx_app_id;
        $redirect_uri=request()->domain().request()->baseFile();
		  $redirect_uri=str_replace('index','wxpublic/wx'.$this->acid.'/web_wx_login',$redirect_uri);
        $url='https://open.weixin.qq.com/connect/oauth2/authorize?appid='.$appid.'&redirect_uri='.$redirect_uri.'&response_type=code&scope=snsapi_userinfo&state='.time().'#wechat_redirect';
        header("Location: $url");
    }
    //公众号初始化
    public function wxPublicLoad(){
        $wx=App::where('id',$this->acid)->find();
        $jsapiTicket=self::getJsapiTicket($wx);
        $url=input('url');
        $url=urldecode($url);
        $wxConf = [
            'jsapi_ticket' => $jsapiTicket,
            'nonceStr' => md5(time() . '!@#$%^&*()_+'),
            'timestamp' => time(),
            'url' => $url,  //这个就是你要自定义分享页面的Url啦
        ];
        $string1 = sprintf('jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s', $wxConf['jsapi_ticket'], $wxConf['nonceStr'], $wxConf['timestamp'], $wxConf['url']);
        // 计算签名
        $wxConf['signature'] = sha1($string1);
        $wxConf['appId'] = $wx->wx_app_id;
        return fetchJson($wxConf);
    }
    private function getJsapiTicket($wx=null){
        $res=self::web_wx_access_token($wx);
        $cache_jsapi_ticket=Cache::get('web_wx_get_jsapi_ticket_acid'.$wx->id);
        if ($cache_jsapi_ticket) {
            //return $cache_jsapi_ticket;
        }
        $jsapi_ticket_url="https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token={$res['data']}&type=jsapi";
        $jsres=httpRequest($jsapi_ticket_url);
        $jsres=@json_decode($jsres);
        if(isset($jsres->ticket)){
            Cache::set('web_wx_get_jsapi_ticket_acid'.$wx->id,$jsres->ticket,3600);
            return $jsres->ticket;
        }else{
            return '无效';
        }
    }
	public function web_wx_login_redirect_uri(){
    	$wx=App::where('id',$this->acid)->find();
    	$code=input('code');
    	$url="https://api.weixin.qq.com/sns/oauth2/access_token?appid={$wx->wx_app_id}&secret={$wx->wx_app_secret}&code={$code}&grant_type=authorization_code";
    	$res=httpRequest($url);
    	$res=@json_decode($res);
    	if(isset($res->access_token)){
    		  $user_url="https://api.weixin.qq.com/sns/userinfo?access_token={$res->access_token}&openid={$res->openid}&lang=zh_CN";
    		  $res_user=httpRequest($user_url);
    		  $data=@json_decode($res_user,1);
		     $wxUser=WeixinUser::where(['acid'=>$this->acid,'wx_open_id'=>$data['openid']])->find();
           if(!$wxUser){
           	 $wxUser=new WeixinUser();
			    $wxUser->acid=$this->acid;
			    $wxUser->nickname=$data['nickname'];
			    $wxUser->avatar_url=$data['headimgurl'];
			    $wxUser->mobile=0;
           }
           $wxUser->wx_open_id=$data['openid'];
           $wxUser->save();
           $access_token=0;
           if($wxUser->mobile){
           		$user=User::where(['acid'=>$this->acid,'account'=>$wxUser->mobile])->find();
           		if($user){
           			$access_token=$user->access_token;
           		}
           }
           $redirect_uri=request()->domain().request()->baseFile();
           $redirect_uri=str_replace('index.php','wxpublic/wx'.$this->acid.'/#/pages/login/login?wx_openid='.$wxUser->wx_open_id."&access_token=".$access_token,$redirect_uri);
           header("Location: $redirect_uri");
    	}else{
    		die(json_encode(['code'=>$res->errcode,'msg'=>$res->errmsg]));
    	}
    }
    //获取access_token
    static public function web_wx_access_token($wx){
    	$access_token=Cache::get('web_wx_access_token_acid'.$wx->wx_app_id);
    	if ($access_token) {
    		return ['code'=>0,'msg'=>'','data'=>$access_token];
    	}
    	$url="https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$wx->wx_app_id}&secret={$wx->wx_app_secret}";
    	$res=httpRequest($url);
    	$res=@json_decode($res);
    	if(isset($res->access_token)){
    		Cache::set('web_wx_access_token_acid'.$wx->wx_app_id,$res->access_token,3600);
    		return ['code'=>0,'msg'=>'','data'=>$res->access_token];
    	}else{
    		return ['code'=>$res->errcode,'data'=>'','msg'=>$res->errmsg];
    	}
    }
}
class WXBizDataCrypt
{
    private $appid;
	private $sessionKey;
	/**
	 * 构造函数
	 * @param $sessionKey string 用户在小程序登录后获取的会话密钥
	 * @param $appid string 小程序的appid
	 */
	public function __construct( $appid, $sessionKey)
	{
		$this->sessionKey = $sessionKey;
		$this->appid = $appid;
	}


	/**
	 * 检验数据的真实性，并且获取解密后的明文.
	 * @param $encryptedData string 加密的用户数据
	 * @param $iv string 与用户数据一同返回的初始向量
	 * @param $data string 解密后的原文
     *
	 * @return int 成功0，失败返回对应的错误码
	 */
	public function decryptData( $encryptedData, $iv, &$data )
	{
		if (strlen($this->sessionKey) != 24) {
			return ErrorCode::$IllegalAesKey;
		}
		$aesKey=base64_decode($this->sessionKey);

        
		if (strlen($iv) != 24) {
			return ErrorCode::$IllegalIv;
		}
		$aesIV=base64_decode($iv);

		$aesCipher=base64_decode($encryptedData);

		$result=openssl_decrypt( $aesCipher, "AES-128-CBC", $aesKey, 1, $aesIV);

		$dataObj=@json_decode( $result );
		if( $dataObj  == NULL )
		{
			return ErrorCode::$IllegalBuffer;
		}
		if( $dataObj->watermark->appid != $this->appid )
		{
			return ErrorCode::$IllegalBuffer;
		}
		$data = $result;
		return ErrorCode::$OK;
	}

}
class ErrorCode
{
	public static $OK = 0;
	public static $IllegalAesKey = -41001;
	public static $IllegalIv = -41002;
	public static $IllegalBuffer = -41003;
	public static $DecodeBase64Error = -41004;
}
