<?php
namespace app\shared\logic\user;
use app\shared\model\User;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\House;
use app\shared\model\HouseRoom;
use app\shared\model\HouseRoomStock;
use app\shared\model\Coupon;
use app\shared\model\CouponUser;
use app\shared\model\StoreCoupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\HouseStock;
use app\shared\model\HouseStockOem;
use app\shared\model\Electricity;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\StoreCleaning;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\CardUserOrder;
use wechatpay\WechatPay;
use app\shared\model\Store;
use app\shared\model\Bill;
use app\shared\model\ElectricityLine;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\HouseUserOrder as StockHouseUserOrder;
use app\plugin\model\usercashgrade\Usercashgrade;
use app\plugin\model\usercashgrade\UsercashgradeOrder;
use app\shared\model\CardCoupon;
use app\shared\model\StoreUserMoney;
use app\shared\model\Partner;
use app\shared\model\PartnerUser;
use app\shared\model\PartnerUserOrder;
use app\shared\model\CardCouponOrder;
use slock\Slock;
use think\facade\Cache;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
class HouseOrderOemForm extends  UserForm
{
    //列表
    public function list(){
        $query=HouseOrder::where(['acid'=>$this->acid,'user_id'=>$this->user_id]);
        $status=input('status');
        if($is_tea_specialist=input('is_tea_specialist')){
           $store_ids=Store::where(['acid'=>$this->acid,'is_tea_specialist'=>1,'is_delete'=>0,'status'=>1])->column('id');
           $query=$query->where('tea_specialist_id',0)->where('status','in','1,2')->where('store_id','in',$store_ids);
        }else{
           switch ($status) {
              case '-2':
                $query->where('status',-2);
                break;
              case '-1':
                $query->where('status',-1);
                break;  
              case '0':
                $query->where('status',0);
                break;
              case '1':
                $query->where('status',1);
                break;
              case '2':
                $query->where('status',2);
                break;
              case '3':
                $query->where('status',3);
                break;      
              default:
              
                break;
            }
        }
        $list=$query->limit(10)->page($this->page)->order('id DESC')->select();
        $time=time()-90;
        foreach ($list as $key => &$value) {
            if($value->book_type==3){
                 $house=House::where('id',$value->house_id)->find();
                 $endOrderTime=$value->start_time+$house['limit_time']*3600;
                 if(time()>$endOrderTime){
                    $value->end_time=$endOrderTime;
                    $value->save();
                 }
            }else{
                $startTime=strtotime($value->create_time);
                if($startTime<$time&&$value->status==0&&$value->is_pay==0){
                   $value->status=-1;
                   //优惠券还原
                   $userCoupon=CouponUser::where(['id'=>$value->coupon_user_id])->find();
                   if($userCoupon){
                       $value->pay_price+=$userCoupon['discounts_price'];
                       $value->price=$value->pay_price;
                       $value->coupon_user_id=0;
                       $userCoupon->is_use=0;
                       $userCoupon->order_id=0;
                       $userCoupon->discounts_price=0;
                       $userCoupon->use_time=0;
                       $userCoupon->save();
                   }
                   //商家优惠券还原
                   $storeUserCoupon=StoreCouponUser::where(['id'=>$value->store_coupon_user_id])->find();
                   if($storeUserCoupon){
                       $value->pay_price+=$storeUserCoupon['discounts_price'];
                       $value->price=$value->pay_price;
                       $value->store_coupon_user_id=0;
                       $storeUserCoupon->is_use=0;
                       $storeUserCoupon->use_time=0;
                       $storeUserCoupon->save();
                   }
                   $value->save();
                }
                if($value->start_time<time()&&$value->status==1){
                  $value->status=2;

                  $value->save();
                }
            }
            $start_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$value->id])->order('id ASC')->value('start_time');
            if($start_time){
              //续单
              if($start_time>$value->start_time){
                  $end_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$value->id])->order('id DESC')->value('end_time');
                  $value->end_time=$end_time;
              }else{
                //向前续单
                   $value->start_time=$start_time;
              }
              $value->is_reorder=1;
            }else{
              $value->is_reorder=0;
            }
            if(isset($value->type)){
                if($value->type==2){
                    $value->start_time=date('Y-m-d',$value->start_time);
                    $value->end_time=date('Y-m-d',$value->end_time);
                }else{
                    $value->start_time=date('Y-m-d H:i',$value->start_time);
                    $value->end_time=date('Y-m-d H:i',$value->end_time);
                }
            }else{
                $value->start_time=date('Y-m-d H:i',$value->start_time);
                $value->end_time=date('Y-m-d H:i',$value->end_time);
            }
            $store=Store::where('id',$value->store_id)->field('address,lng,lat')->find();
            $snapshoot=@json_decode($value->snapshoot,1);
            $snapshoot['address']=$store['address'];
            $snapshoot['lng']=$store['lng'];
            $snapshoot['lat']=$store['lat'];
            $value->snapshoot=$snapshoot;
            $value->price+=HouseOrderContinue::where(['status'=>1,'order_id'=>$value->id])->sum('price');
            $value->pay_price+=HouseOrderContinue::where(['status'=>1,'order_id'=>$value->id])->sum('pay_price');
        }
        return fetchJson($list);
    }
    //商家营业时间
    private function storeBusinessHours($store_id='',$starttime=0,$endtime=0){
           $business_hours=Store::where(['id'=>$store_id])->value('business_hours');
           $business_hours=@json_decode($business_hours,1);
           $halfDay=($endtime-$starttime)/1800;
           $dayArr=[];
           $dayArr1=[];
           $starttime_pus=((int)($starttime/1800))*1800;
           $starttime_pus1=((int)($starttime/1800))*1800;
           $starttime_pus2=(($starttime/1800))*1800;
           if($starttime_pus1==$starttime_pus2){
              for ($j=0;$j<($halfDay+1);$j++){ 
                  $dayArr[]=$starttime_pus+1800*$j;
                  //$dayArr1[]=date('Y-m-d H:i',$starttime_pus+1800*$j);
               }
           }else{
                for ($j=0;$j<($halfDay+2);$j++){ 
                  $dayArr[]=$starttime_pus+1800*$j;
                  //$dayArr1[]=date('Y-m-d H:i',$starttime_pus+1800*$j);
               }
           }
           if(isset($business_hours['start_time'])&&isset($business_hours['end_time'])){
               $bus_start=date('Y-m-d ',$starttime).$business_hours['start_time'];
               $bus_end=date('Y-m-d ',$starttime).$business_hours['end_time'];
               if($bus_end!=$bus_start){
                     //判断结束时间是否比开始时间大
                     $bus_end=strtotime($bus_end);
                     $bus_start=strtotime($bus_start);
                     if($bus_end<$bus_start){
                        $bus_arr=[];
                        $x=($bus_start-$bus_end)/1800;
                        for ($y=1;$y<($x);$y++){ 
                          $bus_arr[]=date('H:i',$bus_end+1800*$y);
                        }
                        foreach($dayArr as $dbus){
                            $dbus_t=date('H:i',$dbus);                  
                            if(in_array($dbus_t,$bus_arr)){
                                 die(json_encode([
                                    'code'=>1,
                                    'msg'=>date('Y-m-d H:i',$dbus).'该时间段不在营业时间内~',
                                    'data'=>[]
                                ],JSON_UNESCAPED_UNICODE));
                            }
                        }

                     }else{
                        if(!($starttime>=$bus_start&&$endtime<=$bus_end)){
                            die(json_encode([
                                'code'=>1,
                                'msg'=>'该时间段不在营业时间内',
                                'data'=>[]
                            ],JSON_UNESCAPED_UNICODE));
                        }
                     }
               }
           }
           return true;
    }
    //获取时间价格
    private function getTimePirce($house,$starttime,$endtime,$feeHour=0){
        $price_list=@json_decode($house['price_list'],1);

        $halfDay=($endtime-$starttime)/1800;
        $priceArr=[];
        $timePirce=0;
        //判断是否是民宿
        if($house['type']==2){
            $feeHour=0;
        }
        //每个小时的钱
        if($feeHour>0){
         
          $feeHour=(int)($feeHour*2);
          if(empty($price_list)){
             return ($feeHour)*$house['price']/2;
          }
          $feeHour-=1;
          $priceData=array_column($price_list,'price','time');
          for ($j=0;$j<($halfDay);$j++){
              $key=date('H',$starttime+1800*$j); 
              $timePirce+=$priceData[$key]/2;
              if($j>=$feeHour){
                break;
              }
          }
          if($timePirce<=0){
            return $halfDay*$house['price']/2;
          }
          return $timePirce;
        }
        if(empty($price_list)){
           return $halfDay*$house['price']/2;
        }
        $priceData=array_column($price_list,'price','time');
        for ($j=0;$j<($halfDay);$j++){
            $key=date('H',$starttime+1800*$j); 
            $timePirce+=$priceData[$key]/2;
        }
        if($timePirce<=0){
          return $halfDay*$house['price']/2;
        }
        return $timePirce;
    }
    //空间房间价格
    private function houseRoomPrice($house,$start_time='',$end_time='',$is_member=0){
        $stockDate=[];
        $stock=HouseRoomStock::where(['house_id'=>$house['id']])->whereBetweenTime('date',$start_time,$end_time)->column('id,date,price,status');
        foreach($stock as $dayStock){
            $stockDate[$dayStock['date']]=[
                'price'=>$dayStock['price'],
                'day'=>$dayStock['date'],
                'status'=>$dayStock['status']>0?1:0,
            ];
        }
        $monthDate=monthDate($start_time,$end_time);
        $price=0;
        foreach($monthDate as $day){
            if(isset($stockDate[$day])){
               $roomData=$stockDate[$day];
               if($roomData['status']>0){
                 die(json_encode(['code'=>1,'data'=>[],'msg'=>'该'.$roomData['day'].'日期已被预定']));
               }else{
                  $price+=$roomData['price'];
               }
            }else{
                if($is_member==1){
                    $price+=$house['member_price'];
                }else{
                    $price+=$house['price'];
                }
            }
        }
        return $price;
    }
    //提交预览
    public function submit_preview(){
      try {
          $data=request()->post();
          $rule = [
               'house_id|房间ID' => 'require|number',
               'start_time|开始时间'=>'require',
               'end_time|结束时间'=>'require',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $house=House::where('id',$data['house_id'])->find();
       if(!$house){
          return fetchJson([],'暂无茶室',1);
       }
       $time=time();
       $book_type=input('book_type');
       $pay_type=input('pay_type');
       if($house['type']==2){
            $end_time=input('end_time');
            if(!$end_time){
                return fetchJson([],'离店时间必传',1); 
            }
            $start_time=date('Y-m-d',strtotime(input('start_time')));
            $end_time=date('Y-m-d',strtotime($end_time));
            $start_time=strtotime($start_time);
            $end_time=strtotime($end_time);
            $endtime=$end_time;
            $num=($endtime-$start_time)/3600;
            $orderPrice=self::houseRoomPrice($house,$start_time,$end_time);
       }else{
           $is_room_status=Store::where(['id'=>$house['store_id']])->value('is_room_status');
           if($is_room_status==2){
                $house_room_status=House::where('id',$data['house_id'])->value('room_status');
                if($house_room_status==2){
                    return fetchJson([],'该房间未打扫，不可下单',1);
                }
           }
           $user_cash_grade=Usercashgrade::whereFindInSet('store_ids',$house['store_id'])->where(['acid'=>$this->acid,'status'=>1,'is_delete'=>0])->column('id');
           if($user_cash_grade){
              if(!UsercashgradeOrder::where(['acid'=>$this->acid,'status'=>1,'user_id'=>$this->user_id])->where('user_cash_grade_id','in',$user_cash_grade)->count()){
                 return fetchJson([],'该门店暂时无法使用，请前往我的缴纳押金方可使用',1);
              }
           }
           $start_time=strtotime($data['start_time']);
           $end_time=input('end_time')?strtotime(input('end_time')):$start_time+(3600*$house['booktime']);
           //优化----------------------------------
           $newhours=($end_time-$start_time)/3600;
           if($start_time<$time){
              $start_time=strtotime(date('Y-m-d H:i',$time));
              $end_time=$start_time+$newhours*3600;
           }

           //优化----------------------------------

           $starttime=strtotime(date('Y-m-d H:i',$start_time));
           $endtime=strtotime(date('Y-m-d H:i',$end_time));
           self::storeBusinessHours($house['store_id'],$starttime,$endtime);
           $num=($endtime-$start_time)/3600;
           $booktime=$house['booktime']>0?$house['booktime']:1;
           if($num<$booktime){
               return fetchJson([$num],'预订时间请大于等于'.$booktime.'小时',1);
           }
           $dayArr=houseTimeOemPus($starttime,$endtime);

           foreach($dayArr as $dV){
                $is_booKtime=HouseStockOem::where(['acid'=>$house['acid'],'store_id'=>$house['store_id'],'house_id'=>$data['house_id']])
                ->where('status',1)
                ->whereTime('start_time','<=',$dV)
                ->whereTime('end_time','>=',$dV)
                ->count();
                if($is_booKtime){
                    return fetchJson([],date('Y-m-d H:i:s',$dV).'该时间段已预订',1);
                }
           }
           $orderPrice=self::getTimePirce($house,$start_time,$end_time);
           $package_price=@json_decode($house['package_price'],1);
           if($package_price){
              foreach ($package_price as $package){
                  if(isset($package['num'])&&isset($package['price'])){
                    if($package['num']==$num){
                      $orderPrice=$package['price'];
                      break;
                    }
                  }
              }
           }
       }
       
       $subscibe['book_inform']=Option::get_data($this->acid,'platform','wx_subscibe_book_inform');
       //预约结束提醒
       $subscibe['book_finish']=Option::get_data($this->acid,'platform','wx_subscibe_book_finish');
       //预约提醒加时
       $subscibe['book_overtime']=Option::get_data($this->acid,'platform','wx_subscibe_book_overtime');
       
       $store_id=$house['store_id'];
       $cardUser=CardUser::alias('c_u')
       ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
       ->where(function ($query) use($store_id) {
            $query->whereFindInSet('c.store_ids',$store_id)
            ->whereOr('c.store_ids','-1');
       })
       ->where(['c_u.status'=>1,'c_u.user_id'=>$this->user_id,'c_u.is_delete'=>0]);
       $cardUser->where('c_u.start_time','<',$time)->where('c_u.end_time','>',strtotime(date('Y-m-d',$time))-86399);
       $card_user_id=input('card_user_id');
       if($card_user_id){
          $cardUser=$cardUser->where('c_u.id',$card_user_id);
       }
       $cardUser=$cardUser->order('c_u.level DESC')->field('c_u.*')->find();

       $payPrice=$orderPrice;
       $discount=-1;
       $hour=0;
       $partnerUser=PartnerUser::where([
          'user_id'=>$this->user_id,
          'acid'=>$this->acid,
          'status'=>1
        ])->find();
       $feeHour=0;

       $card_coupon_id=input('card_coupon_id');
       $partnerStatus=0;
       if($partnerUser){
          $partnerStatus=Partner::where([
            'id'=>$partnerUser->partner_id,
            'acid'=>$this->acid,
            'is_delete'=>0,
            'status'=>1
          ])->count();
       }

       if($partnerStatus&&$partnerUser&&$pay_type!=3){
          if($partnerUser->end_time<-1){
            $partnerUser->end_time=-1;
            $partnerUser->save();
          }
          if($partnerUser->end_time>time()&&$partnerUser->start_time<time()||$partnerUser->end_time==-1){
              $partner=Partner::where([
                'id'=>$partnerUser->partner_id,
                'acid'=>$this->acid
              ])->find();
              $everyday_hour=$partner->everyday_hour;
              $hour=PartnerUserOrder::where(['user_partner_id'=>$partnerUser->id,'user_id'=>$this->user_id,'acid'=>$this->acid,'status'=>1])->whereDay('create_time','today')->sum('hour');
              $useHour=$everyday_hour-$hour;
              if($useHour>0){
                if($useHour>$num){
                   $feeHour=$num;
                }else{
                   $feeHour=$useHour;
                }
              }
              //免费金额
              $feehourPirce=self::getTimePirce($house,$start_time,$end_time,$feeHour);
              if($feeHour>0){
                if($feehourPirce>$partnerUser->money&&$partnerUser->money>0){
                  $payPrice-=$partnerUser->money;
                }else{
                  $payPrice-=$feehourPirce;
                }
                $payPrice=$payPrice>0?$payPrice:0;
              }              
          }
       }else{

          if($cardUser){
              if($pay_type==2){
                 $card=Card::where(['id'=>$cardUser['card_id'],'is_delete'=>0,'is_balance'=>1])->find();
              }else{
                 $card=Card::where(['id'=>$cardUser['card_id'],'is_delete'=>0])->find();
              }
              if($card&&empty($card_coupon_id)){
                  $discount=$card['discount'];

                  if($card['type']==2){
                      $hour=0;
                      $coutHour=$num;
                      
                      $cardHouseIds=explode(',',$card['house_ids']);
                      $feePirce=0;
                      if($card['house_ids']=='-1'||in_array($data['house_id'],$cardHouseIds)){

                        if($coutHour<=$cardUser['hour']){
                         $hour=$coutHour;
                         $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                         if($payPrice<$feePirce){
                             $feePirce=$payPrice;
                         }
                         $payPrice-=$feePirce;
                        }
                      
                        if($coutHour>$cardUser['hour']&&$cardUser['hour']>0){
                          $hour=$cardUser['hour'];
                          $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                          if($payPrice<$feePirce){
                             $feePirce=$payPrice;
                          }
                          $payPrice-=$feePirce;
                        }
                      }

                      if($house['member_price']>0){
                            if($house['type']==2){
                                $payPrice=self::houseRoomPrice($house,$start_time,$end_time,1); 
                            }else{
                                $payPrice=$house['member_price']*($coutHour-$hour);
                            }
                      }else{
                            $payPrice=$payPrice*$discount/10;
                      }
                  }else if($card['type']==3){
                      $use_start_time=date("Y-m-d",$start_time).' '.$card['use_start_time'];
                      $use_end_time=date("Y-m-d",$end_time).' '.$card['use_end_time'];
                      $use_start_time=strtotime($use_start_time);
                      $use_end_time=strtotime($use_end_time);
                      if($use_start_time>$use_end_time){
                        $use_end_time=date("Y-m-d",time()+86400).' '.$card['use_end_time'];
                        $use_end_time=strtotime($use_end_time);
                      }
                      $feePirce=0;
                      if($start_time==$use_start_time&&$use_end_time==$end_time){
                       
                          $hour=0;
                          $coutHour=$num;
                          $cardHouseIds=explode(',',$card['house_ids']);
                          
                          if($card['house_ids']=='-1'||in_array($data['house_id'],$cardHouseIds)){
                            if($coutHour<=$cardUser['hour']){
                             $hour=$coutHour;
                             $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                             if($payPrice<$feePirce){
                                 $feePirce=$payPrice;
                             }
                             $payPrice-=$feePirce;
                            }
                          
                            if($coutHour>$cardUser['hour']&&$cardUser['hour']>0){
                              $hour=$cardUser['hour'];
                              $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                              if($payPrice<$feePirce){
                                 $feePirce=$payPrice;
                              }
                              $payPrice-=$feePirce;
                            }
                          }
                          if($house['member_price']>0){
                                if($house['type']==2){
                                    $payPrice=self::houseRoomPrice($house,$start_time,$end_time,1); 
                                }else{
                                    $payPrice=$house['member_price']*($coutHour-$hour);
                                }
                          }else{
                                $payPrice=$payPrice*$discount/10;
                          }
                      }

                  }else{
                    if($house['member_price']>0){
                      $bookNum=($endtime-$start_time)/1800;
                      $booknum1=ceil($bookNum)/2;
                      if($house['type']==2){
                         $payPrice=self::houseRoomPrice($house,$start_time,$end_time,1);   ;
                      }else{
                         $payPrice=$house['member_price']*$booknum1;
                      }
                      
                    }else{
                      $house_price=$card['house_price'];
                      $hour=0;
                      if($house_price>0){
                          $coutHour=(int)($orderPrice/$house_price);
                          if($coutHour<=$cardUser['hour']){
                            $hour=$coutHour;
                          }
                      }

                      $payPrice=($orderPrice-$hour*$house_price)*$discount/10;
                    }
                  }
              }
           }
       }
       if($card_coupon_id&&$pay_type!=3){
          $cardCoupon=CardCoupon::where(['id'=>$card_coupon_id,'acid'=>$this->acid,'user_id'=>$this->user_id,'status'=>1])->field('id,name,discounts_price')->find();
          if($cardCoupon){
              if($house['original_price']>=$house['price']){
                $payPrice=$num*$house['original_price'];
              }else{
                $payPrice=$num*$house['price'];
              }
              if($payPrice>=$cardCoupon->discounts_price){
                  $orderPrice=$payPrice;
                  $payPrice-=$cardCoupon->discounts_price;
              }else{
                return fetchJson([],'支付价格必须大于等于美团兑换券价格',1);
              }
          }
       }
       $coupon_user_id=input('coupon_user_id');
       if($coupon_user_id&&$pay_type!=3){
          $userCoupon=CouponUser::where(['id'=>$coupon_user_id,'is_use'=>0,'type'=>Coupon::TYPE_HOTEL,'user_id'=>$this->user_id])->find();
          $coupon=Coupon::where('id',$userCoupon['coupon_id'])->find();
          if($coupon){
              if($coupon['full_price']<=$payPrice){
                $payPrice-=$coupon['price'];
                $userCoupon->discounts_price=$coupon['price'];
                $userCoupon->save();
              }
          }
       }
       $store_coupon_user_id=input('store_coupon_user_id');
       if($store_coupon_user_id){
          $storeUserCoupon=StoreCouponUser::where(['id'=>$store_coupon_user_id,'is_use'=>0,'user_id'=>$this->user_id])->where('type','in','1,4')->find();
          $storeCoupon=StoreCoupon::where('id',$storeUserCoupon['coupon_id'])->find();
          if($storeCoupon){
              if($storeCoupon['full_price']<=$payPrice){
                $payPrice-=$storeCoupon['price'];
                $storeUserCoupon->discounts_price=$storeCoupon['price'];
                $storeUserCoupon->save();
              }
          }
       }
       $store=Store::where(['id'=>$house['store_id']])->field('pay_types,warm_hint,is_show_room_status')->find();
       $popup=0;
       if($store['is_show_room_status']==1){
          if($house['room_status']==2){
             $popup='本房间还未清扫，可能会影响您的消费体验。请选择其他房间。';
          }
       }
       $xd_price=$house['price'];
       if($discount>0){
          $xd_price=$house['price']*($discount*0.1);
          $xd_price=round($xd_price,2);
       }
       return fetchJson([
          'price'=>round($orderPrice,2),
          'pay_price'=>round($payPrice,2),
          'xd_price'=>$xd_price,
          'discount'=>$discount,
          'subscibe'=>$subscibe,
          'hour'=>$hour,
          'feeHour'=>$feeHour,
          'day'=>timetodate(($end_time-$start_time),1),
          'user_money'=>$this->user->money,
          'user_store_money'=>StoreUserMoney::where(['store_id'=>$house['store_id'],'user_id'=>$this->user_id])->value('money'),
          'warm_hint'=>$store['warm_hint'],
          'pay_types'=>$store['pay_types'],
          'popup'=>$popup,
       ]);

    }
    //提交订单
    public function submit(){
        try {
          $data=request()->post();
          $rule = [
               'house_id|房间ID' => 'require|number',
               'start_time|入住时间'=>'require',
               'tel|电话'=>'require',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $house=House::where('id',$data['house_id'])->find();
       if(!$house){
          return fetchJson([],'暂无茶室',1);
       }
       $is_room_status=Store::where(['id'=>$house['store_id']])->value('is_room_status');
       if($is_room_status==2){
            $house_room_status=House::where('id',$data['house_id'])->value('room_status');
            if($house_room_status==2){
                return fetchJson([],'该房间未打扫，不可下单',1);
            }
       }
       $user_cash_grade=Usercashgrade::whereFindInSet('store_ids',$house['store_id'])->where(['acid'=>$this->acid,'status'=>1,'is_delete'=>0])->column('id');
       if($user_cash_grade){
          if(!UsercashgradeOrder::where(['acid'=>$this->acid,'status'=>1,'user_id'=>$this->user_id])->where('user_cash_grade_id','in',$user_cash_grade)->count()){
             return fetchJson([],'该门店暂时无法使用，请前往我的缴纳押金方可使用',1);
          }
       }
       $pay_type=input('pay_type');
       $book_type=input('book_type');
       $time=time();
       $start_time=strtotime($data['start_time']);

       $end_time=strtotime($data['end_time']);
       //优化----------------------------------
       $newhours=($end_time-$start_time)/3600;
       if($start_time<$time){
          $start_time=strtotime(date('Y-m-d H:i',$time));
          $end_time=$start_time+$newhours*3600;
       }
       //优化----------------------------------
       if($end_time<$time){
          return fetchJson([],'预订时间已过',1);
       }
       if($start_time>$end_time){
          return fetchJson([],'预订时间错误',1);
       }
       $starttime=strtotime(date('Y-m-d H:i',$start_time));
       $endtime=strtotime(date('Y-m-d H:i',$end_time));
       $halfDay=($endtime-$starttime)/3600;
       $booktime=$house['booktime']>0?$house['booktime']:1;
       if($halfDay<$booktime){
          return fetchJson([],'预订时间请大于等于'.$booktime.'小时',1);
       }
       if($house['type']!=2){
            self::storeBusinessHours($house['store_id'],$starttime,$endtime);
       }
        $exist = HouseOrder::where(['acid'=>$house['acid'],'house_id'=>$data['house_id']])
        ->where('status','in','1,2,0')
        ->where('start_time', '<=', $endtime)  
        ->where('end_time', '>=', $starttime) 
        ->find();
       if($exist){
            return fetchJson([],'该时间段已经被预定了！',1);
       }
       $exist1 = HouseOrderContinue::where(['acid'=>$house['acid'],'house_id'=>$data['house_id'],'status'=>1])
        ->where('start_time', '<=', $endtime)  
        ->where('end_time', '>=', $starttime)  
        ->find();
       if($exist1){
            return fetchJson($exist1,'该时间段已经被续单了~',1);
       }
       
       $dayArr=houseTimeOemPus($starttime,$endtime);
       foreach($dayArr as $dV){
            $is_booKtime=HouseStockOem::where(['acid'=>$house['acid'],'store_id'=>$house['store_id'],'house_id'=>$data['house_id']])
            ->where('status',1)
            ->whereTime('start_time','<=',$dV)
            ->whereTime('end_time','>=',$dV)
            ->count();
            if($is_booKtime){
                return fetchJson([],date('Y-m-d H:i:s',$dV).'该时间段已预订',1);
            }
       }
       $repetition_submint=Cache::get("repetition".$this->user_id);
       if($repetition_submint){
           return fetchJson([],'请勿重复提交',1);
       }else{
           Cache::set("repetition".$this->user_id,1,10);
       }
       $order=new HouseOrder();
       $order->acid=$this->acid;
       $order->user_id=$this->user_id;
       $order->order_no=HouseOrder::crateOrderNo('HN');
       $order->username=$this->user->nickname;
       $order->tel=$data['tel'];
       $order->house_id=$data['house_id'];
       $order->store_id=$house['store_id'];
       $order->start_time=$starttime;
       $order->end_time=$endtime;
       $order->pay_type=1;
       $order->is_verifier=$house['open_type']==2?1:0;
       //--------------------------------------------------------------------------------------------------------------

       $num=($endtime-$start_time)/3600;
       $num=round($num,2);
       $num1=explode(".",$num);
       if(isset($num1[1])){
           $x=$num1[0];
           $y=$num1[1];
           if($y>=50){
             $x+=1;
             $y=0;
           }
           if($y>0&&$y<50){
             $y=50;
           }
           $num=$x.".".$y;
           $num=$num*1;
       }
       if($house['type']==2){
            $end_time=input('end_time');
            if(!$end_time){
                return fetchJson([],'离店时间必传',1); 
            }
            $start_time=date('Y-m-d',strtotime(input('start_time')));
            $end_time=date('Y-m-d',strtotime($end_time));
            $start_time=strtotime($start_time);
            $end_time=strtotime($end_time);
            $orderPrice=self::houseRoomPrice($house,$start_time,$end_time);
            $order->price=$orderPrice;
            $order->start_time=$start_time;
            //添加到第二天的下午2点
            $order->end_time=$end_time+50400;
            $check_people=input('check_people');
            if(!$check_people){
                return fetchJson([],'入住人信息不得为空',1); 
            }
            $check_people=@json_decode($check_people,true);
            $user_name='';
            foreach($check_people as $people){
                if(!$people['name']){
                     return fetchJson([],'入住人姓名不得为空',1); 
                }
                if(!$people['IDnum']){
                     return fetchJson([],'入住人身份证不得为空',1); 
                }
                if(!$user_name){
                    $user_name=$people['name'];
                }
            }
            $order->username=$user_name;
            $order->check_people=json_encode($check_people,JSON_UNESCAPED_UNICODE);
       }else{
           $order->price=self::getTimePirce($house,$start_time,$end_time);
           $package_price=@json_decode($house['package_price'],1);
           if($package_price){
              foreach ($package_price as $package){
                  if(isset($package['num'])&&isset($package['price'])&&isset($package['title'])){
                    if($package['num']==$num){
                      $order->price=$package['price'];
                      $order->package_price=$package['title'];
                      break;
                    }
                  }
              }
           }
       }
       $store_id=$house['store_id'];
       $cardUser=CardUser::alias('c_u')
       ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
       ->where(function ($query) use($store_id) {
            $query->whereFindInSet('c.store_ids',$store_id)
            ->whereOr('c.store_ids','-1');
       })
       ->where(['c_u.status'=>1,'c_u.user_id'=>$this->user_id,'c_u.is_delete'=>0]);
       $cardUser->where('c_u.start_time','<',$time)->where('c_u.end_time','>',strtotime(date('Y-m-d',$time))-86399);
       $card_user_id=input('card_user_id');
       if($card_user_id){
          $cardUser=$cardUser->where('c_u.id',$card_user_id);
       }
       $orderPrice=$order->price;
       $orderPayPrice=$order->price;
       $order->type=empty($house['type'])?1:$house['type'];

       $order->save();
       $feeHour=0;
       //使用合伙人支付
       $partnerUser=PartnerUser::where([
          'user_id'=>$this->user_id,
          'acid'=>$this->acid,
           'status'=>1
        ])->find();
       $partnerStatus=0;
       if($partnerUser){
          $partnerStatus=Partner::where([
            'id'=>$partnerUser->partner_id,
            'acid'=>$this->acid,
            'is_delete'=>0,
            'status'=>1
          ])->count();
       }
       if($partnerStatus&&$partnerUser&&$pay_type!=3){
          if($partnerUser->end_time<-1){
            $partnerUser->end_time=-1;
            $partnerUser->save();
          }
          if($partnerUser->end_time>time()&&$partnerUser->start_time<time()||$partnerUser->end_time==-1){
              $partner=Partner::where([
                'id'=>$partnerUser->partner_id,
                'acid'=>$this->acid
              ])->find();
              $everyday_hour=$partner->everyday_hour;
              $hour=PartnerUserOrder::where(['user_partner_id'=>$partnerUser->id,'user_id'=>$this->user_id,'acid'=>$this->acid,'status'=>1])->whereDay('create_time','today')->sum('hour');
              $useHour=$everyday_hour-$hour;
              if($useHour>0){
                if($useHour>$num){
                   $feeHour=$num;
                }else{
                   $feeHour=$useHour;
                }
                //免费金额
                $feehourPirce=self::getTimePirce($house,$start_time,$end_time,$feeHour);
                if($feeHour==0){
                  $feehourPirce=0;
                }
                if($feehourPirce>$partnerUser->money&&$partnerUser->money>0){
                  $feehourPirce=$partnerUser->money;
                }
                $feehourPirce=$feehourPirce>$orderPayPrice?$orderPayPrice:$feehourPirce;
                $order->pay_price=$orderPayPrice-$feehourPirce;  
                $order->snapshoot=json_encode($house);
                $order->store_id=$house['store_id'];
                $order->save();
                //插入订单记录
                if($feehourPirce){
                  (new PartnerUserOrder())->save([
                    'acid'=>$this->acid,
                    'type'=>1,
                    'user_id'=>$this->user_id,
                    'user_partner_id'=>$partnerUser->id,
                    'order_id'=>$order->id,
                    'hour'=>$feeHour,
                    'price'=>$feehourPirce
                  ]);
                }
                return fetchJson($order);
              }
          }
       }else{
         $card_coupon_id=input('card_coupon_id');
         $cardUser=$cardUser->order('c.level DESC')->field('c_u.*')->find();
         if($cardUser){
            if($pay_type==2){
               $card=Card::where(['id'=>$cardUser['card_id'],'is_delete'=>0,'is_balance'=>1])->find();
            }else{
               $card=Card::where(['id'=>$cardUser['card_id'],'is_delete'=>0])->find();
            }

            if($card&&empty($card_coupon_id)){
                 $discount=$card['discount'];
                 if($card['type']==2){
                      $hour=0;
                      $order->card_type=$card['type'];
                      $coutHour=$num;
                      $cardHouseIds=explode(',',$card['house_ids']);
                      $feePirce=0;
                      if($card['house_ids']=='-1'||in_array($order->house_id,$cardHouseIds)){
                         if($coutHour<=$cardUser['hour']){
                           $hour=$coutHour;
                           $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                           if($orderPayPrice<$feePirce){
                               $feePirce=$orderPayPrice;
                           }
                           $orderPayPrice-=$feePirce;
                         }
                         if($coutHour>$cardUser['hour']&&$cardUser['hour']>0){
                           $hour=$cardUser['hour'];
                           $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                           if($orderPayPrice<$feePirce){
                               $feePirce=$orderPayPrice;
                           }
                           $orderPayPrice-=$feePirce;
                         }
                      }
                      if($house['member_price']>0){
                            if($house['type']==2){
                                $orderPayPrice=self::houseRoomPrice($house,$start_time,$end_time,1); 
                            }else{
                                $orderPayPrice=$house['member_price']*($coutHour-$hour);
                            }
                      }else{
                            $orderPayPrice=$orderPayPrice*$discount/10;
                      }
                      
                      (new CardUserOrder())->save([
                        'acid'=>$this->acid,
                        'order_id'=>$order->id,
                        'user_id'=>$this->user_id,
                        'card_user_id'=>$cardUser->id,
                        'order_id'=>$order->id,
                        'price'=>($orderPrice-$orderPayPrice)<=0?$feePirce:$orderPrice-$orderPayPrice,
                        'hour'=>$hour,
                        'discount'=>$discount
                      ]);
                  }else if($card['type']==3){
                      $use_start_time=date("Y-m-d",$start_time).' '.$card['use_start_time'];
                      $use_end_time=date("Y-m-d",$end_time).' '.$card['use_end_time'];
                      $use_start_time=strtotime($use_start_time);
                      $use_end_time=strtotime($use_end_time);
                      if($use_start_time>$use_end_time){
                        $use_end_time=date("Y-m-d",time()+86400).' '.$card['use_end_time'];
                        $use_end_time=strtotime($use_end_time);
                      }
                      if($start_time==$use_start_time&&$use_end_time==$end_time){
                          $hour=0;
                          $order->card_type=$card['type'];
                          $coutHour=$num;
                          $cardHouseIds=explode(',',$card['house_ids']);
                          $feePirce=0;
                          if($card['house_ids']=='-1'||in_array($order->house_id,$cardHouseIds)){
                             if($coutHour<=$cardUser['hour']){
                               $hour=$coutHour;
                               $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                               if($orderPayPrice<$feePirce){
                                   $feePirce=$orderPayPrice;
                               }
                               $orderPayPrice-=$feePirce;
                             }
                             if($coutHour>$cardUser['hour']&&$cardUser['hour']>0){
                               $hour=$cardUser['hour'];
                               $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                               if($orderPayPrice<$feePirce){
                                   $feePirce=$orderPayPrice;
                               }
                               $orderPayPrice-=$feePirce;
                             }
                          }
                          if($house['member_price']>0){
                                if($house['type']==2){
                                    $orderPayPrice=self::houseRoomPrice($house,$start_time,$end_time,1); 
                                }else{
                                    $orderPayPrice=$house['member_price']*($coutHour-$hour);
                                }
                          }else{
                                $orderPayPrice=$orderPayPrice*$discount/10;
                          }
                          (new CardUserOrder())->save([
                            'acid'=>$this->acid,
                            'order_id'=>$order->id,
                            'user_id'=>$this->user_id,
                            'card_user_id'=>$cardUser->id,
                            'order_id'=>$order->id,
                            'price'=>($orderPrice-$orderPayPrice)<=0?$feePirce:$orderPrice-$orderPayPrice,
                            'hour'=>$hour,
                            'discount'=>$discount
                          ]);
                      }

                  }else{
                      if($house['member_price']>0){
                        $bookNum=($endtime-$start_time)/1800;
                        $booknum1=ceil($bookNum)/2;
                        if($house['type']==2){
                             $orderPayPrice=self::houseRoomPrice($house,$start_time,$end_time,1);   ;
                        }else{
                            $orderPayPrice=$house['member_price']*$booknum1;
                        }
                        (new CardUserOrder())->save([
                          'acid'=>$this->acid,
                          'order_id'=>$order->id,
                          'user_id'=>$this->user_id,
                          'card_user_id'=>$cardUser->id,
                          'order_id'=>$order->id,
                          'price'=>$orderPrice-$orderPayPrice,
                          'hour'=>0,
                          'discount'=>10
                        ]);
                      }else{
                        $house_price=$card['house_price'];
                        
                        $hour=0;
                        if($house_price>0){
                            $coutHour=(int)($orderPrice/$house_price);
                            if($coutHour<=$cardUser['hour']){
                              $hour=$coutHour;
                            }
                        }
                        $orderPayPrice=($orderPrice-$hour*$house_price)*$discount/10;
                        (new CardUserOrder())->save([
                          'acid'=>$this->acid,
                          'order_id'=>$order->id,
                          'user_id'=>$this->user_id,
                          'card_user_id'=>$cardUser->id,
                          'order_id'=>$order->id,
                          'price'=>$orderPrice-$orderPayPrice,
                          'hour'=>$hour,
                          'discount'=>$discount
                        ]);
                      }
                 }
            }
         }
       }

       //使用卡券
       if($card_coupon_id=input('card_coupon_id')){
          $cardCoupon=CardCoupon::where(['id'=>$card_coupon_id,'acid'=>$this->acid,'user_id'=>$this->user_id,'status'=>1])->field('id,name,discounts_price')->find();
          if($cardCoupon&&$pay_type!=3){
              if($house['original_price']>=$house['price']){
                $orderPayPrice=$num*$house['original_price'];
                $orderMeituanPrice=$num*$house['original_price'];
              }else{
                $orderPayPrice=$num*$house['price'];
                $orderMeituanPrice=$num*$house['price'];
              }
              if($orderPayPrice>=$cardCoupon->discounts_price){
                  $order->price=$orderPayPrice;
                  $order->meituan_price=$orderMeituanPrice;
                  $orderPayPrice-=$cardCoupon->discounts_price;
                  (new CardCouponOrder())->save([
                    'card_coupon_id'=>$card_coupon_id,
                    'order_id'=>$order->id,
                    'user_id'=>$order->user_id,
                  ]);
                  $order->card_coupon_id=$card_coupon_id;
              }else{
                return fetchJson([],'支付价格必须大于等于美团兑换券价格',1);
              }
          }
       }
       //优惠券使用
       $coupon_user_id=input('coupon_user_id');
       if($coupon_user_id&&$pay_type!=3){
          $userCoupon=CouponUser::where(['id'=>$coupon_user_id,'is_use'=>0,'type'=>Coupon::TYPE_HOTEL,'user_id'=>$this->user_id])->field('coupon_id,discounts_price')->find();
          $coupon=Coupon::where('id',$userCoupon->coupon_id)->find();
          if($coupon){
              if($coupon['full_price']<=$orderPayPrice){
                $userCoupon->discounts_price=$coupon['price'];
                $userCoupon->save();
                if($order->price<0){
                  $order->price=0;
                }else{
                  $order->coupon_user_id=$coupon_user_id;
                }
              }
          }
       }
       //优惠券使用
       $store_coupon_user_id=input('store_coupon_user_id');
       if($store_coupon_user_id){
          $userCoupon=StoreCouponUser::where(['id'=>$store_coupon_user_id,'is_use'=>0,'user_id'=>$this->user_id])->where('type','in','1,4')->field('coupon_id,discounts_price')->find();

          $storeCoupon=StoreCoupon::where('id',$userCoupon->coupon_id)->find();
          if($storeCoupon){
              if($storeCoupon['full_price']<=$orderPayPrice){
                $userCoupon->discounts_price=$storeCoupon['price'];
                $userCoupon->save();
                if($order->price<0){
                  $order->price=0;
                }else{
                  $order->store_coupon_user_id=$store_coupon_user_id;
                }
              }
          }
       }

       $order->pay_price=$orderPayPrice>0?$orderPayPrice:0;

       
       $snapshootData=[
           'id'=>$house['id'],
           'name'=>$house['name'],
           'cover'=>$house['cover'],
           'lng'=>$house['lng'],
           'lat'=>$house['lat'],
           'price'=>$house['price'],
           'member_price'=>$house['member_price'],
           'booktime'=>$house['booktime'],
           'ahead_time'=>$house['ahead_time'],
           'forward_time'=>$house['forward_time'],
           'address'=>$house['address'],
           'cancel_time'=>$house['cancel_time']
       ];
       $store=Store::where('id',$house['store_id'])->find();
       $snapshootData['is_wallet']=$store['is_wallet'];
       $snapshootData['store_info']=[
            'id'=>$store['id'],
            'area_id'=>$store['area_id'],
            'name'=>$store['name'],
            'logo'=>$store['logo'],
            'banner'=>$store['banner'],
            'address'=>$store['address'],
       ];
       if($formation_num=input('formation_num')){
          if($formation_num>1){
             $order->is_formation=1;
             $order->formation_price=$order->pay_price-($order->pay_price/$formation_num);
             $order->formation_num=$formation_num;
             $order->formation_category=input('formation_category');
          }
       }
       $order->snapshoot=json_encode($snapshootData);
       $order->store_id=$house['store_id'];
       $order->book_type=$book_type==2?2:1;
       $order->save();
       return fetchJson($order);
    }
    //支付订单
    public function orderPay(){

       $order_id=input('order_id');
       $order=HouseOrder::where(['id'=>$order_id,'user_id'=>$this->user_id,'is_pay'=>0])->find();
       if(!$order){
          return fetchJson([],'暂无订单',1);
       }
       $starttime=$order->start_time;
       $endtime=$order->end_time;
       $halfDay=($endtime-$starttime)/3600;
       $house=House::where('id',$order->house_id)->find();
       $booktime=$house['booktime']>0?$house['booktime']:1;
       if($halfDay<$booktime){
          return fetchJson([],'预订时间请大于等于'.$booktime.'小时',1);
       }
       $dayArr=houseTimeOemPus($starttime,$endtime);
       foreach($dayArr as $dV){
            $is_booKtime=HouseStockOem::where(['acid'=>$house['acid'],'store_id'=>$house['store_id'],'house_id'=>$order->house_id])
            ->where('status',1)
            ->whereTime('start_time','<=',$dV)
            ->whereTime('end_time','>=',$dV)
            ->count();
            if($is_booKtime){
                return fetchJson([],date('Y-m-d H:i:s',$dV).'该时间段已预订',1);
            }
       }
       $update_time=strtotime($order->update_time);
       if($update_time+10<time()){
          $order->order_no=HouseOrder::crateOrderNo('HN');
       }
       $pay_type=input('pay_type')?input('pay_type'):1;
       //使用优惠券
       $couponUser=CouponUser::where(['id'=>$order->coupon_user_id,'is_use'=>0,'type'=>Coupon::TYPE_HOTEL,'user_id'=>$this->user_id])->find();
       if($couponUser&&$pay_type!=3){
          $order->pay_price=$order->pay_price-$couponUser->discounts_price;
          $couponUser->is_use=1;
          $couponUser->save();
       }else{
          $order->coupon_user_id=0;
       }

       //使用优惠券
       $storeCouponUser=StoreCouponUser::where(['id'=>$order->store_coupon_user_id,'is_use'=>0,'user_id'=>$this->user_id])->where('type','in','1,4')->find();
       if($storeCouponUser){
          $order->pay_price=$order->pay_price-$storeCouponUser->discounts_price;
          $storeCouponUser->is_use=1;
          $storeCouponUser->save();
       }else{
          $order->store_coupon_user_id=0;
       }
	   $order->pay_price=$order->pay_price>0?$order->pay_price:0;
       $order->pay_type=$pay_type;
       $order->save();
        //判断是否用余额支付
       if($pay_type==2){
           $res=self::balancePayment($order);
           return fetchJson([],$res['msg'],$res['code']);
       }
        //判断是否用店铺余额支付
       if($pay_type==3){
           $res=self::storeBalancePayment($order);
           return fetchJson([],$res['msg'],$res['code']);
       }
       //钱不够的时候
       if($order->pay_price<=0){
           if($order->pay_price<0){
               return fetchJson([],'支付价格'.$order->pay_price,1);
           }
           $order->pay_price=0;
           $order->pay_type=2;
           $order->save();
           $res=self::balancePayment($order);
           return fetchJson([],$res['msg'],$res['code']);
       }
       $app=App::find($this->acid);
       $appid=$app->wxapp_app_id;
       $app_secret=$app->wxapp_app_secret;
       $openid=$this->user->wxapp_open_id;
       if(input('is_weixin')==1){
          $appid=$app->wx_app_id;
          $app_secret=$app->wx_app_secret;
          $openid=$this->user->wx_open_id;
       }
       if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
            $appConfig=Option::get_data($this->acid,'platform','app_config');
            $appConfig=@json_decode($appConfig);
            $appid=isset($appConfig->appid)?$appConfig->appid:'';
            $app_secret=isset($appConfig->app_secret)?$appConfig->app_secret:'';
       }
       $wx_config=[
            'appid'=>$appid,
            'appsecret'=>$app_secret,
            'mchid'=>$app->wx_mch_id,
            'key'=>$app->wx_key,
            'sslcert'=>$app->wx_cert_pem,
            'sslkey'=>$app->wx_key_pem,
       ];
       if(isset($app->wx_pay_type)){
          $storeWx=Store::where('id',$order->store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey,fee,wx_sub_config')->find();
          //服务商模式
          if($app->wx_pay_type==2){
             $wx_config=[
                  'appid'=>$appid,
                  'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                  'wx_server_appid'=>$app->wx_server_appid,
                  'appsecret'=>$app_secret,
                  'wx_server_mch_id'=>$app->wx_server_mch_id,
                  'key'=>$app->wx_server_key,
                  'sslcert'=>$app->wx_server_cert_pem,
                  'sslkey'=>$app->wx_server_key_pem,
                  'sub_appid'=>$appid,
                  'sub_mch_id'=>$app->wx_mch_id,
                  'wx_pay_type'=>$app->wx_pay_type
             ];
             $wx_sub_config=@json_decode($storeWx['wx_sub_config'],1);
             if(isset($wx_sub_config['shared_teahouse']['status'])){
                $wx_sub_config['shared_teahouse']['status']=$wx_sub_config['shared_teahouse']['status']*1;
                if(isset($wx_sub_config['shared_teahouse']['fee'])&&$wx_sub_config['shared_teahouse']['status']==1){
                    $order->sub_account_status=1;
                    $order->save();
                    $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                }
             }
          }else{
             if($storeWx['wx_mch_id']){
                $wx_config=[
                      'appid'=>$appid,
                      'appsecret'=>$app_secret,
                      'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                      'key'=>$storeWx['wx_key']?$storeWx['wx_key']:$app->wx_key,
                      'sslcert'=>$storeWx['wx_sslcert']!=0?$storeWx['wx_sslcert']:$app->wx_cert_pem,
                      'sslkey'=>$storeWx['wx_sslkey']!=0?$storeWx['wx_sslkey']:$app->wx_key_pem,
                 ];

                 $wx_sub_config=@json_decode($storeWx['wx_sub_config'],1);
                 if(isset($wx_sub_config['shared_teahouse']['status'])){
                    $wx_sub_config['shared_teahouse']['status']=$wx_sub_config['shared_teahouse']['status']*1;
                    if(isset($wx_sub_config['shared_teahouse']['fee'])&&$wx_sub_config['shared_teahouse']['status']==1){
                        $order->sub_account_status=1;
                        $order->save();
                        $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                    }
                 }
             }
          }
       }
       $wechatPay=new WechatPay($wx_config);
       $notify_url=request()->domain().str_replace('index.php', 'pay_shared.php',request()->baseFile());
       $paydata = [
            'body' =>$order->house_title.'购买商品',
            'out_trade_no' => $order->order_no,
            'total_fee' => round($order->pay_price,2)* 100,
            'notify_url' =>$notify_url ,
            'trade_type' => 'JSAPI',
            'openid' => $openid,
        ];
       //字节跳动支付
       if($this->platform=='ttapp'){
             $paydata=[
                'body' =>$order->house_title.'购买商品',
                'appid'=>$app->wx_app_id,
                'attach'=>'购买商品',
                'mch_id'=>$app->mch_id,
                'notify_url' =>$notify_url ,
                'out_trade_no' => $order->order_no,
                'total_fee' => round($order->pay_price,2)* 100,
                'trade_type' => 'MWEB',
                'openid' => $openid,
                'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
            ];
            $ttapp=Option::get_data($this->acid,'platform','ttapp_config');
            $ttapp=@json_decode($ttapp);
            $res=$wechatPay->toutiaoh5pay($paydata,$ttapp);
            if($res['code']==0){
              return fetchJson($res);
            }else{
              return fetchJson([],$res['msg'],1);
            }
       }
        //微信外部支付
       if($this->platform=='h5'&&input('is_weixin')==0){
            $paydata=[
              'body' =>$order->house_title.'购买商品',
              'appid'=>$app->wx_app_id,
              'attach'=>'购买商品',
              'mch_id'=>$app->mch_id,
              'notify_url' =>$notify_url ,
              'out_trade_no' => $order->order_no,
              'total_fee' => round($order->pay_price,2)* 100,
              'trade_type' => 'MWEB',
              'openid' => $openid,
              'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
            ];
            $rest['order_id']=$order->id;
            $res=$wechatPay->h5pay($paydata);
            if($res['code']==0){
              $rest['mweb_url']=$res['data'];
              return fetchJson($rest);
            }else{
              return fetchJson([],$res['msg'],1);
            }
       }
       if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
            unset($paydata['openid']);
            $paydata['trade_type']="APP";
            $res=$wechatPay->appPay($paydata);
       }else{
          $res=$wechatPay->pay($paydata);
       }
       $res['order_id']=$order->id;
       return fetchJson($res);
    }
   //余额支付
    private function balancePayment($order=[]){
         $user=User::where('id',$order['user_id'])->find();
         $cardUserOrder=CardUserOrder::where(['order_id'=>$order->id,'type'=>1])->find();
         if($cardUserOrder){
            $cardUser=CardUser::where('id',$cardUserOrder->card_user_id)->find();
            if($cardUser){
              $card=Card::where(['id'=>$cardUser->card_id,'is_balance'=>0])->count();
              if($card){
                 $order->pay_price+=$cardUserOrder->price;
                 $order->save();
                 $cardUserOrder->is_delete=1;
                 $cardUserOrder->save();
              }
            }
         }
         if($user->money<$order->pay_price){
            return [
              'msg'=>'余额不足',
              'code'=>1
            ];
         }
         
         $form=new \app\shared\logic\pay\HouseOrderOemForm();
         $res=$form->saveOrder($order->order_no);
         if($res=='success'){
            return [
              'msg'=>'支付成功',
              'code'=>0
            ];
         }
        return [
          'msg'=>'余额支付错误',
          'code'=>1
        ];
    }
    private function storeBalancePayment($order=[]){
         $user=StoreUserMoney::where(['user_id'=>$order['user_id'],'store_id'=>$order['store_id']])->find();
         if(!$user){
            return [
              'msg'=>'用户商户余额不足',
              'code'=>1
            ];
         }
         if($user->money<$order->pay_price){
            return [
              'msg'=>'用户商户余额不足',
              'code'=>1
            ];
         }
         $form=new \app\shared\logic\pay\HouseOrderOemForm();
         $res=$form->saveOrder($order->order_no);
         if($res=='success'){
            return [
              'msg'=>'支付成功',
              'code'=>0
            ];
         }
        return [
          'msg'=>'用户商户余额支付错误',
          'code'=>1
        ];
    }
    //取消订单
    public function cancelOrder(){
        $order_id=input('order_id');
        $order=HouseOrder::where(['id'=>$order_id,'user_id'=>$this->user_id])->where('status','in','0,1,2')->find();
        if(!$order){
           return fetchJson([],'暂无订单',1);
        }
        //订单开始后几分钟可退款
        $use_refund_time=Store::where('id',$order->store_id)->value('use_refund_time');
        $order_start_time=$order->start_time+$use_refund_time*60;
        if($order_start_time<time()&&$order->status==2){
            return fetchJson([],'退款失败，开始时间可退款已过了',1);
        }
        $cancel_time=House::where('id',$order->house_id)->value('cancel_time');
        $order_cancel_time=$order->start_time-$cancel_time*60;
        if($order_cancel_time<time()&&$order->status==1){
            if($use_refund_time>0){
               if($order_start_time<time()){
                   return fetchJson([],'退款失败，退款时间已过了',1);
               }
            }else{
               return fetchJson([],'退款失败，退款时间已过了',1);
            }
        }
        if($order->status==0){
           $order->status=-1;
           //优惠券还原
           $userCoupon=CouponUser::where(['id'=>$order->coupon_user_id])->find();
           if($userCoupon){
               $order->pay_price+=$userCoupon['discounts_price'];
               $order->price=$order->pay_price;
               $order->coupon_user_id=0;
               $userCoupon->is_use=0;
               $userCoupon->order_id=0;
               $userCoupon->discounts_price=0;
               $userCoupon->use_time=0;
               $userCoupon->save();
           }
           //商家优惠券还原
           $storeUserCoupon=StoreCouponUser::where(['id'=>$order->store_coupon_user_id])->find();
           if($storeUserCoupon){
               $order->pay_price+=$storeUserCoupon['discounts_price'];
               $order->price=$order->pay_price;
               $order->store_coupon_user_id=0;
               $storeUserCoupon->is_use=0;
               $storeUserCoupon->use_time=0;
               $storeUserCoupon->save();
           }
           $order->save();
           return fetchJson([],'取消成功');
        }

        //已支付
        if($order->status==1||$order->status==2){
              $refund_rate=Store::where('id',$order->store_id)->value('refund_rate');
              if(!$refund_rate){
                 $refund_rate=0;
              }
              $refund_price=$order->pay_price*(100-$refund_rate)*0.01;
              $refund_price=filter_money($refund_price);
              $refund_fee_price=$order->pay_price-$refund_price;
              //微信支付
              $user=User::where('id',$order->user_id)->find();
              $app=App::find($order->acid);
              if($order->pay_type==1){
                 if($order->out_order_time>0){
                    return ['code' => 0, 'info' => '已经退过了','data' =>''];
                 }
                 $appid=$app->wxapp_app_id;
                 $app_secret=$app->wxapp_app_secret;
                 $wx_config=[
                      'appid'=>$appid,
                      'appsecret'=>$app_secret,
                      'mchid'=>$app->wx_mch_id,
                      'key'=>$app->wx_key,
                      'sslcert'=>$app->wx_cert_pem,
                      'sslkey'=>$app->wx_key_pem,
                 ];
                 if(isset($app->wx_pay_type)){
                    $storeWx=Store::where('id',$order->store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey,fee')->find();
                    //服务商模式
                    if($app->wx_pay_type==2){
                       $wx_config=[
                            'appid'=>$appid,
                            'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                            'wx_server_appid'=>$app->wx_server_appid,
                            'appsecret'=>$app_secret,
                            'wx_server_mch_id'=>$app->wx_server_mch_id,
                            'key'=>$app->wx_server_key,
                            'sslcert'=>$app->wx_server_cert_pem,
                            'sslkey'=>$app->wx_server_key_pem,
                            'sub_appid'=>$appid,
                            'sub_mch_id'=>$app->wx_mch_id,
                            'wx_pay_type'=>$app->wx_pay_type
                       ];
                       if($storeWx['fee']>0){
                            $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                       }
                    }else{
                       if($storeWx['wx_mch_id']){
                          $wx_config=[
                                'appid'=>$appid,
                                'appsecret'=>$app_secret,
                                'mchid'=>$storeWx['wx_mch_id'],
                                'key'=>$storeWx['wx_key'],
                                'sslcert'=>$storeWx['wx_sslcert'],
                                'sslkey'=>$storeWx['wx_sslkey']
                           ];
                           if($storeWx['fee']>0){
                              $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                           }
                       }
                    }

                 }
                 $wechatPay=new WechatPay($wx_config);
                 $notify_url='https://chashi-demo.youdiy.cn';
                 $order->out_order_no=HouseOrder::crateOutOrderNo();
                 $data = [
                    'out_refund_no' => $order->out_order_no,//订单号码
                    'out_trade_no' =>$order->order_no,//退款单号
                    'total_fee' =>  $order->pay_price * 100,//支付金额
                    'refund_fee' => $refund_price * 100,//全额退款
                ];
                if(isset($order->xml_array)){
                    $xml_array=@json_decode($order->xml_array,1);
                    if(isset($xml_array['transaction_id'])){
                      $data['transaction_id']=$xml_array['transaction_id'];
                    }
                }
                $payResult = $wechatPay->refund($data);
                if (!isset($payResult['return_code']) || $payResult['return_code'] != 'SUCCESS') {
                    $info='退款失败，' . (isset($payResult['return_msg']) ? $payResult['return_msg'] : '');
                    return fetchJson([],$info,1);
                }
                if (!isset($payResult['result_code']) || $payResult['result_code'] != 'SUCCESS') {
                    $info='提交业务失败，'. (isset($payResult['err_code_des']) ? $payResult['err_code_des'] : '');
                    return fetchJson([],$info,1);
                }
                $order->out_order_time=time();
                if($refund_price>0){
                    (new Bill())->save([
                        'acid'=>$order->acid,
                        'type'=>Bill::TYPE_HOUSE_REFUND,
                        'account_type'=>Bill::ACCOUNT_TYPE_USER,
                        'form_id'=>$order->user_id,
                        'order_id'=>$order->id,
                        'price'=>$refund_price,
                        'price_type'=>$order->pay_type,
                        'status'=>1,
                        'fee'=>$refund_fee_price,
                        'balance'=>$user->money,
                        'des'=>'用户: 【'.$user->nickname.'】茶室预订微信退款'
                    ]);
                }
             }
             //余额支付退款
             if($order->pay_type==2){
                $user->money+=$refund_price;
                $user->save();
                $order->out_order_no=HouseOrder::crateOutOrderNo();
                $order->out_order_time=time();
                if($refund_price>0){
                    (new Bill())->save([
                        'acid'=>$order->acid,
                        'type'=>Bill::TYPE_HOUSE_REFUND,
                        'account_type'=>Bill::ACCOUNT_TYPE_USER,
                        'form_id'=>$order->user_id,
                        'order_id'=>$order->id,
                        'price'=>$refund_price,
                        'price_type'=>$order->pay_type,
                        'status'=>1,
                        'fee'=>$refund_fee_price,
                        'balance'=>$user->money,
                        'des'=>'用户: 【'.$user->nickname.'】茶室预订余额退款'
                    ]);
                }
             }
             if($order->pay_type==3){
                $order->out_order_no=HouseOrder::crateOutOrderNo();
                $order->out_order_time=time();
                $storeUser=StoreUserMoney::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'user_id'=>$order->user_id])->find();
                if($storeUser){
                    $storeUser->money+=$refund_price;
                    $storeUser->save();
                    (new Bill())->save([
                        'acid'=>$order->acid,
                        'type'=>Bill::TYPE_HOUSE_REFUND,
                        'account_type'=>Bill::ACCOUNT_TYPE_USER,
                        'form_id'=>$order->user_id,
                        'order_id'=>$order->id,
                        'price'=>$refund_price,
                        'price_type'=>$order->pay_type,
                        'status'=>1,
                        'fee'=>$refund_fee_price,
                        'balance'=>$storeUser->money,
                        'des'=>'商户储值卡-用户: 【'.$user->nickname.'】茶室预订余额退款'
                    ]);
                }
             }
             if($refund_price>0&&$order->pay_type!=3){
                self::addStoreBill($order,$refund_fee_price);
             }
             HouseStockOem::where('order_id',$order->id)->update(['status'=>2]);
             //优惠券还原
             $userCoupon=CouponUser::where(['id'=>$order->coupon_user_id])->find();
             if($userCoupon){
                 $order->coupon_user_id=0;
                 $order->save();
                 $userCoupon->is_use=0;
                 $userCoupon->order_id=0;
                 $userCoupon->discounts_price=0;
                 $userCoupon->use_time=0;
                 $userCoupon->save();
             }
             //商家优惠券还原
             $storeUserCoupon=StoreCouponUser::where(['id'=>$order->store_coupon_user_id])->find();
             if($storeUserCoupon){
                 $order->store_coupon_user_id=0;
                 $order->save();
                 $storeUserCoupon->is_use=0;
                 $storeUserCoupon->use_time=0;
                 $storeUserCoupon->save();
             }
             //会员卡免费时长还原
             $cardUserOrder=CardUserOrder::where(['acid'=>$this->acid,'order_id'=>$order->id,'user_id'=>$this->user_id,'type'=>1])->find();
             if($cardUserOrder){
                 $cardUser=CardUser::where(['id'=>$cardUserOrder->card_user_id])->find();
                 $cardUser->hour+=$cardUserOrder->hour;
                 $cardUser->save();
                 $cardUserOrder->status=0;
                 $cardUserOrder->save();
             }
             //美团卡券
             $cardCoupon=CardCoupon::where(['id'=>$order->card_coupon_id])->find();
             if($cardCoupon){
                $cardCoupon->num+=1;
                $cardCoupon->status=1;
                $cardCoupon->save();
                CardCouponOrder::where(['order_id'=>$order->id])->update(['status'=>-1,'use_time'=>time()]);
             }
             $order->status=-2;
             $order->save();
             Cache::set('subscribeOrder'.$order_id,0,1);
             //发送保洁人员
             $weixin=new \weixin\Wechat();
             $snapshoot=@json_decode($order->snapshoot,1);
             $store=Store::where('id',$order->store_id)->field('openid,name,store_manager')->find();
             $data=[
                "first"    =>[
                  "value"  =>"取消订单",
                  "color"  =>"#173177"
                ],
                "keyword1" =>[
                  "value"  =>date("Y-m-d H:i",$order->start_time).' 至 '.date("Y-m-d H:i",$order->end_time),//取消时间
                  "color"  =>"#173177"
                ],
                "keyword2" =>[
                  "value"  =>$snapshoot['name'],//标签
                  "color"  =>"#173177"
                ],
                "thing11"=>[
                    'value'=>$snapshoot['name'],//房间名称
                ],
                "thing7"=>[
                    'value'=>$store['name'],//门店名称
                ],
                "time12"=>[
                    'value'=>date("Y-m-d H:i",$order->start_time),//开始时间
                ],
                "time13"=>[
                    'value'=>date("Y-m-d H:i",$order->end_time),//结束时间
                ],
                "phone_number15"=>[
                    'value'=>$order['tel'],//联系电话
                ],
            ];
            $openids=$store['openid'];
            if($openids){
                $openidArr=explode(',',$openids);
                $tpl=Option::get_data($this->acid,'platform','wx_template_new_cancel_order_inform');
                $tpl=$tpl?$tpl:Option::get_data($this->acid,'platform','wx_template_cancel_order_inform');
                $weixin->sendWxopenTemplatePro($app,$tpl,$openidArr,"pages/index/index",$data);
            }
            $res2=$weixin->atroomMsg($store['store_manager'],$data,4,$order['order_no']);
            self::sendCleaningTpl($app,$order);
            $elelist=Electricity::where(['order_id'=>$order->id])->field('id,status,end_time,start_time')->select();
            $eleClrCount=Electricity::alias('e')->leftJoin([HouseOrder::getTable()=>'o'],'e.order_id=o.id')
                ->where('e.order_id','<>',$order->id)
                ->where('o.house_id',$order->house_id)
                ->whereTime('e.start_time', '<=', time())
                ->whereTime('e.end_time', '>=', time())
                ->where('e.status','in','0,1')
                ->count();
            foreach($elelist as $evalue){
              if($evalue->start_time>time()){
                if($eleClrCount>0){
                    $evalue->status=2;
                }
                $evalue->start_time=time();
              }
              $evalue->end_time=time();
              $evalue->save();
            }
            $form= new \app\task\controller\Wechat();
            $form->offLvmiEle();
        }
        return fetchJson([],'退款成功');
    }
    //保洁端用户取消订单提醒
    public function sendCleaningTpl($app,$order){
        set_time_limit(0);
        $account=User::where('id',$order->user_id)->value('account');
        $snapshoot=@json_decode($order->snapshoot,1);
        $store=Store::where('id',$order->store_id)->field('address,name')->find();
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>"用户{$account}"."取消订单", //保洁时间：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>'订单时间'.date('m-d H:i',$order->start_time)."\r至".
              date('m-d H:i',$order->end_time), //保洁时间：
              "color"  =>"#173177"
            ],
            "thing1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
            ],
            "thing2" =>[
              "value"  =>"用户{$account}取消订单",//
            ],
            "time4" =>[
              "value"  => date('Y-m-d H:i',$order->start_time)."~".
              date('H:i',$order->end_time),
            ],
        ];
        $tpl=Option::get_data($order->acid,'platform','wx_template_new_cleaning_port_inform');
        $tpl=$tpl?$tpl:Option::get_data($order->acid,'platform','wx_template_cleaning_port_inform');
        //加强版群发
        $storeCleaning= StoreCleaning::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'is_delete'=>0,'status'=>1])->where('openid','<>','')->column('openid,account,id');
        $openidArr=array_column($storeCleaning,'openid');
        $phones=array_column($storeCleaning,'account');
        $weixin->sendWxopenTemplatePro($app,$tpl,$openidArr,"pages/index/index",$data);
        $res2=$weixin->atroomMsg($phones,$data,1,$order['order_no']);
    }
    //用户提前使用
    public function useOrdersEarlyTpl($app,$order){
        set_time_limit(0);
        $order=HouseOrder::where('id',$order->id)->find();
        $account=User::where('id',$order->user_id)->value('account');
        $snapshoot=@json_decode($order->snapshoot,1);
        $store=Store::where('id',$order->store_id)->field('address,name')->find();
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>"用户{$account}"."提前使用",//房间地址：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>'提前使用'.date('m-d H:i',$order->start_time)."\r至".
              date('m-d H:i',$order->end_time), //保洁时间：
              "color"  =>"#173177"
            ],
             "thing1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
            ],
            "thing2" =>[
              "value"  =>"用户{$account}下单提醒",//房间地址：
            ],
            "time4" =>[
              "value"  => date('Y-m-d H:i',$order->start_time)."~".
              date('H:i',$order->end_time),//房间地址：
            ],
        ];
        $wx_template_new_cleaning_port_inform=Option::get_data($order->acid,'platform','wx_template_new_cleaning_port_inform');
        $tpl=$wx_template_new_cleaning_port_inform?$wx_template_new_cleaning_port_inform:Option::get_data($order->acid,'platform','wx_template_cleaning_port_inform');
        //加强版群发
        $openidArr= StoreCleaning::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'is_delete'=>0,'status'=>1])->where('openid','<>','')->column('openid');
        $res=$weixin->sendWxopenTemplatePro($app,$tpl,$openidArr,"pages/index/index",$data);
    }
    //增加商户账单
    public function addStoreBill($order=[],$price=0){
        $store=Store::where('id',$order['store_id'])->find();
        $fee=($store->fee*0.01)*$price;
        $fee=$fee>0?$fee:0;//手续费
        $orderPrice=$price-$fee; //总金额   
        $stockHouse=StockHouseUser::alias('h_u')
               ->leftJoin([StockHouse::getTable()=>'h'],'h_u.stock_house_id=h.id')
               ->where(['h_u.acid'=>$order->acid,'h.house_id'=>$order->house_id,'h_u.is_delete'=>0,'h.is_delete'=>0])
               ->field('h_u.stock_user_id,h_u.ratio,h.house_id,h_u.stock_house_id')
               ->select()
               ->toArray();
        //只能用微信支付结算了
        if(isset($store->is_actually_weixin_pay)){
            if($store->is_actually_weixin_pay==1){
                return false;
            }
        }       
        //分红金额
        $sharePrice=0;           
        foreach($stockHouse as $hu){
           (new StockHouseUserOrder())->save([
              'acid'=>$order->acid,
              'type'=>1,
              'order_id'=>$order->id,
              'stock_house_id'=>$hu['stock_house_id'],
              'stock_user_id'=>$hu['stock_user_id'],
              'ratio'=>$hu['ratio'],
              'price'=>$hu['ratio']*$orderPrice*0.01, 
            ]);
           $user=StockUser::where('id',$hu['stock_user_id'])->field('money,total_price')->find();
           if($user){
             $user->money+=$hu['ratio']*$orderPrice*0.01;
             $user->total_price+=$hu['ratio']*$orderPrice*0.01;
             $user->save();
           }
           $sharePrice+=$hu['ratio']*$orderPrice*0.01;
        }  
        if($sharePrice>0){
            (new Bill())->save([
                'acid'=>$order['acid'],
                'type'=>Bill::TYPE_HOUSE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order['store_id'],
                'order_id'=>$order['id'],
                'price'=>$orderPrice-$sharePrice,
                'price_type'=>$order['pay_type'],
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】茶室用户退款手续费收入其中股东分红扣除'.$sharePrice.'元'
            ]);
            $store->money+=$orderPrice-$sharePrice;
        }else{
            (new Bill())->save([
                'acid'=>$order['acid'],
                'type'=>Bill::TYPE_HOUSE,
                'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                'form_id'=>$order['store_id'],
                'order_id'=>$order['id'],
                'price'=>$orderPrice-$sharePrice,
                'price_type'=>$order['pay_type'],
                'status'=>1,
                'fee'=>$fee,
                'des'=>'商户: 【'.$store->name.'】茶室用户退款手续费收入'
            ]);
            $store->money+=$orderPrice-$sharePrice;
        }        
        $store->save();
    } 
    //详情
    public function details(){
        $order_id=input('order_id');
        $order=HouseOrder::where(['id'=>$order_id])->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $order['snapshoot']=@json_decode($order['snapshoot'],1);
        $order['store']=Store::where('id',$order['store_id'])->field('tel,name,pay_types,use_refund_time,is_tea_specialist')->find();
        if($order['book_type']==3&&$order['is_pay']==0){
           $order['start_time']=date("Y-m-d H:i:s",$order['start_time']);
           $order['end_time']=$order['end_time']>0?date("Y-m-d H:i:s",$order['end_time']):'';
           return fetchJson($order,'获取成功');
        }
        $order_continue_list=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id DESC')->column('id,start_time,pay_price,price,end_time');
        $price=0;
        foreach ($order_continue_list as $key => &$value) {
          $value['start_time']=date('Y-m-d H:i',$value['start_time']);
          $value['end_time']=date('Y-m-d H:i',$value['end_time']);
          $price+=$value['pay_price'];
          $value['discounts_price']=$value['price']-$value['pay_price'];
        }
        $end_time=$order->end_time;
        $start_time=$order->start_time;
        $xdstart_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id ASC')->value('start_time');
        $start_time=$order['start_time'];
        if($xdstart_time){
          //续单
          if($xdstart_time>$order['start_time']){
              $xdend_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id DESC')->value('end_time');
              $end_time=$xdend_time;
          }else{
            //向前续单
              $start_time=$xdstart_time;
          }
        }
        $order['start_time']=date("Y-m-d H:i:s",$start_time);
        $order['end_time']=date("Y-m-d H:i:s",$end_time);

        if($start_time<time()&&$order['status']==1){
           HouseOrder::where(['id'=>$order_id,'user_id'=>$this->user_id])->update(['status'=>2]);
        }
        $order['pay_price']+=$price;
        $order['order_continue_list']=$order_continue_list;
        $card_user_order=CardUserOrder::alias('cuo')
            ->leftJoin([CardUser::getTable()=>'cu'],'cuo.card_user_id=cu.id')
            ->leftJoin([Card::getTable()=>'c'],'cu.card_id=c.id')
            ->where(['cuo.type'=>1,'cuo.order_id'=>$order->id,'cuo.user_id'=>$this->user_id,'cuo.is_delete'=>0])
            ->field('cuo.price,cuo.hour,cuo.discount,cuo.status,cuo.type,c.title')
            ->find();
        if($card_user_order){
           $card_user_order['discounts_price']=0;
        }
        //判断是否使用合伙人
        $is_table = Db::query('show tables like "'.PartnerUserOrder::getTable().'"');
        if($is_table){
          $partner_order=PartnerUserOrder::alias('puo')
          ->leftJoin([PartnerUser::getTable()=>'pu'],'puo.user_partner_id=pu.id')
          ->leftJoin([Partner::getTable()=>'p'],'pu.partner_id')
          ->where(['puo.order_id'=>$order->id,'puo.status'=>1])
          ->field("puo.*,p.title")->find();
          $order['partner_user_order']=$partner_order;
        }else{
          $order['partner_user_order']=[];
        }
        $order['card_user_order']=$card_user_order;
        $discounts_price=CouponUser::where(['id'=>$order->coupon_user_id,'type'=>Coupon::TYPE_HOTEL,'user_id'=>$this->user_id])->value('discounts_price');
        $order['discounts_price']=$discounts_price>0?$discounts_price:0;
        $storeCoupon=StoreCouponUser::alias('c_u')
        ->leftJoin([StoreCoupon::getTable()=>"c"],'c_u.coupon_id=c.id')
        ->where(['c_u.id'=>$order->store_coupon_user_id,'c_u.user_id'=>$this->user_id])
        ->where('c_u.type','in','1,4')
        ->field('c_u.id,c_u.discounts_price,c_u.verifier_code,c_u.verifier_id,c_u.type,c.name,c.detail')
        ->find();
        $order['store_coupon']=$storeCoupon;
        $order['store_discounts_price']=$storeCoupon['discounts_price']>0?$storeCoupon['discounts_price']:0;
        $order['card_coupon']=CardCouponOrder::alias('cco')->leftJoin([CardCoupon::getTable()=>'cc'],'cco.card_coupon_id=cc.id')->where(['cco.order_id'=>$order_id])->field('cc.discounts_price,cc.name,cco.id')->find();
        $house=House::where('id',$order['house_id'])->field('cancel_time,reordertime')->find();
        $order['cancel_time']=$house['cancel_time'];
        $order['reordertime']=$house['reordertime'];
        $order['warm_hint']=Store::where(['id'=>$order['store_id']])->value('warm_hint');
        $snapshoot=$order['snapshoot'];
        if(!isset($snapshoot['cancel_time'])){
            $snapshoot['cancel_time']=House::where('id',$order['house_id'])->value('cancel_time');
        }
        $order['is_use_refund']=($start_time+$order['store']['use_refund_time']*60)>time()?1:0;
        return fetchJson($order,'获取成功');
    }
    
    //订单续单预览
    public function orderContinuePreview(){
         try {
            $data=request()->post();
            $rule = [
                 'order_id|订单ID' => 'require|number',
                 'time|入住时间'=>'require|in:0.5,1,1.5,2,2.5,3,3.5,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5,10',
             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $order=HouseOrder::where(['id'=>$data['order_id'],'is_pay'=>1])->where('status','in','1,2')->find();
         if(!$order){
            return fetchJson([],'订单',1);
         }
         $pay_type=input('pay_type');
         $store_pay_type=Store::where(['id'=>$order->store_id])->whereFindInSet('pay_types',$pay_type)->count();
         if(!$store_pay_type){
            $pay_type_array=[1=>'微信支付',2=>'平台储值卡',3=>"店铺储值卡"];
            $pay_type_text=isset($pay_type_array[$pay_type])?$pay_type_array[$pay_type]:"";
            return fetchJson([],'该商户不支持'.$pay_type_text,1);
         }
         //向前续单
         if($type=input('type')){
              $start_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('start_time ASC')->value('start_time');
              if($start_time){
                $start_time=$start_time-$data['time']*3600;
                if($start_time<time()){
                   $start_time=time();
                }
                $end_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('start_time ASC')->value('start_time');
              }else{
                $start_time=$order->start_time-$data['time']*3600;
                if($start_time<time()){
                   $start_time=time();
                }
                $end_time=$order->end_time;
              }
         }else{
           // 向后续单
           $end_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('end_time DESC')->value('end_time');
           if($end_time){
              $start_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('end_time DESC')->value('end_time');
              $end_time=$end_time+$data['time']*3600;

           }else{
              $start_time=$order->end_time;
              $end_time=$order->end_time+$data['time']*3600;
           }
         }
         if($end_time<time()){
            return fetchJson([],'预订时间已过',1);
         }
         if($start_time>$end_time){
            return fetchJson([],'预订时间错误',1);
         }
         $starttime=strtotime(date('Y-m-d H:i',$start_time));
         $endtime=strtotime(date('Y-m-d H:i',$end_time));
         self::storeBusinessHours($order->store_id,$starttime,$endtime);
         $halfDay=($endtime-$starttime)/3600;
         $num=$halfDay;
         $dayArr=[];
         for ($j=1;$j<($halfDay+1);$j++){ 
            $dayArr[]=$starttime+1800*$j;
         }
         $store=Store::where(['id'=>$order->store_id])->field('id,book_interval_status')->find();
         if($store['book_interval_status']==1){
             $exist = HouseOrder::where(['acid'=>$order->acid,'house_id'=>$order->house_id])
                ->where('status','in','1,2,0')
                ->where('start_time', '<=', $endtime)  
                ->where('end_time', '>=', $starttime) 
                ->find();
         }else{
              $exist = HouseOrder::where(['acid'=>$order->acid,'house_id'=>$order->house_id])
                ->where('status','in','1,2,0')
                ->where('start_time', '<=', $endtime)  
                ->where('end_time', '>', $starttime) 
                ->find();
         }
         if($exist){
                return fetchJson([],'该时间段已经被预定了！',1);
         }
         if($store['book_interval_status']==1){
                $exist1 = HouseOrderContinue::where(['acid'=>$order->acid,'house_id'=>$order->house_id,'status'=>1])
                    ->where('start_time', '<=', $endtime)  
                    ->where('end_time', '>=', $starttime)  
                    ->find();
         }else{
                $exist1 = HouseOrderContinue::where(['acid'=>$order->acid,'house_id'=>$order->house_id,'status'=>1])
                    ->where('start_time', '<=', $endtime)  
                    ->where('end_time', '>', $starttime)  
                    ->find();
         }
         if($exist1){
                return fetchJson($exist1,'该时间段已经被续单了~',1);
         }
         $house=House::where('id',$order['house_id'])->find();
         $xdOrderPrice=self::getTimePirce($house,$start_time,$end_time);
         $package_price=@json_decode($house['package_price'],1);
         if(isset($house['is_repeat_original_price'])){
            if($house['is_repeat_original_price']!=1){
                if($package_price){
                    foreach ($package_price as $package){
                        if(isset($package['num'])&&isset($package['price'])){
                          if($package['num']==$num){
                            $xdOrderPrice=$package['price'];
                            break;
                          }
                        }
                    }
                 }    
            }
         }else{
            if($package_price){
                foreach ($package_price as $package){
                    if(isset($package['num'])&&isset($package['price'])){
                      if($package['num']==$num){
                        $xdOrderPrice=$package['price'];
                        break;
                      }
                    }
                }
             }
         }
         $xdOrderPayPrice=$xdOrderPrice;
         $time=time();
         $store_id=$order['store_id'];

         $cardUser=CardUser::alias('c_u')
         ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
         ->where(function ($query) use($store_id) {
            $query->whereFindInSet('c.store_ids',$store_id)
            ->whereOr('c.store_ids','-1');
         })
         ->where(['c_u.status'=>1,'c_u.user_id'=>$this->user_id,'c_u.is_delete'=>0]);
         $cardUser->where('c_u.start_time','<',$time)->where('c_u.end_time','>',strtotime(date('Y-m-d',$time))-86399);
         $card_user_id=input('card_user_id');
         if($card_user_id){
            $cardUser=$cardUser->where('c_u.id',$card_user_id);
         }
         $orderPrice=$xdOrderPrice;
         $orderPayPrice=$orderPrice;
         $cardUserList=$cardUser->order('c_u.status DESC,c.level DESC')
         ->field('c_u.*')
         ->limit(1)
         ->select();
         $cardUser=[];
         foreach($cardUserList as $cardUserV){
            $cardUser=$cardUserV;
         }
         $cardUserArr=[];
         $cardUserArr['title']='普通会员';
         $cardUserArr['price']=0;
         $is_repeat_order_original=0;
         $store=Store::where('id',$house['store_id'])->find();
         if(isset($store['is_repeat_order_original'])){
            $is_repeat_order_original=$store['is_repeat_order_original']==1?1:0;
         }

         if($cardUser&&$is_repeat_order_original==0){
            $card=Card::where(['id'=>$cardUser['card_id'],'is_delete'=>0])->find();

            if($card){
                $discount=$card['discount'];
                if($card['type']==2){
                    $hour=$cardUser['hour'];
                    $order->card_type=$card['type'];
                    $coutHour=$num;
                    $cardHouseIds=explode(',',$card['house_ids']);
                    $feePirce=0;
                    if($card['house_ids']=='-1'||in_array($order->house_id,$cardHouseIds)){
                       
                       if($coutHour<=$hour){
                         $hour=$coutHour;
                         $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                         $orderPayPrice-=$feePirce;
                       }
                       if($coutHour>$hour&&$hour>0){
                         $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                         $orderPayPrice-=$feePirce;
                       }
                    }
                    if($house['member_price']>0){
                        if($house['type']==2){
                            $orderPayPrice=self::houseRoomPrice($house,$start_time,$end_time,1); 
                        }else{
                            $orderPayPrice=$house['member_price']*($coutHour-$hour);
                        }
                    }else{
                        $orderPayPrice=$orderPayPrice*$discount/10;
                    }
                }else{
                   if($house['member_price']>0){
                    $bookNum=($endtime-$start_time)/1800;
                    $booknum1=ceil($bookNum)/2;
                    $orderPayPrice=$house['member_price']*$booknum1;
                    $cardUserArr['title']='会员价减免';
                    $cardUserArr['price']=$orderPrice-$orderPayPrice;
                  }else{
                        $house_price=$card['house_price'];
                        if($house_price>0){
                            $discount=$card['discount'];
                            $hour=$cardUser['hour'];
                            $coutHour=(int)($orderPrice/$house_price);
                            if($coutHour<=$hour){
                              $hour=$coutHour;
                              $cardUserArr['title']='会员优惠时长&折扣减免';
                            }else{
                              $cardUserArr['title']='会员折扣减免';
                            }
                            $orderPayPrice=($orderPrice-$hour*$house_price)*$discount/10;
                            $cardUserArr['price']=$orderPrice-$orderPayPrice;
                        }else{
                            $house_price=self::getTimePirce($house,$start_time,$end_time);
                            $discount=$card['discount'];
                            $hour=$cardUser['hour'];
                            $coutHour=(int)($orderPrice/$house_price);
                            if($coutHour<=$hour){
                              $hour=$coutHour;
                              $cardUserArr['title']='会员优惠时长&折扣减免';
                            }else{
                              $cardUserArr['title']='会员折扣减免';
                            }
                            $orderPayPrice=($orderPrice-$hour*$house_price)*$discount/10;
                            $cardUserArr['price']=$orderPrice-$orderPayPrice;
                      }
                  }
                }
                $xdOrderPayPrice=$orderPayPrice;
            }
         }
         $store=Store::where(['id'=>$house['store_id']])->field('pay_types')->find();
         return fetchJson([
          'card_user'=>$cardUserArr,
          'price'=>$orderPrice,
          'pay_price'=>$orderPayPrice,
          'pay_types'=>$store['pay_types']
         ]);
    }
    //订单续单提交
    public function orderContinueSubmit(){
         try {
            $data=request()->post();
            $rule = [
                 'order_id|订单ID' => 'require|number',
                 'time|入住时间'=>'require|in:0.5,1,1.5,2,2.5,3,3.5,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5,10',
             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         $order=HouseOrder::where(['id'=>$data['order_id'],'is_pay'=>1])->where('status','in','1,2')->find();
         if(!$order){
            return fetchJson([],'订单',1);
         }
         $pay_type=input('pay_type')?input('pay_type'):1;
         $store_pay_type=Store::where(['id'=>$order->store_id])->whereFindInSet('pay_types',$pay_type)->count();
         if(!$store_pay_type){
            $pay_type_array=[1=>'微信支付',2=>'平台储值卡',3=>"店铺储值卡"];
            $pay_type_text=isset($pay_type_array[$pay_type])?$pay_type_array[$pay_type]:"";
            return fetchJson([],'该商户不支持'.$pay_type_text,1);
         }
         //向前续单
         if($type=input('type')){
              $start_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('start_time ASC')->value('start_time');
              if($start_time){
                $start_time=$start_time-$data['time']*3600;
                if($start_time<time()){
                   $start_time=time();
                }
                $end_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('start_time ASC')->value('start_time');
              }else{
                $start_time=$order->start_time-$data['time']*3600;
                if($start_time<time()){
                   $start_time=time();
                }
                $end_time=$order->end_time;
              }
         }else{
           // 向后续单
           $end_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('end_time DESC')->value('end_time');
           if($end_time){
              $start_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('end_time DESC')->value('end_time');
              $end_time=$end_time+$data['time']*3600;

           }else{
              $start_time=$order->end_time;
              $end_time=$order->end_time+$data['time']*3600;
           }
         }
         

         if($end_time<time()){
            return fetchJson([],'预订时间已过',1);
         }
         if($start_time>$end_time){
            return fetchJson([],'预订时间错误',1);
         }
         $starttime=strtotime(date('Y-m-d H:i',$start_time));
         $endtime=strtotime(date('Y-m-d H:i',$end_time));
         self::storeBusinessHours($order->store_id,$starttime,$endtime);
         $halfDay=($endtime-$starttime)/3600;
         $num=$halfDay;
         $dayArr=houseTimeOemXdPus($starttime,$endtime);
         $store=Store::where(['id'=>$order->store_id])->field('id,book_interval_status')->find();
         if($store['book_interval_status']==1){
             $exist = HouseOrder::where(['acid'=>$order->acid,'house_id'=>$order->house_id])
                ->where('status','in','1,2,0')
                ->where('user_id',"<>",$order->user_id)
                ->where('start_time', '<=', $endtime)  
                ->where('end_time', '>=', $starttime) 
                ->find();
         }else{
              $exist = HouseOrder::where(['acid'=>$order->acid,'house_id'=>$order->house_id])
                ->where('status','in','1,2,0')
                ->where('user_id',"<>",$order->user_id)
                ->where('start_time', '<=', $endtime)  
                ->where('end_time', '>', $starttime) 
                ->find();
         }
         if($exist){
                return fetchJson([],'该时间段已经被预定了！',1);
         }
         if($store['book_interval_status']==1){
                $exist1 = HouseOrderContinue::where(['acid'=>$order->acid,'house_id'=>$order->house_id,'status'=>1])
                    ->where('start_time', '<=', $endtime)
                    ->where('user_id',"<>",$order->user_id)  
                    ->where('end_time', '>=', $starttime)  
                    ->find();
         }else{
                $exist1 = HouseOrderContinue::where(['acid'=>$order->acid,'house_id'=>$order->house_id,'status'=>1])
                    ->where('start_time', '<=', $endtime)
                    ->where('user_id',"<>",$order->user_id)  
                    ->where('end_time', '>', $starttime)  
                    ->find();
         }
         if($exist1){
                return fetchJson($exist1,'该时间段已经被续单了~',1);
         }
         $house=House::where('id',$order['house_id'])->find();
         $xdOrder=new HouseOrderContinue();
         $xdOrder->save([
            'order_no'=>HouseOrderContinue::crateOrderNo('XDN'),
            'start_time'=>$start_time,
            'end_time'=>$end_time,
            'order_id'=>$order->id,
            'user_id'=>$this->user_id,
            'acid'=>$order->acid,
            'house_id'=>$order->house_id,
            'store_id'=>$order->store_id,
         ]);
         $xdOrder->price=self::getTimePirce($house,$start_time,$end_time);
         $package_price=@json_decode($house['package_price'],1);
         if(isset($house['is_repeat_original_price'])){
            if($house['is_repeat_original_price']!=1){
                if($package_price){
                    foreach ($package_price as $package){
                        if(isset($package['num'])&&isset($package['price'])){
                          if($package['num']==$num){
                            $xdOrder->price=$package['price'];
                            break;
                          }
                        }
                    }
                } 
            }
         }else{
            if($package_price){
                foreach ($package_price as $package){
                    if(isset($package['num'])&&isset($package['price'])){
                      if($package['num']==$num){
                        $xdOrder->price=$package['price'];
                        break;
                      }
                    }
                }
             }
         }
         $xdOrder->pay_price=$xdOrder->price;
         $time=time();
         $store_id=$order['store_id'];
         $cardUser=CardUser::alias('c_u')
         ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
         ->where(function ($query) use($store_id) {
            $query->whereFindInSet('c.store_ids',$store_id)
            ->whereOr('c.store_ids','-1');
         })
         ->where(['c_u.status'=>1,'c_u.user_id'=>$this->user_id,'c_u.is_delete'=>0]);
         $cardUser->where('c_u.start_time','<',$time)->where('c_u.end_time','>',strtotime(date('Y-m-d',$time))-86399);
         $card_user_id=input('card_user_id');
         if($card_user_id){
            $cardUser=$cardUser->where('c_u.id',$card_user_id);
         }
         $orderPrice=$xdOrder->price;
         $orderPayPrice=$orderPrice;
         $cardUserList=$cardUser->order('c_u.status DESC,c.level DESC')
         ->field('c_u.*')
         ->limit(1)
         ->select();
         $cardUser=[];
         foreach($cardUserList as $cardUserV){
            $cardUser=$cardUserV;
         }
         $is_repeat_order_original=0;
         $store=Store::where('id',$order->store_id)->find();
         if(isset($store['is_repeat_order_original'])){
            $is_repeat_order_original=$store['is_repeat_order_original']==1?1:0;
         }
         if($cardUser&&$is_repeat_order_original==0){
            $card=Card::where(['id'=>$cardUser['card_id'],'is_delete'=>0])->find();
            if($card){
                $discount=$card['discount'];
                if($card['type']==2){
                    $hour=$cardUser['hour'];
                    $order->card_type=$card['type'];
                    $coutHour=$num;
                    $cardHouseIds=explode(',',$card['house_ids']);
                    $feePirce=0;
                    if($card['house_ids']=='-1'||in_array($order->house_id,$cardHouseIds)){
                       if($coutHour<=$hour){
                         $hour=$coutHour;
                         $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                         $orderPayPrice-=$feePirce;

                       }
                       if($coutHour>$hour&&$hour>0){
                         $feePirce=self::getTimePirce($house,$start_time,$end_time,$hour);
                         $orderPayPrice-=$feePirce;
                       }
                    }
                    if($house['member_price']>0){
                        if($house['type']==2){
                            $orderPayPrice=self::houseRoomPrice($house,$start_time,$end_time,1); 
                        }else{
                            $orderPayPrice=$house['member_price']*($coutHour-$hour);
                        }
                    }else{
                        $orderPayPrice=$orderPayPrice*$discount/10;
                    }
                    (new CardUserOrder())->save([
                      'acid'=>$this->acid,
                      'order_id'=>$xdOrder->id,
                      'user_id'=>$this->user_id,
                      'card_user_id'=>$cardUser->id,
                      'price'=>($orderPrice-$orderPayPrice)<=0?$feePirce:$orderPrice-$orderPayPrice,
                      'hour'=>$hour,
                      'type'=>10,
                      'discount'=>$discount
                    ]);
                }else{
                   if($house['member_price']>0){
                      $bookNum=($endtime-$start_time)/1800;
                      $booknum1=ceil($bookNum)/2;
                      $orderPayPrice=$house['member_price']*$booknum1;

                    }else{
                      $house_price=$card['house_price'];
                      $hour=0;
                      if($house_price>0){
                        $hour=$cardUser['hour'];
                        $coutHour=(int)($orderPrice/$house_price);
                        if($coutHour<=$hour){
                          $hour=$coutHour;
                        }
                      }
                      $orderPayPrice=($orderPrice-$hour*$house_price)*$discount/10;
                      (new CardUserOrder())->save([
                        'acid'=>$this->acid,
                        'order_id'=>$xdOrder->id,
                        'user_id'=>$this->user_id,
                        'card_user_id'=>$cardUser->id,
                        'price'=>$orderPrice-$orderPayPrice,
                        'type'=>10,
                        'hour'=>$hour,
                        'discount'=>$discount
                      ]);
                    }
                }
                
                $xdOrder->pay_price=$orderPayPrice;
            }
         }
         $xdOrder->save();
         return fetchJson($xdOrder);
    }
    //订单续单支付
    public function orderContinuePay(){
       $order_id=input('order_id');
       $order=HouseOrderContinue::where(['id'=>$order_id,'user_id'=>$this->user_id,'is_pay'=>0])->find();
       if(!$order){
          return fetchJson([],'暂无订单',1);
       }
       $update_time=strtotime($order->update_time);
       if($update_time+10<time()){
          $order->order_no=HouseOrderContinue::crateOrderNo('XDN');
       }
       $pay_type=input('pay_type')?input('pay_type'):1;
       $order->pay_type=$pay_type;
       $order->save();
        //判断是否用余额支付
       $starttime=$order->start_time;
       $endtime=$order->end_time;
       $store=Store::where(['id'=>$order->store_id])->field('id,book_interval_status')->find();
       if($store['book_interval_status']==1){
         $exist = HouseOrder::where(['acid'=>$order->acid,'house_id'=>$order->house_id])
            ->where('status','in','1,2,0')
            ->where('user_id',"<>",$order->user_id)
            ->where('start_time', '<=', $endtime)  
            ->where('end_time', '>=', $starttime) 
            ->find();
       }else{
          $exist = HouseOrder::where(['acid'=>$order->acid,'house_id'=>$order->house_id])
            ->where('status','in','1,2,0')
            ->where('user_id',"<>",$order->user_id)
            ->where('start_time', '<=', $endtime)  
            ->where('end_time', '>', $starttime) 
            ->find();
       }
       if($exist){
            return fetchJson([],'该时间段已经被预定了！',1);
       }
       if($store['book_interval_status']==1){
            $exist1 = HouseOrderContinue::where(['acid'=>$order->acid,'house_id'=>$order->house_id,'status'=>1])
                ->where('start_time', '<=', $endtime) 
                ->where('user_id',"<>",$order->user_id) 
                ->where('end_time', '>=', $starttime)  
                ->find();
       }else{
            $exist1 = HouseOrderContinue::where(['acid'=>$order->acid,'house_id'=>$order->house_id,'status'=>1])
                ->where('start_time', '<=', $endtime)
                ->where('user_id',"<>",$order->user_id)  
                ->where('end_time', '>', $starttime)  
                ->find();
       }
       if($exist1){
            return fetchJson($exist1,'该时间段已经被续单了~',1);
       }

       if($pay_type==2){
           $res=self::balancePaymentContinue($order);
           return fetchJson([],$res['msg'],$res['code']);
       }
       if($pay_type==3){
           $res=self::storeBalancePaymentContinue($order);
           return fetchJson([],$res['msg'],$res['code']);
       }
       $app=App::find($this->acid);
       $appid=$app->wxapp_app_id;
       $app_secret=$app->wxapp_app_secret;
       $openid=$this->user->wxapp_open_id;
       if(input('is_weixin')==1){
          $appid=$app->wx_app_id;
          $app_secret=$app->wx_app_secret;
          $openid=$this->user->wx_open_id;
       }
       if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
            $appConfig=Option::get_data($this->acid,'platform','app_config');
            $appConfig=@json_decode($appConfig);
            $appid=isset($appConfig->appid)?$appConfig->appid:'';
            $app_secret=isset($appConfig->app_secret)?$appConfig->app_secret:'';
       }
       $wx_config=[
            'appid'=>$appid,
            'appsecret'=>$app_secret,
            'mchid'=>$app->wx_mch_id,
            'key'=>$app->wx_key,
            'sslcert'=>$app->wx_cert_pem,
            'sslkey'=>$app->wx_key_pem,
       ];
       if(isset($app->wx_pay_type)){
          $storeWx=Store::where('id',$order->store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey,fee,wx_sub_config')->find();
          //服务商模式
          if($app->wx_pay_type==2){
             $wx_config=[
                  'appid'=>$appid,
                  'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                  'wx_server_appid'=>$app->wx_server_appid,
                  'appsecret'=>$app_secret,
                  'wx_server_mch_id'=>$app->wx_server_mch_id,
                  'key'=>$app->wx_server_key,
                  'sslcert'=>$app->wx_server_cert_pem,
                  'sslkey'=>$app->wx_server_key_pem,
                  'sub_appid'=>$appid,
                  'sub_mch_id'=>$app->wx_mch_id,
                  'wx_pay_type'=>$app->wx_pay_type
             ];
             $wx_sub_config=@json_decode($storeWx['wx_sub_config'],1);
             if(isset($wx_sub_config['shared_teahouse']['status'])){
                $wx_sub_config['shared_teahouse']['status']=$wx_sub_config['shared_teahouse']['status']*1;
                if(isset($wx_sub_config['shared_teahouse']['fee'])&&$wx_sub_config['shared_teahouse']['status']==1){
                    $order->sub_account_status=1;
                    $order->save();
                    $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                }
             }
          }else{
             if($storeWx['wx_mch_id']){
                $wx_config=[
                      'appid'=>$appid,
                      'appsecret'=>$app_secret,
                      'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                      'key'=>$storeWx['wx_key']?$storeWx['wx_key']:$app->wx_key,
                      'sslcert'=>$storeWx['wx_sslcert']!=0?$storeWx['wx_sslcert']:$app->wx_cert_pem,
                      'sslkey'=>$storeWx['wx_sslkey']!=0?$storeWx['wx_sslkey']:$app->wx_key_pem,
                 ];
                 $wx_sub_config=@json_decode($storeWx['wx_sub_config'],1);
                 if(isset($wx_sub_config['shared_teahouse']['status'])){
                    $wx_sub_config['shared_teahouse']['status']=$wx_sub_config['shared_teahouse']['status']*1;
                    if(isset($wx_sub_config['shared_teahouse']['fee'])&&$wx_sub_config['shared_teahouse']['status']==1){
                        $order->sub_account_status=1;
                        $order->save();
                        $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                    }
                 }
                
             }
          }
       }
       
       $wechatPay=new WechatPay($wx_config);
       $notify_url=request()->domain().str_replace('index.php', 'pay_shared.php',request()->baseFile());
       $paydata = [
            'body' =>$order->house_title.'购买商品',
            'out_trade_no' => $order->order_no,
            'total_fee' => round($order->pay_price,2)* 100,
            'notify_url' =>$notify_url ,
            'trade_type' => 'JSAPI',
            'openid' => $openid,
        ];
       //字节跳动支付
       if($this->platform=='ttapp'){
             $paydata=[
                'body' =>$order->house_title.'购买商品',
                'appid'=>$app->wx_app_id,
                'attach'=>'购买商品',
                'mch_id'=>$app->mch_id,
                'notify_url' =>$notify_url ,
                'out_trade_no' => $order->order_no,
                'total_fee' => round($order->pay_price,2)* 100,
                'trade_type' => 'MWEB',
                'openid' => $openid,
                'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
            ];
            $ttapp=Option::get_data($this->acid,'platform','ttapp_config');
            $ttapp=@json_decode($ttapp);
            $res=$wechatPay->toutiaoh5pay($paydata,$ttapp);
            if($res['code']==0){
              return fetchJson($res);
            }else{
              return fetchJson([],$res['msg'],1);
            }
       }
        //微信外部支付
       if($this->platform=='h5'&&input('is_weixin')==0){
            $paydata=[
              'body' =>$order->house_title.'购买商品',
              'appid'=>$app->wx_app_id,
              'attach'=>'购买商品',
              'mch_id'=>$app->mch_id,
              'notify_url' =>$notify_url ,
              'out_trade_no' => $order->order_no,
              'total_fee' => round($order->pay_price,2)* 100,
              'trade_type' => 'MWEB',
              'openid' => $openid,
              'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
            ];
            $rest['order_id']=$order->id;
            $res=$wechatPay->h5pay($paydata);
            if($res['code']==0){
              $rest['mweb_url']=$res['data'];
              return fetchJson($rest);
            }else{
              return fetchJson([],$res['msg'],1);
            }
       }
       if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
            unset($paydata['openid']);
            $paydata['trade_type']="APP";
            $res=$wechatPay->appPay($paydata);
       }else{
          $res=$wechatPay->pay($paydata);
       }
       $res['order_id']=$order->id;
       return fetchJson($res);
    }
    //续单
    private function balancePaymentContinue($order=[]){
         $user=User::where('id',$order['user_id'])->find();
         $cardUserOrder=CardUserOrder::where(['order_id'=>$order->id,'type'=>10])->find();
         if($cardUserOrder){
            $cardUser=CardUser::where('id',$cardUserOrder->card_user_id)->find();
            if($cardUser){
              $card=Card::where(['id'=>$cardUser->card_id,'is_balance'=>0])->count();
              if($card){
                 $order->pay_price+=$cardUserOrder->price;
                 $order->save();
                 $cardUserOrder->is_delete=1;
                 $cardUserOrder->save();
              }
            }
         }
         if($user->money<$order->pay_price){
            return [
              'msg'=>'余额不足',
              'code'=>1
            ];
         }
         $form=new \app\shared\logic\pay\HouseOrderContinueOemForm();
         $res=$form->saveOrder($order->order_no);
         if($res=='success'){
            return [
              'msg'=>'支付成功',
              'code'=>0
            ];
         }
        return [
          'msg'=>'余额支付错误',
          'code'=>1
        ];
    }
    //续单商家储值卡支付
    private function storeBalancePaymentContinue($order=[]){
         $user=StoreUserMoney::where(['user_id'=>$order['user_id'],'store_id'=>$order['store_id']])->find();
         if(!$user){
            return [
              'msg'=>'用户商户余额不足',
              'code'=>1
            ];
         }
         if($user->money<$order->pay_price){
            return [
              'msg'=>'用户商户余额不足',
              'code'=>1
            ];
         }
         $form=new \app\shared\logic\pay\HouseOrderContinueOemForm();
         $res=$form->saveOrder($order->order_no);
         if($res=='success'){
            return [
              'msg'=>'支付成功',
              'code'=>0
            ];
         }
        return [
          'msg'=>'用户商户余额支付错误',
          'code'=>1
        ];
    }
    //提前结束订单
    public function endOrdersEarly(){
        $order=HouseOrder::where(['id'=>input('order_id'),'is_pay'=>1])->where('status','in','1,2')->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $form= new \app\task\controller\Wechat();
        $form->endOrdersEarly($order);
        return fetchJson([],'提前结束订单');
    }
    public function timePus($start_time='',$end_time='',$book_interval_status=1){
         $dateHi=[];
         $start_time_H=strtotime(date('Y-m-d H',$start_time).':00');
         if($start_time>$start_time_H&&$start_time<$start_time_H+1800){
            $start_time=$start_time_H;
         }
         if($start_time>$start_time_H+1800&&$start_time<$start_time_H+3600){
            $start_time=$start_time_H+1800;
         }
         $end_time_H=strtotime(date('Y-m-d H',$end_time).':00');
         if($end_time<$end_time_H+1800){
            if($end_time>($end_time_H+900)){
                $end_time=$end_time_H+1800;
            }
         }
         if($end_time>$end_time_H+1800&&$end_time<$end_time_H+3600){
            if($end_time>($end_time_H+1800+900)){
                 $end_time=$end_time_H+3600;
            }
         }
         $numB=($end_time-$start_time)/1800;
         if($book_interval_status){
            $numB=$numB+1;
            $x=0;
         }else{
            $x=0;
         }
         for ($j=$x;$j<$numB;$j++){
           $time=$start_time+(1800*$j);
           $dateHi[date('Y-m-d H:i',$time)]=$time;
           //$dateHi[]=$time;
         }
         return $dateHi;
    }
    //提前使用订单
    public function useOrdersEarly(){
        $order=HouseOrder::where(['id'=>input('order_id'),'is_pay'=>1,'status'=>1])->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $start_time=time();
        $start_time1=$start_time;
        $numB=($order->end_time-$order->start_time)/1800;
        
        $end_time=$start_time+$numB*1800;
        self::storeBusinessHours($order->store_id,$start_time,$end_time);
        $dayArr=houseTimePus($start_time,$end_time);

        foreach($dayArr as $dV){
            $is_booKtime=HouseStockOem::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'house_id'=>$order->house_id])
            ->where('status',1)
            ->whereTime('start_time','<=',$dV)
            ->whereTime('end_time','>=',$dV)
            ->where('order_id','<>',$order->id)
            ->count();
            if($is_booKtime){
                return fetchJson([],date('Y-m-d H:i:s',$dV).'该时间段已预订',1);
            }
        }
        $order->start_time=$start_time1;
        $order->end_time=$end_time;
        //OEM修改房态
        HouseStockOem::where('order_id',$order->id)->update(['start_time'=>$order->start_time,'end_time'=>$order->end_time]);
        $order->save();
        $cacheOrder=Cache::get('subscribeOrder'.$order->id);
        $cacheOrder=@json_decode($cacheOrder,true);
        if(isset($cacheOrder['order']['start_time'])&&isset($cacheOrder['order']['end_time'])){
            $cacheOrder['order']['start_time']=$start_time1;
            $cacheOrder['order']['end_time']=$end_time;
        }
        Cache::set('subscribeOrder'.$order->id,json_encode($cacheOrder));
        $form=new HouseOrderDoorForm();
        $form->openRoom($order,1);
        $task= new \app\task\controller\Wechat();
        $task->sendSubscribe(0);
        $app=App::where('id',$order->acid)->find();
        if($app){
            self::useOrdersEarlyTpl($app,$order);
        }
        return fetchJson([],'提前成功');
    }

}


