<?php
namespace app\shared\logic\user;
use app\shared\model\User;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\House;
use app\shared\model\Coupon;
use app\shared\model\CouponUser;
use app\shared\model\HouseStock;
use app\shared\model\Electricity;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\CardUserOrder;
use wechatpay\WechatPay;
use app\shared\model\Store;
use app\shared\model\Bill;
use app\shared\model\ElectricityLine;
use app\shared\model\CardCoupon;
use app\shared\model\Partner;
use app\shared\model\PartnerUser;
use app\shared\model\PartnerUserOrder;
use app\shared\model\CardCouponOrder;
use app\shared\model\LumiElectricityConfig;
use app\shared\model\StoreCoupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\DoorDevice;
use slock\Slock;
use slock\Xsj;
use slock\Ttlock;
use think\facade\Cache;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
class HouseOrderDoorForm extends  UserForm
{
	//开房
    public function openRoom($order=[],$is_useOrdersEarly=0){
        if(!$order){
            $order_id=input('order_id');
            $order_no=input('order_no');
            if($order_no){
              $order=HouseOrder::where(['order_no'=>$order_no])->find();

            }else{
              $order=HouseOrder::where(['id'=>$order_id,'user_id'=>$this->user_id])->find();
            }
            if(!$order){
                return fetchJson([],'暂无订单',1);
            }
        }
        if($order['status']==-2){
            return fetchJson([],'订单已退款',1);
        }
        if($order['status']==-1){
            return fetchJson([],'订单已取消',1);
        }

        $onclick=input('onclick');
        $store=Store::where('id',$order->store_id)->field('smart_device,config,tel,name,lvmi_device,address,lng,lat,is_tea_specialist')->find();
        $smart_device=$store['smart_device'];
        if(empty($smart_device)){
           return fetchJson([],'开锁失败，请联系商家,暂无设备',1);
        }
        $smart_device=@json_decode($smart_device,1);
        $house=House::where('id',$order->house_id)->find();
        $ahead_time=$house['ahead_time']*60;
        $forward_time=$house['forward_time']*60;
        //曼顿取电
        $config=[
            'appKey'=>$smart_device['electronic_mandun_appKey'],
            'appSecret'=>$smart_device['electronic_mandun_appSecret'],
            'uname'=>$smart_device['electronic_mandun_uname'],
            'passwd'=>$smart_device['electronic_mandun_passwd'],
            'projectCode'=>$smart_device['electronic_mandun_projectCode'],
            'api_url'=>$smart_device['electronic_mandun_apiUrl'],
        ];
        $storeConfig=@json_decode($store['config'],1);
        $order['open_door_bgm']=isset($storeConfig['open_door_bgm'])?$storeConfig['open_door_bgm']:'';
        $order['open_room_bgm']=isset($storeConfig['open_room_bgm'])?$storeConfig['open_room_bgm']:'';

        $config['xsj_app_key']=isset($storeConfig['xsjConfig']['app_key'])?$storeConfig['xsjConfig']['app_key']:'';
        $config['xsj_yard_sn']=isset($storeConfig['xsjConfig']['yard_sn'])?$storeConfig['xsjConfig']['yard_sn']:'';

        $config['tt_lock_username']=isset($storeConfig['xsjConfig']['tt_lock_username'])?$storeConfig['xsjConfig']['tt_lock_username']:'';
        $config['tt_lock_password']=isset($storeConfig['xsjConfig']['tt_lock_password'])?md5($storeConfig['xsjConfig']['tt_lock_password']):'';
        $config['tt_lock_is_china']=isset($storeConfig['xsjConfig']['tt_lock_is_china'])?$storeConfig['xsjConfig']['tt_lock_is_china']:1;

       
        if($house['lockid']=='-1'||$house['lockid']=='0'){
             $order['is_lockid']=0;
        }else{
             $order['is_lockid']=1;
        }
        if($house['gatelockid']=='-1'||$house['gatelockid']=='0'){
             $order['is_gatelock']=0;
        }else{
             $order['is_gatelock']=1;
        }
        $end_time=$order->end_time;
        $start_time=$order->start_time;
        $continueOrder=HouseOrderContinue::where(['order_id'=>$order->id])->where('status','>',0)->order('id DESC')->field('start_time,end_time')->find();


        $xdstart_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id ASC')->value('start_time');
        if($xdstart_time){
          //续单
          if($xdstart_time>$order['start_time']){
              $xdend_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id DESC')->value('end_time');
              $end_time=$xdend_time;
              $order['end_time']=$end_time;
          }else{
            //向前续单
              $start_time=$xdstart_time;
              $order['start_time']=$start_time;
          }
        }
        if(($start_time)<time()&&$order['status']==1){
           HouseOrder::where(['id'=>$order->id])->update(['status'=>2]);
           $order['status']=2;
        }
        $order['is_network']=$house['is_network'];
        //开门方式
        //1、用户扫码开门，
    	//2、核销开门，
    	//3、13387开门方式，
    	//4、大门金属二维码门禁，包间优盯锁，
    	//5、大门金属二维码，包厢金属二维码门禁，
    	//6、大门金属二维码，包间通通锁
        $electricty_line_config=@json_decode($house['electricty_line_config'],1);
        //即到即用
        if($order['book_type']==3){
        	if($order['status']==1||$order['status']==3){
               return fetchJson([],'订单已结束',1);
            }

            $end_time=$start_time+$house['limit_time']*3600;
            
        }else{
        	if($order->status==0)return fetchJson([],'暂无支付订单',1);

            if($order->status==3)return fetchJson([],'订单已完成',1);
        }
        if($is_useOrdersEarly==1){
            self::electricityLine($house,$order,$config,$order->start_time,$order->end_time);
        }
        $snapshoot=@json_decode($order['snapshoot'],1);
        $snapshoot['address']=$store['address'];
        $snapshoot['lng']=$store['lng'];
        $snapshoot['lat']=$store['lat'];
        $order['is_bluetooth']=$house['is_bluetooth']==1?1:0;
        $order['is_psd_door']=$house['is_psd_door']==1?1:0;
        $order['snapshoot']=$snapshoot;
        $order['store']=[
        	'name'=>$store['name'],
        	'tel'=>$store['tel'],
            'is_tea_specialist'=>$store['is_tea_specialist']
        ];
        $order['end_time']=$end_time;
        $order['open_type']=$house['open_type'];
        if($house['is_network']==1){
            $order['tts_gatelockid_bluetooth']=0;
            $order['tts_lockid_bluetooth']=0;
            $order['tts_gatelockid_bluetooth_config']=[];
            $order['tts_lockid_bluetooth_config']=[];
            $order['gatelockidBluetooth']=[
                'gatelockid'=>'',
                'type'=>0,//1通通锁，2YY锁
                'data'=>[
                    'yy_appid'=>'',
                    'yy_appsecret'=>'',
                    'yy_device_pwd'=>'',
                    'yy_open_password'=>'',
                    'tt_lock_username'=>'',
                    'tt_lock_password'=>'',
                    'tt_open_password'=>''
                ]
            ];
            $order['lockidBluetooth']=[
                'lockid'=>'',
                'type'=>0,//1通通锁，2YY锁
                'data'=>[
                    'yy_appid'=>'',
                    'yy_appsecret'=>'',
                    'yy_device_pwd'=>'',
                    'yy_open_password'=>'',
                    'tt_lock_username'=>'',
                    'tt_lock_password'=>'',
                    'tt_open_password'=>''
                ]
            ];

            if($house['open_type']==6){
                if($house['lockid']){
                    $order['tts_lockid_bluetooth']=1;
                    $slock=new Ttlock($config);
                    $lockPwd=$slock->keyboardPwdGet($house['lockid'],date('Y-m-d H:i',($start_time-$ahead_time)),date('Y-m-d H:i',($end_time+$forward_time)));
                    $open_password='';
                    if($lockPwd['code']==0){
                        $open_password=$lockPwd['data'];
                    }
                    $order['tts_lockid_bluetooth_config']=[
                        'tt_lock_username'=>$config['tt_lock_username'],
                        'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                        'open_password'=>$open_password,
                        'lockid'=>$house['lockid'],
                    ];
                    $order['lockidBluetooth']=[
                        'lockid'=>$house['lockid'],
                        'type'=>1,//1通通锁，2YY锁
                        'data'=>[
                            'yy_appid'=>'',
                            'yy_appsecret'=>'',
                            'yy_device_pwd'=>'',
                            'yy_open_password'=>'',
                            'tt_lock_username'=>$config['tt_lock_username'],
                            'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                            'tt_open_password'=>$open_password,
                        ]
                    ];
                }
            }
            if($house['open_type']==7){
                if($house['gatelockid']){
                    $order['tts_gatelockid_bluetooth']=1;
                    $slock=new Ttlock($config);
                    $lockPwd=$slock->keyboardPwdGet($house['gatelockid'],date('Y-m-d H:i',($start_time-$ahead_time)),date('Y-m-d H:i',($end_time+$forward_time)));
                    $open_password='';
                    if($lockPwd['code']==0){
                        $open_password=$lockPwd['data'];
                    }
                    $order['tts_gatelockid_bluetooth_config']=[
                        'tt_lock_username'=>$config['tt_lock_username'],
                        'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                        'open_password'=>$open_password,
                        'gatelockid'=>$house['gatelockid'],
                    ];
                    $order['gatelockidBluetooth']=[
                        'gatelockid'=>$house['gatelockid'],
                        'type'=>1,//1通通锁，2YY锁
                        'data'=>[
                            'yy_appid'=>'',
                            'yy_appsecret'=>'',
                            'yy_device_pwd'=>'',
                            'yy_open_password'=>'',
                            'tt_lock_username'=>$config['tt_lock_username'],
                            'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                            'tt_open_password'=>$open_password,
                        ]
                    ];
                }
                if($house['lockid']){
                    $order['tts_lockid_bluetooth']=1;
                    $slock=new Ttlock($config);
                    $lockPwd=$slock->keyboardPwdGet($house['lockid'],date('Y-m-d H:i',($start_time-$ahead_time)),date('Y-m-d H:i',($end_time+$forward_time)));
                    $open_password='';
                    if($lockPwd['code']==0){
                        $open_password=$lockPwd['data'];
                    }
                    $order['tts_lockid_bluetooth_config']=[
                        'tt_lock_username'=>$config['tt_lock_username'],
                        'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                        'open_password'=>$open_password,
                        'lockid'=>$house['lockid'],
                    ];
                    $order['lockidBluetooth']=[
                        'lockid'=>$house['lockid'],
                        'type'=>1,//1通通锁，2YY锁
                        'data'=>[
                            'yy_appid'=>'',
                            'yy_appsecret'=>'',
                            'yy_device_pwd'=>'',
                            'yy_open_password'=>'',
                            'tt_lock_username'=>$config['tt_lock_username'],
                            'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                            'tt_open_password'=>$open_password,
                        ]
                    ];
                }
            }
            if($house['open_type']==11){
                if($house['gatelockid']){
                    $order['tts_gatelockid_bluetooth']=1;
                    $slock=new Ttlock($config);
                    $lockPwd=$slock->keyboardPwdGet($house['gatelockid'],date('Y-m-d H:i',($start_time-$ahead_time)),date('Y-m-d H:i',($end_time+$forward_time)));
                    $open_password='';
                    if($lockPwd['code']==0){
                        $open_password=$lockPwd['data'];
                    }
                    $order['tts_gatelockid_bluetooth_config']=[
                        'tt_lock_username'=>$config['tt_lock_username'],
                        'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                        'open_password'=>$open_password,
                        'gatelockid'=>$house['gatelockid'],
                    ];
                    $order['gatelockidBluetooth']=[
                        'gatelockid'=>$house['gatelockid'],
                        'type'=>1,//1通通锁，2YY锁
                        'data'=>[
                            'yy_appid'=>'',
                            'yy_appsecret'=>'',
                            'yy_device_pwd'=>'',
                            'yy_open_password'=>'',
                            'tt_lock_username'=>$config['tt_lock_username'],
                            'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                            'tt_open_password'=>$open_password,
                        ]
                    ];
                }
            }
            if($house['open_type']==12){
                if($house['lockid']){
                    $order['tts_lockid_bluetooth']=1;
                    $slock=new Ttlock($config);
                    $lockPwd=$slock->keyboardPwdGet($house['lockid'],date('Y-m-d H:i',($start_time-$ahead_time)),date('Y-m-d H:i',($end_time+$forward_time)));
                    $open_password='';
                    if($lockPwd['code']==0){
                        $open_password=$lockPwd['data'];
                    }
                    $order['tts_lockid_bluetooth_config']=[
                        'tt_lock_username'=>$config['tt_lock_username'],
                        'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                        'open_password'=>$open_password,
                        'lockid'=>$house['lockid'],
                    ];
                    $order['lockidBluetooth']=[
                        'lockid'=>$house['lockid'],
                        'type'=>1,//1通通锁，2YY锁
                        'data'=>[
                            'yy_appid'=>'',
                            'yy_appsecret'=>'',
                            'yy_device_pwd'=>'',
                            'yy_open_password'=>'',
                            'tt_lock_username'=>$config['tt_lock_username'],
                            'tt_lock_password'=>$storeConfig['xsjConfig']['tt_lock_password'],
                            'tt_open_password'=>$open_password,
                        ]
                    ];
                }
            }
            $yy_lockid_device_pwd=DoorDevice::where(['device_sn'=>$house['lockid'],'acid'=>$house['acid'],'is_delete'=>0,'type'=>1])->value('device_pwd');
            $yy_gatelockid_device_pwd=DoorDevice::where(['device_sn'=>$house['gatelockid'],'acid'=>$house['acid'],'is_delete'=>0,'type'=>1])->value('device_pwd');
            if($yy_lockid_device_pwd||$yy_gatelockid_device_pwd){
                $order['yy_gatelockid_bluetooth_config']=[
                    'appid'=>isset($smart_device['appid'])?$smart_device['appid']:'',
                    'appkey'=>isset($smart_device['appkey'])?$smart_device['appkey']:'',
                    'lockid'=>$house['lockid'],
                    'lockid_device_pwd'=>$yy_lockid_device_pwd,
                    'gatelockid'=>$house['gatelockid'],
                    'gatelockid_device_pwd'=>$yy_gatelockid_device_pwd
                ];
            }
            if($yy_lockid_device_pwd){
                $yy_slock=new Slock($smart_device);
                $yy_lockPost['keylockid']=$house['lockid'];
                $yy_lock=$yy_slock->getDeviceVistCode($yy_lockPost);
                if($yy_lock['code']==0){

                    $yy_open_password=$yy_lock['data'];
                }else{
                    $yy_open_password="GET PASSWORD ERROR";
                }
                
                $order['lockidBluetooth']=[
                    'lockid'=>$house['lockid'],
                    'type'=>2,//1通通锁，2YY锁
                    'data'=>[
                        'yy_appid'=>isset($smart_device['appid'])?$smart_device['appid']:'',
                        'yy_appsecret'=>isset($smart_device['appkey'])?$smart_device['appkey']:'',
                        'yy_device_pwd'=>$yy_lockid_device_pwd,
                        'yy_open_password'=>$yy_open_password,
                        'tt_lock_username'=>'',
                        'tt_lock_password'=>'',
                        'tt_open_password'=>''
                    ]
                ];
            }
            if($yy_gatelockid_device_pwd){
                $yy_slock=new Slock($smart_device);
                $yy_lockPost['keylockid']=$house['gatelockid'];
                $yy_lock=$yy_slock->getDeviceVistCode($yy_lockPost);
                if($yy_lock['code']==0){
                    $yy_open_password=$yy_lock['data'];
                }else{
                    $yy_open_password="GET PASSWORD ERROR";
                }
                $order['gatelockidBluetooth']=[
                    'gatelockid'=>$house['gatelockid'],
                    'type'=>2,//1通通锁，2YY锁
                    'data'=>[
                        'yy_appid'=>isset($smart_device['appid'])?$smart_device['appid']:'',
                        'yy_appsecret'=>isset($smart_device['appkey'])?$smart_device['appkey']:'',
                        'yy_device_pwd'=>$yy_gatelockid_device_pwd,
                        'yy_open_password'=>$yy_open_password,
                        'tt_lock_username'=>'',
                        'tt_lock_password'=>'',
                        'tt_open_password'=>''
                    ]
                ];
            
            }
        }
        $mac=$house['electricityid'];
        //联网方式使用按钮开门
        if($house['is_network']==1){
        	$onclick=input('onclick');
        	//13187电磁锁开门方案
        	if($house['open_type']==3){
        		if($onclick==1){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){

                        if($mac=="-1"||$mac=="0"||$mac==''){
                             //绿米配置开门
                             $lvelectricty_line_config=@json_decode($house['lvelectricty_line_config'],1);
                             $electricty_line=$lvelectricty_line_config[0];
                             $lvmi_device=@json_decode($store['lvmi_device'],1);
                             $accessToken=isset($lvmi_device['accessToken'])?$lvmi_device['accessToken']:'';
                             $task=new \app\shared\controller\Task();
                             $task->lvmihandleIntime($accessToken,$electricty_line);
                        }else{
                            $electricty_line=$electricty_line_config[0];
                            $task=new \app\shared\controller\Task();
                            $task->handleIntime($config,$mac,$electricty_line['line'],$electricty_line['status'],$electricty_line['minute']);
                        }
                        
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
                    return fetchJson($order,'大门开门成功');
	            }
	            if($onclick==2){
	                  if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                          
                          if($mac=="-1"||$mac=="0"||$mac==''){
                                 //绿米配置开门
                                $lvelectricty_line_config=@json_decode($house['lvelectricty_line_config'],1);
                                $electricty_line=$lvelectricty_line_config[1];
                                $lvmi_device=@json_decode($store['lvmi_device'],1);
                                $accessToken=isset($lvmi_device['accessToken'])?$lvmi_device['accessToken']:'';
                                $task=new \app\shared\controller\Task();
                                $task->lvmihandleIntime($accessToken,$electricty_line);
                          }else{
                               $electricty_line=$electricty_line_config[1];
                               $task=new \app\shared\controller\Task();
                               $task->handleIntime($config,$mac,$electricty_line['line'],$electricty_line['status'],$electricty_line['minute']);//副设备
                              
                          }
                          sleep(1);
                          self::electricityLine($house,$order,$config,$start_time,$end_time); 
			          }else{
                          return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                      }
	                  return fetchJson($order,'包厢开门成功');
	            }
        	}

        	//优盯智能锁
        	if($house['open_type']==1){
        		$slock=new Slock($smart_device);
        		if($onclick==1){
		            if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
			            self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $lockPost['keylockid']=$house['gatelockid'];
                        $lock=$slock->openRemoteDeviceLock($lockPost);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开大门失败,请联系管理员',1);
                        }
			        }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
		            return fetchJson($order,'开大门成功');
        		}
        		if($onclick==2){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        $lockPost['keylockid']=$house['lockid'];
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        if($house['lockid']==-1){
                            return fetchJson([],'请开包厢门进入',1);
                        }
                        $lock=$slock->openRemoteDeviceLock($lockPost);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员',1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                    }
		            return fetchJson($order,'开包厢成功');
        		}
	           
        	}
        	//大门金属二维码---包厢优盯智能锁
        	if($house['open_type']==4){
        		if($onclick==1){
		            if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
			            self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Xsj($config);
                        $lock=$slock->deviceRemote($house['gatelockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开大门失败,请联系管理员',1);
                        }
			        }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
		            return fetchJson([],'开大门成功');
        		}
        		if($onclick==2){
		            if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
			            self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Slock($smart_device);
                        $lockPost['keylockid']=$house['lockid'];
                        $lock=$slock->openRemoteDeviceLock($lockPost);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员',1);
                        }
			        }else{
                        return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                    }
		            return fetchJson($order,'开包厢成功');
        		}
	            return fetchJson($order,'开门错误',1);
        	}
        	//大门金属二维码---包厢金属二维码
        	if($house['open_type']==5){
        		$slock=new Xsj($config);
        		if($onclick==1){
		            if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
			            self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $lock=$slock->deviceRemote($house['gatelockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开大门失败,请联系管理员',1);
                        }
			        }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
		            return fetchJson($order,'开大门成功');
        		}
        		if($onclick==2){
		            if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $lock=$slock->deviceRemote($house['lockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员',1);
                        }
                        
			        }else{
                        return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                    }
		            return fetchJson($order,'开包厢门成功');
        		}
        	}
            //大门金属二维码---包厢通通锁
            if($house['open_type']==6){
                $slock=new Xsj($config);
                if($onclick==1){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $lock=$slock->deviceRemote($house['gatelockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开大门失败,请联系管理员',1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
                    return fetchJson($order,'开大门成功');
                }
                if($onclick==2){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Ttlock($config);
                        $lock=$slock->unlock($house['lockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员原因'.$lock['msg'],1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                    }
                    return fetchJson($order,'开包厢门成功');
                }
            }
             //大门通通锁---包厢通通锁
            if($house['open_type']==7){
                if($onclick==1){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Ttlock($config);
                        $lock=$slock->unlock($house['gatelockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开大门失败,请联系管理员'.$lock['msg'],1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
                    return fetchJson($order,'开大门成功');
                }
                if($onclick==2){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Ttlock($config);
                        $lock=$slock->unlock($house['lockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员原因'.$lock['msg'],1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                    }
                    return fetchJson($order,'开包厢门成功');
                }
            }
            if($house['open_type']==8){
                if($onclick==1){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Xsj($config);
                        $lock=$slock->deviceRemote($house['gatelockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开大门失败,请联系管理员',1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
                    return fetchJson($order,'开大门成功');
                }
                if($onclick==2){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $form=new \slock\Jwlock();
                        $lock=$form->qrcode($house['lockid'],($start_time-$ahead_time),($end_time+$forward_time));
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员',1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                    }
                    return fetchJson($order,'开包厢门成功');
                }
            }
            if($house['open_type']==9){
                if($onclick==1){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $form=new \slock\Jwlock();
                        $lock=$form->oneKeyLock($house['gatelockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,',开大门失败,请联系管理员',1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
                    return fetchJson($order,'开大门成功');                    
                }
                if($onclick==2){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $form=new \slock\Jwlock();
                        $lock=$form->oneKeyLock($house['lockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员',1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                    }
                    return fetchJson([],'开包厢门成功');
                }
            }
            //大门绿米包间优盯智能锁
            if($house['open_type']==10){
                if($onclick==1){
                    if($mac=="-1"||$mac=="0"||$mac==''){
                         //绿米配置开门
                         $lvelectricty_line_config=@json_decode($house['lvelectricty_line_config'],1);
                         $electricty_line=$lvelectricty_line_config[0];
                         $lvmi_device=@json_decode($store['lvmi_device'],1);
                         $accessToken=isset($lvmi_device['accessToken'])?$lvmi_device['accessToken']:'';
                         $task=new \app\shared\controller\Task();
                         $task->lvmihandleIntime($accessToken,$electricty_line);
                    }else{
                        $electricty_line_config=@json_decode($house['electricty_line_config'],1);
                        $electricty_line=$electricty_line_config[0];
                        $task=new \app\shared\controller\Task();
                        $task->handleIntime($config,$mac,$electricty_line['line'],$electricty_line['status'],$electricty_line['minute']);
                    }
                    self::electricityLine($house,$order,$config,$start_time,$end_time);
                    return fetchJson([],'大门开门成功');
                }
                if($onclick==2){
                    $slock=new Slock($smart_device);
                    $lockPost['keylockid']=$house['lockid'];
                    self::electricityLine($house,$order,$config,$start_time,$end_time);
                    $lock=$slock->openRemoteDeviceLock($lockPost);
                    if($lock['code']!=0){
                         $lock['lock_id']=$house['lockid'];
                       return fetchJson($lock,'开包厢失败'.$lock['msg'],1);
                    }
                    return fetchJson([],'开包厢成功');
                }
            }
             //大门通通锁---包厢YY锁
            if($house['open_type']==11){
                if($onclick==1){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Ttlock($config);
                        $lock=$slock->unlock($house['gatelockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开大门失败,请联系管理员'.$lock['msg'],1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
                    return fetchJson($order,'开大门成功');
                }
                if($onclick==2){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Xsj($config);
                        $lock=$slock->deviceRemote($house['lockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员',1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                    }
                    return fetchJson($order,'开包厢门成功');
                }
            }
             //大门YY锁---包厢通通锁
            if($house['open_type']==12){
                if($onclick==1){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Xsj($config);
                        $lock=$slock->deviceRemote($house['gatelockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员',1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开大门',1);
                    }
                    return fetchJson($order,'开大门成功');
                }
                if($onclick==2){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                        $slock=new Ttlock($config);
                        $lock=$slock->unlock($house['lockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开包厢失败,请联系管理员原因'.$lock['msg'],1);
                        }
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法开包厢',1);
                    }
                    return fetchJson($order,'开包厢门成功');
                }
            }
            //大门金属二维码---包厢通通锁
            if($house['open_type']==13){
                $slock=new Xsj($config);
                if($onclick==1){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        $lock=$slock->deviceRemote($house['gatelockid']);
                        if($lock['code']!=0){
                           return fetchJson($lock,'开大门失败,请联系管理员',1);
                        }
                    }else{
                        return fetchJson([],'暂未到预定时间，如到现场，请点击提前使用！谢谢',1);
                    }
                    return fetchJson($order,'开大门成功');
                }
                if($onclick==2){
                    if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                        self::electricityLine($house,$order,$config,$start_time,$end_time);
                    }else{
                        return fetchJson([],'不在服务时间范围内，无法取电',1);
                    }
                    return fetchJson($order,'无法取电门成功');
                }
            }

        }else{
            //联网方式使用二维码开门
            //核销员开门方式
            if($house['open_type']==2){
            	$order['qrcode_url']="https://api.pwmqr.com/qrcode/create/?url=".urlencode(json_encode(['type'=>1,'order_id'=>$order->id]));
                return fetchJson($order,'开房成功');
            }
            if(($start_time-$ahead_time)<time()&&($end_time+$forward_time)>time()){
                self::electricityLine($house,$order,$config,$start_time,$end_time);
            }
            if($house['open_type']==13){
                $slock=new Xsj($config);
                if($house['gatelockid']==-1||$house['gatelockid']==0){
                     $lock_id=$house['lockid'];
                }else{
                     $lock_id=$house['gatelockid'].",".$house['lockid'];
                }
                if($lock_id!=0){
                    $lock=$slock->deviceQr($lock_id,($start_time-$ahead_time),($end_time+$forward_time));
                    if($lock['code']!=0){
                       return fetchJson($lock,'获取失败',1);
                    }
                    $order['lock_password']=generateQrCode($lock['data'],'house_id'.$house['id']);
                    if(($end_time+$forward_time)<time()){
                       return fetchJson([],'订单已过期，无法开锁',1);
                    }
                }else{
                    $order['lock_password'] =-1;
                }
            }
            //优盯智能锁
        	if($house['open_type']==1){
		        $lockPost['keylockid']=$house['lockid'];
		        $lockPost['userid']=$smart_device['username'];
		        $lockPost['enddate']=date('YmdHis',$end_time+$forward_time);
		        $lockPost['startdate']=date('YmdHis',($start_time-$ahead_time));//软件测试了二位会提前20-30分钟，所以需要减去时间秒数
		        $lockPost['validminute']=5;
		        $slock=new Slock($smart_device);
		        $lock=$slock->getLockQRCode($lockPost);
		        if($lock['code']!=0){
		           return fetchJson([],'开锁失败,请联系管理员',1);
		        }
		        $order->lock_password='data:image/jpg;base64,'.$lock['data'];
		        
		        if(($end_time+$forward_time)<time()){
		           return fetchJson([],'订单已过期，无法开锁',1);
		        }
		        return fetchJson($order,'获取成功');
        	}
        	//大门金属二维码---包厢金属二维码
        	if($house['open_type']==5){
        		$slock=new Xsj($config);
                if($house['gatelockid']==-1||$house['gatelockid']==0){
                     $lock_id=$house['lockid'];
                }else{
                     $lock_id=$house['gatelockid'].",".$house['lockid'];
                }
                
		        $lock=$slock->deviceQr($lock_id,($start_time-$ahead_time),($end_time+$forward_time));
	            if($lock['code']!=0){
	               return fetchJson($lock,'获取失败',1);
	            }
                $order['lock_password']=generateQrCode($lock['data'],'house_id'.$house['id']);
	            
		        if(($end_time+$forward_time)<time()){
		           return fetchJson([],'订单已过期，无法开锁',1);
		        }
        	}
            //大门金属二维码---包厢金属二维码
            if($house['open_type']==9){
                $form=new \slock\Jwlock();
                
                $lock=$form->qrcode($house['lockid']);
                if($lock['code']!=0){
                   return fetchJson($lock,'开包厢失败,请联系管理员',1);
                }
                $order['lock_password']=generateQrCode($lock['data'],'house_id'.$house['id']);
                return fetchJson($order,'开门成功');
            }

        }
         return fetchJson($order);
    }
    
    //YY取电
    public function yYele($house,$config,$order,$start_time,$end_time){
        $slock=new Xsj($config);
        $electricity_yy_config=@json_decode($house['electricity_yy_config'],true);
        foreach($electricity_yy_config as $device){
              $form=Electricity::where(['acid'=>$this->acid,'order_id'=>$order['id'],'config'=>json_encode($config,JSON_UNESCAPED_UNICODE)])->find();
              if(!$form){
                    $form=new Electricity();
                    $form->status=0;
              }
              $form->save([
                  'acid'=>$this->acid,
                  'config'=>json_encode($config,JSON_UNESCAPED_UNICODE),
                  'order_id'=>$order['id'],
                  'mac'=>"YY",
                  'lockid'=>$device['electricityid'],
                  'line'=>-1,
                  'status'=>1,
                  'start_time'=>$start_time,
                  'end_time'=>$end_time,
              ]);
              $slock->electricity($device['electricityid'],1);
        }
        return fetchJson([],'取电成功');
    }
    public function electricityLine($house,$order,$config,$start_time,$end_time){
        if(!StoreCouponUser::where([
            'give_order_id'=>$order->id,
            'user_id'=>$order->user_id,
        ])->count()){
            //赠送商户优惠券
            $package_price=@json_decode($house['package_price'],1);
            if($package_price){
                $store_coupon_ids='';
                $num=($order->end_time-$order->start_time)/3600;
                foreach ($package_price as $package){
                  if(isset($package['num'])&&isset($package['store_coupon_ids'])){
                    if($package['num']==$num){
                      $store_coupon_ids=$package['store_coupon_ids'];
                      break;
                    }
                  }
                }
                $coupon_list=StoreCoupon::where('id','in',$store_coupon_ids)->column('type,id');
                foreach($coupon_list as $coupon){
                    $form=new StoreCouponUser();
                    $form->save([
                        'acid'=>$order->acid,
                        'store_id'=>$order->store_id,
                        'coupon_id'=>$coupon['id'],
                        'give_order_id'=>$order->id,
                        'user_id'=>$order->user_id,
                        'type'=>$coupon['type'],
                    ]);
                }
            }
        }
        //取电开始
        if($house['electricityid']=="-1"||$house['electricityid']=="0"||$house['electricityid']==''){
            $electricity_yy_config=@json_decode($house['electricity_yy_config'],true);
            if($electricity_yy_config){
                self::yYele($house,$config,$order,$start_time,$end_time);
            }else{
                self::lvjoinTask($house,$order,$start_time,$end_time);
            }    
        }else{
            $lineList=ElectricityLine::where([
                'acid'=>$house['acid'],
                'store_id'=>$house['store_id'],
                'mac'=>$house['electricityid'],
                'house_id'=>$house['id'],
                'is_delete'=>0
             ])->column('line,ahead_time,forward_time');
            foreach ($lineList as $key => $value) {
               $ahead_time=$value['ahead_time']*60;
               $forward_time=$value['forward_time']*60;
               self::joinTask($house['is_network'],$house['lockid'],$order->id,1,$config,$house['electricityid'],$value['line'],($start_time-$ahead_time),($end_time+$forward_time));
            }
        }
    	
    }
    //加入任务
    public function joinTask($is_network,$lockid,$order_id,$type,$config,$mac,$line,$start_time,$end_time){
        $form=Electricity::where(['acid'=>$this->acid,'mac'=>$mac,'line'=>$line,'order_id'=>$order_id])->find();
        if(!$form){
            $form=new Electricity();
            $form->status=0;
        }
        if(!$mac){
            return false;
        }
        $form->save([
          'acid'=>$this->acid,
          'config'=>json_encode($config),
          'order_id'=>$order_id,
          'lockid'=>$lockid,
          'mac'=>$mac,
          'line'=>$line,
          'start_time'=>$start_time,
          'end_time'=>$end_time
        ]);
        
        $task=new \app\shared\controller\Task();
        $task->handleOther($form->id,$start_time,$end_time);
    }
    //加入绿米任务
    public function lvjoinTask($house,$order,$start_time,$end_time){
        $lumi_electricity_config=LumiElectricityConfig::where([
            'acid'=>$this->acid,
            'store_id'=>$house['store_id'],
            'house_id'=>$house['id'],
            'is_delete'=>0
        ])->column('dev_did,dev_model,resource,ahead_time,forward_time,reset_time');
        $params=[];
        $lvmi_device=Store::where(['id'=>$house['store_id']])->value('lvmi_device');
        $lvmi_device=@json_decode($lvmi_device,1);
        $accessToken=isset($lvmi_device['accessToken'])?$lvmi_device['accessToken']:'';
        $config=[];
        foreach ($lumi_electricity_config as &$vlm){
            $resources=[];
            $resource=@json_decode($vlm['resource'],1);
            foreach ($resource as $v){
              $resources[]=[
                'resourceId'=>$v['resuors'],
                'value'=>$v['status'],
              ];
              $config[]=[
                'subjectId'=>$vlm['dev_did'],
                'resources'=>$resources,
              ];
          }
        }
        if(!$config)return 0;
        $storeConfig=Store::where('id',$house['store_id'])->value('lvmi_developer');
        $storeConfig=@json_decode($storeConfig,1);

        $form=new \Electronic\Lvmi([],$storeConfig);
        $res=$form->controllerDevice($accessToken,$config);
        foreach ($lumi_electricity_config as &$vlm){
            $resources=[];
            $resource=@json_decode($vlm['resource'],1);
            foreach ($resource as $v){
              $resources[]=[
                'resourceId'=>$v['resuors'],
                'value'=>$v['status'],
              ];
              $ahead_time=$v['ahead_time']*60;
              $forward_time=$v['forward_time']*60;
              $config=json_encode([
                [
                    'subjectId'=>$vlm['dev_did'],
                    'resources'=>$resources,
                ]
              ]);
              $form=Electricity::where(['acid'=>$this->acid,'order_id'=>$order['id'],'config'=>$config])->find();
              if(!$form){
                    $form=new Electricity();
                    $form->status=0;
              }
              $form->save([
                  'acid'=>$this->acid,
                  'lvmi_developer'=>json_encode($storeConfig,JSON_UNESCAPED_UNICODE),
                  'config'=>$config,
                  'order_id'=>$order['id'],
                  'mac'=>$accessToken,
                  'line'=>-1,
                  'start_time'=>$start_time-$ahead_time,
                  'end_time'=>$end_time+$forward_time,
                  'reset_time'=>$vlm['reset_time']>0?$end_time+$forward_time+($vlm['reset_time']*60):0,
              ]);
              $task=new \app\shared\controller\Task();
              $task->lvhandleOther($form->id,$form->start_time,$form->end_time);
           }
        }
    }
}