<?php
namespace app\shared\logic\user;
use app\shared\model\Banner;
use app\shared\model\Option;
use app\shared\model\Category;
use app\shared\model\Card;
use app\shared\model\Tags;
use app\shared\model\Area;
use app\shared\model\App;
use app\shared\model\User;
use app\shared\model\Travel;
use app\shared\model\TravelType;
use app\shared\model\Advertising;
use app\shared\model\Store;

use app\shared\model\Coupon;
use app\shared\model\CardCoupon;

use app\shared\model\CardCouponOrder;


use app\shared\model\CardUser;
use app\shared\model\CardUserOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\Partner;
use app\shared\model\PartnerUser;
use app\shared\model\PartnerUserOrder;
use app\shared\model\House;
use app\shared\model\HouseOrder;
use app\shared\model\CouponUser;
use app\shared\model\StoreCoupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\Agreement;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
use think\facade\Cache;
//首页管理
class HomeForm extends  Base
{   
    //区域
    public function area_list(){
        $app_home_theme=Option::get_data($this->acid,'shared','app_home_theme',10);
        $app_home_theme=@json_decode($app_home_theme,true);
        if($app_home_theme['type']=='selected_lm'){
            $is_unify_login=1;
        }else{
            $is_unify_login=0;
        }
        if($is_unify_login){
            $url="https://atroom.youdiy.cn/index.php?_acid=1&_version=1.1.23&platform=wxapp&s=/sass/common/allCity";
            $res=httpRequest($url);
            $res=@json_decode($res,true);
            $data=$res['data'];
            $hot_city=$data['hot_city'];
            $letter=array_column($hot_city,'letter');
            $letter=array_unique($letter);
            return fetchJson([
                'list'=>$hot_city,
                'letter'=>$letter
            ]);
        }
        $list=Area::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->order('letter ASC')->cache(30)->column('id,name,cover,address_location,letter');
        $letter=Area::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->order('letter ASC')->cache(30)->column('letter');
        $letter=array_unique($letter);
        foreach ($list as $key => &$value) {
            $value['cover_url']=get_file_url($value['cover']);
            $address_location=explode(',', $value['address_location']);
            $value['lat']=isset($address_location[0])?$address_location[0]:'';
            $value['lng']=isset($address_location[1])?$address_location[1]:'';
        }
        return fetchJson([
            'list'=>$list,
            'letter'=>$letter
        ]);
    }
    //菜单列表
    public function navList(){
        $nav_list=Option::get_data($this->acid,'platform','app_nav_list');
        return fetchJson([
            'app_nav_list'=>json_decode($nav_list,1)
        ],'保存成功');
    }
    //协议列表
    public function agreementList(){
        $type=input('type')?input('type'):1;
        $list=Agreement::where(['acid'=>$this->acid,'is_delete'=>0,'type'=>$type])->page($this->page)->limit(20)->column('id,title');
        return fetchJson($list);
    }
    //协议详情
    public function agreementDetails(){
        $id=input('id');
        $find=Agreement::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$id])->field('id,title,content')->cache(60)->find();
        return fetchJson($find);
    }
    //菜单列表
    public function homePage(){
        $appcCacheHomePage=Cache::get('appcCacheHomePage');
        if($appcCacheHomePage){
            return fetchJson($appcCacheHomePage);
        }
        $ad_list=Advertising::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->cache(30)->column('id,url,cover');           
        $optionAll=Option::get_multi_data($this->acid,[
            'app_tea_specialist_setting',
            'app_home_theme',
            'app_user_center_config',
            'app_recharge_status',
            'app_property_donation_status',
            'app_property_donation_money_des',
            'app_property_donation_integral_des',
            'app_property_donation_coupon_des',
            'app_system_shortened',
            'app_system_help_dec',
            'app_system_about_dec',
            'app_audit_version',
            'app_plugin_conversion_dec',
            'app_card_show_type',
            'app_board_status',
            'app_board_content',
            'app_companion_config'
        ]);

        $teaSpecialist=$optionAll['app_tea_specialist_setting'];
        $app=App::where('id',$this->acid)->field('logo,name')->cache(60)->find();
        $app_home_theme=$optionAll['app_home_theme'];

        $app_home_theme=@json_decode($app_home_theme,1);
        if(!$app_home_theme){
            $app_home_theme=\app\shared\model\Theme::defaultTheme();
        }
        if(strpos(request()->domain(),'192.168.1')!==false){
            $is_unify_login=0;
        }else{
            if($app_home_theme['type']=='selected_lm'){
                $is_unify_login=1;
            }else{
                $is_unify_login=0;
            }
        }
        //约搭拼场
        $app_companion_config=$optionAll['app_companion_config'];
        $app_companion_config=@json_decode($app_companion_config,1);


        $root_url=request()->domain().str_replace('index.php', '',request()->baseFile());
        $userCenter=$optionAll['app_user_center_config'];
        $userCenter=@json_decode($userCenter,1);

        if(!$userCenter){
            $url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/';
            $userCenter=[
                'type'=>1,
                'money'=>[
                    'status'=>1,
                    'price'=>1,
                    'tea'=>1,
                    'integral'=>0,
                    'cash'=>0
                ],
                'tea_order'=>[
                    ['icon'=>$url.'order/daifukuan.svg','url'=>'/order/index?status=1','title'=>'待付款'],
                    ['icon'=>$url.'order/daishiyong.svg','url'=>'/order/index?status=2','title'=>'待使用'],
                    ['icon'=>$url.'order/shiyongzhong.svg','url'=>'/order/index?status=3','title'=>'使用中'],
                    ['icon'=>$url.'order/yiwancheng.svg','url'=>'/order/index?status=4','title'=>'已完成'],
                    ['icon'=>$url.'order/quanbu.svg','url'=>'/order/index?status=0','title'=>'全部'],
                ],
                'is_share'=>1,
                'myserve'=>[
                    ['icon'=>$url.'myserve/chayishidd.svg','type'=>"common",'status'=>1,'url'=>'/teaOrder/index','title'=>'茶艺师订单'],
                    ['icon'=>$url.'myserve/shangpingdd.svg','type'=>"common",'status'=>1,'url'=>'/pages/user/buyHistory/index','title'=>'商品订单'],
                    ['icon'=>$url.'myserve/shanghugl.svg','type'=>"store",'status'=>1,'url'=>'/storeManager/navBar/index','title'=>'商户管理'],
                    ['icon'=>$url.'myserve/jiamenghezuo.svg','type'=>"storeJoin",'status'=>1,'url'=>'/pages/store/joinUs','title'=>'加盟合作'],
                    ['icon'=>$url.'myserve/pingtaixieyi.svg','type'=>"common",'status'=>1,'url'=>'/pages/user/protocol/index?type=1','title'=>'平台协议'],
                    ['icon'=>$url.'myserve/gudongfenhong.svg','type'=>"shareholder_receive",'status'=>1,'url'=>'/stock/index','title'=>'股东分红'],
                    ['icon'=>$url.'myserve/baojieduan.svg','type'=>"common",'status'=>1,'url'=>'/storeManager/cleaner/index','title'=>'保洁端'],
                    ['icon'=>$url.'myserve/meituanyanquan.svg','type'=>"meituan_coupon",'status'=>1,'url'=>'/pages/user/meituan/getCoupon','title'=>'美团验券'],
                    ['icon'=>$url.'myserve/chayishiduan.svg','type'=>"common",'status'=>1,'url'=>'/teaMasterPort/navBar/Footer','title'=>'茶艺师端'],
                    ['icon'=>$url.'myserve/bangzhuzhongxing.svg','type'=>"common",'status'=>1,'url'=>'/pages/user/protocol/index?type=2','title'=>'帮助中心'],
                    ['icon'=>$url.'myserve/guanyuwomen.svg','type'=>"common",'status'=>1,'url'=>'/pages/user/protocol/index?type=3','title'=>'关于我们'],
                    ['icon'=>$url.'myserve/shouhuodizhi.svg','type'=>"common",'status'=>1,'url'=>'/pages/address/index','title'=>'收货地址'],
                    ['icon'=>$url.'myserve/woyaokaipiao.png','type'=>"common",'status'=>1,'url'=>'/invoice/index','title'=>'我要开票'],
                    ['icon'=>$url.'myserve/mianfeihecha.png','type'=>"invite_tea",'status'=>1,'url'=>'/group/index','title'=>'免费约茶'],
                    ['icon'=>$url.'myserve/zaixiankefu.svg','type'=>"kefu",'status'=>1,'url'=>'','title'=>'在线客服'],
                ],
            ];
        }else{
           $userCenter['money']=@json_decode($userCenter['money'],1);
        }
        $pluginlist=Cache::get('platform_plugin_list_wxapp');
        if(isset($pluginlist['info']['plugin'])){
              $plugin_list=explode(',',$pluginlist['info']['plugin']);
              $myserve=[];
              foreach ($userCenter['myserve'] as $value){
                  if($value['type']!='kefu'&&$value['type']!="common"&&$value['type']!="card"&&$value['type']!="store"&&$value['type']!="storeJoin"&&$value['type']!="ranking"&&$value['type']!="tea_specialist"){
                     if(in_array($value['type'],$plugin_list)) {
                        $myserve[]=$value;
                     }
                  }else{
                    $myserve[]=$value;
                  }
              }
              $userCenter['myserve']=$myserve;
        }
        $bannerList=Banner::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->cache(30)->where('type','in','1,2,3,4,5')->order('sort ASC')->column('cover,url,type,jump_type,appid');
        $goodsBanner=[];
        $homePop=[];

        $giftCard=[];
        $mooncake=[];
        $tea_specialist_banner=[];
        foreach ($bannerList as &$value){
            $banner=[
                'cover'=>get_file_url($value['cover']).'?time='.strtotime(date("Y-m-d")),
                'url'=>$value['url'],
                'jump_type'=>$value['jump_type'],
                'appid'=>$value['appid'],
            ];
            switch ($value['type']) {
                case 1:
                   $goodsBanner[]=$banner;
                    break;
                case 2:
                   $homePop[]=$banner;
                    break;
                case 3:
                   $giftCard[]=$banner;
                    break;
                case 4:
                   $mooncake[]=$banner;
                    break;
                case 5:
                   $tea_specialist_banner[]=$banner;
                    break;            
                default:
                    break;
            }
        }
        $newOrderIds=HouseOrder::where(['acid'=>$this->acid])->where('status','in','1,2,3')->distinct(true)->field('user_id')->limit(10)->column('id');
        $new_order_list=HouseOrder::alias('ho')
        ->leftJoin([User::getTable()=>'u'],'ho.user_id=u.id')
        ->where('ho.id','in',$newOrderIds)
        ->order('ho.id DESC')
        ->limit(10)
        ->column('ho.snapshoot,u.nickname,u.avatar_url,ho.id,ho.create_time');
        foreach($new_order_list as &$order){
            $order['nickname']=$order['nickname'];
            $snapshoot=@json_decode($order['snapshoot'],1);
            $order['house_name']=$snapshoot['name'];
            $order['create_time']=date('Y-m-d H:i:s:',$order['create_time']);
            unset($order['snapshoot']);
        }
        $app_recharge_status=$optionAll['app_recharge_status'];
        $app_recharge_status=$app_recharge_status==0?0:1;
        $app_property_donation_status=$optionAll['app_property_donation_status'];
        $app_property_donation_money_des=$optionAll['app_property_donation_money_des'];
        $app_property_donation_integral_des=$optionAll['app_property_donation_integral_des'];
        $app_property_donation_coupon_des=$optionAll['app_property_donation_coupon_des'];
        $app_board_status=$optionAll['app_board_status']==1?1:0;
        $app_board_content=$optionAll['app_board_content'];
        $appcCacheHomePage=[
            'homePop'=>$homePop,
            'app_board_status'=>$app_board_status,
            'app_board_content'=>$app_board_content,
            'goodsBanner'=>$goodsBanner,
            'giftCard'=>$giftCard,
            'mooncake'=>$mooncake,
            'new_order_list'=>$new_order_list,
            'ad_list'=>$ad_list,
            'platform_logo'=>get_file_url($app['logo']),
            'platform_name'=>$app['name'],
            'tea_specialist_banner'=>$tea_specialist_banner,
            'teaSpecialist'=>json_decode($teaSpecialist,1),
            'app_home_theme'=>$app_home_theme,
            'is_unify_login'=>$is_unify_login,
            'app_system_shortened'=>$optionAll['app_system_shortened'],
            'app_system_help_dec'=>$optionAll['app_system_help_dec'],
            'app_system_about_dec'=>$optionAll['app_system_about_dec'],
            'app_audit_version'=>$optionAll['app_audit_version'],
            'app_property_donation_status'=>$app_property_donation_status==1?1:0,
            'app_property_donation_money_des'=>$app_property_donation_money_des?$app_property_donation_money_des:'',
            'app_property_donation_integral_des'=>$app_property_donation_integral_des?$app_property_donation_integral_des:'',
            'app_property_donation_coupon_des'=>$app_property_donation_coupon_des?$app_property_donation_coupon_des:'',
            'music'=>[
                'gate'=>$root_url.'static/shared/mp3/gate.mp3',
                'door'=>$root_url.'static/shared/mp3/door.mp3',
            ],
            "images"=>[
                'new_coupon_url'=>$root_url.'static/shared/img/hongbao.png',
            ],
            'userCenter'=>$userCenter,
            'conversion_dec'=>$optionAll['app_plugin_conversion_dec'],
            'app_recharge_status'=>$app_recharge_status,
            'app_card_show_type'=>$optionAll['app_card_show_type'],
            'app_companion_config'=>$app_companion_config
        ];
        Cache::set('appcCacheHomePage',$appcCacheHomePage,5);
        return fetchJson($appcCacheHomePage);
    }
    //审核判断
    public function auditJudge(){
        $android_version='1.0.9';
        $ios_version='1.0.10';
        $wxapp_version='1.0.2';
        if($this->platform=='app'){
            return fetchJson([
                'isShow'=>0,
            ],'获取成功'); 
        }
        if($this->platform=='ios'){
            if($ios_version==$this->version){
                return fetchJson([
                    'isShow'=>0,
                ],'获取成功'); 
            }
        }
        if($this->platform=='android'){
            if($android_version==$this->version){
                return fetchJson([
                    'isShow'=>0
                ],'获取成功'); 
            }
        }
        if($this->platform=='wxapp'){
            if($wxapp_version==$this->version){
                return fetchJson([
                    'isShow'=>0
                ],'获取成功'); 
            }
        }
        return fetchJson([
            'isShow'=>1
        ],'获取成功'); 

    }
    //获取系统信息
    public function getSystem(){
        $data['app_system_copyright']=Option::get_data($this->acid,'platform','app_system_copyright');
        return fetchJson($data);
    }
    //茶室订单详情
    public function houseOrderDetail(){
        $order_no=input('order_no');
        $order=HouseOrder::where(['order_no'=>$order_no])->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $order['snapshoot']=@json_decode($order['snapshoot'],1);
        $order['store']=Store::where('id',$order['store_id'])->field('tel,name,pay_types,use_refund_time,is_tea_specialist')->find();
        if($order['book_type']==3&&$order['is_pay']==0){
           $order['start_time']=date("Y-m-d H:i:s",$order['start_time']);
           $order['end_time']=$order['end_time']>0?date("Y-m-d H:i:s",$order['end_time']):'';
           return fetchJson($order,'获取成功');
        }
        $order_continue_list=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id DESC')->column('id,start_time,pay_price,price,end_time');
        $price=0;
        foreach ($order_continue_list as $key => &$value) {
          $value['start_time']=date('Y-m-d H:i',$value['start_time']);
          $value['end_time']=date('Y-m-d H:i',$value['end_time']);
          $price+=$value['pay_price'];
          $value['discounts_price']=$value['price']-$value['pay_price'];
        }
        $end_time=$order->end_time;
        $start_time=$order->start_time;
        $xdstart_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id ASC')->value('start_time');
        $start_time=$order['start_time'];
        if($xdstart_time){
          //续单
          if($xdstart_time>$order['start_time']){
              $xdend_time=HouseOrderContinue::where(['status'=>1,'order_id'=>$order->id])->order('id DESC')->value('end_time');
              $end_time=$xdend_time;
          }else{
            //向前续单
              $start_time=$xdstart_time;
          }
        }
        $order['start_time']=date("Y-m-d H:i:s",$start_time);
        $order['end_time']=date("Y-m-d H:i:s",$end_time);

        if($start_time<time()&&$order['status']==1){
           HouseOrder::where(['id'=>$order->id,'user_id'=>$order->user_id])->update(['status'=>2]);
        }
        $order['pay_price']+=$price;
        $order['pay_price']=round($order['pay_price'],2);
        $order['order_continue_list']=$order_continue_list;
        $card_user_order=CardUserOrder::alias('cuo')
            ->leftJoin([CardUser::getTable()=>'cu'],'cuo.card_user_id=cu.id')
            ->leftJoin([Card::getTable()=>'c'],'cu.card_id=c.id')
            ->where(['cuo.type'=>1,'cuo.order_id'=>$order->id,'cuo.user_id'=>$order->user_id,'cuo.is_delete'=>0])
            ->field('cuo.price,cuo.hour,cuo.discount,cuo.status,cuo.type,c.title')
            ->find();
        if($card_user_order){
           $card_user_order['discounts_price']=0;
        }
        //判断是否使用合伙人
        $is_table = Db::query('show tables like "'.PartnerUserOrder::getTable().'"');
        if($is_table){
          $partner_order=PartnerUserOrder::alias('puo')
          ->leftJoin([PartnerUser::getTable()=>'pu'],'puo.user_partner_id=pu.id')
          ->leftJoin([Partner::getTable()=>'p'],'pu.partner_id')
          ->where(['puo.order_id'=>$order->id,'puo.status'=>1])
          ->field("puo.*,p.title")->find();
          $order['partner_user_order']=$partner_order;
        }else{
          $order['partner_user_order']=[];
        }
        $order['card_user_order']=$card_user_order;
        $discounts_price=CouponUser::where(['id'=>$order->coupon_user_id,'type'=>Coupon::TYPE_HOTEL,'user_id'=>$order->user_id])->value('discounts_price');
        $order['discounts_price']=$discounts_price>0?$discounts_price:0;
        $storeCoupon=StoreCouponUser::alias('c_u')
        ->leftJoin([StoreCoupon::getTable()=>"c"],'c_u.coupon_id=c.id')
        ->where(['c_u.id'=>$order->store_coupon_user_id,'c_u.user_id'=>$order->user_id])
        ->where('c_u.type','in','1,4')
        ->field('c_u.id,c_u.discounts_price,c_u.verifier_code,c_u.verifier_id,c_u.type,c.name,c.detail')
        ->find();
        $order['store_coupon']=$storeCoupon;
        $order['store_discounts_price']=$storeCoupon['discounts_price']>0?$storeCoupon['discounts_price']:0;
        $order['card_coupon']=CardCouponOrder::alias('cco')->leftJoin([CardCoupon::getTable()=>'cc'],'cco.card_coupon_id=cc.id')->where(['cco.order_id'=>$order->id])->field('cc.discounts_price,cc.name,cco.id')->find();
        $house=House::where('id',$order['house_id'])->field('cancel_time,reordertime')->find();
        $order['cancel_time']=$house['cancel_time'];
        $order['reordertime']=$house['reordertime'];
        $order['warm_hint']=Store::where(['id'=>$order['store_id']])->value('warm_hint');
        $snapshoot=$order['snapshoot'];
        if(!isset($snapshoot['cancel_time'])){
            $snapshoot['cancel_time']=House::where('id',$order['house_id'])->value('cancel_time');
        }
        $order['is_use_refund']=($start_time+$order['store']['use_refund_time']*60)>time()?1:0;
        return fetchJson($order,'获取成功');
    }

}