<?php
namespace app\shared\logic\user;
use app\shared\model\GoodsCat;
use app\shared\model\Goods;
use app\shared\model\GoodsOrder;
use app\shared\model\GoodsOrderDetail;
use app\shared\model\GoodsAttr;
use app\shared\model\Card;
use app\shared\model\Store;
use app\shared\model\Banner;
use app\shared\model\CardUser;
use app\shared\model\CounterChest;
use think\exception\ValidateException;
use app\BaseController;
class GoodsForm extends  UserForm
{
    public function banner(){
        $list=Banner::where(['acid'=>$this->acid,'type'=>1,'is_delete'=>0])->column('cover,url');
        foreach ($list as &$value){
            $value['cover']=get_file_url($value['cover']);
        }
        return fetchJson($list);
    }
    public function home(){
         $store_id=input('store_id');
        if(empty($store_id))$store_id=0;

        $counter_id=input('counter_id')>0?input('counter_id'):0;
        $query=GoodsCat::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$store_id]);
        $goods_ids=[-1];
        if($counter_id){
            $goods_ids=CounterChest::where(['counter_id'=>$counter_id,'is_delete'=>0,'type'=>1,'status'=>1])->where('goods_id','>',0)->group('goods_id')->column('goods_id');
            $cat_ids=Goods::where('id','in',$goods_ids)->column('cat_id');
            $query->where('id','in',$cat_ids);
        }
        
        $cat=$query->order('sort ASC')->column('id,title name,cover icon');

        $cardUser=CardUser::alias('c_u')
        ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
        ->where(['c_u.status'=>1,'c_u.user_id'=>$this->user_id,'c.is_delete'=>0])
        ->where('c_u.start_time','<',time())
        ->where('c_u.end_time','>',strtotime(date('Y-m-d',time()+86400)))
        ->order('c_u.level DESC')->field('c_u.*,c.discount')->find();
        $discount=0;
        if($cardUser){
          $discount=$cardUser['discount'];
        }
        $type=input('type')?input('type'):0;
        foreach ($cat as &$value) {
            $value['icon']=get_file_url($value['icon']);
            $query=Goods::where(['cat_id'=>$value['id'],'is_delete'=>0,'status'=>1]);
            if($type>0){
                $query->where(['type'=>$type]);
            }
            if($counter_id){
                $query->where('id','in',$goods_ids);
            }
            $goods_list=$query->column('id,name,price,images,cover,use_attr use_property,attribe_list property,detail,type');
            foreach ($goods_list as &$goods) {
                $property=@json_decode($goods['property'],1);
                foreach ($property as &$pv) {
                    $attr_list1=$pv['attr_list'];
                    foreach ($attr_list1 as $key => &$attr1) {
                        if($key==0){
                            $attr1['is_default']=1;
                        }else{
                            $attr1['is_default']=0;
                        }
                    }
                    $pv['values']=$attr_list1;
                    unset($pv['attr_list']);
                }
                $goods['property']=$property;
                $attr=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$goods['id']])->order('index ASC')->column('attr_list,price,stock,integral,index');
                foreach ($attr as &$aV){
                    $aV['attr_list']=@json_decode($aV['attr_list'],1);
                    $aV['member_price']=$discount>0?$discount*$aV['price']*0.1:-1;
                }
                $goods['entity']=$attr;
                $goods['images']=get_file_urls($goods['images']);
                $goods['cover']=get_file_url($goods['cover']);
                $goods['number']=1;
                $goods['num']=array_sum(array_column($attr, 'stock'));
                $goods['member_price']=$discount>0?$discount*$goods['price']*0.1:-1;
                $goods['member_price']=round($goods['member_price'],2);
            }
            $value['goods_list']=$goods_list;
        }
        return fetchJson($cat);
    }
    //商品分类
    public  function catList(){
        $store_id=input('store_id');
        if(empty($store_id))$store_id=0;
        $list=GoodsCat::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$store_id])
        ->order('sort DESC')
        ->field('id,title,cover,sort,parent_id,is_delete')
        ->page($this->page)
        ->limit(10)
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            $value['cover_url']=get_file_url($value['cover']);
            if(!Goods::where(['status'=>1,'is_delete'=>0])->where('cat_id','like',"%{$value['id']}%")->count()){
                unset($value);
            }
        }
        $list=generateTree($list,'parent_id');
        return fetchJson($list);
    }
    //商品列表
    public function list(){
        $cat_id=input('cat_id');
        $query=Goods::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1,'store_id'=>0]);
        if($cat_id=='choiceness'){
            $query->where('is_choiceness',1);
        }else if($cat_id=='hotsell'){
            $query->where('is_choiceness',1);
        }else{
            if(is_numeric($cat_id)){
               $query->whereFindInSet('cat_id',$cat_id);
            }
        }
        //新品排序
        if($type=input('type')){
            $query->where('type',$type);
        }
        $sort_type=input('sort_type');
        //綜合排序
        if($sort_type==1){
            $query->order('id DESC')->order('price ASC');
        }
        //銷量排序
        if($sort_type==2){
            $query->order('sales_volume DESC');
        }
        //新品排序
        if($sort_type==3){
            $query->order('id DESC');
        }
        //價格排序
        if($sort_type==4){
            $query->order('price ASC');
        }
        //價格排序
        if($sort_type==5){
            $query->order('price DESC');
        }
        if($keyword=input('keyword')){
            $query->where('name','like',"%$keyword%");
        }
        if($is_integral=input('is_integral')){
            $query->where('integral','>',0);
        }
        $list=$query->withoutField('is_delete,detail,create_time,cost_price')->limit(10)
            ->page($this->page)
            ->select();
        $cardUser=CardUser::alias('c_u')
        ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
        ->where(['c_u.status'=>1,'c_u.user_id'=>$this->user_id,'c.is_delete'=>0])
        ->where('c_u.start_time','<',time())
        ->where('c_u.end_time','>',strtotime(date('Y-m-d',time()+86400)))
        ->order('c_u.level DESC')->field('c_u.*,c.discount')
        ->find();
        $discount=0;
        if($cardUser){
          $discount=$cardUser['discount'];
        }
        foreach ($list as $key => &$value) {
            $value['cover_url']=get_file_url($value['cover']);
            $value['tip']='商家自营';
            $goods_attr=@json_decode($value['attr'],1);
            unset($value['attr']);
            $value['member_price']=$discount>0?$discount*$value['price']*0.1:-1;
            $value['member_price']=round($value['member_price'],2);
            $value['sales_num']=$value['virtual_sales']+$value['sales_num'];
            unset($value['virtual_sales']);
        }
        return fetchJson($list);
    }
    //详情
    public function details(){
        $goods_id=input('goods_id');
        $goods=Goods::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$goods_id,'status'=>1])->find();
        if($goods){
            $goods['images_list']=get_file_urls($goods['images']);
            $goods['cover_url']=get_file_url($goods['cover']);
            $goods_attr=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$goods_id])->order('index ASC')->column('attr_list,price,stock,integral,index');
            $attribe_list=@json_decode($goods->attribe_list,1);

            $specifications=[];
            foreach ($attribe_list as $spe) {
               $attr_list=$spe['attr_list'];
               $attr_v_arr=[];
               foreach ($attr_list as &$attr_v) {
                  $attr_v_arr[]=[
                    'name'=>$attr_v['attr_name'],
                  ];
               }
               $specifications[]=[
                    'name'=>$spe['attr_group_name'],
                    'item'=>$attr_v_arr
               ];
            }
           $difference=[];
           foreach ($goods_attr as $spe) {
                $spe['attr_list']=@json_decode($spe['attr_list'],1);
                $difference[]=[
                    'id'=>$spe['index']+1,
                    'price'=>$spe['price'],
                    'stock'=>$spe['stock'],
                    'pic'=>isset(array_column($spe['attr_list'],'pic')[0])?array_column($spe['attr_list'], 'pic')[0]:$goods['cover_url'],
                    'difference'=>array_column($spe['attr_list'], 'attr_name'),
                    'integral'=>isset($spe['integral'])?$spe['integral']:0
                ];
            }
            $goods['lat']= $goods['take_their_lat'];
            $goods['lng']= $goods['take_their_lng'];
            $goods['specifications']=$specifications;
            $goods['difference']=$difference;
            $goods['sales_num']=$goods['sales_num']+$goods['virtual_sales'];
            unset($goods['attribe_list']);
            unset($goods['attr']);
           //商品访问量
           \app\shared\model\UserUv::todayUv($this->acid,3,$goods['store_id'],$this->user_id,$goods['id']);
        }    
        return fetchJson($goods);
    }
}