<?php
namespace app\shared\logic\user;
use app\shared\model\GiftCard;
use app\shared\model\App;
use app\shared\model\User;
use app\shared\model\Bill;
use app\shared\model\GiftCardOrder;
use app\shared\model\GiftCardOrderRedpacket;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
use wechatpay\WechatPay;
class GiftCardForm extends  Base
{
    //获取数据
    public  function index(){
        $query=GiftCard::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1]);
        $list=$query
        ->page($this->page)
        ->limit(10)
        ->order('id DESC')
        ->select();
        foreach ($list as $key => &$value) {
            $value['price_list']=@json_decode($value['price_list'],1);
        }
        return fetchJson($list);
    }
    //详情
    public function detail(){
        $info=GiftCard::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1,'id'=>input('id')])->find();
        if($info){
            $info['price_list']=@json_decode($info['price_list'],1);
        }
        return fetchJson($info);
    }
    public function orderList(){
        $that=new UserForm();
        $query=GiftCardOrder::alias('o')->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')->where(['o.acid'=>$this->acid,'o.user_id'=>$that->user_id]);
        $status=input('status')?input('status'):0;
        if($status!=-10){
            $query->where('o.status',$status);
        }
        $list=$query->page($this->page)->limit(10)->order('o.id DESC')->field('o.id,o.order_no,o.title,o.cover,o.price,o.pay_price,o.money,o.create_time,o.status,o.is_pay,o.give_price,u.nickname,u.avatar_url')->select();
        $time=time();
        foreach ($list as $value){
            $sum_price=GiftCardOrderRedpacket::where(['order_id'=>$value['id'],'status'=>0])->where('create_time','<',$time-86400)->sum('price');
            if(GiftCardOrderRedpacket::where(['order_id'=>$value['id'],'status'=>0])->where('create_time','<',$time-86400)->update(['status'=>2,'update_time'=>$time])){
               $order=GiftCardOrder::where(['id'=>$value['id'],'status'=>1])->find();
               if($order){
                   $order->money=$order->money+$sum_price;
                   $order->save();
               }
            }
        }
        return fetchJson($list);
    }
    //发放记录
    public function releaseRecord(){
        $that=new UserForm();
        $query= GiftCardOrderRedpacket::alias('a')
        ->leftJoin([GiftCardOrder::getTable()=>'b'],'a.order_id=b.id')
        ->leftJoin([User::getTable()=>'u'],'a.user_id=u.id')
        ->where(['a.acid'=>$this->acid,'b.user_id'=>$that->user_id,'a.status'=>1]);
        $status=input('status')?input('status'):0;
        if($status!=-10){
            $query->where('a.status',$status);
        }
        $list=$query->page($this->page)->limit(10)->order('a.id DESC')->field('a.*,u.nickname,u.avatar_url')->select();
        foreach ($list as $key => &$value) {
            $value['get_time']=date('Y-m-d H:i:s',$value['get_time']);
        }
        return fetchJson($list);
    }
    //领取记录
    public function drawRecord(){
        $that=new UserForm();
        $query= GiftCardOrderRedpacket::alias('a')
        ->leftJoin([GiftCardOrder::getTable()=>'b'],'a.order_id=b.id')
        ->leftJoin([User::getTable()=>'u'],'a.user_id=u.id')
        ->where(['a.acid'=>$this->acid,'a.user_id'=>$that->user_id,'a.status'=>1]);
        $status=input('status')?input('status'):0;
        if($status!=-10){
            $query->where('a.status',$status);
        }
        $list=$query->page($this->page)->limit(10)->order('a.id DESC')->field('a.*,u.nickname,u.avatar_url')->select();
        foreach ($list as $key => &$value) {
            $value['get_time']=date('Y-m-d H:i:s',$value['get_time']);
        }
        return fetchJson($list);
    }
    public function orderDetail(){
        $that=new UserForm();
        $info=GiftCardOrder::alias('o')
        ->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')
        ->leftJoin([GiftCard::getTable()=>'g'],'o.gift_card_id=g.id')
        ->where(['o.acid'=>$this->acid,'o.user_id'=>$that->user_id,'o.id'=>input('order_id')])
        ->page($this->page)
        ->limit(10)
        ->field('o.id,o.order_no,o.title,o.cover,o.price,o.pay_price,o.money,o.create_time,o.status,o.is_pay,o.give_price,o.pay_time,u.nickname,u.avatar_url,g.detail')
        ->find();
        if($info['pay_time']){
            $info['pay_time']=date('Y-m-d H:i:s',$info['pay_time']);
        }
        return fetchJson($info);
    }
    //红包记录
    public function redPacketList(){
        try {
          $data=request()->post();
          $rule = [
             'order_id|订单ID' => 'require|number',
             'key|口令错误' => "require|>=:0.01",
           ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
        }
        $that=new UserForm();
        $order=GiftCardOrder::alias('o')
        ->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')
        ->leftJoin([GiftCard::getTable()=>'g'],'o.gift_card_id=g.id')
        ->where(['o.id'=>$data['order_id']])->field('o.cover,o.title,o.id,u.nickname,u.avatar_url,g.detail')->find();
        $list=GiftCardOrderRedpacket::alias('r')->leftJoin([User::getTable()=>'u'],'r.user_id=u.id')->where(['r.order_id'=>$data['order_id'],'r.key'=>$data['key'],'r.status'=>1])->field('r.id,r.price,u.nickname,u.avatar_url,r.get_time,r.user_id')->order('get_time ASC')->select();
        $price=0;
        foreach($list as $value){
            if($value['user_id']=$that->user_id){
                $price=$value['price'];
            }
            $value['get_time']=date('Y-m-d H:i:s',$value['get_time']);
        }
        return fetchJson([
            'order'=>$order,
            'list'=>$list,
            'price'=>$price,
            'count'=>GiftCardOrderRedpacket::where(['order_id'=>$data['order_id'],'key'=>$data['key']])->count(),
            'already_count'=>GiftCardOrderRedpacket::where(['order_id'=>$data['order_id'],'key'=>$data['key'],'status'=>1])->count(),
            'unread_count'=>GiftCardOrderRedpacket::where(['order_id'=>$data['order_id'],'key'=>$data['key'],'status'=>0])->count(),
            'unread_price'=>GiftCardOrderRedpacket::where(['order_id'=>$data['order_id'],'key'=>$data['key'],'status'=>0])->sum('price'),
        ]);
    }
    //订单明细
    public function orderRedpacketDetail(){
        $that=new UserForm();
        $list=GiftCardOrderRedpacket::alias('r')
        ->leftJoin([GiftCardOrder::getTable()=>'o'],'r.order_id=o.id')
        ->leftJoin([User::getTable()=>'u'],'r.user_id=u.id')

        ->where(['r.order_id'=>input('order_id'),'r.status'=>1,'o.user_id'=>$that->user_id])->field('r.id,r.price,u.nickname,u.avatar_url,r.get_time,r.user_id,r.type')->order('get_time ASC')->page($this->page)->limit($this->limit)->select();
        foreach($list as $value){
            $value['get_time']=date('Y-m-d H:i:s',$value['get_time']);
        }
        return fetchJson($list);
    }

    //发红包
    public function sendRedPacket(){
        try {
          $data=request()->post();
          $rule = [
             'order_id|订单ID' => 'require|number',
             'money|红包金额' => "require|>=:0.01",
             'type|类型'=>'require|in:1,2',
             'people_num|人数'=>'require|number|>=:1|<=:100',
           ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
        }
        $data['money']=round($data['money'],2);
        $min_price=$data['money']/$data['people_num'];
        if($min_price<0.01){
            return fetchJson([],'单个红包不得低于0.01',1);
        }
        $that=new UserForm();
        $order=GiftCardOrder::where(['user_id'=>$that->user_id,'id'=>$data['order_id'],'status'=>1,'is_pay'=>1])->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        if($order->money<$data['money']){
            return fetchJson([],'礼品卡余额不足',1);
        }
        $insertArray=[];
        $key=md5($that->user_id.time());
        //拼手气
        if($data['type']==2){
            $priceData=self::randPrice($data['money'],$data['people_num']);
            
        }else{
            $priceData=self::averagePrice($data['money'],$data['people_num']);
        }
        $time=time();
        for($i=0;$i<$data['people_num'];$i++){
            $insertArray[]=[
                'key'=>$key,
                'acid'=>$order->acid,
                'order_id'=>$order->id,
                'title'=>$order->title,
                'create_time'=>$time,
                'update_time'=>$time,
                'cover'=>input('cover')?input('cover'):$order->cover,
                'price'=>$data['type']==1?$priceData[$i]/100:$priceData[$i],
                'type'=>$data['type'],
                'content'=>input('content')?input('content'):'恭喜发财',
            ];
        }
        (new GiftCardOrderRedpacket())->saveAll($insertArray);
        $order->money-=$data['money'];
        $order->save();
        return fetchJson([
            'key'=>$key,
            'order_id'=>$order->id,
        ]);
    }
    //开红包
    public function openRedPacket(){
        try {
          $data=request()->post();
          $rule = [
             'order_id|订单ID' => 'require|number',
             'key|口令错误' => "require|>=:0.01",
           ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
        }
        $that=new UserForm();
        if(GiftCardOrderRedpacket::where(['order_id'=>$data['order_id'],'key'=>$data['key'],'status'=>1,'user_id'=>$that->user_id])->count()){
            return fetchJson(['status'=>2],'您已领取过~');
        }
        Db::startTrans();
        try {
            $order=GiftCardOrderRedpacket::where(['order_id'=>$data['order_id'],'key'=>$data['key'],'status'=>0])->lock(true)->order('id ASC')->find();
            if(!$order){
                return fetchJson(['status'=>-1],'很遗憾红包都被已抢走了~');
            }
            $order->user_id=$that->user_id;
            $order->status=1;
            $order->get_time=time();
            $order->save();
            $user=User::where('id',$that->user_id)->find();
            $user->money=$user->money+$order->price;
            $user->save();
            (new Bill())->save([
                  'acid'=>$order->acid,
                  'type'=>Bill::TYPE_GIFT_CARD,
                  'account_type'=>Bill::ACCOUNT_TYPE_USER,
                  'form_id'=>$order->user_id,
                  'order_id'=>$order->id,
                  'price'=>$order->price,
                  'price_type'=>1,
                  'balance'=>$user->money,
                  'status'=>1,
                  'des'=>"用户:【{$user['nickname']}】领取[$order->title]礼品卡红包金额"
            ]);
            Db::commit();
            $giftCardOrder=GiftCardOrder::where(['id'=>$data['order_id']])->find();
            if(GiftCardOrderRedpacket::where(['order_id'=>$data['order_id'],'status'=>1])->sum('price')==$giftCardOrder['give_price']){
                $giftCardOrder->status=2;
                $giftCardOrder->save();
            }
            return fetchJson(['status'=>1,'price'=>$order->price],'领取成功');
        } catch (Exception $e) {
            Db::rollback();
            return fetchJson(['status'=>-1],'很遗憾红包都被已抢走了~');
        }
    }
    //平均金额
    private function averagePrice($money,$num,$arr=[],$conversion_val=1)
    {
        $money = $money * 100;
        $arr_sum = 0;//保存数组和
        if (count($arr) > 0) {// 随机分配，会调用此方法将剩余的钱分掉，此数组为随机分配后的结果
            foreach ($arr as $k=>$v)  {
                $arr[$k] = $v * 100 / $conversion_val;// 如果单位有变化这调整一下，一直以分为单位处理数据
            }
            $arr_sum = array_sum($arr);// 统计随机分配已经分配了总钱数
        } else {
            for ($i=0; $i<$num; $i++) {
                $arr[] = 0;// 初始化每个人的数组，兼容下边循环处理部分
            }
        }
        $add_money = $money - $arr_sum;
        // 如果总钱数和之前随机分配的数组的总和差值为0，就说明随机分配已经将钱全部分出去了，就不需要再平均分配处理了
        if ($add_money == 0) {
            return $arr;
        }
        // 先把剩余的能均分的部分均分一下，然后若再有剩余，则从前到后，注意分配
        for ($i = 0; $i < $num; $i++) {
            $arr[$i] = $arr[$i] + floor($add_money / $num);// 如果之前有随机分配，则是将剩余的钱平均追加入随机分配的值里
        }
        $arr_sum = array_sum($arr);// 分配后，求和，用于修正最后剩余的零钱
        // 如果还有剩余，这部分说明每人一分都不够，就从头开始没人一分的分下去，直到分完为止
        $odd_money = bcsub($money, $arr_sum, 0);// 针对钱的计算，建议使用bc函数，普通的计算方法有误差
        $i = 0;
        while ($odd_money >= 1) {
            $arr[$i] = $arr[$i] + 1;// 每人加1分钱
            $odd_money = $odd_money - 1;// 剩余的金额，每分掉一个人，就减1分钱
            $i++;
        }
        return $arr;
    }
    private function randPrice($total, $num, $min = 0.01)
    {
        for ($i = 1; $i < $num; $i++) {
            $safe_total = ($total - ($num - $i) * $min) / ($num - $i);//随机安全上限
            if ($safe_total < 0.01)
                $safe_total = 0.01;
            $money = mt_rand($min * 100, $safe_total * 100) / 100;
            $total = $total - $money;
            $data[] = round($money, 2);
        }
        $data[] = round($total, 2);
        shuffle($data);//重新打乱数组
        return $data;
    }

    //提交订单
    public function submitOrder(){
        try {
          $data=request()->post();
          $rule = [
             'gift_card_id|礼品卡ID' => 'require|number',
             'money|金额' => 'require|float',
           ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
        }
        $that=new UserForm();
        $giftCard=GiftCard::where(['id'=>$data['gift_card_id'],'is_delete'=>0,'status'=>1])->withoutField('detail')->find();
        if(!$giftCard){
            return fetchJson([],'暂无礼品卡',1);
        }
        $price_list=@json_decode($giftCard['price_list'],1);
        $give_price=0;
        foreach($price_list as $value){
            if($value['price']==$data['money']){
                $give_price=$value['give_price'];
                break;
            }
        }
        if($give_price<=0){
             return fetchJson([],'礼品卡数据赠送金额错误',1);
        }
        $order=new GiftCardOrder();
        $order->acid=$this->acid;
        $order->gift_card_id=$data['gift_card_id'];
        $order->user_id=$that->user_id;
        $order->order_no=GiftCardOrder::crateOrderNo();
        $order->title=$giftCard['title'];
        $order->cover=$giftCard['cover'];
        $order->give_price=$give_price;
        $order->money=$give_price;
        $order->price=$data['money'];
        $order->pay_price=$order->price;
        $order->snapshoot=json_encode($giftCard);
        $order->save();
        return fetchJson($order);
    }
    //支付订单
    public function payOrder(){
        $that=new UserForm();
        $order=GiftCardOrder::where(['id'=>input('order_id'),'user_id'=>$that->user_id,'is_pay'=>0])->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $order->order_no=GiftCardOrder::crateOrderNo();
        $order->save();
        $app=App::find($this->acid);
        $appid=$app->wxapp_app_id;
        $app_secret=$app->wxapp_app_secret;
        $openid=$that->user->wxapp_open_id;
        if(input('is_weixin')==1){
          $appid=$app->wx_app_id;
          $app_secret=$app->wx_app_secret;
          $openid=$that->user->wx_open_id;
        }
        //App
        if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
            $appConfig=Option::get_data($this->acid,'platform','app_config');
            $appConfig=@json_decode($appConfig);
            $appid=isset($appConfig->appid)?$appConfig->appid:'';
            $app_secret=isset($appConfig->app_secret)?$appConfig->app_secret:'';
        }
        $wx_config=[
            'appid'=>$appid,
            'appsecret'=>$app_secret,
            'mchid'=>$app->wx_mch_id,
            'key'=>$app->wx_key,
            'sslcert'=>$app->wx_cert_pem,
            'sslkey'=>$app->wx_key_pem,
       ];
       $wechatPay=new WechatPay($wx_config);
       $notify_url=request()->domain().str_replace('index.php', 'pay_shared.php',request()->baseFile());
       $paydata = [
            'body' =>'购买礼品卡',
            'out_trade_no' => $order->order_no,
            'total_fee' => round($order->pay_price,2)* 100,
            'notify_url' =>$notify_url ,
            'trade_type' => 'JSAPI',
            'openid' => $openid,
        ];
        //字节跳动支付
        if($this->platform=='ttapp'){
             $paydata=[
                'body' =>'购买礼品卡',
                'appid'=>$app->wx_app_id,
                'attach'=>'购买礼品卡',
                'mch_id'=>$app->mch_id,
                'notify_url' =>$notify_url ,
                'out_trade_no' => $order->order_no,
                'total_fee' => round($order->money,2)* 100,
                'trade_type' => 'MWEB',
                'openid' => $openid,
                'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
              ];
              $ttapp=Option::get_data($this->acid,'platform','ttapp_config');
              $ttapp=@json_decode($ttapp);
              $res=$wechatPay->toutiaoh5pay($paydata,$ttapp);
              if($res['code']==0){
                return fetchJson($res);
              }else{
                return fetchJson([],$res['msg'],1);
              }
        }
        //微信外部支付
        if($this->platform=='h5'&&input('is_weixin')==0){
            $paydata=[
              'body' =>'购买礼品卡',
              'appid'=>$app->wx_app_id,
              'attach'=>'购买礼品卡',
              'mch_id'=>$app->mch_id,
              'notify_url' =>$notify_url ,
              'out_trade_no' => $order->order_no,
              'total_fee' => round($order->money,2)* 100,
              'trade_type' => 'MWEB',
              'openid' => $openid,
              'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
            ];
            $rest['order_id']=$order->id;
            $res=$wechatPay->h5pay($paydata);
            if($res['code']==0){
              $rest['mweb_url']=$res['data'];
              return fetchJson($rest);
            }else{
              return fetchJson([],$res['msg'],1);
            }
       }
      if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
            unset($paydata['openid']);
            $paydata['trade_type']="APP";
            $res=$wechatPay->appPay($paydata);
       }else{
          $res=$wechatPay->pay($paydata);
       }
       $res['order_id']=$order->id;
       return fetchJson($res);
    }
}