<?php
namespace app\shared\logic\user;
use app\shared\model\Store;
use app\shared\model\ShareOrder;
use app\shared\model\User;
use app\shared\model\HouseOrder;
use app\shared\model\GoodsOrder;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\Withdraw;
use think\facade\Cache;
use think\facade\Db;
use think\Validate;
use app\shared\model\CardCoupon;
use Douyin\Live;
class DouyinForm extends UserForm
{
    //首页数据
    public function verifyTicket(){
        $poi_id=input('poi_id');
        $code=input('code');
        $code=trim($code);
        $douyin_config=Store::where(['douyin_poi_id'=>$poi_id])->value('douyin_config');
        $douyin_config=@json_decode($douyin_config,true);
        $form=new Live($douyin_config);
        $res=$form->certificateVerify($poi_id,$code);
        if($res['code']==0){
            $data=$res['data'];
            $coupon=CardCoupon::where([
              'acid'=>$this->acid,
              'type'=>2,
              'user_id'=>$this->user_id,
              'code'=>$data['code'],
            ])->find();
            if(!$coupon){
               $coupon=new CardCoupon();
            }
            $coupon->save([
              'acid'=>$this->acid,
              'type'=>2,
              'poi_id'=>$poi_id,
              'user_id'=>$this->user_id,
              'code'=>$data['code'],
              'name'=>implode(',',$data['sku_title']),
              'discounts_price'=>$data['sku_price'],
              'num'=>1,
              'start_time'=>time(),
              'status'=>1,
              'end_time'=>$data['expire_time'],
              'snapshoot'=>json_encode($data['certificates']),
            ]);
            return fetchJson($coupon,'核销成功');
        }
        return fetchJson([],'请求错误',1); 
    }
}
