<?php
namespace app\shared\logic\user;
use app\shared\model\Counter;
use app\shared\model\Store;
use app\shared\model\Goods;
use app\shared\model\CounterChest;
use app\shared\model\GoodsOrderDetail;
use think\exception\ValidateException;
use app\BaseController;
class CounterForm extends  Base
{
    //商户列表
    public function storeList(){
        $lat=input('lat')?input('lat'):0;
        $lng=input('lng')?input('lng'):0;
        $store_ids=Counter::where(['acid'=>$this->acid,'is_delete'=>0])->group('store_id')->column('store_id');
        $query=Store::where('id','in',$store_ids)->where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->field('id,name,logo,address,tel,lat,lng,score,(6378.138 * 2 * asin(sqrt(pow(sin((lat * pi() / 180 - '.$lat.' * pi() / 180) / 2),2) + cos(lat * pi() / 180) * cos('.$lat.' * pi() / 180) * pow(sin((lng * pi() / 180 - '.$lng.' * pi() / 180) / 2),2))) * 1000) as distance');
        if($keyword=input('keyword')){
          $query->where('name','like',"%$keyword%");
        }
        if($area_id=input('area_id')){
            $query->where('area_id',$area_id);
        }
        if($price_sort=input('price_sort')){
           if($price_sort==1){
               $query->order('tea_price ASC');
           }else{
               $query->order('tea_price DESC');
           }
        }
        if($category=input('category')){
          $query->whereFindInSet('category',$category);
        }
       if($distance_sort=input('distance_sort')){
           if($distance_sort==1){
               $query->order('distance ASC');
           }else{
               $query->order('distance DESC');
           }
       }else{
          $query->order('distance ASC');
       }
       $list=$query->page($this->page)->cache(30)->select();
       
       foreach ($list as $key => &$value) {
            $value['logo']=get_file_url($value['logo']);
            $config=@json_decode($value['config'],1);
       }    
       return fetchJson($list); 
    }
    //柜子
    public  function index(){
        $query=Counter::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>input('store_id'),'status'=>1]);
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('sort DESC')
        ->field('id,name')
        ->select();
        foreach ($list as $key => &$value) {
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //柜子详情
    public function details(){
        $counter=Counter::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>input('counter_id'),'status'=>1])->find();
        if($counter){
            $counter_chest_list=CounterChest::alias('c_c')
            ->leftJoin([Goods::getTable()=>'g'],'c_c.goods_id=g.id')
            ->where(['c_c.counter_id'=>$counter['id'],'c_c.is_delete'=>0])
            ->order('c_c.motoNum ASC')
            ->column('c_c.id,c_c.motoNum,c_c.status,c_c.deviceId,c_c.counter_id,c_c.type,c_c.goods_id,g.cover,g.name,g.price');
            foreach($counter_chest_list as &$v){
                $v['cover']=get_file_url($v['cover']);
                $v['sales_num']=GoodsOrderDetail::where(['status'=>1,'counter_chest_id'=>$v['id']])->sum('num');
            }
            $counter['counter_chest_list']=$counter_chest_list;
        }
        return fetchJson($counter);
        
    }
}