<?php
namespace app\shared\logic\user;
use app\shared\model\Companion;
use app\shared\model\CompanionCategory;
use app\shared\model\CompanionOrder;
use app\shared\model\Store;
use app\shared\model\HouseOrder;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\HouseUserOrder as StockHouseUserOrder;
use app\shared\model\Bill;
use app\shared\model\User;
use app\shared\model\App;
use app\admin\model\Option;
use app\shared\model\CircleTopic;
use app\shared\model\WxpayAccounting;
use think\exception\ValidateException;
use app\BaseController;
use wechatpay\WechatPay;
//约搭管理
class CompanionSelfForm extends  UserForm
{   
    //列表
    public function list(){
        $query=Companion::alias('c')->where(['c.user_id'=>$this->user_id,'c.is_delete'=>0]);
        $status=input("status");
        if($status!=-10){
            $query->where('c.status',$status);
        }
        $list=$query->limit(10)->page($this->page)->order('c.id DESC')->field('c.*')->select();
        foreach($list as &$value){
            $value['start_time']=date('Y-m-d H:i',$value['start_time']);
            $value['end_time']=date('Y-m-d H:i',$value['end_time']);
        }
        return fetchJson($list);
    }
    //详情
    public function detail(){
        $value=Companion::where(['user_id'=>$this->user_id,'is_delete'=>0,'id'=>input('id')])->find();
        if($value){
            $value['start_time']=date('Y-m-d H:i',$value['start_time']);
            $value['end_time']=date('Y-m-d H:i',$value['end_time']);
            $value['book_people_list']=CompanionOrder::alias('o')->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')->where(['o.companion_id'=>$value['id']])->where('o.status','in','1,2,3')->limit(5)->group('u.id')->column('u.id,u.avatar_url');
            if($value['house_order_id']){
                $value['house_order']=HouseOrder::where('id',$value['house_order_id'])->field('order_no,id')->find();
            }
        }
        return fetchJson($value);
    }
    //参与人
    public function bookPeopleList(){
        $companion_id=input('companion_id');
        $status=input('status');
        $query=CompanionOrder::alias('o')
        ->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')
        ->leftJoin([Companion::getTable()=>'c'],'c.id=o.companion_id')
        ->where(['o.companion_id'=>$companion_id,'c.user_id'=>$this->user_id]);
        if($status==1){
            $query->where('o.status','in','2,3');
        }else{
            $query->where('o.status',1);
        }
        $list=$query->page($this->page)
        ->limit(10)
        ->field('o.id as order_id,u.avatar_url,u.nickname,u.sex,c.start_time,c.end_time,o.status,o.create_time,o.avatar_url,o.tags,o.age,o.user_id')->select();
         foreach($list as &$value){
            $value['start_time']=date('Y-m-d H:i',$value['start_time']);
            $value['end_time']=date('Y-m-d H:i',$value['end_time']);
            $value['sex']=$value['sex']==2?2:1;
        }
        return fetchJson($list);
    }
    //审核订单
    public function auditOrder(){
        try {
          $data=request()->post();
          $rule = [
              'order_id|订单ID' => 'require',
              'status|状态' => 'require|in:0,1',
          ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(CompanionOrder::alias('o')
            ->leftJoin([Companion::getTable()=>'c'],'c.id=o.companion_id')
            ->where(['o.id'=>$data['order_id'],'c.user_id'=>$this->user_id,'o.status'=>1])->count()){
            if($data['status']==1){
                CompanionOrder::where(['id'=>$data['order_id']])->save(['status'=>2]);
                return fetchJson([],'审核通过');
            }else{
                CompanionOrder::where(['id'=>$data['order_id']])->save(['status'=>-1]);
                //退款退钱
                return fetchJson([],'拒绝通过');
            }
        }else{
            return fetchJson([],'暂无订单');
        }
    }
    //编辑
    public function edit(){
        try {
          $data=request()->post();
          $rule = [
              'id|ID' => 'require',
              'category_id|分类ID'=>'require',
              'title|标题'=>'require',
              'describe|描述'=>'require',
              'date|开始日期'=>'require|date',
              'start_time|开始时间'=>'require|date',
              'end_time|结束时间'=>'require|date',
              'place|地点'=>'require',
              'address|地址'=>'require',
              'people_type|参与人形式'=>'require',
              'man_num|男生人数'=>'require',
              'woman_num|女生人数'=>'require',
              'pay_types|支付类型'=>'require',
              'consume_types|消费类型'=>'require',
              'cash_price|押金费用'=>'require',
              'price|活动费用'=>'require',
              'organizer_type|玩家类型'=>'require',
              'username|用户姓名'=>'require',
              'tel|联系电话'=>'require',
              'wx_num|微信号'=>'require',
              'status|状态'=>'require|in:0,1',
              'lat|维度'=>'require',
              'lng|经度'=>'require',
          ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=Companion::where(['id'=>$data['id'],'user_id'=>$this->user_id])->find();
        if(!$form){
            $form=new Companion();
        }
        $form->save([
          'acid'=>$this->acid,
          'user_id'=>$this->user_id,
          'sex'=>$this->user->sex==2?2:1,
          'title'=>$data['title'],
          'city_id'=>input('city_id'),
          'category_id'=>$data['category_id'],
          'category_name'=>CompanionCategory::where('id',$data['category_id'])->value('name'),
          'describe'=>$data['describe'],
          'date'=>$data['date'],
          'start_time'=>strtotime($data['start_time']),
          'end_time'=>strtotime($data['end_time']),
          'place'=>$data['place'],
          'address'=>$data['address'],
          'people_type'=>$data['people_type'],
          'man_num'=>$data['man_num'],
          'woman_num'=>$data['woman_num'],
          'pay_types'=>$data['pay_types'],
          'consume_types'=>$data['consume_types'],
          'cash_price'=>$data['cash_price'],
          'price'=>$data['price'],
          'organizer_type'=>$data['organizer_type'],
          'username'=>$data['username'],
          'tel'=>$data['tel'],
          'wx_num'=>$data['wx_num'],
          'status'=>$data['status'],
          'lat'=>$data['lat'],
          'lng'=>$data['lng'],
        ]);
        if(!CompanionOrder::where(['companion_id'=>$form->id,'user_id'=>$this->user_id])->count()){
            $order=new CompanionOrder();
            $order->pay_price=0;
            $order->order_no=CompanionOrder::crateOrderNo();
            $order->user_id=$this->user_id;
            $order->username=$data['username'];
            $order->start_time=$form['start_time'];
            $order->end_time=$form['end_time'];
            $order->status=2;
            $form['start_time']=date('Y-m-d H:i',$form['start_time']);
            $form['end_time']=date('Y-m-d H:i',$form['end_time']);
            $order->save([
                'companion_id'=>$form->id,
                'snapshoot'=>$form
            ]);
        }
        return fetchJson([],'保存成功');
    }
    //活动开始
    public function begin(){
        $form=Companion::where(['id'=>input('id'),'user_id'=>$this->user_id])->find();
        if($form){
            $form->save(['status'=>2]);
            CompanionOrder::where(['companion_id'=>$form->id,'status'=>2])->save(['status'=>3]);
        }
        return fetchJson([],'活动开始');
    }
    //活动完成
    public function complete(){
        $form=Companion::where(['id'=>input('id'),'user_id'=>$this->user_id])->find();
        if($form){
            if($form->house_order_id){
                //分账、给支付空间者退款
                $orderList=CompanionOrder::where(['companion_id'=>$form->id,'status'=>3])->select();
                $store=Store::where('id',$form->store_id)->find();
                $houseOrder=HouseOrder::where(['id'=>$form->house_order_id,'is_pay'=>1])->field('house_id,pay_type')->find();
                $money=0;    
                foreach($orderList as $order){
                    if($order->pay_price){
                        $money+=$order->pay_price;
                        $res=self::houseOrderBill($order,$houseOrder);
                    }
                }
                self::addUserBill($form,$money);
            }
            $form->save(['status'=>3]);
            CompanionOrder::where(['companion_id'=>$form->id,'status'=>3])->save(['status'=>4]);
        }
        return fetchJson([],'活动完成');
    }    //活动删除
    public function delete(){
        Companion::where(['id'=>input('id'),'user_id'=>$this->user_id,'status'=>-1])->save(['is_delete'=>1]);
        return fetchJson([],'删除');
    }
    //活动取消
    public function cancle(){
        Companion::where(['id'=>input('id'),'user_id'=>$this->user_id])->save(['status'=>-1]);
        return fetchJson([],'活动取消');
    }
    private function addUserBill($companion=[],$refund_price=0){
        $user=User::where('id',$companion->user_id)->find();
        $des="用户:【{$user->nickname}】约搭组局成功，系统为您退回垫付费用";
        $price_type=2;
        $order=HouseOrder::where(['id'=>$companion->house_order_id,'is_pay'=>1])->find();
        if($order->pay_type==2){
            $user->money=$user->money+$refund_price;
        }else{
             if($order->formation_price<$refund_price){
                die(json_encode(['code' => 1, 'msg' => '退款金额大于组局退款金额','data' =>'']));
             }
             //微信退款
             if($order->out_order_time>0){
                die(json_encode(['code' => 1, 'msg' => '已经退过了','data' =>'']));
             }
             $app=App::find($order->acid);
             $appid=$app->wxapp_app_id;
             $app_secret=$app->wxapp_app_secret;
             $wx_config=[
                  'appid'=>$appid,
                  'appsecret'=>$app_secret,
                  'mchid'=>$app->wx_mch_id,
                  'key'=>$app->wx_key,
                  'sslcert'=>$app->wx_cert_pem,
                  'sslkey'=>$app->wx_key_pem,
             ];
             
             if(isset($app->wx_pay_type)){
                $storeWx=Store::where('id',$order->store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey,fee')->find();
                //服务商模式
                if($app->wx_pay_type==2){
                   $wx_config=[
                        'appid'=>$appid,
                        'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                        'wx_server_appid'=>$app->wx_server_appid,
                        'appsecret'=>$app_secret,
                        'wx_server_mch_id'=>$app->wx_server_mch_id,
                        'key'=>$app->wx_server_key,
                        'sslcert'=>$app->wx_server_cert_pem,
                        'sslkey'=>$app->wx_server_key_pem,
                        'sub_appid'=>$appid,
                        'sub_mch_id'=>$app->wx_mch_id,
                        'wx_pay_type'=>$app->wx_pay_type
                   ];
                   if($storeWx['fee']>0){
                        $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                   }
                }else{
                   if($storeWx['wx_mch_id']){
                      $wx_config=[
                            'appid'=>$appid,
                            'appsecret'=>$app_secret,
                            'mchid'=>$storeWx['wx_mch_id'],
                            'key'=>$storeWx['wx_key'],
                            'sslcert'=>$storeWx['wx_sslcert'],
                            'sslkey'=>$storeWx['wx_sslkey']
                       ];
                       if($storeWx['fee']>0){
                          $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                       }
                   }
                }

             }
           
             $wechatPay=new WechatPay($wx_config);
             $notify_url='https://chashi-demo.youdiy.cn';
             $order->out_order_no=HouseOrder::crateOutOrderNo();
             $data = [
                'out_refund_no' => $order->out_order_no,//订单号码
                'out_trade_no' =>$order->order_no,//退款单号
                'total_fee' =>  $order->pay_price * 100,//支付金额
                'refund_fee' => $refund_price * 100,//全额退款
            ];
            if(isset($order->xml_array)){
                $xml_array=@json_decode($order->xml_array,1);
                if(isset($xml_array['transaction_id'])){
                  $data['transaction_id']=$xml_array['transaction_id'];
                }
            }
            $payResult = $wechatPay->refund($data);
            if (!isset($payResult['return_code']) || $payResult['return_code'] != 'SUCCESS') {
                $info='退款失败，' . (isset($payResult['return_msg']) ? $payResult['return_msg'] : '');
                die(json_encode(['code' => 1, 'msg' => $info,'data' =>'']));
            }
            if (!isset($payResult['result_code']) || $payResult['result_code'] != 'SUCCESS') {
                $info='提交业务失败，'. (isset($payResult['err_code_des']) ? $payResult['err_code_des'] : '');
               die(json_encode(['code' => 1, 'msg' => $info,'data' =>'']));
            }
            $order->formation_price=$refund_price;
            $order->out_order_time=time();
            $order->pay_price-=$refund_price;
            $order->save();
            $price_type=1;
        }
        $user->save();

        if($refund_price){
            (new Bill())->save([
              'acid'=>$order->acid,
              'type'=>Bill::TYPE_COMPANION,
              'account_type'=>Bill::ACCOUNT_TYPE_USER,
              'form_id'=>$companion->user_id,
              'order_id'=>$companion->id,
              'price'=>$refund_price,
              'price_type'=>$price_type,
              'balance'=>$user->money,
              'status'=>1,
              'des'=>$des
          ]);
        }
    }
    //增加茶室账单
    private function houseOrderBill($order=[],$houseOrder=[]){
            $store=Store::where('id',$order->store_id)->find();
            if($store['is_actually_pay']==1){
                $fee=($store->fee*0.01)*$order->pay_price;
                $fee=$fee>0?$fee:0;//手续费
                $orderPrice=$order->pay_price-$fee; //总金额 
            }else{
                $fee=($store->fee*0.01)*$order->price;
                $fee=$fee>0?$fee:0;//手续费
                $orderPrice=$order->price-$fee; //总金额  
            }  
            $stockHouse=StockHouseUser::alias('h_u')
                   ->leftJoin([StockHouse::getTable()=>'h'],'h_u.stock_house_id=h.id')
                   ->where(['h_u.acid'=>$order->acid,'h.house_id'=>$houseOrder['house_id'],'h_u.is_delete'=>0,'h.is_delete'=>0])
                   ->field('h_u.stock_user_id,h_u.ratio,h.house_id,h_u.stock_house_id')
                   ->select()
                   ->toArray();
            $wxpayAccounting=self::WxpayAccounting($store,$order,$order->pay_price,1);
            $wxfz_total_fee=0;
            $wxfz_sub_price=0;
            if($wxpayAccounting['code']==0){
                $wxfz_total_fee=$wxpayAccounting['data']->total_fee;
                $wxfz_sub_price=$wxpayAccounting['data']->sub_price;
            }else{
                return ['code'=>1,'msg'=>$wxpayAccounting];
            }
            //分红金额
            $sharePrice=0;           
            foreach($stockHouse as $hu){
                if(!StockHouseUserOrder::where([
                  'acid'=>$order->acid,
                  'type'=>1,
                  'order_id'=>$order->id,
                  'stock_house_id'=>$hu['stock_house_id'],
                  'stock_user_id'=>$hu['stock_user_id'],
                ])->count()){
                    (new StockHouseUserOrder())->save([
                      'acid'=>$order->acid,
                      'type'=>1,
                      'order_id'=>$order->id,
                      'stock_house_id'=>$hu['stock_house_id'],
                      'stock_user_id'=>$hu['stock_user_id'],
                      'ratio'=>$hu['ratio'],
                      'price'=>$hu['ratio']*$orderPrice*0.01, 
                    ]);
                   $user=StockUser::where('id',$hu['stock_user_id'])->field('id,money,total_price')->find();
                   if($user){
                     $user->money+=$hu['ratio']*$orderPrice*0.01;
                     $user->total_price+=$hu['ratio']*$orderPrice*0.01;
                     $user->save();
                   }
                   $sharePrice+=$hu['ratio']*$orderPrice*0.01;
               }
            }
            
            if($sharePrice>0){
                $store->money+=$orderPrice-$sharePrice;
                (new Bill())->save([
                    'acid'=>$order->acid,
                    'type'=>Bill::TYPE_HOUSE,
                    'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                    'form_id'=>$order->store_id,
                    'order_id'=>$order->id,
                    'price'=>$orderPrice-$sharePrice,
                    'price_type'=>$order->pay_type,
                    'balance'=>$store->money,
                    'status'=>1,
                    'fee'=>$fee,
                    'des'=>'商户: 【'.$store->name.'】进行了分账约搭茶室收入其中股东分红扣除'.$sharePrice.'元'
                ]);            
            }else{
                $store->money+=$orderPrice-$sharePrice;
                (new Bill())->save([
                    'acid'=>$order->acid,
                    'type'=>Bill::TYPE_HOUSE,
                    'account_type'=>Bill::ACCOUNT_TYPE_STORE,
                    'form_id'=>$order->store_id,
                    'order_id'=>$order->id,
                    'price'=>$orderPrice,
                    'price_type'=>$order->pay_type,
                    'balance'=>$store->money,
                    'status'=>1,
                    'fee'=>$fee,
                    'des'=>'商户: 【'.$store->name.'】进行分账约搭茶室收入'
                ]);
            }        
            $store->save();
            return ['code'=>0,'msg'=>'分账成功'];
    }
    //微信分账
     //分账
    public function WxpayAccounting($store,$order,$total_fee=1,$formType=1){
       if(!$order){
          return ['code'=>1];
       }
       
       $app=App::find($order->acid);
       if($app->wx_profit_sharing==0){
          return ['code'=>1];
       }
       
       if($app->wx_pay_type==1){
           $wx_config=[
              'appid'=>$app->wxapp_app_id,
              'mchid'=>$store['wx_mch_id'],
              'appsecret'=>$app->wxapp_app_secret,
              'key'=>$store['wx_key'],
              'sslcert'=>$store['wx_sslcert'],
              'sslkey'=>$store['wx_sslkey'],
              'sub_mch_id'=>$app->wx_mch_id,
              'wx_pay_type'=>$app->wx_pay_type,
           ];
       }else{
           $wx_config=[
              'appid'=>$app->wxapp_app_id,
              'mchid'=>$app->wx_mch_id,
              'wx_server_appid'=>$app->wx_server_appid,
              'appsecret'=>$app->wxapp_app_secret,
              'wx_server_mch_id'=>$app->wx_server_mch_id,
              'key'=>$app->wx_server_key,
              'sslcert'=>$app->wx_server_cert_pem,
              'sslkey'=>$app->wx_server_key_pem,
              'sub_appid'=>$app->wxapp_app_id,
              'sub_mch_id'=>$app->wx_mch_id,
              'wx_pay_type'=>$app->wx_pay_type,
           ];
       }
      
       $is_server=$app->wx_pay_type==2?1:0;
       $xml_array=@json_decode($order->xml_array,1);
       $is_subaccount=WxpayAccounting::where('out_trade_no',$xml_array['out_trade_no'])->count();
       if($is_subaccount){
          return ['code'=>1];
       }
       $order_no=WxpayAccounting::crateOrderNo("FZR".$order->store_id."S");

       $wx_sub_config=@json_decode($store['wx_sub_config'],1);
       $store_fee=$store['fee'];
       if($formType==4){
         if(isset($wx_sub_config['recharge']['fee'])){
             $store_fee=$wx_sub_config['recharge']['fee'];
          }
       }else if($formType==2){
          if(isset($wx_sub_config['shared_teahouse']['fee'])){
             $store_fee=$wx_sub_config['shared_teahouse']['fee'];
          }  
       }else if($formType==1){
          if(isset($wx_sub_config['shared_teahouse']['fee'])){
             $store_fee=$wx_sub_config['shared_teahouse']['fee'];
          }  
       }else{
         $store_fee=$store['fee'];
       }
       $form=new WechatPay($wx_config);
       $account=$app->wx_mch_id;
       $companyName=$app->wx_mch_name;
       $amount=$total_fee*$store_fee;//分账金额（分）
       $amount=filter_money($amount,0);
       if($amount<=0){
           $amount=1;
           if($store['wx_mch_id']==0){
               return ['code'=>1,'msg'=>'不用分账'];
           }
       }
       
       $out_trade_no=$xml_array['out_trade_no'];//订单号
       $transaction_id=$xml_array['transaction_id'];//微信交易订单号
       $res=$form->profitsharingaddreceiver($account,$companyName,$is_server);
       if($res['code']==1){
           return ['code'=>1,'res'=>$res];
       }
       $res=$form->profitsharing($order_no,$transaction_id,$account,$amount,$companyName,$is_server);
       if($res['code']===0){
         if($res['data']['result_code']=="SUCCESS"){
            $form=new WxpayAccounting();
            $form->acid=$order->acid;
            $form->store_id=$order->store_id;
            $form->type=WxpayAccounting::TYPE_COMPANION;
            $form->order_id=$order->id;
            $form->appid=$xml_array['appid'];
            $form->mch_id=$xml_array['mch_id'];
            $form->openid=$xml_array['openid'];
            $form->order_no=$order_no;
            $form->out_trade_no=$xml_array['out_trade_no'];
            $form->transaction_id=$xml_array['transaction_id'];
            $form->total_fee=$xml_array['total_fee']*0.01;
            $form->sub_price=$amount*0.01;
            $form->sub_account=$account;
            $form->sub_type=1;
            $form->save();
            return ['code'=>0,'data'=>$form];
         }else{
            return ['code'=>1,'res'=>$res];
         }
       }else{
           return ['code'=>1,'res'=>$res];;
       }
    }

}
