<?php
namespace app\shared\logic\user;
use app\shared\model\Companion;
use app\shared\model\CompanionOrder;
use app\shared\model\CompanionCategory;
use app\shared\model\HouseOrder;
use app\shared\model\User;
use app\shared\model\App;
use app\shared\model\Bill;
use app\shared\model\Store;
use app\admin\model\Option;
use app\shared\model\CircleTopic;
use think\exception\ValidateException;
use app\BaseController;
use wechatpay\WechatPay;
//约搭管理
class CompanionOrderForm extends  UserForm
{   
    //列表
    public function list(){
        $query=CompanionOrder::alias('o')
        ->leftJoin([companion::getTable()=>'c'],'o.companion_id=c.id')
        ->leftJoin([CompanionCategory::getTable()=>'ca'],'c.category_id=ca.id')
        ->where(['o.user_id'=>$this->user_id,'o.is_delete'=>0]);
        $status=input("status");
        if($status!=-10){
            $query->where('o.status',$status);
        }else{
            $query->where('o.status','<>',0);
        }
        $list=$query->limit(10)->page($this->page)->field('o.*,c.title,ca.name category_name,c.address,c.start_time,c.end_time,c.place,c.lat,c.lng')->order('o.id DESC')->select();
        foreach($list as &$value){
            $value['snapshoot']=@json_decode($value['snapshoot'],true);
            $value['start_time']=date('Y-m-d H:i',$value['start_time']);
            $value['end_time']=date('Y-m-d H:i',$value['end_time']);
        }
        return fetchJson($list);
    }
    //编辑
    public function submit(){
        try {
          $data=request()->post();
          $rule = [
              'companion_id|ID' => 'require',
              'username|用户名'=>'require',
              'wx_num|微信号'=>'require',
              'phone|手机号码'=>'require',
              'sex|性别'=>'require',
              'age|年龄'=>'require',
              'tags|标签'=>'require',
              'avatar_url|生活照'=>'require'
          ];
          $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $companion=Companion::where(['id'=>$data['companion_id'],'is_delete'=>0,'status'=>1])->field('id,price,title,date,start_time,end_time,man_num,woman_num,store_id')->find();
        if(!$companion){
            return fetchJson([],'暂无该搭子',1);
        }
        $orderNum=CompanionOrder::where('companion_id',$data['companion_id'])->where(['is_pay'=>1])->count();
        $man_num=$companion['man_num']*1;
        $woman_num=$companion['woman_num']*1;
        if($orderNum>=($man_num+$woman_num)){
             return fetchJson([],'人数已满了',1);
        }
        $order=new CompanionOrder();
        $order->acid=$this->acid;
        $order->pay_price=$companion['price'];
        $order->order_no=CompanionOrder::crateOrderNo();
        $order->user_id=$this->user_id;
        $order->store_id=$companion['store_id'];
        $order->username=$data['username'];
        $order->start_time=$companion['start_time'];
        $order->end_time=$companion['end_time'];
        $companion['start_time']=date('Y-m-d H:i',$companion['start_time']);
        $companion['end_time']=date('Y-m-d H:i',$companion['end_time']);
        $order->save([
            'companion_id'=>$data['companion_id'],
            'wx_num'=>$data['wx_num'],
            'phone'=>$data['phone'],
            'sex'=>$data['sex'],
            'age'=>$data['age'],
            'tags'=>$data['tags'],
            'avatar_url'=>$data['avatar_url'],
            'snapshoot'=>json_encode($companion,JSON_UNESCAPED_UNICODE)
        ]);
        return fetchJson([
            'order_id'=>$order->id
        ]);
    }
    //支付订单
    public function orderPay(){
           $order_id=input('order_id');
           $order=CompanionOrder::where(['id'=>$order_id,'user_id'=>$this->user_id,'is_pay'=>0])->find();
           if(!$order){
              return fetchJson([],'暂无订单',1);
           }
           $companion=Companion::where(['id'=>$order->companion_id])->find();
           $orderNum=CompanionOrder::where('companion_id',$order->companion_id)->where(['is_pay'=>1])->count();
           $man_num=$companion['man_num']*1;
           $woman_num=$companion['woman_num']*1;
           if($orderNum>=($man_num+$woman_num)){
                return fetchJson([],'人数已满了',1);    
           }
           $order->order_no=CompanionOrder::crateOrderNo();
           $pay_type=input('pay_type')?input('pay_type'):1;
           if($order->pay_price==0){
                $pay_type=2;
           }
           $order->pay_type=$pay_type;
           $order->save();
            //判断是否用余额支付
           if($pay_type==2){
               $res=self::balancePayment($order);
               return fetchJson(['order_id'=>$order_id],$res['msg'],$res['code']);
           }
           $app=App::find($this->acid);
           $appid=$app->wxapp_app_id;
           $app_secret=$app->wxapp_app_secret;
           $openid=$this->user->wxapp_open_id;
           if(input('is_weixin')==1){
              $appid=$app->wx_app_id;
              $app_secret=$app->wx_app_secret;
              $openid=$this->user->wx_open_id;
           }
           if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
                $appConfig=Option::get_data($this->acid,'platform','app_config');
                $appConfig=@json_decode($appConfig);
                $appid=isset($appConfig->appid)?$appConfig->appid:'';
                $app_secret=isset($appConfig->app_secret)?$appConfig->app_secret:'';
           }
           $wx_config=[
                'appid'=>$appid,
                'appsecret'=>$app_secret,
                'mchid'=>$app->wx_mch_id,
                'key'=>$app->wx_key,
                'sslcert'=>$app->wx_cert_pem,
                'sslkey'=>$app->wx_key_pem,
           ];
           if(isset($app->wx_pay_type)){
              $storeWx=Store::where('id',$order->store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey,fee,wx_sub_config')->find();
              //服务商模式
              if($app->wx_pay_type==2){
                 $wx_config=[
                      'appid'=>$appid,
                      'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                      'wx_server_appid'=>$app->wx_server_appid,
                      'appsecret'=>$app_secret,
                      'wx_server_mch_id'=>$app->wx_server_mch_id,
                      'key'=>$app->wx_server_key,
                      'sslcert'=>$app->wx_server_cert_pem,
                      'sslkey'=>$app->wx_server_key_pem,
                      'sub_appid'=>$appid,
                      'sub_mch_id'=>$app->wx_mch_id,
                      'wx_pay_type'=>$app->wx_pay_type
                 ];
                 $wx_sub_config=@json_decode($storeWx['wx_sub_config'],1);
                 if(isset($wx_sub_config['goods']['status'])){
                    $wx_sub_config['goods']['status']=$wx_sub_config['goods']['status']*1;
                    if(isset($wx_sub_config['goods']['fee'])&&$wx_sub_config['goods']['status']==1){
                        $order->sub_account_status=1;
                        $order->save();
                        $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                    }
                 }
              }else{
                 if($storeWx['wx_mch_id']){
                    $wx_config=[
                          'appid'=>$appid,
                          'appsecret'=>$app_secret,
                          'mchid'=>$storeWx['wx_mch_id'],
                          'key'=>$storeWx['wx_key'],
                          'sslcert'=>$storeWx['wx_sslcert'],
                          'sslkey'=>$storeWx['wx_sslkey']
                     ];
                     $wx_sub_config=@json_decode($storeWx['wx_sub_config'],1);
                     if(isset($wx_sub_config['goods']['status'])){
                        $wx_sub_config['goods']['status']=$wx_sub_config['goods']['status']*1;
                        if(isset($wx_sub_config['goods']['fee'])&&$wx_sub_config['goods']['status']==1){
                            $order->sub_account_status=1;
                            $order->save();
                            $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                        }
                     }
                 }
              }
           }
           $wechatPay=new WechatPay($wx_config);
           $notify_url=request()->domain().str_replace('index.php', 'pay_shared.php',request()->baseFile());
           $paydata = [
                'body' =>$companion->order_id>0?$companion['title'].'组局':$companion['title'].'约搭活动',
                'out_trade_no' => $order->order_no,
                'total_fee' => round($order->pay_price,2)* 100,
                'notify_url' =>$notify_url ,
                'trade_type' => 'JSAPI',
                'openid' => $openid,
            ];
           //字节跳动支付
           if($this->platform=='ttapp'){
                 $paydata=[
                    'body' =>$companion->order_id>0?$companion['title'].'组局':$companion['title'].'约搭活动',
                    'appid'=>$app->wx_app_id,
                    'attach'=>'约搭',
                    'mch_id'=>$app->mch_id,
                    'notify_url' =>$notify_url ,
                    'out_trade_no' => $order->order_no,
                    'total_fee' => round($order->pay_price,2)* 100,
                    'trade_type' => 'MWEB',
                    'openid' => $openid,
                    'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
                ];
                $ttapp=Option::get_data($this->acid,'platform','ttapp_config');
                $ttapp=@json_decode($ttapp);
                $res=$wechatPay->toutiaoh5pay($paydata,$ttapp);
                if($res['code']==0){
                  return fetchJson($res);
                }else{
                  return fetchJson([],$res['msg'],1);
                }
           }
            //微信外部支付
           if($this->platform=='h5'&&input('is_weixin')==0){
                $paydata=[
                  'body' =>$companion->order_id>0?$companion['title'].'组局':$companion['title'].'约搭活动',
                  'appid'=>$app->wx_app_id,
                  'attach'=>'约搭',
                  'mch_id'=>$app->mch_id,
                  'notify_url' =>$notify_url ,
                  'out_trade_no' => $order->order_no,
                  'total_fee' => round($order->pay_price,2)* 100,
                  'trade_type' => 'MWEB',
                  'openid' => $openid,
                  'scene_info'=>'{"h5_info":{"type":"Wap","wap_url":"'.request()->domain().'","wap_name":"测试支付"}}'
                ];
                $rest['order_id']=$order->id;
                $res=$wechatPay->h5pay($paydata);
                if($res['code']==0){
                  $rest['mweb_url']=$res['data'];
                  return fetchJson($rest);
                }else{
                  return fetchJson([],$res['msg'],1);
                }
           }
           if($this->platform=='app'||$this->platform=='ios'||$this->platform=='android'){
                unset($paydata['openid']);
                $paydata['trade_type']="APP";
                $res=$wechatPay->appPay($paydata);
           }else{
              $res=$wechatPay->pay($paydata);
           }
           $res['order_id']=$order->id;
           return fetchJson($res);
    }
    //余额支付
    private function balancePayment($order=[]){
         $user=User::where('id',$order['user_id'])->find();
         if($user->money<$order->pay_price){
            return [
              'msg'=>'余额不足',
              'code'=>1
            ];
         }
         $form=new \app\shared\logic\pay\CompanionOrderForm();
         $res=$form->saveOrder($order->order_no);
         if($res=='success'){
            return [
              'msg'=>'支付成功',
              'code'=>0
            ];
         }
        return [
          'msg'=>'余额支付错误',
          'code'=>1
        ];
    }
    //订单签到
    public function oderSignin(){
          CompanionOrder::where(['id'=>input('order_id'),'user_id'=>$this->user_id])->where('status','in','2,3')->update(['is_signin'=>1]);
          return fetchJson([],'签到成功');
    }
    //活动删除
    public function detail(){
        $query=CompanionOrder::alias('o')
        ->leftJoin([companion::getTable()=>'c'],'o.companion_id=c.id')
        ->leftJoin([CompanionCategory::getTable()=>'ca'],'c.category_id=ca.id')
        ->where(['o.user_id'=>$this->user_id,'o.is_delete'=>0,'o.id'=>input('id')]);
        $value=$query->field('o.*,c.title,ca.name category_name,c.address,c.start_time,c.end_time,c.place,c.lat,c.lng,c.price,c.cash_price,c.consume_types,c.pay_types,c.describe,c.man_num,c.woman_num,c.house_order_id')->find();
        if($value){
            $value['start_time']=date('Y-m-d H:i',$value['start_time']);
            $value['end_time']=date('Y-m-d H:i',$value['end_time']);
            if($value['house_order_id']){
                $value['house_order']=HouseOrder::where('id',$value['house_order_id'])->field('order_no,id')->find();
            }
        }
        return fetchJson($value);
    }
    //活动删除
    public function delete(){
        CompanionOrder::where(['id'=>input('id'),'user_id'=>$this->user_id,'status'=>-1])->save(['is_delete'=>1]);
        return fetchJson([],'删除');
    }
    //活动取消
    public function cancle(){
        $order=CompanionOrder::where(['id'=>input('id'),'user_id'=>$this->user_id])->where('status','in','1,2')->find();
        if($order){
              $refund_price=filter_money($order->pay_price);
              //微信支付
              $user=User::where('id',$order->user_id)->find();
              $app=App::find($order->acid);
              if($order->pay_type==1){
                 if($order->out_order_time>0){
                    return fetchJson([],'已经退过了',1);
                 }
                 $appid=$app->wxapp_app_id;
                 $app_secret=$app->wxapp_app_secret;
                 $wx_config=[
                      'appid'=>$appid,
                      'appsecret'=>$app_secret,
                      'mchid'=>$app->wx_mch_id,
                      'key'=>$app->wx_key,
                      'sslcert'=>$app->wx_cert_pem,
                      'sslkey'=>$app->wx_key_pem,
                 ];
                 if(isset($app->wx_pay_type)){
                    $storeWx=Store::where('id',$order->store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey,fee')->find();
                    //服务商模式
                    if($app->wx_pay_type==2){
                       $wx_config=[
                            'appid'=>$appid,
                            'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                            'wx_server_appid'=>$app->wx_server_appid,
                            'appsecret'=>$app_secret,
                            'wx_server_mch_id'=>$app->wx_server_mch_id,
                            'key'=>$app->wx_server_key,
                            'sslcert'=>$app->wx_server_cert_pem,
                            'sslkey'=>$app->wx_server_key_pem,
                            'sub_appid'=>$appid,
                            'sub_mch_id'=>$app->wx_mch_id,
                            'wx_pay_type'=>$app->wx_pay_type
                       ];
                       if($storeWx['fee']>0){
                            $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                       }
                    }else{
                       if($storeWx['wx_mch_id']){
                          $wx_config=[
                                'appid'=>$appid,
                                'appsecret'=>$app_secret,
                                'mchid'=>$storeWx['wx_mch_id'],
                                'key'=>$storeWx['wx_key'],
                                'sslcert'=>$storeWx['wx_sslcert'],
                                'sslkey'=>$storeWx['wx_sslkey']
                           ];
                           if($storeWx['fee']>0){
                              $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                           }
                       }
                    }

                 }
                 
                 $wechatPay=new WechatPay($wx_config);
                 $notify_url='https://chashi-demo.youdiy.cn';
                 $order->out_order_no=CompanionOrder::crateOutOrderNo();
                 $data = [
                    'out_refund_no' => $order->out_order_no,//订单号码
                    'out_trade_no' =>$order->order_no,//退款单号
                    'total_fee' =>  $order->pay_price * 100,//支付金额
                    'refund_fee' => $refund_price * 100,//全额退款
                ];
                if(isset($order->xml_array)){
                    $xml_array=@json_decode($order->xml_array,1);
                    if(isset($xml_array['transaction_id'])){
                      $data['transaction_id']=$xml_array['transaction_id'];
                    }
                }
                $payResult = $wechatPay->refund($data);
                if (!isset($payResult['return_code']) || $payResult['return_code'] != 'SUCCESS') {
                    $info='退款失败，' . (isset($payResult['return_msg']) ? $payResult['return_msg'] : '');
                    return fetchJson([],$info,1);
                }
                if (!isset($payResult['result_code']) || $payResult['result_code'] != 'SUCCESS') {
                    $info='提交业务失败，'. (isset($payResult['err_code_des']) ? $payResult['err_code_des'] : '');
                    return fetchJson([],$info,1);
                }
                $order->out_order_time=time();
                
                if($refund_price>0){
                    (new Bill())->save([
                        'acid'=>$order->acid,
                        'type'=>Bill::TYPE_COMPANION,
                        'account_type'=>Bill::ACCOUNT_TYPE_USER,
                        'form_id'=>$order->user_id,
                        'order_id'=>$order->id,
                        'price'=>$refund_price,
                        'price_type'=>$order->pay_type,
                        'status'=>1,
                        'fee'=>0,
                        'balance'=>$user->money,
                        'des'=>'用户: 【'.$user->nickname.'】约搭订单微信退款'
                    ]);
                }
             }
             //余额支付退款
             if($order->pay_type==2){
                $user->money+=$refund_price;
                $user->save();
                if($refund_price>0){
                    (new Bill())->save([
                        'acid'=>$order->acid,
                        'type'=>Bill::TYPE_COMPANION,
                        'account_type'=>Bill::ACCOUNT_TYPE_USER,
                        'form_id'=>$order->user_id,
                        'order_id'=>$order->id,
                        'price'=>$refund_price,
                        'price_type'=>$order->pay_type,
                        'status'=>1,
                        'fee'=>0,
                        'balance'=>$user->money,
                        'des'=>'用户: 【'.$user->nickname.'】约搭订单余额退款'
                    ]);
                }
             }
            $order->status=-1;
            $order->save(['status'=>-1]);
        }
        return fetchJson([],'活动取消');
    }

}