<?php
namespace app\shared\logic\user;
use app\shared\model\Companion;
use app\shared\model\CompanionOrder;
use app\shared\model\User;
use app\admin\model\App;
use app\admin\model\Option;
use app\shared\model\CircleTopic;
use app\shared\model\CompanionCategory;
use app\shared\model\CompanionTags;
use app\thousands\model\CardOrder;
use think\exception\ValidateException;
use app\BaseController;
use wechatpay\WechatPay;
//约搭管理
class CompanionForm extends  Base
{	
    public function list(){
        $user_id=input('user_id');
        $query=Companion::alias('c')->leftJoin([User::getTable()=>'u'],'c.user_id=u.id')->leftJoin([CompanionCategory::getTable()=>'ca'],'c.category_id=ca.id')->where(['c.is_delete'=>0])->where('c.status','in','1,2,3');
        if($category_id=input('category_id')){
            $query->where('c.category_id',$category_id);
        }
        if($keyword=input('keyword')){
            $query->where('c.title|c.describe','like',"%{$keyword}%");
        }
        if($city_id=input('city_id')){
            $query->where('c.city_id',$city_id);
        }
        $list=$query->limit(10)->page($this->page)->order('c.id DESC')
        ->field('c.id,c.title,c.describe,c.date,c.start_time,c.end_time,c.place,c.address,c.sex,c.status,c.people_type,c.man_num,c.woman_num,c.pay_types,c.consume_types,c.cash_price,c.price,c.username,c.tel,c.wx_num,c.create_time,u.nickname,u.avatar_url,ca.name category_name')
        ->select();
        foreach($list as &$value){
            $start_time=$value['start_time'];
            $end_time=$value['end_time'];
            $value['start_time']=date('Y-m-d H:i',$start_time);
            $value['end_time']=date('Y-m-d H:i',$end_time);
            if($value['people_type']==4){
                $value['sum_people']=$value['man_num'];
            }else{
                $value['sum_people']=$value['man_num']+$value['woman_num'];
            }
            $value['book_people_num']=CompanionOrder::where(['companion_id'=>$value['id']])->where('status','in','1,2,3')->count();
            if($value['sum_people']<=$value['book_people_num']){
                $value['order_status']=4;
            }else{
                $value['order_status']=1;
            }    
            //1可报名，2已报名，3进行中，4已满员，5已完成
            if($user_id){
                if(CompanionOrder::where(['companion_id'=>$value['id'],'user_id'=>$user_id])->where('status','in','1,2,3')->count()){
                    $value['order_status']=2;//2已报名
                }else{
                    if($value['sum_people']<=$value['book_people_num']){
                        $value['order_status']=4;
                    }else{
                        $value['order_status']=$value['status'];//已满员
                    }
                }
            }
            if($value['status']==2){
                $value['order_status']=3;//进行中
            }
            $book_people_list=CompanionOrder::alias('o')->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')->where(['o.companion_id'=>$value['id']])->where('o.status','in','1,2,3')->limit(5)->group('u.id')->column('u.id,u.avatar_url');
            foreach($book_people_list as &$v){
                $v['avatar_url']=$v['avatar_url']!="null"?$v['avatar_url']:'';
            }
            $value['avatar_url']=$value['avatar_url']!="null"?$value['avatar_url']:'';
            $value['book_people_list']=$book_people_list;
        }
        return fetchJson($list);
    }
    //分类列表
    public function categoryList(){
        $list=CompanionCategory::where(['is_delete'=>0,'status'=>1])->order('sort ASC')->column('id,name');
        return fetchJson($list);
    }
    //标签列表
    public function tagList(){
        $list=CompanionTags::where(['is_delete'=>0,'status'=>1])->order('sort ASC')->column('id,name');
        return fetchJson($list);
    }
    public function detail(){
        $id=input('id');
        $user_id=input('user_id');
        $value=Companion::alias('c')
        ->leftJoin([User::getTable()=>'u'],'c.user_id=u.id')
        ->leftJoin([CompanionCategory::getTable()=>'ca'],'c.category_id=ca.id')
        ->where(['c.is_delete'=>0,'c.id'=>$id])
        ->order('c.id DESC')
        ->field('c.id,c.title,c.describe,c.date,c.start_time,c.end_time,c.place,c.address,c.sex,c.status,c.people_type,c.man_num,c.woman_num,c.pay_types,c.consume_types,c.cash_price,c.price,c.username,c.tel,c.wx_num,c.create_time,u.nickname,u.avatar_url,ca.name category_name')
        ->find();
        if($value){
            $start_time=$value['start_time'];
            $end_time=$value['end_time'];
            $value['start_time']=date('Y-m-d H:i',$start_time);
            $value['end_time']=date('Y-m-d H:i',$end_time);
            if($value['people_type']==4){
                $value['sum_people']=$value['man_num'];
            }else{
                $value['sum_people']=$value['man_num']+$value['woman_num'];
            }
            $value['book_people_num']=CompanionOrder::where(['companion_id'=>$value['id']])->where('status','in','1,2,3')->count();
            $value['order_status']=1;
            //1可报名，2已报名，3进行中，4已满员，5已完成
            if($user_id){
                if(CompanionOrder::where(['companion_id'=>$value['id'],'user_id'=>$user_id])->where('status','in','1,2,3')->count()){
                    $value['order_status']=2;//2已报名
                }else{
                    if($start_time<time()&&time()<$end_time){
                        if($value['book_people_num']>=$value['sum_people']){
                            $value['order_status']=4;//已满员
                        }else{
                             $value['order_status']=3;//进行中
                        }
                    }else if(time()>$end_time){
                        $value['order_status']=5;//已结束
                    }else{
                        if($value['book_people_num']>=$value['sum_people']){
                            $value['order_status']=4;//已满员
                        }
                    }
                }
            }
            $value['book_people_list']=CompanionOrder::alias('o')->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')->where(['o.companion_id'=>$value['id']])->where('o.status','in','1,2,3')->limit(5)->group('u.id')->column('u.id,u.avatar_url');
            $value['book_woman_num']=CompanionOrder::where(['companion_id'=>$value['id'],'sex'=>'女'])->where('status','in','1,2,3')->count();
            $value['book_man_num']=CompanionOrder::where(['companion_id'=>$value['id'],'sex'=>'男'])->where('status','in','1,2,3')->count();
            $value['is_vip']=1;
            $value['is_autonym']=1;
        }
        return fetchJson($value);
    }
}
