<?php
namespace app\shared\logic\user;
use app\shared\model\Address;
use app\shared\model\App;
use app\shared\model\CardOrder;
use think\exception\ValidateException;
use app\BaseController;
use wechatpay\WechatPay;
//地址管理
class AddressForm extends  UserForm
{	
    public function list(){
    	$list=Address::where(['acid'=>$this->acid,'is_delete'=>0,'user_id'=>$this->user_id])->order('is_default DESC,id DESC')->column('id,name,address,phone,is_default');
    	return fetchJson($list);
    }
    //编辑
    public function edit(){
       try {
          $data=request()->post();
          $rule = [
               'id|地址ID' => 'require',
               'name|姓名'=>'require',
               'phone|手机'=>'require',
               'address|地址'=>'require',
               'is_default|是否默认'=>'require|number|in:0,1',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $form=Address::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'id'=>$data['id']])->find();
       if(!$form){
       	  $form=new Address();
       	  $form->acid=$this->acid;
       	  $form->user_id=$this->user_id;
       }
       $form->name=$data['name'];
       $form->address=$data['address'];
       $form->phone=$data['phone'];
       $form->is_default=$data['is_default'];
       if($data['is_default']==1){
       	  Address::where(['acid'=>$this->acid,'is_delete'=>0])->update(['is_default'=>0]);
       }
       $form->save();
       return fetchJson([],'保存成功');
    }
    public function delete(){
    	 $id=input('id');
    	 Address::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$id])->update(['is_delete'=>1]);
    	 return fetchJson([],'删除成功');
    }
}