<?php
namespace app\shared\logic\store;
use app\shared\model\Withdraw;
use app\shared\model\Store;
use app\shared\model\User;
use think\exception\ValidateException;
use app\BaseController;
class WithdrawForm extends  Base
{
    //获取数据
    public  function index(){
        $list=Withdraw::where(['acid'=>$this->acid,'is_delete'=>0,'user_type'=>2,'user_id'=>$this->store_id])
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        $count=Withdraw::where(['acid'=>$this->acid,'is_delete'=>0,'user_type'=>2,'user_id'=>$this->store_id])->count();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]); 
    }
    //处理
    public function apply(){
        try {
            $data=request()->post();
            $rule = [
                'type|类型'   => 'require|in:1,2,3',
                'username|姓名'      => 'require',
                'account|账号'   => 'require',
                'money|金额'   => 'require|>=:10|float',
            ];
            $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=Withdraw::where(['acid'=>$this->acid,'user_id'=>$this->store_id,'status'=>0,'user_type'=>2])->find();
        if($form){
            return fetchJson([],'已有提交，请等待审核通过',1);
        }
        if(Store::where('id',$this->store_id)->value('money')<$data['money']){
             return fetchJson([],'账户余额不足',1);
        }
        $form=new Withdraw();
        $form->acid=$this->acid;
        $form->user_id=$this->store_id;
        $form->asset_type=1;
        $form->user_type=2;
        $form->save($data);
        return fetchJson([],'提交成功');

    }
}