<?php
namespace app\shared\logic\store;
use app\shared\model\Store;
use app\shared\model\House;
use app\shared\model\Area;
use app\shared\model\Withdraw;
use app\shared\model\LumiElectricityConfig;
use think\exception\ValidateException;
use app\BaseController;
use Electronic\Lvmi;
class SettingForm extends  Base
{
    public function info(){
      $form=Store::where(['id'=>$this->store_id])->withoutField('password')->find();
      $form['area_title']=Area::where('id',$form['area_id'])->value('name');
      $form['logo_url']=get_file_url($form['logo']);
      $form['banner_url']=get_file_urls($form['banner']);
      $smart_device=@json_decode($form['smart_device'],1);
      $form['smart_device_appid']=isset($smart_device['appid'])?$smart_device['appid']:'';
      $form['smart_device_appkey']=isset($smart_device['appkey'])?$smart_device['appkey']:'';
      $form['smart_device_username']=isset($smart_device['username'])?$smart_device['username']:'';
      $form['smart_device_password']=isset($smart_device['password'])?$smart_device['password']:'';
      $form['electronic_mandun_apiUrl']=isset($smart_device['electronic_mandun_apiUrl'])?$smart_device['electronic_mandun_apiUrl']:'';
      $form['electronic_mandun_appKey']=isset($smart_device['electronic_mandun_appKey'])?$smart_device['electronic_mandun_appKey']:'';
      $form['electronic_mandun_appSecret']=isset($smart_device['electronic_mandun_appSecret'])?$smart_device['electronic_mandun_appSecret']:'';
      $form['electronic_mandun_uname']=isset($smart_device['electronic_mandun_uname'])?$smart_device['electronic_mandun_uname']:'';
      $form['electronic_mandun_passwd']=isset($smart_device['electronic_mandun_passwd'])?$smart_device['electronic_mandun_passwd']:'';
      $form['electronic_mandun_projectCode']=isset($smart_device['electronic_mandun_projectCode'])?$smart_device['electronic_mandun_projectCode']:'';
      $config=@json_decode($form['config'],1);
      $form['open_door_bgm']=isset($config['open_door_bgm'])?$config['open_door_bgm']:'';
      $form['open_room_bgm']=isset($config['open_room_bgm'])?$config['open_room_bgm']:'';
      $form['xsj_app_key']=isset($config['xsjConfig']['app_key'])?$config['xsjConfig']['app_key']:'';
      $form['xsj_yard_sn']=isset($config['xsjConfig']['yard_sn'])?$config['xsjConfig']['yard_sn']:'';
      $form['wifi_username']=isset($config['wifi_config']['username'])?$config['wifi_config']['username']:'';
      $form['wifi_password']=isset($config['wifi_config']['password'])?$config['wifi_config']['password']:'';
      $icon_config=isset($config['icon_config']['home']['icon'])?$config['icon_config']:[];
      if(!$icon_config){
          $url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/';
          $icon_config=[
                'home'=>[
                  'title'=>'首页',
                  'status'=>1,
                  'icon'=>$url.'store_icon/home.png'
                ],
                'shop'=>[
                  'title'=>'茶城',
                  'status'=>1,
                  'icon'=>$url.'store_icon/shop.png'
                ],
                'kefu'=>[
                  'title'=>'客服',
                  'status'=>1,
                  'icon'=>$url.'store_icon/kefu.png'
                ],
                'wifi'=>[
                  'title'=>'WiFi',
                  'status'=>1,
                  'icon'=>$url.'store_icon/wifi.png'
                ],
                'code'=>[
                  'title'=>'商家码',
                  'status'=>1,
                  'icon'=>$url.'store_icon/code.png'
                ],
              ];
      }
      $form['icon_config']=$icon_config;
      $form['select_name']=isset($config['select_name'])?$config['select_name']:'茶厅';
      $form['tt_lock_username']=isset($config['xsjConfig']['tt_lock_username'])?$config['xsjConfig']['tt_lock_username']:'';
      $form['tt_lock_password']=isset($config['xsjConfig']['tt_lock_password'])?$config['xsjConfig']['tt_lock_password']:'';
      $lvmi_device=@json_decode($form['lvmi_device'],1);
      $form['lvmi_device']=[
        'expiresIn'=>isset($lvmi_device['expiresIn'])?$lvmi_device['expiresIn']:'',
        'openId'=>isset($lvmi_device['openId'])?$lvmi_device['openId']:'',
        'accessToken'=>isset($lvmi_device['openId'])?$lvmi_device['accessToken']:'',
        'refreshToken'=>isset($lvmi_device['openId'])?$lvmi_device['refreshToken']:'',
      ];
      $form['withdraw']=Withdraw::where(['acid'=>$this->acid,'user_id'=>$this->store_id,'user_type'=>Withdraw::USER_TYPE_STORE])->where('type','in','2,3')->order('id DESC')->find();
      return fetchJson($form);
    }
    //获取数据
    public  function edit(){
      	 	try {
      	      $data=request()->post();
      	      $rule = [
      	           'account|账号'=>'require',
      	           'name|名称' => 'require',
      	           'logo|Logo' => 'require',
      	           'banner|图片' => 'require',
      	           'status|状态'=>'require',
      	           'tel|电话'=>'require',
      	           'tags|标签'=>'require',
      	           'address|地址'=>'require',
      	           'dec|概括'=>'require',
                   'lat|纬度'=>'require',
                   'lng|经度'=>'require',
                   'policy|入住政策'=>'require'
      	       ];
      	      $this->validate($data,$rule);
           }catch (ValidateException $e){
              return fetchJson([],$e->getError(),1);
           }
           
           if(Store::where(['acid'=>$this->acid,'account'=>$data['account']])->where('id','<>',$this->store_id)->count()){
               return fetchJson([],'该账号已存在',1);
           }
           $form=Store::where(['id'=>$this->store_id])->find();
           if(input('password')){
              $form->password=md5(input('password'));
           }
           $form->logo=$data['logo'];
           $form->name=$data['name'];
           $form->banner=$data['banner'];
           $form->status=$data['status'];
           $form->tel=$data['tel'];
           $form->tags=$data['tags'];
           $form->address=$data['address'];
           $form->dec=$data['dec'];
           $form->lat=$data['lat'];
           $form->lng=$data['lng'];
           $form->is_shop=input('is_shop');
           $form->policy=$data['policy'];
           $form->refund_rate=input('refund_rate');
           $form->service_facilities=input('service_facilities');
           $form->facilities=input('facilities');
           $form->policy=input('policy');
           $form->store_manager=input('store_manager');
           $form->local=input('local');
           $form->video_url=input('video_url')?input('video_url'):0;
           $form->share_img=input('share_img')?input('share_img'):0;
           $form->is_wallet=input('is_wallet')==1?1:0;
           if(input('warm_hint')){
              $form->warm_hint=input('warm_hint');
           }
           $use_refund_time=input('use_refund_time');
           if($use_refund_time>-1){
                $form->use_refund_time=$use_refund_time;
           }
           $config=@json_decode($form->config,1);
           if(isset($config['wifi_config'])){
              if(input('wifi_username')){
                $config['wifi_config']['username']=input('wifi_username');
                $config['wifi_config']['password']=input('wifi_password');
              }
           }
           $form->config=json_encode($config,JSON_UNESCAPED_UNICODE);
           $form->save();
           House::where('store_id',$form->id)->update(['address'=>$form->address,'lat'=>$form->lat,'lng'=>$form->lng]);
           return fetchJson([],'保存成功');
    }
}