<?php
namespace app\shared\logic\store;
use app\shared\model\StoreRecharge;
use app\shared\model\StoreRechargeOrder;
use app\shared\model\StoreUserMoney;
use app\shared\model\Bill;
use app\shared\model\User;
use app\shared\model\Store;
use think\exception\ValidateException;
use app\BaseController;
class RechargeForm extends  Base
{
    //用户列表
    public function userList(){
       $query=StoreUserMoney::alias('a')
            ->leftJoin([User::getTable()=>'b'],'a.user_id=b.id')
            ->where(['a.acid'=>$this->acid,'a.store_id'=>$this->store_id]);
        if($keyword=input('keyword')){
             $query->where('b.account|b.nickname','like',"%{$keyword}%");
        }
        $query->field('a.*,b.account,b.nickname,b.avatar_url');
        $count=$query->count();
        $list=$query
            ->page($this->page)
            ->limit($this->limit)
            ->order('a.id DESC')
            ->select();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //充值
    public function rechargeUser(){
          try {
            $data=request()->post();
            $rule = [
                'money|金额'=>'require|float|>:0',
                'account|账号'=>'require',
                'status|状态'=>'require|in:-1,1',
            ];
            $this->validate($data,$rule);
          }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
          }
          $user=User::where(['account'=>$data['account'],'acid'=>$this->acid])->find();
          if(!$user){
            return fetchJson([],'暂无用户',1);
          }
          $store=Store::where('id',$this->store_id)->find();
          $money=$data['money']*$data['status'];
          $storeUser=StoreUserMoney::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'user_id'=>$user->id])->find();
          if(!$storeUser){
            $storeUser=new StoreUserMoney();
            $storeUser->acid=$this->acid;
            $storeUser->user_id=$user->id;
            $storeUser->store_id=$this->store_id;
            $storeUser->money=0;
            $storeUser->tea_money=0;
          }
          if($money<0&&$storeUser->money<$data['money']){
            return fetchJson([],'该用户储值卡余额不足，不足以扣除'.$data['money'].'元');
          }
          $storeUser->money=$storeUser->money+$money;
          $storeUser->save();
          $status_dec=$data['status']==1?'充值':'扣除';
          (new Bill())->save([
              'acid'=>$this->acid,
              'type'=>Bill::TYPE_STORE_USER_RECHARGE,
              'account_type'=>Bill::ACCOUNT_TYPE_USER,
              'form_id'=>$user->id,
              'order_id'=>$this->store_id*-1,
              'price'=>$money,
              'price_type'=>2,
              'balance'=>$storeUser->money,
              'status'=>$data['status'],
              'des'=>"商家[{$store->name}] 为用户:【{$user['nickname']}】储值卡{$status_dec}金额"
          ]);
          return fetchJson([],$status_dec.'成功');
    }
    //账单列表
    public function billList(){
           $query=Bill::alias('b')
           ->leftJoin([User::getTable()=>'u'],'b.form_id=u.id')
           ->where(['b.acid'=>$this->acid,'b.type'=>Bill::TYPE_STORE_USER_RECHARGE,'account_type'=>Bill::ACCOUNT_TYPE_USER])
           ->where('des','like',"%{$this->admin->name}%");
           if($user_id=input('user_id')){
              $query->where(['b.form_id'=>$user_id]);
           }
           $count=$query->field('b.*,u.avatar_url,u.nickname,u.account')->count();
           $list=$query->order('id DESC')->select();
           return fetchJson([
              'list'=>$list,
              'count'=>$count
           ]);
    }
    //获取数据
    public  function index(){
        $query=StoreRecharge::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$this->store_id]);
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=StoreRecharge::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'price|金额'=>'require',
                'give_price|赠送金额'=>'require',
                'give_tea_price|赠送茶叶金'=>'require',
                'status|状态'=>'require|in:0,1',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new StoreRecharge();
            $form->acid=$this->acid;
            $form->store_id=$this->store_id;
        }
        $form->price=$data['price'];
        $form->give_price=$data['give_price'];
        $form->give_tea_price=$data['give_tea_price'];
        $form->coupon_ids=input('coupon_ids');
        $form->status=$data['status'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         StoreRecharge::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //订单列表
    public function orderList(){
        $query=StoreRechargeOrder::alias('a')
            ->leftJoin([User::getTable()=>'b'],'a.user_id=b.id')
            ->where(['a.acid'=>$this->acid,'a.store_id'=>$this->store_id,'a.status'=>1])
            ->field('a.*,b.nickname,b.avatar_url');
        $count=$query->count();
        $list=$query
            ->page($this->page)
            ->limit($this->limit)
            ->order('a.id DESC')
            ->select();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
}