<?php
namespace app\shared\logic\store;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\User;
use app\shared\model\Store;
use app\shared\model\Goods;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\House;
use app\shared\model\Bill;
use app\shared\model\UserUv;
use app\shared\model\Electricity;

use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
class IndexForm extends  Base
{
    //数据统计
    public  function statistics(){
       

        $house_price=0;
        $start_date=input('start_date');
        $end_date=input('end_date');
        $days=7;
        if($end_date){
           $time=strtotime($end_date);
           $days=strtotime($end_date)-strtotime($start_date);
           $days=$days/86400;
           if($days<7){
            $days=7;
           }
           if($start_date==$end_date){
             $end_date=date('Y-m-d',strtotime($end_date)+86400);
           }
        }else{
          $time=time();
        }
        $getServenDay=getServenDay(date('Y-m-d',$time+86400),0,$days);
        $getServenDay = array_column($getServenDay,'time');
        $house_order_arr=[];
        foreach ($getServenDay as $day) {
           $house_order_arr[]=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1,'store_id'=>$this->store_id])->where('status',3)->whereDay('create_time',$day)->count();
        }
        if($start_date&&$end_date){


          //统计商户余额
          $sum_store_balance=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'pay_type'=>3])
          ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->sum('price');

          $sum_store_balance_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$this->store_id])
          ->whereBetweenTime('h.create_time',$start_date,$end_date)->where(['xd.status'=>1,'xd.pay_type'=>3])->sum('xd.price');
          $sum_store_balance+=$sum_store_balance_xd;



          //统计茶室订单数量
          $house_order_num=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id])
          ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->count();
          //统计商户总收入
          $sum_earnings=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id])
          ->whereBetweenTime('create_time',$start_date,$end_date)->where('pay_type','in','1')->where('status','in','1,2,3')->sum('price');
          //统计商户总收入-续单
          $sum_earnings_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$this->store_id])->where('xd.pay_type','in','1')
          ->whereBetweenTime('h.create_time',$start_date,$end_date)->where('xd.status',1)->sum('xd.price');
          $sum_earnings+=$sum_earnings_xd;

          
          //退款金额
          $sum_house_refund= HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id])
          ->whereBetweenTime('create_time',$start_date,$end_date)->where('status',-2)->sum('price');

          //统计余额
          $sum_balance=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'pay_type'=>2])
          ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->sum('price');
          //统计余额-续单
          $sum_balance_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$this->store_id])
          ->whereBetweenTime('h.create_time',$start_date,$end_date)->where(['xd.status'=>1,'xd.pay_type'=>2])->sum('xd.price');
          $sum_balance+=$sum_balance_xd;
          
          //微信支付统计
          $sum_wechatPay=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'pay_type'=>1])
          ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->sum('price');
          //微信支付统计-续单
          $sum_wechatPay_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$this->store_id])
          ->whereBetweenTime('h.create_time',$start_date,$end_date)->where(['xd.status'=>1,'xd.pay_type'=>1])->sum('xd.price');
          $sum_wechatPay+=$sum_wechatPay_xd;

           //时长
          $electricityInfo=Electricity::alias('e')->leftJoin([HouseOrder::getTable()=>'o'],'e.order_id=o.id')
            ->leftJoin([House::getTable()=>'h'],'o.house_id=h.id')
            ->where(['e.acid'=>$this->acid,'h.store_id'=>$this->store_id])->whereBetweenTime('e.create_time',$start_date,$end_date)->fieldRaw('SUM(e.end_time-e.start_time) as duration')->find();
        }else{
          
          //统计商户余额
          $sum_store_balance=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'pay_type'=>3])->where('status','in','1,2,3')->sum('price');

          $sum_store_balance_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$this->store_id])->where(['xd.status'=>1,'xd.pay_type'=>3])->sum('xd.price');
          $sum_store_balance+=$sum_store_balance_xd;

          //统计茶室订单数量
          $house_order_num=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id])->where('status','in','1,2,3')->count();
          //统计商户总收入
          $sum_earnings=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id])->where('status','in','1,2,3')->sum('price');
          //统计商户总收入-续单
          $sum_earnings_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$this->store_id])->where('xd.status',1)->sum('xd.price');
          $sum_earnings+=$sum_earnings_xd;

          
          //退款金额
          $sum_house_refund= HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id])->where('status',-2)->sum('price');

          //统计余额
          $sum_balance=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'pay_type'=>2])->where('status','in','1,2,3')->sum('price');
          //统计余额-续单
          $sum_balance_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$this->store_id])->where(['xd.status'=>1,'xd.pay_type'=>2])->sum('xd.price');
          $sum_balance+=$sum_balance_xd;
          
          //微信支付统计
          $sum_wechatPay=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'pay_type'=>1])->where('status','in','1,2,3')->sum('price');
          //微信支付统计-续单
          $sum_wechatPay_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$this->store_id])->where(['xd.status'=>1,'xd.pay_type'=>1])->sum('xd.price');
          $sum_wechatPay+=$sum_wechatPay_xd;


           //时长
          $electricityInfo=Electricity::alias('e')->leftJoin([HouseOrder::getTable()=>'o'],'e.order_id=o.id')
            ->leftJoin([House::getTable()=>'h'],'o.house_id=h.id')
            ->where(['e.acid'=>$this->acid,'h.store_id'=>$this->store_id])->fieldRaw('SUM(e.end_time-e.start_time) as duration')->find();
        }

        //统计今日商户总收入
        $today_earnings=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id])
          ->whereDay('update_time',date('Y-m-d'))->where('status','in','1,2,3')->sum('price');
          //统计商户总收入-续单
        $today_earnings_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$this->store_id])
          ->whereDay('h.create_time',date('Y-m-d'))->where('xd.status',1)->sum('xd.price');
        $today_earnings+=$today_earnings_xd;

        $house_order_sumprice=$sum_earnings;
        $house_order_sumprice=$sum_earnings;
        $store_uv =UserUv::where(['store_id'=>$this->store_id,'type'=>1])->count('distinct user_id');
        $house_uv =UserUv::where(['store_id'=>$this->store_id,'type'=>2])->count('distinct user_id');
        $goods_uv =UserUv::where(['store_id'=>$this->store_id,'type'=>3])->count('distinct user_id');

        $house_count=House::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'is_delete'=>0])->count();
        return fetchJson([
            'sum_earnings'=>$sum_earnings,
            'house_count'=>$house_count,
            'sum_house_refund'=>$sum_house_refund,
            'house_order_num'=>$house_order_num,
            'house_order_sumprice'=>$house_order_sumprice,
            'today_earnings'=>$today_earnings,
            'sum_balance'=>$sum_balance,
            'sum_wechatPay'=>$sum_wechatPay,
            'sum_store_balance'=>$sum_store_balance,
            'repast_sum_wechat'=>0,
            'repast_sum_balance'=>0,
            'electricity_duration'=>timetodatePus($electricityInfo['duration']),
            'store_uv'=>$store_uv,
            'house_uv'=>$house_uv,
            'goods_uv'=>$goods_uv,
            'broken_line'=>[
                'date'=>$getServenDay,
                'legend'=>['茶室订单'],
                'series'=>[
                    [
                        'name'=>'茶室订单',
                        'type'=>'line',
                        'stack'=>'总量',
                        'data'=>$house_order_arr
                    ],
                ]
            ]
        ]);
    }
    public function uvList(){
       $query=UserUv::alias('uv')
                    ->leftJoin([User::getTable()=>'u'],'uv.user_id=u.id')
                    ->where('uv.store_id',$this->store_id)
                    ->field('u.nickname,u.avatar_url,uv.create_time,uv.type,uv.form_id');
       $count=UserUv::where('store_id',$this->store_id)->field('id')->count();
       $list=$query->page($this->page)->limit($this->limit)->order('uv.id DESC')->select();
       $logo=Store::where('id',$this->store_id)->value('logo');
       $logo=get_file_url($logo);
       foreach ($list as &$value){
          if($value['type']==1){
             $value['title']='访问本商户';
             $value['cover_url']=$logo;
          }else if($value['type']==2){
             $house=House::where('id',$value['form_id'])->field('name,cover')->find();
             $value['title']='浏览茶室：'.$house['name'];
             $value['cover_url']=$house['cover'];
          }else if($value['type']==3){
             $goods=House::where('id',$value['form_id'])->field('name,cover')->find();
             $value['title']='浏览商品：'.$goods['name'];
             $value['cover_url']=get_file_url($goods['cover']);
          }else{
             $value['title']='未知';
             $value['cover_url']='未知';
          }
       }
       return fetchJson([
          'count'=>$count,
          'list'=>$list
       ]);
    }
}