<?php
namespace app\shared\logic\store;
use app\shared\model\HouseStock;
use app\shared\model\House;
use app\shared\model\HouseRoomStock;
use app\shared\model\HouseOrder;
use think\exception\ValidateException;
use app\BaseController;
class HouseStockForm extends  Base
{
    //获取数据
    public  function index(){
        try {
            $data=request()->post();
            $rule = [
                'house_id|房间ID' =>'require|number',
                'date|日期'   => 'require|date',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $date=strtotime($data['date']);
        $stock=HouseStock::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'house_id'=>$data['house_id'],'date'=>$date])->column('id,hour,status,order_id');
        $stockData=[];
        $stockArr=[];
        foreach ($stock as $vsindex=> &$vs){
          $vs['dd']=date('Y-m-d H:i',$vs['hour']);
        }

        for ($j=0;$j<48;$j++){
           $time=strtotime(date('Y-m-d H:i',$date))+1800*$j;
           foreach($stock as $v){
              if($time>($v['hour']-1800)&&$time<($v['hour']+1800)){
                   $stockData[date('Y-m-d H:i',$v['hour'])]=[
                        'hour'=>$time,
                        'id'=>$v['id'],
                        'data'=>date('Y-m-d H:i',$time),
                        'status'=>$v['status'],
                        'order_id'=>0//$v['order_id'],
                     ];   
              }
           } 
        }

        $hourStock=array_column($stockData,'status','hour');
        $hourStockOrder=array_column($stockData,'order_id','hour');
        for ($j=0;$j<48;$j++){
           $time=strtotime(date('Y-m-d H:i',$date))+1800*$j;
           $stockArr[]=[
             'time'=>date('H:i',$time),
             'status'=>isset($hourStock[$time])?$hourStock[$time]:1,
             'order_id'=>isset($hourStockOrder[$time])?$hourStockOrder[$time]:0,
           ];
        }
        return fetchJson([
            'stock'=>$stockArr
        ]);
    }
    //编辑库存
    public function edit(){
         try {
            $data=request()->post();
            $rule = [
                'house_id|房间ID' =>'require|number',
                'date|日期'   => 'require|date',
                'hour|小时'   =>'require',
                'status|状态' =>'require|in:0,1'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $date=strtotime($data['date']);
        $hour=strtotime($data['date'].' '.$data['hour']);
        $form=HouseStock::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'house_id'=>$data['house_id'],'date'=>$date,'hour'=>$hour])->find();
        if(!$form){
            $form=new HouseStock();
        }
        if($data['status']==1){
            $form->order_id=0;
        }
        $form->save([
            'acid'=>$this->acid,
            'store_id'=>$this->store_id,
            'house_id'=>$data['house_id'],
            'date'=>$date,
            'hour'=>$hour,
            'status'=>$data['status']
        ]);
        return fetchJson([],'保存成功');
    }
    //民宿房间
    public function hotelList(){
         try {
            $data=request()->post();
            $rule = [
                'house_id|房间ID' =>'require|number',
                'date|日期'   => 'require|date',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $start_time=strtotime($data['date']);
        $end_time=$start_time+86400*30;
        $month=date('Y-m',$start_time);
        $monthDate=monthDate($start_time);
        $house=House::where('id',$data['house_id'])->find();
        $stockDate=[];
        $bookDate=[];
        $stock=HouseRoomStock::where(['house_id'=>$data['house_id']])
        ->whereMonth('date',$month)
        ->column('id,date,price,status,house_type,order_id');
        $order_ids=array_column($stock,'order_id');
        $houseOrder=HouseOrder::where('id','in',$order_ids)->column('id,username');
        $houseOrder=array_column($houseOrder,'username','id');
        foreach($stock as $dayStock){
            $stockDate[$dayStock['date']]=[
                'price'=>$dayStock['price'],
                'day'=>$dayStock['date'],
                'status'=>$dayStock['status'],
                'username'=>isset($houseOrder[$dayStock['order_id']])?$houseOrder[$dayStock['order_id']]:'',
                'order_id'=>$dayStock['order_id'],
            ];
        }
        foreach($monthDate as $key=>$day){
            if(isset($stockDate[$day])){
                $data=$stockDate[$day];
                $bookDate[]=[
                    'price'=>$data['price'],
                    'day'=>$data['day'],
                    'status'=>$data['status'],
                    'username'=>$data['username'],
                    'order_id'=>$data['order_id'],
                    'show_day'=>$key+1
                ];
            }else{
                $bookDate[]=[
                    'price'=>$house['price'],
                    'day'=>$day,
                    'status'=>0,
                    'username'=>0,
                    'order_id'=>0,
                    'show_day'=>$key+1
                ];
            }
        }
        return fetchJson([
            'stock'=>$bookDate,
        ]);
    }
    //民宿房态编辑
    public function hotelEdit(){
         try {
            $data=request()->post();
            $rule = [
                'house_id|房间ID' =>'require|number',
                'date|日期'   => 'require|date',
                'price|金额'   => 'require|float|>:0',
                'status|状态' =>'require|in:0,1,2'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $date=$data['date'];
        $form=HouseRoomStock::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'house_id'=>$data['house_id'],'date'=>$date])->find();
        if(!$form){
            $form=new HouseRoomStock();
        }
        if($data['status']==0){
            $form->order_id=0;
        }
        $form->save([
            'acid'=>$this->acid,
            'store_id'=>$this->store_id,
            'house_id'=>$data['house_id'],
            'date'=>$date,
            'price'=>$data['price'],
            'status'=>$data['status']
        ]);
        return fetchJson([],'保存成功');
    }
}