<?php
namespace app\shared\logic\store;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\CardUserOrder;
use app\shared\model\CouponUser;
use app\shared\model\Coupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\StoreCoupon;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\CardCouponOrder;
use app\shared\model\CardCoupon;
use app\shared\model\PartnerUserOrder;
use think\exception\ValidateException;
use app\shared\model\Bill;
use app\shared\model\App;

use app\shared\model\User;
use app\shared\model\House;
use app\shared\model\HouseRoom;
use app\shared\model\HouseRoomStock;
use app\shared\model\HouseStock;
use app\shared\model\Electricity;
use app\shared\model\Option;
use app\shared\model\StoreCleaning;
use wechatpay\WechatPay;
use app\shared\model\Store;
use app\shared\model\ElectricityLine;
use app\plugin\model\stock\User as StockUser;
use app\plugin\model\stock\House as StockHouse;
use app\plugin\model\stock\HouseUser as StockHouseUser;
use app\plugin\model\stock\HouseUserOrder as StockHouseUserOrder;
use app\plugin\model\usercashgrade\Usercashgrade;
use app\plugin\model\usercashgrade\UsercashgradeOrder;
use app\shared\model\StoreUserMoney;
use app\shared\model\Partner;
use app\shared\model\PartnerUser;
use slock\Slock;
use think\facade\Cache;
use app\BaseController;
use think\facade\Db;
class HouseOrderForm extends  Base
{
    //获取数据
    public  function index(){
        $query=HouseOrder::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$this->store_id]);
        $status=input('status');
        if($status!=-10){
            $query->where('status',$status);
        }
        $keyword=input('keyword');
        if($keyword){
            $query=$query->where('username|tel|order_no','like',"%{$keyword}%");
        }
        $start_date=input('start_date');
        $end_date=input('end_date');
        if($start_date&&$end_date){
            $query->whereBetweenTime('create_time',$start_date,$end_date);
        }
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            $value['snapshoot']=@json_decode($value['snapshoot'],1);
            $value['start_time']=date('Y-m-d H:i:s',$value['start_time']);
            $value['end_time']=date('Y-m-d H:i:s',$value['end_time']);
            $order_continue_list=HouseOrderContinue::where(['status'=>1,'order_id'=>$value['id']])->order('id DESC')->column('id,start_time,price,pay_price,end_time');
            $price=0;
            $pay_price=0;

            $card_user_order=CardUserOrder::alias('cuo')
            ->leftJoin([CardUser::getTable()=>'cu'],'cuo.card_user_id=cu.id')
            ->leftJoin([Card::getTable()=>'c'],'cu.card_id=c.id')
            ->where(['cuo.type'=>1,'cuo.order_id'=>$value['id']])
            ->field('cuo.price,cuo.hour,cuo.discount,cuo.status,cuo.type,c.title')
            ->find();
            if($card_user_order){
               $discounts_price=$card_user_order['discount']*($value['price']-$card_user_order['price'])*0.1;
               $card_user_order['discounts_price']=($value['price']-$card_user_order['price'])-$discounts_price;
            }
            foreach ($order_continue_list as $k => &$v) {
               $v['start_time']=date('Y-m-d H:i',$v['start_time']);
               $v['end_time']=date('Y-m-d H:i',$v['end_time']);
               if($k==0){
                  $value['end_time']=$v['end_time'];
               }
               $price+=$v['price'];
               $pay_price+=$v['pay_price'];
               $v['price']=$v['pay_price'];
               
            }
            $value['pay_price']+=$pay_price;
            $value['pay_price']=round($value['pay_price'],2);
            $value['price']+=$price;
            $value['price']=round($value['price'],2);
            $value['order_continue_list']=$order_continue_list;
            $value['card_user_order']=$card_user_order; 
            $couponUser=CouponUser::alias('a')
            ->leftJoin([Coupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['coupon_user_id'],'a.type'=>Coupon::TYPE_HOTEL])
            ->field('a.discounts_price,b.name')->find();
            $value['discounts_name']=$couponUser['name'];
            $value['discounts_price']=$couponUser['discounts_price']>0?$couponUser['discounts_price']:0;

            $storeCouponUser=StoreCouponUser::alias('a')
            ->leftJoin([StoreCoupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['store_coupon_user_id'],'a.type'=>StoreCoupon::TYPE_HOTEL])
            ->field('a.discounts_price,b.name')->find();
            $value['store_discounts_name']=$storeCouponUser['name'];
            $value['store_discounts_price']=$storeCouponUser['discounts_price']>0?$storeCouponUser['discounts_price']:0;
            $value['partner_user_order']=PartnerUserOrder::where(['type'=>1,'order_id'=>$value['id']])->column('id,hour,price');
            $card_coupon=CardCouponOrder::alias('cco')->leftJoin([CardCoupon::getTable()=>'cc'],'cco.card_coupon_id=cc.id')->where(['cco.order_id'=>$value['id']])->field('cc.discounts_price,cc.name,cco.id,cc.type')->find();
            $value['card_coupon']=$card_coupon;
            $value['order_source_name']="小程序";
            if($card_coupon){
                if($card_coupon['type']==1){
                    $value['order_source_name']="美团";
                }
                if($card_coupon['type']==2){
                    $value['order_source_name']="抖音";
                }
            }
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //提前结束订单
    public function endOrdersEarly(){
        $order=HouseOrder::where(['id'=>input('order_id'),'is_pay'=>1])->where('status','in','1,2')->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $form= new \app\task\controller\Wechat();
        $form->endOrdersEarly($order);
        return fetchJson([],'提前结束订单');
    }
    //退款订单
    public function refundOrder(){
        $order_id=input('order_id');
        $order=HouseOrder::where(['id'=>$order_id,'store_id'=>$this->store_id])->where('status','in','1,2')->find();
        if(!$order){
           return fetchJson([],'暂无订单',1);
        }
        //已支付
        if($order->status==1||$order->status==2){
              // $refund_rate=Store::where('id',$order->store_id)->value('refund_rate');
              // if(!$refund_rate){
              //    $refund_rate=0;
              // }
              $refund_rate=0;
              $refund_price=$order->pay_price*(100-$refund_rate)*0.01;
              $refund_price=filter_money($refund_price);
              $refund_fee_price=$order->pay_price-$refund_price;
              //微信支付
              $user=User::where('id',$order->user_id)->find();
              $app=App::find($order->acid);
              if($order->pay_type==1){
                 if($order->out_order_time>0){
                    return ['code' => 0, 'info' => '已经退过了','data' =>''];
                 }
                 $appid=$app->wxapp_app_id;
                 $app_secret=$app->wxapp_app_secret;
                 $wx_config=[
                      'appid'=>$appid,
                      'appsecret'=>$app_secret,
                      'mchid'=>$app->wx_mch_id,
                      'key'=>$app->wx_key,
                      'sslcert'=>$app->wx_cert_pem,
                      'sslkey'=>$app->wx_key_pem,
                 ];
                 if(isset($app->wx_pay_type)){
                    $storeWx=Store::where('id',$order->store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey,fee')->find();
                    //服务商模式
                    if($app->wx_pay_type==2){
                       $wx_config=[
                            'appid'=>$appid,
                            'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                            'wx_server_appid'=>$app->wx_server_appid,
                            'appsecret'=>$app_secret,
                            'wx_server_mch_id'=>$app->wx_server_mch_id,
                            'key'=>$app->wx_server_key,
                            'sslcert'=>$app->wx_server_cert_pem,
                            'sslkey'=>$app->wx_server_key_pem,
                            'sub_appid'=>$appid,
                            'sub_mch_id'=>$app->wx_mch_id,
                            'wx_pay_type'=>$app->wx_pay_type
                       ];
                       if($storeWx['fee']>0){
                            $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                       }
                    }else{
                       if($storeWx['wx_mch_id']){
                          $wx_config=[
                                'appid'=>$appid,
                                'appsecret'=>$app_secret,
                                'mchid'=>$storeWx['wx_mch_id'],
                                'key'=>$storeWx['wx_key'],
                                'sslcert'=>$storeWx['wx_sslcert'],
                                'sslkey'=>$storeWx['wx_sslkey']
                           ];
                           if($storeWx['fee']>0){
                              $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                           }
                       }
                    }

                 }
                 $wechatPay=new WechatPay($wx_config);
                 $notify_url='https://chashi-demo.youdiy.cn';
                 $order->out_order_no=HouseOrder::crateOutOrderNo();
                 $data = [
                    'out_refund_no' => $order->out_order_no,//订单号码
                    'out_trade_no' =>$order->order_no,//退款单号
                    'total_fee' =>  $order->pay_price * 100,//支付金额
                    'refund_fee' => $refund_price * 100,//全额退款
                ];
                if(isset($order->xml_array)){
                    $xml_array=@json_decode($order->xml_array,1);
                    if(isset($xml_array['transaction_id'])){
                      $data['transaction_id']=$xml_array['transaction_id'];
                    }
                }
                $payResult = $wechatPay->refund($data);
                if (!isset($payResult['return_code']) || $payResult['return_code'] != 'SUCCESS') {
                    $info='退款失败，' . (isset($payResult['return_msg']) ? $payResult['return_msg'] : '');
                    return fetchJson([],$info,1);
                }
                if (!isset($payResult['result_code']) || $payResult['result_code'] != 'SUCCESS') {
                    $info='提交业务失败，'. (isset($payResult['err_code_des']) ? $payResult['err_code_des'] : '');
                    return fetchJson([],$info,1);
                }
                $order->out_order_time=time();
                if($refund_price>0){
                    (new Bill())->save([
                        'acid'=>$order->acid,
                        'type'=>Bill::TYPE_HOUSE_REFUND,
                        'account_type'=>Bill::ACCOUNT_TYPE_USER,
                        'form_id'=>$order->user_id,
                        'order_id'=>$order->id,
                        'price'=>$refund_price,
                        'price_type'=>$order->pay_type,
                        'status'=>1,
                        'fee'=>$refund_fee_price,
                        'balance'=>$user->money,
                        'des'=>'用户: 【'.$user->nickname.'】茶室预订微信退款'
                    ]);
                }
             }
             //余额支付退款
             if($order->pay_type==2){
                $user->money+=$refund_price;
                $user->save();
                if($refund_price>0){
                    (new Bill())->save([
                        'acid'=>$order->acid,
                        'type'=>Bill::TYPE_HOUSE_REFUND,
                        'account_type'=>Bill::ACCOUNT_TYPE_USER,
                        'form_id'=>$order->user_id,
                        'order_id'=>$order->id,
                        'price'=>$refund_price,
                        'price_type'=>$order->pay_type,
                        'status'=>1,
                        'fee'=>$refund_fee_price,
                        'balance'=>$user->money,
                        'des'=>'用户: 【'.$user->nickname.'】茶室预订余额退款'
                    ]);
                }
             }
             if($order->pay_type==3){
                $storeUser=StoreUserMoney::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'user_id'=>$order->user_id])->find();
                if($storeUser){
                    $storeUser->money+=$refund_price;
                    $storeUser->save();
                    (new Bill())->save([
                        'acid'=>$order->acid,
                        'type'=>Bill::TYPE_HOUSE_REFUND,
                        'account_type'=>Bill::ACCOUNT_TYPE_USER,
                        'form_id'=>$order->user_id,
                        'order_id'=>$order->id,
                        'price'=>$refund_price,
                        'price_type'=>$order->pay_type,
                        'status'=>1,
                        'fee'=>$refund_fee_price,
                        'balance'=>$storeUser->money,
                        'des'=>'商户储值卡-用户: 【'.$user->nickname.'】茶室预订余额退款'
                    ]);
                }
             }

             $house_stock_ids=HouseStock::where([
                'acid'=>$order->acid,
                'house_id'=>$order->house_id,
                'order_id'=>$order->id,
                'store_id'=>$order->store_id,
             ])->column('id');
             //还原库存
             HouseStock::where('id','in',$house_stock_ids)->update(['status'=>1,'order_id'=>0]);
             //优惠券还原
             $userCoupon=CouponUser::where(['id'=>$order->coupon_user_id])->find();
             if($userCoupon){
                 $order->coupon_user_id=0;
                 $order->save();
                 $userCoupon->is_use=0;
                 $userCoupon->order_id=0;
                 $userCoupon->discounts_price=0;
                 $userCoupon->use_time=0;
                 $userCoupon->save();
             }
             //商家优惠券还原
             $storeUserCoupon=StoreCouponUser::where(['id'=>$order->store_coupon_user_id])->find();
             if($storeUserCoupon){
                 $order->store_coupon_user_id=0;
                 $order->save();
                 $storeUserCoupon->is_use=0;
                 $storeUserCoupon->use_time=0;
                 $storeUserCoupon->save();
             }
             //会员卡免费时长还原
             $cardUserOrder=CardUserOrder::where(['acid'=>$this->acid,'order_id'=>$order->id,'user_id'=>$this->user_id,'type'=>1])->find();
             if($cardUserOrder){
                 $cardUser=CardUser::where(['id'=>$cardUserOrder->card_user_id])->find();
                 $cardUser->hour+=$cardUserOrder->hour;
                 $cardUser->save();
                 $cardUserOrder->status=0;
                 $cardUserOrder->save();
             }
             //美团卡券
             $cardCoupon=CardCoupon::where(['id'=>$order->card_coupon_id])->find();
             if($cardCoupon){
                $cardCoupon->num+=1;
                $cardCoupon->status=1;
                $cardCoupon->save();
                CardCouponOrder::where(['order_id'=>$order->id])->update(['status'=>-1,'use_time'=>time()]);
             }
             $order->status=-2;
             $order->save();
             Cache::set('subscribeOrder'.$order_id,0,1);
             //发送保洁人员
             $weixin=new \weixin\Wechat();
             $snapshoot=@json_decode($order->snapshoot,1);
             $store=Store::where('id',$order->store_id)->field('openid,name,store_manager')->find();
             $data=[
                "first"    =>[
                  "value"  =>"取消订单",
                  "color"  =>"#173177"
                ],
                "keyword1" =>[
                  "value"  =>date("Y-m-d H:i",$order->start_time).' 至 '.date("Y-m-d H:i",$order->end_time),//取消时间
                  "color"  =>"#173177"
                ],
                "keyword2" =>[
                  "value"  =>$snapshoot['name'],//标签
                  "color"  =>"#173177"
                ],
                "thing11"=>[
                    'value'=>$snapshoot['name'],//房间名称
                ],
                "thing7"=>[
                    'value'=>$store['name'],//门店名称
                ],
                "time12"=>[
                    'value'=>date("Y-m-d H:i",$order->start_time),//开始时间
                ],
                "time13"=>[
                    'value'=>date("Y-m-d H:i",$order->end_time),//结束时间
                ],
                "phone_number15"=>[
                    'value'=>$order['tel'],//联系电话
                ],
            ];
            $openids=$store['openid'];
            if($openids){
                $openidArr=explode(',',$openids);
                $tpl=Option::get_data($this->acid,'platform','wx_template_new_cancel_order_inform');
                $tpl=$tpl?$tpl:Option::get_data($this->acid,'platform','wx_template_cancel_order_inform');

                $weixin->sendWxopenTemplatePro($app,$tpl,$openidArr,"pages/index/index",$data);
                $res2=$weixin->atroomMsg($store['store_manager'],$data,4,$order['order_no']);
            }
            self::sendCleaningTpl($app,$order);
            $elelist=Electricity::where(['order_id'=>$order->id])->field('id,end_time,start_time')->select();
            foreach($elelist as $evalue){
              if($evalue->start_time>time()){
                $evalue->start_time=time();
              }
              $evalue->end_time=time();
              $evalue->save();
            }
            $form= new \app\task\controller\Wechat();
            $form->offLvmiEle();
        }
        return fetchJson([],'退款成功');
    }
    //保洁端用户取消订单提醒
    public function sendCleaningTpl($app,$order){
        set_time_limit(0);
        $account=User::where('id',$order->user_id)->value('account');
        $snapshoot=@json_decode($order->snapshoot,1);
        $store=Store::where('id',$order->store_id)->field('address,name')->find();
        //发送保洁人员
        $weixin=new \weixin\Wechat();
        $data=[
            "keyword1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
              "color"  =>"#173177"
            ],
            "keyword2" =>[
              "value"  =>"用户{$account}"."取消订单", //保洁时间：
              "color"  =>"#173177"
            ],
            "keyword3" =>[
              "value"  =>'订单时间'.date('m-d H:i',$order->start_time)."\r至".
              date('m-d H:i',$order->end_time), //保洁时间：
              "color"  =>"#173177"
            ],
            "thing1" =>[
              "value"  =>$snapshoot['name'],//房间名称：
            ],
            "thing2" =>[
              "value"  =>"管理员取消{$account}订单",//
            ],
            "time4" =>[
              "value"  => date('Y-m-d H:i',$order->start_time)."~".
              date('H:i',$order->end_time),
            ],
        ];
        $tpl=Option::get_data($order->acid,'platform','wx_template_new_cleaning_port_inform');
        $tpl=$tpl?$tpl:Option::get_data($order->acid,'platform','wx_template_cleaning_port_inform');
        //加强版群发
        $storeCleaning= StoreCleaning::where(['acid'=>$order->acid,'store_id'=>$order->store_id,'is_delete'=>0,'status'=>1])->where('openid','<>','')->column('openid,account,id');
        $openidArr=array_column($storeCleaning,'openid');
        $phones=array_column($storeCleaning,'account');
        $weixin->sendWxopenTemplatePro($app,$tpl,$openidArr,"pages/index/index",$data);
        $res2=$weixin->atroomMsg($store['store_manager'],$data,1,$order['order_no']);
    }
}