<?php
namespace app\shared\logic\store;
use app\shared\model\Counter;
use app\shared\model\Goods;
use app\shared\model\CounterChest;
use app\shared\model\GoodsOrder;
use app\shared\model\User;
use app\shared\model\CounterChestOrder;
use think\exception\ValidateException;
use app\BaseController;
class CounterForm extends  Base
{
    //数据统计
    public function statistics(){
        $query=Counter::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$this->store_id]);
        $list=$query->page($this->page)
        ->order('sort DESC')
        ->field('id,name,deviceId,type')
        ->select();
        $onlineNum=0;
        $offlineNum=0;
        $current_month=CounterChestOrder::alias('c_o')
        ->leftJoin([GoodsOrder::getTable()=>'g_o'],'c_o.order_id=g_o.id')
        ->where(['g_o.store_id'=>$this->store_id,'c_o.type'=>1])
        ->whereMonth('c_o.create_time')->sum('g_o.pay_price');
        $today=CounterChestOrder::alias('c_o')
        ->leftJoin([GoodsOrder::getTable()=>'g_o'],'c_o.order_id=g_o.id')
        ->where(['g_o.store_id'=>$this->store_id,'c_o.type'=>1])
        ->whereDay('c_o.create_time')->sum('g_o.pay_price');
        $yesterday=CounterChestOrder::alias('c_o')
        ->leftJoin([GoodsOrder::getTable()=>'g_o'],'c_o.order_id=g_o.id')
        ->where(['g_o.store_id'=>$this->store_id,'c_o.type'=>1])
        ->whereDay('c_o.create_time','yesterday')->sum('g_o.pay_price');
        $form=new \counter\Yunshoukex();
        $counter_config=$this->admin->counter_config;
        $counter_config=@json_decode($counter_config,true);
        $type=$counter_config['type'];
        $appid=$counter_config['appid'];
        $appkey=$counter_config['appkey'];
        $queryMachineList=[];
        if($type==2){
            $formliubao=new \counter\Ksepton($appid,$appkey);
            $res=$formliubao->queryMachineList();
            if($res['code']==0){
                $queryMachineList=$res['data'];
                $queryMachineList=array_column($queryMachineList,'is_online','machine_id');
            }
        }

        foreach ($list as $key => &$value) {
            if($value['type']==2){
                $value['is_online']=0;
                if(isset($queryMachineList[$value['deviceId']])){
                    if($queryMachineList[$value['deviceId']]=="在线"){
                        $value['is_online']=1;
                    }
                }
            }else{
                $res=$form->deviceOnline($value['deviceId']);
                $value['is_online']=isset($res['data']['is_online'])?$res['data']['is_online']:0;
            }
            $onlineNum+=$value['is_online'];
        }
        $offlineNum=count($list)-$onlineNum;
        $stockout_num=CounterChest::where(['store_id'=>$this->store_id,'status'=>0,'is_delete'=>0])->count();
        return fetchJson([
            'onlineNum'=>$onlineNum,
            'offlineNum'=>$offlineNum,
            'current_month'=>$current_month,
            'today'=>$today,
            'yesterday'=>$yesterday,
            'stockout_num'=>$stockout_num
        ]);
    }
    //柜子
    public  function index(){
        $query=Counter::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'is_delete'=>0]);
        if($counter_id=input('counter_id')){
            $query->where('id',$counter_id);
        }
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('sort DESC')
        ->select()
        ->toArray();
        $form=new \counter\Yunshoukex();
        $counter_config=$this->admin->counter_config;
        $counter_config=@json_decode($counter_config,true);
        $type=$counter_config['type'];
        $appid=$counter_config['appid'];
        $appkey=$counter_config['appkey'];
        $queryMachineList=[];
        if($type==2){
            $formliubao=new \counter\Ksepton($appid,$appkey);
            $res=$formliubao->queryMachineList();
            if($res['code']==0){
                $queryMachineList=$res['data'];
                $queryMachineList=array_column($queryMachineList,'is_online','machine_id');
            }
        }
        foreach ($list as $key => &$value) {
            if($value['type']==2){
                $value['is_online']=0;
                if(isset($queryMachineList[$value['deviceId']])){
                    if($queryMachineList[$value['deviceId']]=="在线"){
                        $value['is_online']=1;
                    }
                }
            }else{
               $res=$form->deviceOnline($value['deviceId']);
               $value['is_online']=isset($res['data']['is_online'])?$res['data']['is_online']:0; 
            }
            $res=$form->deviceMacSim($value['deviceId']);
            $value['flow_sum']=isset($res['data']['left_count'])?$res['data']['left_count']:0;
            $counter_chest_list=CounterChest::alias('c_c')
            ->leftJoin([Goods::getTable()=>'g'],'c_c.goods_id=g.id')
            ->where(['c_c.counter_id'=>$value['id'],'c_c.is_delete'=>0])
            ->order('c_c.motoNum ASC')
            ->column('c_c.*,g.cover,g.name,g.price');
            foreach($counter_chest_list as &$v){
                $v['cover']=get_file_url($v['cover']);
            }
            $value['counter_chest_list']=$counter_chest_list;
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=Counter::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'name|名称'=>'require',
                'deviceId|设备ID'=>'require',
                'sort|排序'=>'require|number',
                'status|状态'=>'require|in:0,1'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $number=0;
        if(!$form){
            $form=new Counter();
            $form->acid=$this->acid;
            $number=input('number');
            $form->save();
        }
        $form->type=input('type');
        $form->store_id=$this->store_id;
        $form->name=$data['name'];
        $form->deviceId=$data['deviceId'];
        $form->status=$data['status'];
        $form->sort=$data['sort'];
        $form->address=input('address');
        $form->qrcode_url=qrcodeUrl($this->acid,$wxappPath="mall/goods/list?id=".$form->store_id."&counter_id=".$form->id."&parent_id=-1",$dirname="counter_qr",$filename='counter_id_'.$form->id);
        $form->save();
        if($number){
            $counterChest=[];
            for($i=1;$i<=$number;$i++){
                $counterChest[]=[
                    'acid'=>$form->acid,
                    'store_id'=>$form->store_id,
                    'counter_id'=>$form->id,
                    'motoNum'=>$i,
                    'deviceId'=>$form->deviceId
                ];
            }
            CounterChest::insertAll($counterChest);
        }
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         Counter::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         CounterChest::where(['acid'=>$this->acid,'counter_id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //订单列表
    public function orderList(){
        $query=CounterChestOrder::alias('c_o')
        ->leftJoin([GoodsOrder::getTable()=>'g_o'],'c_o.order_id=g_o.id')
        ->leftJoin([User::getTable()=>'u'],'c_o.user_id=u.id')
        ->where(['g_o.store_id'=>$this->store_id,'c_o.type'=>1])
        ->field('g_o.order_no goods_order_no,g_o.pay_price,g_o.snapshot,u.nickname,u.avatar_url,c_o.order_no,c_o.create_time,c_o.id');
        $list=$query->page($this->page)->limit(10)->order('c_o.id DESC')->select();
        foreach($list as $value){
            $value['snapshot']=@json_decode($value['snapshot'],1);
        }
        return fetchJson($list);
    }
    //缺货查询
    public function stockout(){
        $counter_ids=CounterChest::where(['status'=>0,'is_delete'=>0,'store_id'=>$this->store_id])->group('counter_id')->column('counter_id');
        $query=Counter::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'is_delete'=>0]);
        $query->where('id','in',$counter_ids);
        $list=$query->order('sort DESC')
        ->select();
        $form=new \counter\Yunshoukex();
        $counter_config=$this->admin->counter_config;
        $counter_config=@json_decode($counter_config,true);
        $type=$counter_config['type'];
        $appid=$counter_config['appid'];
        $appkey=$counter_config['appkey'];
        $queryMachineList=[];
        if($type==2){
            $formliubao=new \counter\Ksepton($appid,$appkey);
            $res=$formliubao->queryMachineList();
            if($res['code']==0){
                $queryMachineList=$res['data'];
                $queryMachineList=array_column($queryMachineList,'is_online','machine_id');
            }
        }
        foreach ($list as $key => &$value) {
            if($value['type']==2){
                $value['is_online']=0;
                if(isset($queryMachineList[$value['deviceId']])){
                    if($queryMachineList[$value['deviceId']]=="在线"){
                        $value['is_online']=1;
                    }
                }
            }else{
               $res=$form->deviceOnline($value['deviceId']);
               $value['is_online']=isset($res['data']['is_online'])?$res['data']['is_online']:0; 
            }
            $res=$form->deviceMacSim($value['deviceId']);
            $value['flow_sum']=isset($res['data']['left_count'])?$res['data']['left_count']:0;
            $value['stockout_num']=CounterChest::where(['counter_id'=>$value['id'],'status'=>0,'is_delete'=>0])->count();
        }
        return fetchJson($list);
    }
}