<?php
namespace app\shared\logic\store;
use app\shared\model\Store;
use app\shared\model\StoreCleaning;
use app\shared\model\HouseOrder;
use app\shared\model\StoreCleaningOrder;
use think\exception\ValidateException;
use app\BaseController;
class CleaningForm extends  Base
{
    //获取数据
    public  function index(){
        $query=StoreCleaning::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$this->store_id]);
        $count=$query->count();
        $list= $query
        ->page($this->page)
        ->limit($this->limit)
        ->select();
        foreach($list as &$value){
            $value['cleaning_num']=StoreCleaningOrder::where('cleaning_id',$value['id'])->whereMonth('create_time')->count();
            $value['cleaning_num']="本月".$value['cleaning_num'];
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]); 
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=StoreCleaning::where(['id'=>$id,'store_id'=>$this->store_id])->find();
        try{
            $data=request()->post();
            $rule = [
                'username|姓名'=>'require',
                'account|电话'=>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new StoreCleaning();
            $form->acid=$this->acid;
            $form->store_id=$this->store_id;
        }
        $form->username=$data['username'];
        $form->account=$data['account'];
        $form->is_delete=0;
        $form->status=input('status');
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         StoreCleaning::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
     public function orderList(){
        $query=StoreCleaningOrder::alias('a')
        ->leftJoin([StoreCleaning::getTable()=>'b'],'a.cleaning_id=b.id')
        ->leftJoin([HouseOrder::getTable()=>'c'],'a.order_id=c.id')
        ->where(['a.acid'=>$this->acid,'a.is_delete'=>0,'a.store_id'=>$this->store_id])
        ->field('a.*,b.username,b.account,c.order_no,c.status orderStatus,c.cleaning_completion_time,c.price,c.pay_price,c.snapshoot');
        $count=$query->count();
        $list= $query
        ->page($this->page)
        ->limit($this->limit)
        ->order('a.id DESC')
        ->select();
        foreach ($list as &$value){
            if($value['cleaning_completion_time']>0){
                $value['status']=2;
                $value['time']=timetodate($value['cleaning_completion_time']-$value['cleaning_time']);
                $value['cleaning_over_time']=date('Y-m-d H:i:s',$value['cleaning_completion_time']);
            }else{
                $value['cleaning_over_time']="";
                $value['time']='';
            }
            $value['cleaning_time']=date('Y-m-d H:i:s',$value['cleaning_time']);
            $snapshoot=@json_decode($value['snapshoot'],1);
            $value['houseName']=$snapshoot['name'];
            $value['houseCover']=$snapshoot['cover'];
            unset($value['snapshoot']);
            unset($value['orderStatus']);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]); 
    }
}