<?php
namespace app\shared\logic\store;
use app\shared\model\Bill;
use app\shared\model\User;
use app\shared\model\Store;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\Withdraw;
use app\shared\model\RechargeOrder;
use think\exception\ValidateException;
use app\BaseController;
class BillForm extends  Base
{
    //获取数据
    public  function index(){
        $query=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id]);
        $type=input('type');
        switch ($type) {
            case '1':
                $query->where('type',$type);    
                break;
            case '2':
                $query->where('type',$type);    
                break; 
            case '6':
                $query->where('type',$type);    
                break;
            case '7':
                $query->where('type',$type);    
                break;
            case '13':
                $query->where('type',$type);    
                break;
            case '14':
                $query->where('type',$type);    
                break;
            case '18':
                $query->where('type',$type);    
                break;                       
            default:
                break;
        }
        $start_time=input('start_time');
        $end_time=input('end_time');
        if($start_time&&$end_time){
          $query->whereBetweenTime('create_time',$start_time,$end_time);
        }
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
           if($value['account_type']==3){
              $user=User::where('id',$value['form_id'])->field('avatar_url,nickname,account')->find();
              $value['logo']=$user['avatar_url'];
              $value['name']=$user['nickname'];
              $value['account']=$user['account'];
           }
           if($value['account_type']==2){
              $store=Store::where('id',$value['form_id'])->field('logo,name,account')->find();
              $value['logo']=get_file_url($store['logo']);
              $value['name']=$store['name'];
              $value['account']=$store['account'];  
           }
           switch ($value['type']) {
             case '1'://茶室
               $value['order']=HouseOrder::where('id',$value['order_id'])->find();
               break;
            case '6'://茶室续单
               $order=HouseOrderContinue::where('id',$value['order_id'])->find();
               $value['order']=HouseOrder::where('id',$order['order_id'])->find();
               $value['order']['order_no']=$value['order']['order_no'].'  |续单订单号'.$order['order_no'];
               $value['order']['start_time']=$order['start_time'];
               $value['order']['end_time']=$order['end_time'];
               break;   
            case '2'://充值
                if($value['order_id']==0){
                    $value['order']['title']="后台充值";
                }else{
                    $value['order']=RechargeOrder::where('id',$value['order_id'])->find();  
                } 
               break;
            case '3'://提现
               $value['order']=Withdraw::where('id',$value['order_id'])->find();
               break;      
             default:
              $value['order']=[
                'price'=>'',
                'order'=>'',
              ];
               break;
           }
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }

}