<?php
namespace app\shared\logic\platform;
use app\shared\model\SubscribeBall;
use app\shared\model\SubscribeBallOrder;
use app\shared\model\User;
use think\exception\ValidateException;
use app\BaseController;
class SubscribeBallForm extends  Base
{
    //获取数据
    public  function index(){
        
        $query=SubscribeBall::where(['acid'=>$this->acid,'is_delete'=>0]);
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        $userArr=[];
        $idsArr=[];
        foreach($list as &$value){
            $userArr[]=$value['user_id'];
            if($value['invitation_user_id']){
                $userArr[]=$value['invitation_user_id'];
            }
            $idsArr[]=$value['id'];
        }
        $orderList=SubscribeBallOrder::alias('o')
        ->leftJoin([User::getTable()=>'u'],'o.user_id=u.id')
        ->where('o.subscribe_ball_id','in',$idsArr)
        ->where(['o.is_pay'=>1])
        ->column('o.id,o.subscribe_ball_id,o.order_no,u.avatar_url,u.nickname,o.pay_price,o.pay_time'); 
        $orderArr=[];
        foreach($orderList as $order){
            $orderArr[$order['subscribe_ball_id']][]=$order;
        }
        $userList=User::where('id','in',$userArr)->column('id,nickname,avatar_url');
        $nicknameArr=array_column($userList,'nickname','id');
        $avatarArr=array_column($userList,'avatar_url','id');
        foreach($list as &$value){
            $value['nickname']=$nicknameArr[$value['user_id']];
            $value['avatar_url']=$avatarArr[$value['user_id']];
            $value['invitation_nickname']=isset($nicknameArr[$value['invitation_user_id']])?$nicknameArr[$value['invitation_user_id']]:0;
            $value['invitation_avatar_url']=isset($avatarArr[$value['invitation_user_id']])?$avatarArr[$value['invitation_user_id']]:0;
            if($value['avatar_url']=='null'){
                $value['avatar_url']=0;
            }
            if($value['invitation_avatar_url']=='null'){
                $value['invitation_avatar_url']=0;
            }
            $value['order_list']=isset($orderArr[$value['id']])?$orderArr[$value['id']]:[];
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
}