<?php
namespace app\shared\logic\platform;
use app\shared\model\ShareApply;
use app\shared\model\User;
use think\exception\ValidateException;
use app\BaseController;
class ShareForm extends  Base
{
    //获取数据
    public  function applyList(){
        $query=ShareApply::alias('s')->leftJoin([User::getTable()=>'u'],'s.user_id=u.id')->where(['s.acid'=>$this->acid,'s.is_delete'=>0]);
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('s.id DESC')
        ->field('s.*,u.nickname,u.avatar_url')
        ->select();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //申请处理
    public function applyHandle(){
    	try {
            $data=request()->post();
            $rule = [
                'id|ID'=>'require',
                'status|状态'=>'require|number|in:1,2',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
    	$form=ShareApply::where(['acid'=>$this->acid,'id'=>$data['id'],'status'=>0])->find();
    	if($form){
    		$form->save([
    			'status'=>$data['status']
    		]);  
    		User::where(['id'=>$form->user_id])->update(['is_distribution'=>$data['status']==1?1:0]);
            return fetchJson([],"处理成功");
    	}else{
            return fetchJson([],"暂无数据",1);
        }
    	
    }
    //申请处理
    public function applyDelete(){
    	$form=ShareApply::where(['acid'=>$this->acid,'id'=>input('id')])->find();
        if($form){
            User::where(['id'=>$form->user_id])->update(['is_distribution'=>0]);
            $form->save(['is_delete'=>1]);
        }
    	return fetchJson([],"删除成功");
    }
}