<?php
namespace app\shared\logic\platform;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\model\Role;
use app\admin\model\Role as RoleAdmin;
use app\admin\model\Menu as MenuAdmin;
class RoleForm extends  Base
{
	//菜单权限
	public function menuAuth(){
		$menu_auth=RoleAdmin::where('id',2)->value('menu_auth');
		$menu_auth=@json_decode($menu_auth,1);
		$menu=MenuAdmin::where('id','in',$menu_auth)->where(['status'=>1])->order('sort asc')->column('id,title,pid');
		return fetchJson(generateTree($menu));

	}
    //列表
    public  function index(){
        $query=Role::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>0]);
        $queryCount=Role::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>0]);
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')->select();
        foreach ($list as $key => &$value) {
        	$value['content']=@json_decode($value['content'],1);
        	$value['cover_url']=get_file_url($value['cover']);
        }
        $count=$queryCount->count();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
    	try {
	        $data=request()->post();
	        $rule = [
	            'id|ID' =>'require|number',
	            'name|名称' =>'require',
	            'menu_auth|菜单权限' =>'require',
	        ];
	        $this->validate($data,$rule);
	    } catch (ValidateException $e){
	        return fetchJson([],$e->getError(),1);
	    }
	    $form=Role::where(['id'=>$data['id']])->find();
	    if(!$form){
	    	$form=new Role();
	    	$form->acid=$this->acid;
	    	$form->store_id=0;
	    }
	    $form->name=$data['name'];
	    $form->menu_auth=$data['menu_auth'];
	    $form->save();

	    return fetchJson([],'保存成功');
	}
	//删除
	public function delete(){
		$id=input('id');
		Role::where(['id'=>$id])->update(['is_delete'=>1]);
	    return fetchJson([],'保存成功');
	}

}