<?php
namespace app\shared\logic\platform;
use app\shared\model\App;
use app\admin\model\Option;
use app\shared\model\User;
use app\shared\model\Message;
use think\exception\ValidateException;
use app\BaseController;
use wechatpay\WechatPay;
//消息管理
class MessageForm extends  Base
{	
    public function index(){
        $query=Message::alias('m');
        $queryCount=Message::where('acid',$this->acid);
        $account_type=input('account_type');
        if($account_type==3){
          $query->leftJoin([User::getTable()=>'u'],'m.user_id=u.id')->field('m.*,u.nickname,u.avatar_url');
        }
        if($account_type==1){
          $query->leftJoin([App::getTable()=>'a'],'m.user_id=a.id')->field('m.*,a.logo avatar_url,a.name nickname');
        }
        if($type=input('type')){
          $query->where('m.type',$type);
          $queryCount->where('type',$type);
        }
        if($account_type=input('account_type')){
          $query->where('m.account_type',$account_type);
          $queryCount->where('account_type',$account_type);
        }
        $count=$queryCount->field('id')->count();
        $list=$query->page($this->page)->limit($this->limit)->order('m.id DESC')->select();
        foreach($list as &$value){
           if($value['account_type']==2){
              $value['avatar_url']=get_file_url($value['avatar_url']);
           }
           $user=User::where('id',$value['form_user_id'])->field('nickname,avatar_url')->find();
           $value['form_user_nickname']=$user['nickname'];
           $value['form_user_avatar_url']=$user['avatar_url'];
        }
    	  return fetchJson([
          'list'=>$list,
          'count'=>$count
        ]);
    }
    public function  pushMsg(){
          try {
            $data=request()->post();
            $rule = [
                'account_type|账号类型' => 'require',
                'user_ids|用户ID'=>'require',
                'content|内容'=>'require',
            ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
         \app\shared\model\Message::pushGroupMsg($this->acid,Message::ACCOUNT_TYPE_USER,Message::TYPE_SYSTEM,$this->acid,$data['user_ids'],input('title'),$data['content'],input('images'),input('details'));
         return fetchJson([],'推送成功',0);
    }
}