<?php
namespace app\shared\logic\platform;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\BypassAccount;
use app\shared\model\Role;
use app\admin\model\Menu;
use think\exception\ValidateException;
use app\BaseController;
class LoginForm extends  BaseController
{
    public function __construct()
    {
        $this->initialize();
    }
    public  function  login(){
        try {
            $data=request()->post();
            $rule = [
                'account|账号'   => 'require',
                'password|密码'=>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $user=App::where([
            'account'=>$data['account'],
            'password'=>md5($data['password'])
        ])->withoutField('password')->find();
        if($user){
            $ip=request()->ip();
            if((strtotime($user->update_time)+86400)<time()){
                 $user->access_token=create_access_token(2);
            }
            if(get_access_token_type($user->access_token)==-1){
                $user->access_token=create_access_token(2);
            }
            $user->save();
            $logo_url=request()->domain().substr(request()->baseUrl(),0,stripos(request()->baseUrl(),'index.php')).'static/logo.png';
            $user['logo_url']=get_file_url($user['logo']);
            $user['logo_url']=$user['logo_url']?$user['logo_url']:$logo_url;
            return fetchJson($user,'登录成功',0);
        }else{
            return fetchJson([],'账号密码错误',1);
        }
    }
     //子账户登录
    public function bypassAccountLogin(){
        try {
            $data=request()->post();
            $rule = [
                'acid|平台ID' =>'require|number',
                'account|账号'   => 'require',
                'password|密码'=>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $user=BypassAccount::where([
            'account'=>$data['account'],
            'password'=>md5($data['password']),
            'acid'=>$data['acid'],
            'store_id'=>0,
            'is_delete'=>0
        ])->withoutField('password')->find();
        if($user){
            if((strtotime($user->update_time)+86400)<time()){
                 $user->access_token=create_access_token(6);
            }
            if(!$user->access_token){
                $user->access_token=create_access_token(6);
            }
            $menu_auth=Role::where(['id'=>$user->role_id])->value('menu_auth');
            $url=Menu::where('id','in',$menu_auth)->where('pid','<>',0)->value('path');
            $user->save();
            $logo_url=request()->domain().substr(request()->baseUrl(),0,stripos(request()->baseUrl(),'index.php')).'static/logo.png';
            $user['url']=$url;
            $user['logo_url']=$user['logo'];
            $user['logo_url']=$user['logo_url']?$user['logo_url']:$logo_url;
            return fetchJson($user,'登录成功',0);
        }else{
            return fetchJson([],'账号密码错误',1);
        }
    }
}
