<?php
namespace app\shared\logic\platform;
use app\shared\model\Invoice;
use app\shared\model\User;
use app\shared\model\InvoiceDetail;
use think\exception\ValidateException;
use app\BaseController;
class InvoiceForm extends  Base
{
	//列表
	public function index(){
		$query=Invoice::alias('i')->leftJoin([User::getTable()=>'u'],'i.user_id=u.id')
		->where(['i.acid'=>$this->acid,'i.is_delete'=>0]);
		$status=input('status');
		if($status!=-1){
			$query->where('i.status',$status);
		}
		$count=$query->field('i.*,u.avatar_url,u.nickname')->count();
		$list=$query->limit($this->limit)->page($this->page)->select();
	    return fetchJson([
	    	'count'=>$count,
	    	'list'=>$list
	    ]);
	}
	//处理
	public function handle(){
		$id=input('id');
		$status=input('status');
		$form=Invoice::where(['acid'=>$this->acid,'id'=>$id])->find();
		if($form){
			$form->status=$status;
			$form->dec=input('dec');
			$form->save();
			if($form->status==2){
				InvoiceDetail::where('invoice_id',$id)->update(['is_delete'=>1]);
			}
			return fetchJson([],'处理成功');
		}
		return fetchJson([],'暂无数据');
	}
	//详细
	public function detail(){
		$invoice_id=input('invoice_id');
		$query=InvoiceDetail::where('invoice_id',$invoice_id);
		$count=$query->count();
		$list=$query->limit($this->limit)->page($this->page)->select();
		return fetchJson([
			'count'=>$count,
			'list'=>$list
		]);
	}
}