<?php
namespace app\shared\logic\platform;
use app\shared\model\InviteTea;
use app\shared\model\InviteTeaDetail;
use app\shared\model\User;
use app\shared\model\Option;
use think\exception\ValidateException;
use app\BaseController;
class InviteTeaForm extends  Base
{
    //信息
    public  function info(){
    	$config=Option::get_data($this->acid,'plugin','shared_invite_tea_config');
    	$url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/';
    	$config=@json_decode($config,1);
    	if(!$config){
    		$config=[
    			'bg_img'=>$url.'img/bg_img.jpg',
    			'people_num'=>6,
    			'status'=>0,
    			'dec'=>"",
    			'desk_img'=>$url.'img/desk_img.jpg',
    			'stool_img'=>$url.'img/stool_img.png',
                'is_new_user'=>0,
                'everyday_user_num'=>1,
    		];
    	}
    	return fetchJson($config);
    }
    //设置
    public function setting(){
    	Option::set_data($this->acid,'plugin','shared_invite_tea_config',json_encode([
    		'bg_img'=>input('bg_img'),
			'people_num'=>input('people_num'),
			'status'=>input('status'),
			'dec'=>input('dec'),
			'desk_img'=>input('desk_img'),
			'stool_img'=>input('stool_img'),
            'is_new_user'=>input('is_new_user'),
            'everyday_user_num'=>input('everyday_user_num'),
    	]));
    	return fetchJson([],'保存成功');
    }
    public function inviteTea(){
        $query=InviteTea::alias('a')
        ->leftJoin([User::getTable()=>'b'],'a.user_id=b.id')
        ->where(['a.acid'=>$this->acid])
        ->field('a.*,b.nickname,b.avatar_url');
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->order('a.id DESC')->select();
        foreach ($list as &$value){
            $value['already_num']=InviteTeaDetail::where(['invite_tea_id'=>$value['id']])->count();
        }
        return fetchJson([
           'count'=>$count,
           'list'=>$list
        ]);
    }
    public function inviteTeaDetail(){
        $query=InviteTeaDetail::alias('a')
        ->leftJoin([User::getTable()=>'b'],'a.user_id=b.id')
        ->where(['a.acid'=>$this->acid,'a.invite_tea_id'=>input('invite_tea_id')])
        ->field('a.*,b.nickname,b.avatar_url');
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->order('a.id DESC')->select();
        return fetchJson([
           'count'=>$count,
           'list'=>$list
        ]);
    }
}