<?php
namespace app\shared\logic\platform;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\User;
use app\shared\model\UserUv;
use app\shared\model\Goods;
use app\shared\model\House;
use app\shared\model\Bill;
use app\shared\model\Store;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\SystemLog;
use app\shared\model\Card;
use app\shared\model\CardOrder;
use app\shared\model\CardUser;
use app\shared\model\RechargeOrder;
use app\repast\model\GoodsOrder as RepastGoodsOrder;
use app\shared\model\Electricity;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Cache;
use think\facade\Db;
class IndexForm extends  Base
{
    //数据统计
    public  function statistics(){
        $start_date=input('start_date');
        $end_date=input('end_date');
        $store_id=input('store_id');
        $days=7;
        if($end_date){
           $time=strtotime($end_date);
           $days=strtotime($end_date)-strtotime($start_date);
           $days=$days/86400;
           if($days<7){
            $days=7;
           }
           if($start_date==$end_date){
             $end_date=date('Y-m-d',strtotime($end_date)+86400);
           }
        }else{
          $time=time();
        }
        $house_price=0;
        $user_num=User::where(['acid'=>$this->acid])->count();
        $store_num=Store::where(['acid'=>$this->acid,'is_delete'=>0])->count();
        $getServenDay=getServenDay(date('Y-m-d',$time+86400),0,$days);
        $getServenDay = array_column($getServenDay,'time');
        $house_order_arr=[];
        $cardIds=Card::where(['acid'=>$this->acid,'is_delete'=>0])->column('id');
        $cardUserQuery=CardUser::where('card_id','in',$cardIds);
        $card_id=input('card_id');
        if($card_id){
            $cardUserQuery=CardUser::where(['card_id'=>$card_id]);
        }
        $card_user_num=$cardUserQuery->count();
        
        $card_user_pay_num=0;
        foreach ($getServenDay as $day) {
          if($store_id){
              $house_order_arr[]=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1,'store_id'=>$store_id])->where('status',3)->whereDay('create_time',$day)->count();
          }else{
              $house_order_arr[]=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1])->where('status',3)->whereDay('create_time',$day)->count();
          }
        }
        if($start_date&&$end_date){
          //会员卡
          $card_balance_pay=CardOrder::where(['acid'=>$this->acid,'is_pay'=>1,'pay_type'=>2])->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');
          $card_weixin_pay=CardOrder::where(['acid'=>$this->acid,'is_pay'=>1,'pay_type'=>1])->whereBetweenTime('create_time',$start_date,$end_date)->sum('price'); 
          $cardUserPayQuery=CardOrder::where(['acid'=>$this->acid,'is_pay'=>1,'is_delete'=>0])->whereBetweenTime('create_time',$start_date,$end_date);
          if($card_id){
            $cardUserPayQuery->where('card_id',$card_id);
          }else{
            $cardUserPayQuery->where('card_id','in',$cardIds);
          }
          $card_user_pay_num=$cardUserPayQuery->distinct(true)->field('user_id')->count();

          //余额充值 
          $recharge_pay=RechargeOrder::where(['acid'=>$this->acid,'is_pay'=>1])->whereBetweenTime('create_time',$start_date,$end_date)->sum('money');
          if($store_id){
              $house_order_num=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])->where('pay_type','in','1,2')
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->count();
              $sum_earnings=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->where('pay_type','in','1,2')->sum('price');


              $sum_earnings_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$store_id])
              ->whereBetweenTime('h.create_time',$start_date,$end_date)->where('xd.pay_type','in','1,2')->where('xd.status',1)->sum('xd.price');
              $sum_earnings+=$sum_earnings_xd;
              
              //退款金额
              $sum_house_refund= HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])->where('pay_type','in','1,2')
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status',-2)->sum('price');

              //统计余额
              $sum_balance=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id,'pay_type'=>2])
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->sum('price');

              $sum_balance_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$store_id])
              ->whereBetweenTime('h.create_time',$start_date,$end_date)->where(['xd.status'=>1,'xd.pay_type'=>2])->sum('xd.price');
              $sum_balance+=$sum_balance_xd;
              
              //微信支付统计
              
              $sum_wechatPay=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id,'pay_type'=>1])
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->sum('price');

              $sum_wechatPay_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$store_id])
              ->whereBetweenTime('h.create_time',$start_date,$end_date)->where(['xd.status'=>1,'xd.pay_type'=>1])->sum('xd.price');
              $sum_wechatPay+=$sum_wechatPay_xd;
              
              //用电时长
              $electricityInfo=Electricity::alias('e')->leftJoin([HouseOrder::getTable()=>'o'],'e.order_id=o.id')
                ->leftJoin([House::getTable()=>'h'],'o.house_id=h.id')
                ->where(['e.acid'=>$this->acid,'h.store_id'=>$store_id])->whereBetweenTime('e.create_time',$start_date,$end_date)->fieldRaw('SUM(e.end_time-e.start_time) as duration')->find();
          }else{
              $house_order_num=HouseOrder::where(['acid'=>$this->acid])->where('pay_type','in','1,2')
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->count();
              $sum_earnings=HouseOrder::where(['acid'=>$this->acid])->where('pay_type','in','1,2')
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->sum('price');


              $sum_earnings_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid])
              ->whereBetweenTime('h.create_time',$start_date,$end_date)->where('xd.pay_type','in','1,2')->where('xd.status',1)->sum('xd.price');
              $sum_earnings+=$sum_earnings_xd;
              
              //退款金额
              $sum_house_refund= HouseOrder::where(['acid'=>$this->acid])
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status',-2)->sum('price');

              //统计余额
              $sum_balance=HouseOrder::where(['acid'=>$this->acid,'pay_type'=>2])
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->sum('price');

              $sum_balance_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid])
              ->whereBetweenTime('h.create_time',$start_date,$end_date)->where(['xd.status'=>1,'xd.pay_type'=>2])->sum('xd.price');
              $sum_balance+=$sum_balance_xd;
              
              //微信支付统计
              
              $sum_wechatPay=HouseOrder::where(['acid'=>$this->acid,'pay_type'=>1])
              ->whereBetweenTime('create_time',$start_date,$end_date)->where('status','in','1,2,3')->sum('price');

              $sum_wechatPay_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid])
              ->whereBetweenTime('h.create_time',$start_date,$end_date)->where(['xd.status'=>1,'xd.pay_type'=>1])->sum('xd.price');
              $sum_wechatPay+=$sum_wechatPay_xd;
              //用电时长
              $electricityInfo=Electricity::alias('e')->leftJoin([HouseOrder::getTable()=>'o'],'e.order_id=o.id')
                ->leftJoin([House::getTable()=>'h'],'o.house_id=h.id')
                ->where(['e.acid'=>$this->acid])->whereBetweenTime('e.create_time',$start_date,$end_date)->fieldRaw('SUM(e.end_time-e.start_time) as duration')->find();
          }
        }else{
          //会员卡
          $card_balance_pay=CardOrder::where(['acid'=>$this->acid,'is_pay'=>1,'pay_type'=>2])->sum('price');
          $card_weixin_pay=CardOrder::where(['acid'=>$this->acid,'is_pay'=>1,'pay_type'=>1])->sum('price'); 
          $cardUserPayQuery=CardOrder::where(['acid'=>$this->acid,'is_pay'=>1,'is_delete'=>0]);
          if($card_id){
            $cardUserPayQuery->where('card_id',$card_id);
          }else{
            $cardUserPayQuery->where('card_id','in',$cardIds);
          }
          $card_user_pay_num=$cardUserPayQuery->distinct(true)->field('user_id')->count();

          //余额充值 
          $recharge_pay=RechargeOrder::where(['acid'=>$this->acid,'is_pay'=>1])->sum('money');  
          if($store_id){
              $house_order_num=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])->where('status','in','1,2,3')->where('pay_type','in','1,2')->count();
              $sum_earnings=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])->where('status','in','1,2,3')->where('pay_type','in','1,2')->sum('price');


              $sum_earnings_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where('xd.pay_type','in','1,2')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$store_id])->where('xd.status',1)->sum('xd.price');
              $sum_earnings+=$sum_earnings_xd;
              
              //退款金额
              $sum_house_refund= HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])->where('pay_type','in','1,2')->where('status',-2)->sum('price');

              //统计余额
              $sum_balance=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id,'pay_type'=>2])->where('status','in','1,2,3')->sum('price');

              $sum_balance_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$store_id])->where(['xd.status'=>1,'xd.pay_type'=>2])->sum('xd.price');
              $sum_balance+=$sum_balance_xd;
              
              //微信支付统计
              
              $sum_wechatPay=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id,'pay_type'=>1])
              ->where('status','in','1,2,3')->sum('price');

              $sum_wechatPay_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$store_id])->where(['xd.status'=>1,'xd.pay_type'=>1])->sum('xd.price');
              $sum_wechatPay+=$sum_wechatPay_xd;
             //用电时长
              $electricityInfo=Electricity::alias('e')->leftJoin([HouseOrder::getTable()=>'o'],'e.order_id=o.id')
                ->leftJoin([House::getTable()=>'h'],'o.house_id=h.id')
                ->where(['e.acid'=>$this->acid,'h.store_id'=>$store_id])->fieldRaw('SUM(e.end_time-e.start_time) as duration')->find(); 
          }else{
              $house_order_num=HouseOrder::where(['acid'=>$this->acid])->where('status','in','1,2,3')->where('pay_type','in','1,2')->count();
              $sum_earnings=HouseOrder::where(['acid'=>$this->acid])->where('status','in','1,2,3')->where('pay_type','in','1,2')->sum('price');


              $sum_earnings_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where('xd.pay_type','in','1,2')->where(['xd.acid'=>$this->acid])->where('xd.status',1)->sum('xd.price');
              $sum_earnings+=$sum_earnings_xd;
              
              //退款金额
              $sum_house_refund= HouseOrder::where(['acid'=>$this->acid])->where('pay_type','in','1,2')->where('status',-2)->sum('price');

              //统计余额
              $sum_balance=HouseOrder::where(['acid'=>$this->acid,'pay_type'=>2])->where('status','in','1,2,3')->sum('price');

              $sum_balance_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid])->where(['xd.status'=>1,'xd.pay_type'=>2])->sum('xd.price');
              $sum_balance+=$sum_balance_xd;
              
              //微信支付统计
              
              $sum_wechatPay=HouseOrder::where(['acid'=>$this->acid,'pay_type'=>1])
              ->where('status','in','1,2,3')->sum('price');

              $sum_wechatPay_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid])->where(['xd.status'=>1,'xd.pay_type'=>1])->sum('xd.price');
              $sum_wechatPay+=$sum_wechatPay_xd;
              //用电时长
             $electricityInfo=Electricity::alias('e')->leftJoin([HouseOrder::getTable()=>'o'],'e.order_id=o.id')
                ->leftJoin([House::getTable()=>'h'],'o.house_id=h.id')
                ->where(['e.acid'=>$this->acid])->fieldRaw('SUM(e.end_time-e.start_time) as duration')->find();
          }
        }
        if($store_id){
           $today_earnings=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])
              ->whereDay('create_time',date('Y-m-d'))->where('status','in','1,2,3')->sum('price');
           $today_earnings_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid,'xd.store_id'=>$store_id])
              ->whereDay('h.create_time',date('Y-m-d'))->where('xd.status',1)->sum('xd.price');
           $today_earnings+=$today_earnings_xd;

           $house_count=House::where(['acid'=>$this->acid,'store_id'=>$store_id,'is_delete'=>0])->count();
        }else{
           $today_earnings=HouseOrder::where(['acid'=>$this->acid])
              ->whereDay('create_time',date('Y-m-d'))->where('status','in','1,2,3')->sum('price');
           $today_earnings_xd=HouseOrderContinue::alias('xd')->leftJoin([HouseOrder::getTable()=>'h'],'h.id=xd.order_id')->where(['xd.acid'=>$this->acid])
              ->whereDay('h.create_time',date('Y-m-d'))->where('xd.status',1)->sum('xd.price');
           $today_earnings+=$today_earnings_xd;

           $house_count=House::where(['acid'=>$this->acid,'is_delete'=>0])->count();
        }
        //会员卡
        $today_card_pay=CardOrder::where(['acid'=>$this->acid,'is_pay'=>1])->whereDay('create_time',date('Y-m-d'))->sum('price');

        //余额充值 
        $today_recharge_pay=RechargeOrder::where(['acid'=>$this->acid,'is_pay'=>1])->whereDay('create_time',date('Y-m-d'))->sum('money'); 

        $house_order_sumprice=$sum_earnings;
        $sum_earnings=$sum_earnings+$card_balance_pay+$card_weixin_pay+$recharge_pay;
        return fetchJson([
            'store_num'=>$store_num,
            'card_user_num'=>$card_user_num,
            'card_user_pay_num'=>$card_user_pay_num,
            'sum_earnings'=>$sum_earnings,
            'repast_sum_wechat'=>0,
            'repast_sum_balance'=>0,
            'sum_balance'=>$sum_balance+$card_balance_pay,
            'sum_wechatPay'=>$sum_wechatPay+$card_weixin_pay+$recharge_pay,
            'sum_card_earnings'=>$card_balance_pay+$card_weixin_pay,
            'sum_recharge'=>$recharge_pay,
            'house_count'=>$house_count,
            'user_num'=>$user_num,
            'house_order_num'=>$house_order_num,
            'sum_house_refund'=>$sum_house_refund,
            'house_order_sumprice'=>$house_order_sumprice,
            'today_earnings'=>$today_earnings+$today_card_pay+$today_recharge_pay,
            'electricity_duration'=>timetodatePus($electricityInfo['duration']),
            'consume_ranking'=>self::consumeRanking(),
            
            'broken_line'=>[
                'date'=>$getServenDay,
                'legend'=>['茶室订单'],
                'series'=>[
                    [
                        'name'=>'茶室订单',
                        'type'=>'line',
                        'stack'=>'总量',
                        'data'=>$house_order_arr
                    ],
                ]
            ]
        ]);
    }
     //消费排行
    public function consumeRanking(){
          $bill_list=Cache::get("platform_{$this->acid}_consumeRanking");
          if($bill_list){
             return $bill_list;
          }
          $table=Bill::getTable();
          $sql="SELECT form_id, SUM(price) AS consumption_price FROM {$table} WHERE  `acid` = {$this->acid}  AND `status` = -1  AND `account_type` = 3  AND `type` IN (1,2,4,6,7,8) GROUP BY form_id ORDER BY consumption_price DESC  LIMIT 15";
          $bill_list=Db::query($sql);
          $userIds=[];
          foreach($bill_list as $item){
            $userIds[]=$item['form_id'];
          }
          $userList=User::where('id','in',$userIds)->column('id,nickname,avatar_url,account,acid,create_time');
          $userArr=[];
          foreach($userList as $user){
            $userArr[$user['id']]=$user;
          }
          foreach($bill_list as $key=>&$value){
            $value['ranking']=$key+1;
            $value['nickname']=isset($userArr[$value['form_id']]['nickname'])?$userArr[$value['form_id']]['nickname']:'';
            $value['avatar_url']=isset($userArr[$value['form_id']]['avatar_url'])?$userArr[$value['form_id']]['avatar_url']:0;
            $value['create_time']=isset($userArr[$value['form_id']]['create_time'])?date('Y-m-d H:i:s',$userArr[$value['form_id']]['create_time']):'';
            $value['account']=isset($userArr[$value['form_id']]['account'])?$userArr[$value['form_id']]['account']:0;
            $value['user_id']=$value['form_id'];
            $value['id']=$value['form_id'];
          }
          Cache::set("platform_{$this->acid}_consumeRanking",$bill_list,60);
          return $bill_list;       
    }
    //插件列表
    public function plugList(){
        $list=Cache::get('platform_plugin_list');
        return fetchJson($list);
    }
    //系统日志
    public function systemLog(){
        $platform=Cache::get('platform_plugin_list');
        $end_time=isset($platform['info']['end_time'])?$platform['info']['end_time']:0;
        $start_time=isset($platform['info']['start_time'])?$platform['info']['start_time']:0;
        SystemLog::where('id','145')->update([
          'version'=>'1.1.44'
        ]);
        $list=SystemLog::whereTime('create_time', '<=', date('Y-m-d',$end_time))->limit($this->limit)->page($this->page)->order('id DESC')->select();
        $new_time=strtotime(date('Y-m-d'));
        $day=($end_time-$new_time)>0?($end_time-$new_time)/86400:0;
        $day=round($day);
        return fetchJson([
            'info'=>[
                'start_time'=>date('Y-m-d',$start_time),
                'end_time'=>date('Y-m-d',$end_time),
                'day'=>$day,
                'version'=>SystemLog::whereTime('create_time', '<=', date('Y-m-d',$end_time))->order('id DESC')->value('version')
            ],
            'list'=>$list,
            'count'=>SystemLog::whereTime('create_time', '<=', date('Y-m-d',$end_time))->count(),
        ]);
    }
    //一键更新系统
    public function oneKeyUpdateSystem(){
        $url=env('app.update_url');
        $platform=Cache::get('platform_plugin_list');
        $end_time=isset($platform['info']['end_time'])?$platform['info']['end_time']:0;
        if($end_time<time()){
          return fetchJson([],'请联系芊雅您的系统现已到期！！',1);
        }
        $app=App::where('id',$this->acid)->field('logo')->find();
        $app_atroom_tea_token=Option::get_data($this->acid,'platform','app_atroom_tea_token');
        if(!$app_atroom_tea_token){
            $root_url=request()->domain().str_replace('index.php', '',request()->baseFile());
            $app_atroom_tea_token=qy_encode(json_encode(['url'=>$root_url,'acid'=>$this->acid]));
            Option::set_data($this->acid,'platform','app_atroom_tea_token',$app_atroom_tea_token);
        }
        $manage_accounts=Store::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->where('store_manager','<>','')->column('store_manager');
        $data=[
          'app_atroom_tea_token'=>$app_atroom_tea_token,
          'manage_accounts'=>$manage_accounts,
          'logo_url'=>get_file_url($app['logo']),
        ];
        $weixin=new \weixin\Wechat();
        $weixin->atroomDataInform('',$data);
        if($url){
          httpRequest($url);
          $root_url=request()->domain().str_replace('index.php', '',request()->baseFile());
          sleep(3);
          self::updateSql();
        }
        return fetchJson([],'请求成功');
    }
    //更新数据库
    private function updateSql(){
        $version= Option::get_data('-1','admin','system_version');
        if(!$version){
            Option::set_data('-1','admin','system_version','1.0.0');
            $version="1.0.0";
        }
        $path_version=[];
        foreach(explode('.',$version) as $version_v_index=>$version_v){
          if($version_v_index<2){
            $path_version[]=$version_v;
          }else{
            break;
          }
        }
        $path_version=implode($path_version,'.');
        $path_version=(string)$path_version;
        $path=app()->getRootPath().'sql/'.$path_version.'/';
        if(!is_dir($path)){
            return 0;
        }
        $data = scandir($path);
        $array=[];
        foreach ($data as $key => $value) {
            if(strpos($value,'.sql') !== false){
                $updSql=$path.$value;
                $val=str_replace('.sql','',$value);
                $array[]=$val;
            }
        }
        $array=sortVersion($array);
        foreach ($array as $k => $vl) {
             $version= Option::get_data('-1','admin','system_version');
             $updata=version_compare($version,$vl);
             if($updata==-1||$updata==0){
                $newversion=QyVersionsInc($vl);
                //处理SQL
                 Option::set_data('-1','admin','system_version',$newversion);
                 $sql = Sql::getSqlFromFile($path.$vl.'.sql');  
                 foreach ($sql as $v) {  
                    @Db::execute($v);
                 }
            }else{
                continue;
            }
        }
    }
    public function uvList(){
        $query=UserUv::alias('uv')
                    ->leftJoin([User::getTable()=>'u'],'uv.user_id=u.id')
                    ->leftJoin([Store::getTable()=>'s'],'uv.store_id=s.id')
                    ->field('u.nickname,u.avatar_url,uv.create_time,uv.type,uv.form_id,s.name,s.logo');
        if($store_id=input('store_id')){
           $query->where('uv.store_id',$store_id);
           $count=UserUv::where(['acid'=>$this->acid,'store_id'=>$store_id])->field('id')->count();
        }else{
           $count=UserUv::where(['acid'=>$this->acid])->field('id')->count();
        }             
       
        $list=$query->page($this->page)->limit($this->limit)->order('uv.id DESC')->select();
        foreach ($list as &$value){
          if($value['type']==1){
             $store=Store::where('id',$value['form_id'])->field('name,logo')->find();
             $value['title']=$store['name'];
             $value['cover_url']=get_file_url($store['logo']);
          }else if($value['type']==2){
             $house=House::where('id',$value['form_id'])->field('name,cover')->find();
             $value['title']='浏览茶室：'.$house['name'];
             $value['cover_url']=$house['cover'];
          }else if($value['type']==3){
             $goods=House::where('id',$value['form_id'])->field('name,cover')->find();
             $value['title']='浏览商品：'.$goods['name'];
             $value['cover_url']=get_file_url($goods['cover']);
          }else{
             $value['title']='未知';
             $value['cover_url']='未知';
          }
          $value['logo']=get_file_url($value['logo']);
        }
        return fetchJson([
          'count'=>$count,
          'list'=>$list
        ]);
    }
   
}
class Sql
{
    /**
     * 从sql文件获取纯sql语句
     * @param  string $sql_file sql文件路径
     * @param  bool $string 如果为真，则只返回一条sql语句，默认以数组形式返回
     * @param  array $replace 替换前缀，如：['my_' => 'me_']，表示将表前缀"my_"替换成"me_"
     *         这种前缀替换方法不一定准确，比如正常内容内有跟前缀相同的字符，也会被替换
     * @return mixed
     */
   static public function getSqlFromFile($sql_file = '', $string = false, $replace = [])
    {
        if (!file_exists($sql_file)) {
            return false;
        }

        // 读取sql文件内容
        $handle = self::read_file($sql_file);

        // 分割语句
        $handle = self::parseSql($handle, $string, $replace);

        return $handle;
    }
    /**
     * 分割sql语句
     * @param  string $content sql内容
     * @param  bool $string 如果为真，则只返回一条sql语句，默认以数组形式返回
     * @param  array $replace 替换前缀，如：['my_' => 'me_']，表示将表前缀my_替换成me_
     * @return array|string 除去注释之后的sql语句数组或一条语句
     */
    public static function parseSql($content = '', $string = false, $replace = [])
    {
        // 被替换的前缀
        $from = '';
        // 要替换的前缀
        $to = '';

        // 替换表前缀
        if (!empty($replace)) {
            $to   = current($replace);
            $from = current(array_flip($replace));
        }

        if ($content != '') {
            // 纯sql内容
            $pure_sql = [];

            // 多行注释标记
            $comment = false;

            // 按行分割，兼容多个平台
            $content = str_replace(["\r\n", "\r"], "\n", $content);
            $content = explode("\n", trim($content));

            // 循环处理每一行
            foreach ($content as $key => $line) {
                // 跳过空行
                if ($line == '') {
                    continue;
                }

                // 跳过以#或者--开头的单行注释
                if (preg_match("/^(#|--)/", $line)) {
                    continue;
                }

                // 跳过以/**/包裹起来的单行注释
                if (preg_match("/^\/\*(.*?)\*\//", $line)) {
                    continue;
                }

                // 多行注释开始
                if (substr($line, 0, 2) == '/*') {
                    $comment = true;
                    continue;
                }

                // 多行注释结束
                if (substr($line, -2) == '*/') {
                    $comment = false;
                    continue;
                }

                // 多行注释没有结束，继续跳过
                if ($comment) {
                    continue;
                }

                // 替换表前缀
                if ($from != '') {
                    $line = str_replace('`'.$from, '`'.$to, $line);
                }

                // sql语句
                array_push($pure_sql, $line);
            }

            // 只返回一条语句
            if ($string) {
                return implode($pure_sql, "");
            }

            // 以数组形式返回sql语句
            $pure_sql = implode($pure_sql, "\n");
            $pure_sql = explode(";\n", $pure_sql);
            return $pure_sql;
        } else {
            return $string == true ? '' : [];
        }
    }

    /**
     * 读取文件内容
     * @param $filename  文件名
     * @return string 文件内容
     */
    public static function read_file($filename) {
        $content = '';
        if(function_exists('file_get_contents')) {
            @$content = file_get_contents($filename);
        } else {
            if(@$fp = fopen($filename, 'r')) {
                @$content = fread($fp, filesize($filename));
                @fclose($fp);
            }
        }
        return $content;
    }
}