<?php
namespace app\shared\logic\platform;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\CardUserOrder;
use app\shared\model\CouponUser;
use app\shared\model\Coupon;
use app\shared\model\Store;
use app\shared\model\House;
use app\shared\model\StoreCouponUser;
use app\shared\model\StoreCoupon;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\PartnerUserOrder;
use app\shared\model\CardCouponOrder;
use app\shared\model\CardCoupon;
use app\shared\model\WxpayAccounting;
use think\exception\ValidateException;
use app\BaseController;
class HouseOrderForm extends  Base
{
    //获取数据
    public  function index(){

        $is_export=input('is_export')==1?1:0;
        if($is_export){
            $query=HouseOrder::alias('o')
            ->leftJoin([Store::getTable()=>'s'],'o.store_id=s.id')
            ->leftJoin([House::getTable()=>'h'],'o.house_id=h.id')
            ->where(['o.acid'=>$this->acid,'o.is_delete'=>0]);

            $start_date=input('start_date');
            $end_date=input('end_date');
            if($start_date&&$end_date){
                $query->whereBetweenTime('o.create_time',$start_date,$end_date);
            }
            $status=input('status');
            if($status!=-10){
                $query->where('o.status',$status);
            }
            $store_id=input('store_id');
            if($store_id){
                $query->where('o.store_id',$store_id);
            }
            $list=$query
            ->page($this->page)
            ->limit($this->limit)
            ->order('o.id DESC')
            ->field('o.id,o.order_no,o.create_time,o.username,o.tel,o.pay_price,o.end_time,o.start_time,s.name store_name,h.name house_name,o.price,o.status')
            ->select()
            ->toArray();
            foreach($list as &$value){
                $continue=HouseOrderContinue::where(['status'=>1,'order_id'=>$value['id']])->order('id DESC')->field('id,end_time,sum(price) as cprice')->find()->toArray();
                $value['end_time']=$continue['end_time']>0?$continue['end_time']:$value['end_time'];
                $value['start_time']=date('Y-m-d H:i:s',$value['start_time']);
                $value['end_time']=date('Y-m-d H:i:s',$value['end_time']);
                $value['cprice']=isset($continue['cprice'])?$continue['cprice']:0;
                $value['pay_price']=$value['pay_price']+$continue['cprice'];
                $value['price']=$value['price']+$continue['cprice'];
                $value['house_name']="【{$value['store_name']}】".$value['house_name'];
            }
            return fetchJson([
                'list'=>$list,
                'count'=>-10
            ]);
        }
        $query=HouseOrder::where(['acid'=>$this->acid,'is_delete'=>0]);
        $status=input('status');
        if($status!=-10){
            $query->where('status',$status);
        }
        $store_id=input('store_id');
        if($store_id){
            $query->where('store_id',$store_id);
        }
        $pay_type=input('pay_type');
        if($pay_type){
            $query->where('pay_type',$pay_type);
        }
        $keyword=input('keyword');
        if($keyword){
            $query=$query->where('username|tel|order_no','like',"%{$keyword}%");
        }
        $start_date=input('start_date');
        $end_date=input('end_date');
        if($start_date&&$end_date){
            $query->whereBetweenTime('create_time',$start_date,$end_date);
        }

        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            $value['snapshoot']=@json_decode($value['snapshoot'],1);
            if($value['type']==2){
                $value['start_time']=date('Y-m-d',$value['start_time']);
                $value['end_time']=date('Y-m-d',$value['end_time']);
            }else{
                $value['start_time']=date('Y-m-d H:i:s',$value['start_time']);
                $value['end_time']=date('Y-m-d H:i:s',$value['end_time']);
            }
            $value['xml_array']=@json_decode($value['xml_array'],1);
            $order_continue_list=HouseOrderContinue::where(['status'=>1,'order_id'=>$value['id']])->order('id DESC')->column('id,start_time,price,end_time,create_time,xml_array');
            $price=0;
            $card_user_order=CardUserOrder::alias('cuo')
            ->leftJoin([CardUser::getTable()=>'cu'],'cuo.card_user_id=cu.id')
            ->leftJoin([Card::getTable()=>'c'],'cu.card_id=c.id')
            ->where(['cuo.type'=>1,'cuo.order_id'=>$value['id']])
            ->field('cuo.price,cuo.hour,cuo.discount,cuo.status,cuo.type,c.title')
            ->find();
            if($card_user_order){
               $discounts_price=$card_user_order['discount']*($value['price']-$card_user_order['price'])*0.1;
               $card_user_order['discounts_price']=$card_user_order['price'];//($value['price']-$card_user_order['price'])-$discounts_price;
            }
            foreach ($order_continue_list as $k => &$v) {
               $v['start_time']=date('Y-m-d H:i',$v['start_time']);
               $v['end_time']=date('Y-m-d H:i',$v['end_time']);
               $v['xml_array']=@json_decode($v['xml_array'],1);
               if($k==0){
                  $value['end_time']=$v['end_time'];
               }
               $price+=$v['price'];
            }
            $value['pay_price']+=$price;
            $value['pay_price']=round($value['pay_price'],2);
            $value['price']+=$price;
            $value['price']=round($value['price'],2);
            $value['order_continue_list']=$order_continue_list;
            $value['card_user_order']=$card_user_order;
            $couponUser=CouponUser::alias('a')
            ->leftJoin([Coupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['coupon_user_id'],'a.type'=>Coupon::TYPE_HOTEL])
            ->field('a.discounts_price,b.name')->find();
            $value['discounts_name']=$couponUser['name'];
            $value['discounts_price']=$couponUser['discounts_price']>0?$couponUser['discounts_price']:0;
            //商户优惠券
            $storeCouponUser=StoreCouponUser::alias('a')
            ->leftJoin([StoreCoupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['store_coupon_user_id'],'a.type'=>StoreCoupon::TYPE_HOTEL])
            ->field('a.discounts_price,b.name')->find();
            $value['store_discounts_name']=$storeCouponUser['name'];
            $value['store_discounts_price']=$storeCouponUser['discounts_price']>0?$storeCouponUser['discounts_price']:0;
            $value['is_wxpay_accounting']=WxpayAccounting::where(['type'=>1,'order_id'=>$value['id']])->count();
            $value['partner_user_order']=PartnerUserOrder::where(['type'=>1,'order_id'=>$value['id']])->column('id,hour,price');
            $card_coupon=CardCouponOrder::alias('cco')->leftJoin([CardCoupon::getTable()=>'cc'],'cco.card_coupon_id=cc.id')->where(['cco.order_id'=>$value['id']])->field('cc.discounts_price,cc.name,cco.id,cc.type')->find();
            if($card_coupon['discounts_price']){
                $value['meituan_price']=$card_coupon['discounts_price'];
            }
            $value['card_coupon']=$card_coupon;
            $value['order_source_name']="小程序";
            if($card_coupon){
                if($card_coupon['type']==1){
                    $value['order_source_name']="美团";
                }
                if($card_coupon['type']==2){
                    $value['order_source_name']="抖音";
                }
            }
            
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //提前结束订单
    public function endOrdersEarly(){
        $order=HouseOrder::where(['id'=>input('order_id'),'is_pay'=>1])->where('status','in','1,2')->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $form= new \app\task\controller\Wechat();
        $form->endOrdersEarly($order);
        return fetchJson([],'提前结束订单');
    }
}