<?php
namespace app\shared\logic\platform;
use app\shared\model\GoodsOrder;
use app\shared\model\Goods;
use app\shared\model\User;
use app\shared\model\Store;
use app\shared\model\CouponUser;
use app\shared\model\Coupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\GoodsOrderDetail;
use app\shared\model\StoreCoupon;
use app\shared\model\WeixinUser;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
use wechatpay\WechatPay;
use app\shared\model\Bill;
use app\shared\model\App;
use app\shared\model\CardUserOrder;
use app\shared\model\StoreUserMoney;
class GoodsOrderForm extends  Base
{
     //获取数据
    public  function index(){
        $keyword=input('keyword');
        $status=input('status');
        $store_id=input('store_id');
        $query=Db::view(GoodsOrder::getTable().' o','*')
                ->view(User::getTable().' u','nickname,avatar_url','o.user_id=u.id');
        if($store_id){
            $query->view(Store::getTable().' s','name store_name','o.store_id=s.id');
            $query->where([
                'o.acid'=>$this->acid,
                'o.is_delete'=>0,
                'o.store_id'=>$store_id
            ]);
        }else{
            $query->where([
                'o.acid'=>$this->acid,
                'o.is_delete'=>0,
                'o.store_id'=>$store_id
            ]);
        }       
        if($status!=-1){
           $query=$query->where(['o.status'=>$status]);
        }
        if($keyword){
            $query=$query->where('o.order_no|o.id|o.snapshot','like',"%{$keyword}%");
        }
        $list=$query->page($this->page)
                ->limit($this->limit)
                ->order('o.id DESC')
                ->select()
                ->toArray();
        $status_arr=[-1=>'取消',0=>'未支付',1=>'待发货',2=>'已发货',3=>'已完成',-2=>'退款'];       
        foreach ($list as &$value) {
            $snapshot=@json_decode($value['snapshot'],1);
            $value['snapshot']=$snapshot;
            $value['store_name']=isset($value['store_name'])?$value['store_name']:'平台';
            $value['status_title']=$status_arr[$value['status']];
            $value['create_time']=date('Y-m-d H:i:s',$value['create_time']);
            $value['update_time']=date('Y-m-d H:i:s',$value['update_time']);
            $couponUser=CouponUser::alias('a')
            ->leftJoin([Coupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['coupon_user_id'],'a.type'=>Coupon::TYPE_GOODS])
            ->field('a.discounts_price,b.name')->find();
            $value['discounts_name']=$couponUser['name'];
            $value['discounts_price']=$couponUser['discounts_price']>0?$couponUser['discounts_price']:0;
            //商户优惠券
            $storeCouponUser=StoreCouponUser::alias('a')
            ->leftJoin([StoreCoupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['store_coupon_user_id'],'a.type'=>StoreCoupon::TYPE_GOODS])
            ->field('a.discounts_price,b.name')->find();
            $value['store_discounts_name']=$storeCouponUser['name'];
            $value['store_discounts_price']=$storeCouponUser['discounts_price']>0?$storeCouponUser['discounts_price']:0;
        }
        $queryCount=Db::view(GoodsOrder::getTable().' o','*')
                ->view(User::getTable().' u','nickname,avatar_url','o.user_id=u.id')
                ->where([
                	'o.acid'=>$this->acid,
                	'o.is_delete'=>0,
                	'o.store_id'=>$this->store_id
                ]);
        if($status!=-1){
            $queryCount=$queryCount->where(['o.status'=>$status]);
        }
        if($keyword){
            $queryCount=$queryCount->where('o.order_no|o.id|o.snapshot','like',"%{$keyword}%");
        }
        $count=$queryCount->count();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //订单编辑
    public function order_edit(){
    	 try {
            $data=request()->post();
            $rule = [
                 'order_id|订单号'=>'require|number',
                 'status|状态'=>'require|in:0,1,2,3,-2',

             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
    	 $is_express=input('is_express')==1?1:0;
         $express_name=input('express_name');
         $express_no=input('express_no');
         $express_remark=input('express_remark');
         $order=GoodsOrder::where(['id'=>$data['order_id']])->find();
         if($order){
            //发货
            if($data['status']==2){
                $order->save([
                    'status'=>$data['status'],
                    'is_express'=>$is_express,
                    'express_name'=>$express_name,
                    'express_no'=>$express_no,
                    'express_remark'=>$express_remark,
                ]);
                return fetchJson([],'发货成功');
                //退款
            }else if($data['status']==-2){
                $res=self::addUserBill($order);
                if($res['code']==1){
                    return fetchJson([],$res['msg'],1);
                }
                $order->save([
                    'status'=>-2,
                ]);
                GoodsOrderDetail::where(['order_id'=>$order->id])->update(['status'=>0]);
                CouponUser::where(['id'=>$order->coupon_user_id,'order_id'=>$order->id])->update(['is_use'=>0,'use_time'=>0,'order_id'=>0]);
                StoreCouponUser::where(['id'=>$order->store_coupon_user_id,'order_id'=>$order->id])->update(['is_use'=>0,'use_time'=>0,'order_id'=>0]);
                return fetchJson([],'退款成功');
            }else{
                $order->save([
                    'status'=>$data['status'],
                ]);
            }
            return fetchJson([],'订单完成');
         }else{
            return fetchJson([],'暂无订单',1);
         }
    }
    //增加账单
    public function addUserBill($order=[]){
        $user=User::where('id',$order['user_id'])->find();
        if($order->pay_type==2){
            $user->money+=$order['pay_price'];
            $user->save();
        }
        $userStore=StoreUserMoney::where(['store_id'=>$order->store_id,'user_id'=>$order->user_id])->find();
        if($order->pay_type==3){
            if($userStore){
                $userStore->money+=$order['pay_price'];
                $userStore->save();
                $balance=$userStore->money;
            }
        }
        if($order->pay_type==1){
             if($order->out_order_time>0){
                return ['code' => 0, 'info' => '已经退过了','data' =>''];
             }
             $refund_price=$order->pay_price;
             $app=App::find($order->acid);
             $appid=$app->wxapp_app_id;
             $app_secret=$app->wxapp_app_secret;
             $wx_config=[
                  'appid'=>$appid,
                  'appsecret'=>$app_secret,
                  'mchid'=>$app->wx_mch_id,
                  'key'=>$app->wx_key,
                  'sslcert'=>$app->wx_cert_pem,
                  'sslkey'=>$app->wx_key_pem,
             ];
             if(isset($app->wx_pay_type)){
                $storeWx=Store::where('id',$order->store_id)->field('wx_mch_id,wx_key,wx_sslcert,wx_sslkey,fee')->find();
                //服务商模式
                if($app->wx_pay_type==2){
                   $wx_config=[
                        'appid'=>$appid,
                        'mchid'=>$storeWx['wx_mch_id']!=0?$storeWx['wx_mch_id']:$app->wx_mch_id,
                        'wx_server_appid'=>$app->wx_server_appid,
                        'appsecret'=>$app_secret,
                        'wx_server_mch_id'=>$app->wx_server_mch_id,
                        'key'=>$app->wx_server_key,
                        'sslcert'=>$app->wx_server_cert_pem,
                        'sslkey'=>$app->wx_server_key_pem,
                        'sub_appid'=>$appid,
                        'sub_mch_id'=>$app->wx_mch_id,
                        'wx_pay_type'=>$app->wx_pay_type
                   ];
                   if($storeWx['fee']>0){
                        $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                   }
                }else{
                   if($storeWx['wx_mch_id']){
                      $wx_config=[
                            'appid'=>$appid,
                            'appsecret'=>$app_secret,
                            'mchid'=>$storeWx['wx_mch_id'],
                            'key'=>$storeWx['wx_key'],
                            'sslcert'=>$storeWx['wx_sslcert'],
                            'sslkey'=>$storeWx['wx_sslkey']
                       ];
                       if($storeWx['fee']>0){
                          $wx_config['wx_profit_sharing']=$app->wx_profit_sharing;
                       }
                   }
                }

             }
             $wechatPay=new WechatPay($wx_config);
             $notify_url='https://chashi-demo.youdiy.cn';
             $order->out_order_no=GoodsOrder::crateOutOrderNo();
             $data = [
                'out_refund_no' => $order->out_order_no,//订单号码
                'out_trade_no' =>$order->order_no,//退款单号
                'total_fee' =>  $order->pay_price * 100,//支付金额
                'refund_fee' => $refund_price * 100,//全额退款
            ];
            if(isset($order->xml_array)){
                $xml_array=@json_decode($order->xml_array,1);
                if(isset($xml_array['transaction_id'])){
                  $data['transaction_id']=$xml_array['transaction_id'];
                }
            }
            $payResult = $wechatPay->refund($data);
            if (!isset($payResult['return_code']) || $payResult['return_code'] != 'SUCCESS') {
                $info='退款失败，' . (isset($payResult['return_msg']) ? $payResult['return_msg'] : '');
                return ['code'=>1,'msg'=>$info];
            }
            if (!isset($payResult['result_code']) || $payResult['result_code'] != 'SUCCESS') {
                $info='提交业务失败，'. (isset($payResult['err_code_des']) ? $payResult['err_code_des'] : '');
                return ['code'=>1,'msg'=>$info];
            }
            $order->out_order_time=time();
            $order->save();
        }
        $des='用户: 【'.$user->nickname.'】 退款商品';
        if($order->pay_tea_price>0){
            $userStore->tea_money+=$order['pay_tea_price'];
            $userStore->tea_money=$userStore->tea_money>0?$userStore->tea_money:0;
            $userStore->save();
            $des='用户: 【'.$user->nickname.'】 退款商品，茶叶金消费'.$order['pay_tea_price'].'元';
        }
        $balance=$user->money;
        //更新会员卡券
        CardUserOrder::where(['order_id'=>$order['id'],'type'=>2])->update(['status'=>1]);

        (new Bill())->save([
            'acid'=>$order->acid,
            'type'=>$order->pay_type==3?Bill::TYPE_STORE_USER_GOODS:Bill::TYPE_HOUSE,
            'account_type'=>Bill::ACCOUNT_TYPE_USER,
            'form_id'=>$order['user_id'],
            'order_id'=>$order['id'],
            'price'=>$order['pay_price'],
            'pay_type'=>$order['pay_type'],
            'balance'=>$balance,
            'tea_price'=>$order->pay_tea_price,
            'tea_balance'=>isset($userStore->tea_money)?$userStore->tea_money:0,
            'status'=>1,
            'des'=>$des
        ]);
        return ['code'=>0,'msg'=>'退款成功'];
    }
}